/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async.subscriber;

import io.micronaut.core.async.subscriber.Emitter;
import java.util.LinkedList;
import java.util.Queue;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class SingleThreadedBufferingSubscriber<T>
implements Subscriber<T>,
Emitter<T> {
    protected final Queue<T> upstreamBuffer = new LinkedList<T>();
    protected BackPressureState upstreamState = BackPressureState.NO_SUBSCRIBER;
    protected long upstreamDemand = 0L;
    protected Subscription upstreamSubscription;

    public final synchronized void onSubscribe(Subscription subscription) {
        this.upstreamSubscription = subscription;
        switch (this.upstreamState) {
            case NO_SUBSCRIBER: {
                if (this.upstreamBuffer.isEmpty()) {
                    this.upstreamState = BackPressureState.IDLE;
                    break;
                }
                this.upstreamState = BackPressureState.BUFFERING;
                break;
            }
            case FLOWING: 
            case IDLE: {
                this.doOnSubscribe(subscription);
                break;
            }
        }
    }

    @Override
    public final void onComplete() {
        switch (this.upstreamState) {
            case DONE: {
                return;
            }
            case NO_SUBSCRIBER: 
            case BUFFERING: {
                this.upstreamState = BackPressureState.FLOWING;
            }
        }
        this.doOnComplete();
        this.upstreamState = BackPressureState.DONE;
    }

    @Override
    public final void onNext(T message) {
        switch (this.upstreamState) {
            case IDLE: {
                this.upstreamBuffer.add(message);
                this.upstreamState = BackPressureState.BUFFERING;
                break;
            }
            case NO_SUBSCRIBER: 
            case BUFFERING: {
                this.upstreamBuffer.add(message);
                break;
            }
            case DEMANDING: {
                try {
                    try {
                        this.doOnNext(message);
                    }
                    catch (Exception e) {
                        this.onError(e);
                    }
                    if (this.upstreamState == BackPressureState.DONE || this.upstreamDemand >= Long.MAX_VALUE) break;
                    --this.upstreamDemand;
                    if (this.upstreamDemand != 0L || this.upstreamState == BackPressureState.FLOWING) break;
                }
                catch (Throwable throwable) {
                    if (this.upstreamState != BackPressureState.DONE && this.upstreamDemand < Long.MAX_VALUE) {
                        --this.upstreamDemand;
                        if (this.upstreamDemand == 0L && this.upstreamState != BackPressureState.FLOWING) {
                            this.upstreamState = this.upstreamBuffer.isEmpty() ? BackPressureState.IDLE : BackPressureState.BUFFERING;
                        }
                    }
                    throw throwable;
                }
                if (this.upstreamBuffer.isEmpty()) {
                    this.upstreamState = BackPressureState.IDLE;
                    break;
                }
                this.upstreamState = BackPressureState.BUFFERING;
                break;
            }
        }
    }

    @Override
    public final void onError(Throwable t) {
        if (this.upstreamState != BackPressureState.DONE) {
            try {
                if (this.upstreamSubscription != null) {
                    this.upstreamSubscription.cancel();
                }
            }
            finally {
                this.upstreamState = BackPressureState.DONE;
                this.upstreamBuffer.clear();
                this.doOnError(t);
            }
        }
    }

    protected abstract void doOnSubscribe(Subscription var1);

    protected abstract void doOnNext(T var1);

    protected abstract void doOnError(Throwable var1);

    protected abstract void doOnComplete();

    protected void provideDownstreamSubscription(Subscriber subscriber) {
        subscriber.onSubscribe(this.newDownstreamSubscription());
    }

    protected Subscription newDownstreamSubscription() {
        return new DownstreamSubscription();
    }

    private void processDemand(long demand) {
        switch (this.upstreamState) {
            case FLOWING: 
            case BUFFERING: {
                if (!this.registerDemand(demand)) break;
                this.flushBuffer();
                break;
            }
            case DEMANDING: {
                this.registerDemand(demand);
                break;
            }
            case IDLE: {
                if (!this.registerDemand(demand)) break;
                this.upstreamState = BackPressureState.DEMANDING;
                this.flushBuffer();
                break;
            }
        }
    }

    private boolean registerDemand(long demand) {
        if (demand <= 0L) {
            this.illegalDemand();
            return false;
        }
        if (this.upstreamDemand < Long.MAX_VALUE) {
            this.upstreamDemand += demand;
            if (this.upstreamDemand < 0L) {
                this.upstreamDemand = Long.MAX_VALUE;
            }
        }
        return true;
    }

    private void flushBuffer() {
        while (!(this.upstreamBuffer.isEmpty() || this.upstreamDemand <= 0L && this.upstreamDemand != Long.MAX_VALUE)) {
            this.onNext(this.upstreamBuffer.remove());
        }
        if (this.upstreamBuffer.isEmpty()) {
            if (this.upstreamDemand > 0L) {
                if (this.upstreamState == BackPressureState.BUFFERING) {
                    this.upstreamState = BackPressureState.DEMANDING;
                }
                this.upstreamSubscription.request(this.upstreamDemand);
            } else if (this.upstreamState == BackPressureState.BUFFERING) {
                this.upstreamState = BackPressureState.IDLE;
            }
        }
    }

    private void illegalDemand() {
        this.onError(new IllegalArgumentException("Request for 0 or negative elements in violation of Section 3.9 of the Reactive Streams specification"));
    }

    protected class DownstreamSubscription
    implements Subscription {
        protected DownstreamSubscription() {
        }

        public synchronized void request(long n) {
            SingleThreadedBufferingSubscriber.this.processDemand(n);
            SingleThreadedBufferingSubscriber.this.upstreamSubscription.request(n);
        }

        public synchronized void cancel() {
            SingleThreadedBufferingSubscriber.this.upstreamSubscription.cancel();
        }
    }

    protected static enum BackPressureState {
        NO_SUBSCRIBER,
        IDLE,
        BUFFERING,
        DEMANDING,
        FLOWING,
        DONE;

    }
}

