/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.CompilationUnitAware;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.ast.groovy.InjectVisitor;
import io.micronaut.ast.groovy.config.GroovyConfigurationMetadataBuilder;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.utils.AstMessageUtils;
import io.micronaut.ast.groovy.utils.InMemoryByteCodeGroovyClassLoader;
import io.micronaut.ast.groovy.utils.InMemoryClassWriterOutputVisitor;
import io.micronaut.ast.groovy.visitor.GroovyPackageElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.context.annotation.Configuration;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.writer.BeanConfigurationWriter;
import io.micronaut.inject.writer.BeanDefinitionReferenceWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.DirectoryClassWriterOutputVisitor;
import java.beans.Transient;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.StringReaderSource;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class InjectTransform
implements ASTTransformation,
CompilationUnitAware,
GroovyObject {
    public static final String ANN_VALID = "javax.validation.Valid";
    public static final String ANN_CONSTRAINT = "javax.validation.Constraint";
    public static final String ANN_CONFIGURATION_ADVICE = "io.micronaut.runtime.context.env.ConfigurationAdvice";
    public static final String ANN_VALIDATED = "io.micronaut.validation.Validated";
    public static final Predicate<AnnotationMetadata> IS_CONSTRAINT;
    private CompilationUnit unit;
    private ConfigurationMetadataBuilder<ClassNode> configurationMetadataBuilder;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public InjectTransform() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        GroovyConfigurationMetadataBuilder groovyConfigurationMetadataBuilder;
        this.configurationMetadataBuilder = groovyConfigurationMetadataBuilder = new GroovyConfigurationMetadataBuilder(source, this.unit);
        ModuleNode moduleNode = source.getAST();
        LinkedHashMap beanDefinitionWriters = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        File classesDir = source.getConfiguration().getTargetDirectory();
        boolean defineClassesInMemory = source.getClassLoader() instanceof InMemoryByteCodeGroovyClassLoader;
        Object outputVisitor = null;
        if (defineClassesInMemory) {
            InMemoryClassWriterOutputVisitor inMemoryClassWriterOutputVisitor = new InMemoryClassWriterOutputVisitor((InMemoryByteCodeGroovyClassLoader)((Object)ScriptBytecodeAdapter.asType((Object)source.getClassLoader(), InMemoryByteCodeGroovyClassLoader.class)));
            outputVisitor = inMemoryClassWriterOutputVisitor;
        } else {
            DirectoryClassWriterOutputVisitor directoryClassWriterOutputVisitor;
            outputVisitor = directoryClassWriterOutputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
        }
        List classes = moduleNode.getClasses();
        if (classes.size() == 1) {
            ClassNode classNode = (ClassNode)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)classes, (int)0), ClassNode.class);
            if (ScriptBytecodeAdapter.compareEqual((Object)classNode.getNameWithoutPackage(), (Object)"package-info")) {
                PackageNode packageNode = classNode.getPackage();
                if (AstAnnotationUtils.hasStereotype(source, this.unit, (AnnotatedNode)packageNode, Configuration.class)) {
                    AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(source, this.unit, (AnnotatedNode)packageNode);
                    GroovyVisitorContext visitorContext = new GroovyVisitorContext(source, this.unit);
                    BeanConfigurationWriter writer = new BeanConfigurationWriter(classNode.getPackageName(), (Element)new GroovyPackageElement(visitorContext, packageNode, annotationMetadata), annotationMetadata);
                    try {
                        writer.accept((ClassWriterOutputVisitor)outputVisitor);
                        outputVisitor.finish();
                    }
                    catch (Throwable e) {
                        AstMessageUtils.error(source, (ASTNode)classNode, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{classNode.getName(), e.getMessage()}, new String[]{"Error generating bean configuration for package-info class [", "]: ", ""})));
                    }
                }
                return;
            }
        }
        ClassNode classNode = null;
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            classNode = (ClassNode)ScriptBytecodeAdapter.castToType(iterator.next(), ClassNode.class);
            if (classNode instanceof InnerClassNode && !Modifier.isStatic(classNode.getModifiers())) continue;
            if (classNode.isInterface()) {
                if (!(AstAnnotationUtils.hasStereotype(source, this.unit, (AnnotatedNode)classNode, InjectVisitor.INTRODUCTION_TYPE) || AstAnnotationUtils.hasStereotype(source, this.unit, (AnnotatedNode)classNode, ConfigurationReader.class))) continue;
                InjectVisitor injectVisitor = new InjectVisitor(source, this.unit, classNode, this.configurationMetadataBuilder);
                injectVisitor.visitClass(classNode);
                beanDefinitionWriters.putAll(injectVisitor.getBeanDefinitionWriters());
                continue;
            }
            InjectVisitor injectVisitor = new InjectVisitor(source, this.unit, classNode, this.configurationMetadataBuilder);
            injectVisitor.visitClass(classNode);
            beanDefinitionWriters.putAll(injectVisitor.getBeanDefinitionWriters());
        }
        Object entry = null;
        Iterator iterator2 = DefaultGroovyMethods.iterator((Object)beanDefinitionWriters);
        while (iterator2.hasNext()) {
            entry = iterator2.next();
            BeanDefinitionVisitor beanDefWriter = (BeanDefinitionVisitor)ScriptBytecodeAdapter.castToType(((Map.Entry)entry).getValue(), BeanDefinitionVisitor.class);
            String beanTypeName = beanDefWriter.getBeanTypeName();
            AnnotatedNode beanClassNode = (AnnotatedNode)ScriptBytecodeAdapter.castToType(((Map.Entry)entry).getKey(), AnnotatedNode.class);
            try {
                BeanDefinitionReferenceWriter beanReferenceWriter = new BeanDefinitionReferenceWriter(beanTypeName, beanDefWriter);
                beanReferenceWriter.setRequiresMethodProcessing(beanDefWriter.requiresMethodProcessing());
                beanReferenceWriter.setContextScope(beanDefWriter.getAnnotationMetadata().hasDeclaredAnnotation(Context.class));
                beanDefWriter.visitBeanDefinitionEnd();
                if (classesDir != null) {
                    beanReferenceWriter.accept((ClassWriterOutputVisitor)outputVisitor);
                    beanDefWriter.accept((ClassWriterOutputVisitor)outputVisitor);
                    continue;
                }
                if (!(source.getSource() instanceof StringReaderSource && defineClassesInMemory)) continue;
                beanReferenceWriter.accept((ClassWriterOutputVisitor)outputVisitor);
                beanDefWriter.accept((ClassWriterOutputVisitor)outputVisitor);
            }
            catch (Throwable e) {
                AstMessageUtils.error(source, (ASTNode)beanClassNode, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{beanTypeName, e.getMessage()}, new String[]{"Error generating bean definition class for dependency injection of class [", "]: ", ""})));
                e.printStackTrace(System.err);
            }
        }
        if (!beanDefinitionWriters.isEmpty()) {
            try {
                outputVisitor.finish();
            }
            catch (Throwable e) {
                AstMessageUtils.error(source, (ASTNode)moduleNode, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Error generating META-INF/services files: ", ""})));
                if (e.getMessage() == null) {
                    e.printStackTrace(System.err);
                }
            }
        }
        AstAnnotationUtils.invalidateCache();
    }

    public void setCompilationUnit(CompilationUnit unit) {
        CompilationUnit compilationUnit;
        this.unit = compilationUnit = unit;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != InjectTransform.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Predicate predicate;
        public final class __clinit__closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(AnnotationMetadata am) {
                return am.hasStereotype(ANN_CONSTRAINT) || am.hasStereotype(ANN_VALID);
            }

            public Object call(AnnotationMetadata am) {
                return this.doCall(am);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IS_CONSTRAINT = predicate = (Predicate)ScriptBytecodeAdapter.castToType((Object)((Object)new __clinit__closure1(InjectTransform.class, InjectTransform.class)), Predicate.class);
    }

    @Generated
    public CompilationUnit getUnit() {
        return this.unit;
    }

    @Generated
    public void setUnit(CompilationUnit compilationUnit) {
        this.unit = compilationUnit;
    }

    @Generated
    public ConfigurationMetadataBuilder<ClassNode> getConfigurationMetadataBuilder() {
        return this.configurationMetadataBuilder;
    }

    @Generated
    public void setConfigurationMetadataBuilder(ConfigurationMetadataBuilder<ClassNode> configurationMetadataBuilder) {
        this.configurationMetadataBuilder = configurationMetadataBuilder;
    }
}

