/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.utils;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.beans.Transient;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class AstGenericUtils
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AstGenericUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Map<String, ClassNode> createGenericsSpec(ClassNode classNode) {
        GenericsType[] existingGenericTypes = classNode.getGenericsTypes();
        boolean hasGenericTypes = ArrayUtils.isNotEmpty((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)existingGenericTypes, Object[].class)));
        if (!classNode.isPrimaryClassNode()) {
            ClassNode classNode2;
            if (hasGenericTypes) {
                GenericsType[] redirectTypes = classNode.redirect().getGenericsTypes();
                LinkedHashMap<String, ClassNode> ret = new LinkedHashMap<String, ClassNode>();
                AstGenericUtils.populateGenericsSpec(redirectTypes, existingGenericTypes, ret);
                return ret;
            }
            classNode = classNode2 = classNode.redirect();
            LinkedHashMap<String, ClassNode> ret = new LinkedHashMap<String, ClassNode>();
            GenericsType[] redirectTypes = classNode.getGenericsTypes();
            if (redirectTypes != null) {
                GenericsType gt2 = null;
                GenericsType[] genericsTypeArray = redirectTypes;
                if (redirectTypes != null) {
                    for (GenericsType gt2 : genericsTypeArray) {
                        if (gt2.isPlaceholder()) {
                            if (DefaultTypeTransformation.booleanUnbox((Object)gt2.getUpperBounds())) {
                                ret.put(gt2.getName(), (ClassNode)BytecodeInterface8.objectArrayGet((Object[])gt2.getUpperBounds(), (int)0));
                                continue;
                            }
                            if (DefaultTypeTransformation.booleanUnbox((Object)gt2.getLowerBound())) {
                                ret.put(gt2.getName(), gt2.getLowerBound());
                                continue;
                            }
                            ret.put(gt2.getName(), ClassHelper.OBJECT_TYPE);
                            continue;
                        }
                        ret.put(gt2.getName(), gt2.getType());
                    }
                }
            }
            return ret;
        }
        if (!hasGenericTypes) {
            return Collections.emptyMap();
        }
        return AstGenericUtils.createGenericsSpec(classNode, Collections.emptyMap());
    }

    public static Map<String, ClassNode> createGenericsSpec(ClassNode current, Map<String, ClassNode> oldSpec) {
        LinkedHashMap<String, ClassNode> ret = new LinkedHashMap<String, ClassNode>(oldSpec);
        Object[] sgts = current.getGenericsTypes();
        if (sgts != null) {
            Object[] spec = new ClassNode[sgts.length];
            int i = 0;
            while (i < spec.length) {
                ClassNode classNode = GenericsUtils.correctToGenericsSpec(ret, (GenericsType)((GenericsType)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])sgts, (int)i), GenericsType.class)));
                BytecodeInterface8.objectArraySet((Object[])spec, (int)i, (Object)classNode);
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
            Object[] newGts = current.redirect().getGenericsTypes();
            if (newGts == null) {
                return ret;
            }
            ret.clear();
            int i2 = 0;
            while (i2 < spec.length) {
                ret.put(((GenericsType)BytecodeInterface8.objectArrayGet((Object[])newGts, (int)i2)).getName(), (ClassNode)BytecodeInterface8.objectArrayGet((Object[])spec, (int)i2));
                int n = i2;
                int cfr_ignored_1 = n + 1;
            }
        }
        return ret;
    }

    public static Map<String, ClassNode> createGenericsSpec(MethodNode methodNode, Map<String, ClassNode> genericsSpec) {
        GenericsType[] redirectTypes = methodNode.getGenericsTypes();
        if (redirectTypes != null) {
            GenericsType gt2 = null;
            GenericsType[] genericsTypeArray = redirectTypes;
            if (redirectTypes != null) {
                for (GenericsType gt2 : genericsTypeArray) {
                    if (gt2.isPlaceholder()) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)gt2.getUpperBounds())) {
                            genericsSpec.put(gt2.getName(), (ClassNode)BytecodeInterface8.objectArrayGet((Object[])gt2.getUpperBounds(), (int)0));
                            continue;
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)gt2.getLowerBound())) {
                            genericsSpec.put(gt2.getName(), gt2.getLowerBound());
                            continue;
                        }
                        genericsSpec.put(gt2.getName(), ClassHelper.OBJECT_TYPE);
                        continue;
                    }
                    genericsSpec.put(gt2.getName(), gt2.getType());
                }
            }
        }
        return genericsSpec;
    }

    private static void populateGenericsSpec(GenericsType[] redirectTypes, GenericsType[] genericTypes, HashMap<String, ClassNode> boundTypes) {
        if (DefaultTypeTransformation.booleanUnbox((Object)redirectTypes) && redirectTypes.length == genericTypes.length) {
            int i = 0;
            GenericsType redirect = null;
            GenericsType[] genericsTypeArray = redirectTypes;
            if (redirectTypes != null) {
                int n = genericsTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    redirect = genericsTypeArray[n2];
                    ++n2;
                    GenericsType specifiedType = (GenericsType)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])genericTypes, (int)i), GenericsType.class);
                    ClassNode specifiedClassNode = specifiedType.getType();
                    if (redirect.isPlaceholder() && DefaultTypeTransformation.booleanUnbox((Object)specifiedClassNode)) {
                        if (specifiedType.isPlaceholder()) {
                            if (DefaultTypeTransformation.booleanUnbox((Object)specifiedType.getUpperBounds())) {
                                boundTypes.put(redirect.getName(), (ClassNode)BytecodeInterface8.objectArrayGet((Object[])specifiedType.getUpperBounds(), (int)0));
                            } else if (DefaultTypeTransformation.booleanUnbox((Object)specifiedType.getLowerBound())) {
                                boundTypes.put(redirect.getName(), specifiedType.getLowerBound());
                            } else {
                                boundTypes.put(redirect.getName(), specifiedClassNode.redirect().getPlainNodeReference());
                            }
                        } else {
                            GenericsType[] specifiedGenerics = specifiedType.getType().getGenericsTypes();
                            if (DefaultTypeTransformation.booleanUnbox((Object)specifiedGenerics)) {
                                boundTypes.put(redirect.getName(), specifiedType.getType());
                            } else {
                                boundTypes.put(redirect.getName(), specifiedClassNode.redirect());
                            }
                        }
                    }
                    int n3 = i;
                    int cfr_ignored_0 = n3 + 1;
                }
            }
        }
    }

    public static ClassNode resolveInterfaceGenericType(ClassNode classNode, Class itfe) {
        Reference itfe2 = new Reference((Object)itfe);
        public final class _resolveInterfaceGenericType_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference itfe;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resolveInterfaceGenericType_closure1(Object _outerInstance, Object _thisObject, Reference itfe) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.itfe = reference = itfe;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((ClassNode)it).getName(), (Object)((Class)this.itfe.get()).getName());
            }

            @Generated
            public Class getItfe() {
                return ShortTypeHandling.castToClass((Object)this.itfe.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveInterfaceGenericType_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ClassNode foundInterface = (ClassNode)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)classNode.getAllInterfaces(), (Closure)new _resolveInterfaceGenericType_closure1(AstGenericUtils.class, AstGenericUtils.class, itfe2)), ClassNode.class);
        if (foundInterface != null && DefaultTypeTransformation.booleanUnbox((Object)foundInterface.getGenericsTypes())) {
            Object object = BytecodeInterface8.objectArrayGet((Object[])foundInterface.getGenericsTypes(), (int)0);
            return object != null ? ((GenericsType)object).getType() : null;
        }
        return (ClassNode)ScriptBytecodeAdapter.castToType(null, ClassNode.class);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassNode resolveTypeReference(ClassNode classNode, Map<String, ClassNode> boundTypes) {
        block21: {
            if (classNode == null) {
                return (ClassNode)ScriptBytecodeAdapter.castToType(null, ClassNode.class);
            }
            if (classNode.isGenericsPlaceHolder()) {
                if (DefaultTypeTransformation.booleanUnbox((Object)classNode.getGenericsTypes())) {
                    String typeVar = ((GenericsType)BytecodeInterface8.objectArrayGet((Object[])classNode.getGenericsTypes(), (int)0)).getName();
                    if (boundTypes.containsKey(typeVar)) {
                        ClassNode resolved = (ClassNode)ScriptBytecodeAdapter.castToType((Object)boundTypes.get(typeVar), ClassNode.class);
                        if (!resolved.isGenericsPlaceHolder()) return resolved;
                        return AstGenericUtils.resolveTypeReference(resolved, boundTypes);
                    }
                    break block21;
                } else {
                    if (classNode.isResolved() || ClassHelper.isPrimitiveType((ClassNode)classNode)) {
                        try {
                            return classNode;
                        }
                        catch (ClassNotFoundException ignored) {
                            return classNode;
                        }
                    }
                    ClassNode redirectNode = classNode.redirect();
                    String redirectName = redirectNode.getName();
                    if (!ScriptBytecodeAdapter.compareNotEqual((Object)redirectName, (Object)classNode.getUnresolvedName())) return ClassHelper.OBJECT_TYPE;
                    return redirectNode;
                }
            }
            if (classNode.isArray() && classNode.getComponentType().isGenericsPlaceHolder()) {
                Object[] componentGenericTypes = classNode.getComponentType().getGenericsTypes();
                if (DefaultTypeTransformation.booleanUnbox((Object)componentGenericTypes)) {
                    String typeVar = ((GenericsType)BytecodeInterface8.objectArrayGet((Object[])componentGenericTypes, (int)0)).getName();
                    if (boundTypes.containsKey(typeVar)) {
                        return boundTypes.get(typeVar).makeArray();
                    }
                }
            }
        }
        try {
            return classNode;
        }
        catch (ClassNotFoundException ignored) {
            return classNode;
        }
    }

    public static Map<String, Map<String, ClassNode>> buildAllGenericElementInfo(ClassNode classNode, VisitorContext visitorContext) {
        LinkedHashMap<String, Map<String, Object>> typeArguments = new LinkedHashMap<String, Map<String, Object>>();
        AstGenericUtils.populateTypeArguments(classNode, typeArguments);
        LinkedHashMap<String, Map<String, ClassNode>> elements = new LinkedHashMap<String, Map<String, ClassNode>>(typeArguments.size());
        Map.Entry entry = null;
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = typeArguments.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
            Map value = (Map)ScriptBytecodeAdapter.castToType(entry.getValue(), Map.class);
            LinkedHashMap submap = new LinkedHashMap(value.size());
            Map.Entry genericEntry = null;
            Iterator iterator2 = value.entrySet().iterator();
            while (iterator2.hasNext()) {
                genericEntry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator2.next(), Map.Entry.class);
                Object v = genericEntry.getValue();
                ClassNode te = null;
                if (v instanceof ClassNode) {
                    Object v2 = v;
                    te = (ClassNode)ScriptBytecodeAdapter.castToType(v2, ClassNode.class);
                } else if (v instanceof Class) {
                    ClassNode classNode2;
                    te = classNode2 = ClassHelper.makeCached((Class)ShortTypeHandling.castToClass(v));
                } else if (v instanceof String) {
                    ClassNode classNode3;
                    String className = DefaultGroovyMethods.toString(v);
                    te = classNode3 = AstGenericUtils.findGenericClassInNode(classNode, className);
                    if (te == null) {
                        ClassElement ce = (ClassElement)ScriptBytecodeAdapter.castToType(visitorContext.getClassElement(className).orElse(null), ClassElement.class);
                        ClassElement classElement = ce;
                        Object nativeType = classElement != null ? classElement.getNativeType() : null;
                        if (nativeType instanceof ClassNode) {
                            ClassNode classNode4;
                            te = classNode4 = (ClassNode)ScriptBytecodeAdapter.castToType((Object)nativeType, ClassNode.class);
                        }
                    }
                }
                if (!(te != null)) continue;
                submap.put(genericEntry.getKey(), te);
            }
            elements.put((String)entry.getKey(), submap);
        }
        return elements;
    }

    public static ClassNode findGenericClassInNode(ClassNode classNode, String className) {
        GenericsType[] genericsTypes = classNode.getGenericsTypes();
        if (ArrayUtils.isNotEmpty((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)genericsTypes, Object[].class)))) {
            Object gt = null;
            Iterator iterator = DefaultGroovyMethods.iterator((Object)genericsTypes);
            while (iterator.hasNext()) {
                gt = iterator.next();
                ClassNode classNode2 = ((GenericsType)gt).getType();
                if (!ScriptBytecodeAdapter.compareEqual((Object)(classNode2 != null ? classNode2.getName() : null), (Object)className)) continue;
                return ((GenericsType)gt).getType();
            }
        }
        ClassNode[] interfaces = classNode.getInterfaces();
        Object i = null;
        Iterator iterator = DefaultGroovyMethods.iterator((Object)interfaces);
        while (iterator.hasNext()) {
            i = iterator.next();
            if (ScriptBytecodeAdapter.compareEqual((Object)((ClassNode)i).getName(), (Object)classNode.getName())) continue;
            ClassNode node = AstGenericUtils.findGenericClassInNode((ClassNode)ScriptBytecodeAdapter.castToType(i, ClassNode.class), className);
            if (!(node != null)) continue;
            return node;
        }
        if (!classNode.isInterface()) {
            ClassNode superClass = classNode.getSuperClass();
            while (superClass != null && ScriptBytecodeAdapter.compareNotEqual((Object)superClass.getName(), (Object)ClassHelper.OBJECT)) {
                ClassNode classNode3;
                ClassNode node = AstGenericUtils.findGenericClassInNode(superClass, className);
                if (node != null) {
                    return node;
                }
                superClass = classNode3 = superClass.getSuperClass();
            }
        }
        return (ClassNode)ScriptBytecodeAdapter.castToType(null, ClassNode.class);
    }

    public static void populateTypeArguments(ClassNode typeElement, Map<String, Map<String, Object>> typeArguments) {
        ClassNode current = typeElement;
        ClassNode last = null;
        while (current != null) {
            ClassNode classNode;
            ClassNode classNode2;
            if (ScriptBytecodeAdapter.compareNotEqual((Object)current, (Object)ClassHelper.OBJECT_TYPE)) {
                GenericsType[] superArguments = current.redirect().getGenericsTypes();
                if (ArrayUtils.isNotEmpty((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)superArguments, Object[].class)))) {
                    Map<String, ClassNode> genericSpec = AstGenericUtils.createGenericsSpec(current);
                    LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>(3);
                    if (DefaultTypeTransformation.booleanUnbox(genericSpec)) {
                        Object gt = null;
                        Iterator iterator = DefaultGroovyMethods.iterator((Object)superArguments);
                        while (iterator.hasNext()) {
                            gt = iterator.next();
                            ClassNode cn = (ClassNode)ScriptBytecodeAdapter.castToType((Object)genericSpec.get(((GenericsType)gt).getName()), ClassNode.class);
                            if (!(cn != null)) continue;
                            arguments.put(((GenericsType)gt).getName(), AstGenericUtils.resolveTypeReference(cn, genericSpec));
                        }
                    }
                    if (last != null) {
                        AstGenericUtils.carryForwardTypeArguments(last, typeArguments, arguments);
                    }
                    typeArguments.put(current.getName(), arguments);
                }
            }
            AstGenericUtils.populateTypeArgumentsForInterfaces(typeArguments, current);
            last = classNode2 = current;
            current = classNode = current.getUnresolvedSuperClass();
        }
    }

    private static void populateTypeArgumentsForInterfaces(Map<String, Map<String, Object>> typeArguments, ClassNode current) {
        ClassNode anInterface = null;
        ClassNode[] classNodeArray = current.getInterfaces();
        if (classNodeArray != null) {
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                anInterface = classNodeArray[n2];
                ++n2;
                String name = anInterface.getName();
                if (!(!typeArguments.containsKey(name))) continue;
                Map<String, ClassNode> genericSpec = AstGenericUtils.createGenericsSpec(anInterface);
                if (DefaultTypeTransformation.booleanUnbox(genericSpec)) {
                    LinkedHashMap types = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    Object entry = null;
                    Iterator iterator = DefaultGroovyMethods.iterator(genericSpec);
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        ClassNode classNode = AstGenericUtils.resolveTypeReference((ClassNode)ScriptBytecodeAdapter.castToType(((Map.Entry)entry).getValue(), ClassNode.class), genericSpec);
                        ScriptBytecodeAdapter.invokeMethodN(AstGenericUtils.class, (Object)types, (String)"putAt", (Object[])new Object[]{((Map.Entry)entry).getKey(), classNode});
                    }
                    AstGenericUtils.carryForwardTypeArguments(current, typeArguments, types);
                    typeArguments.put(name, types);
                }
                AstGenericUtils.populateTypeArgumentsForInterfaces(typeArguments, anInterface);
            }
        }
    }

    private static void carryForwardTypeArguments(ClassNode child, Map<String, Map<String, Object>> typeArguments, Map<String, Object> types) {
        Reference types2 = new Reference(types);
        String childName = child.getName();
        if (typeArguments.containsKey(childName)) {
            public final class _carryForwardTypeArguments_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference types;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _carryForwardTypeArguments_closure2(Object _outerInstance, Object _thisObject, Reference types) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.types = reference = types;
                }

                public Object doCall(Object arg, Object type) {
                    if (((Map)this.types.get()).containsKey(arg)) {
                        return ((Map)this.types.get()).put(arg, type);
                    }
                    return null;
                }

                public Object call(Object arg, Object type) {
                    return this.doCall(arg, type);
                }

                @Generated
                public Map getTypes() {
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.types.get(), Map.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _carryForwardTypeArguments_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            typeArguments.get(childName).forEach((BiConsumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _carryForwardTypeArguments_closure2(AstGenericUtils.class, AstGenericUtils.class, types2)), BiConsumer.class));
        }
    }

    public static void extractPlaceholders(ClassNode node, Map<String, Object> map, Map<String, ClassNode> boundTypes) {
        if (node == null) {
            return;
        }
        if (node.isArray()) {
            AstGenericUtils.extractPlaceholders(node.getComponentType(), map, boundTypes);
            return;
        }
        if (!node.isUsingGenerics() || !node.isRedirectNode()) {
            return;
        }
        Object[] parameterized = node.getGenericsTypes();
        if (parameterized == null || parameterized.length == 0) {
            return;
        }
        Object[] redirectGenericsTypes = node.redirect().getGenericsTypes();
        if (redirectGenericsTypes == null) {
            Object[] objectArray;
            redirectGenericsTypes = objectArray = parameterized;
        }
        int i = 0;
        while (i < redirectGenericsTypes.length) {
            GenericsType redirectType = (GenericsType)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])redirectGenericsTypes, (int)i), GenericsType.class);
            if (redirectType.isPlaceholder()) {
                String name = redirectType.getName();
                if (!map.containsKey(name) && !(i >= parameterized.length)) {
                    GenericsType value = (GenericsType)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])parameterized, (int)i), GenericsType.class);
                    ClassNode cn = value.getType();
                    ClassNode typeRef = AstGenericUtils.resolveTypeReference(cn);
                    if (value.isWildcard()) {
                        ClassNode lowerBound = value.getLowerBound();
                        if (lowerBound != null) {
                            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                            map.put(name, Collections.singletonMap(cn.getName(), newMap));
                            AstGenericUtils.extractPlaceholders(lowerBound, newMap, boundTypes);
                        }
                        ClassNode[] upperBounds = value.getUpperBounds();
                        if (upperBounds != null) {
                            ClassNode upperBound2 = null;
                            ClassNode[] classNodeArray = upperBounds;
                            if (upperBounds != null) {
                                for (ClassNode upperBound2 : classNodeArray) {
                                    if (upperBound2.isGenericsPlaceHolder()) {
                                        map.put(name, AstGenericUtils.resolveTypeReference(upperBound2, boundTypes));
                                        continue;
                                    }
                                    LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                                    map.put(name, Collections.singletonMap(upperBound2.getName(), newMap));
                                    if (!cn.isUsingGenerics()) continue;
                                    AstGenericUtils.extractPlaceholders(upperBound2, newMap, boundTypes);
                                }
                            }
                        }
                    } else if (!value.isPlaceholder()) {
                        if (!cn.isUsingGenerics()) {
                            map.put(name, typeRef);
                        } else {
                            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                            map.put(name, Collections.singletonMap(cn.getName(), newMap));
                            AstGenericUtils.extractPlaceholders(cn, newMap, boundTypes);
                        }
                    } else if (boundTypes.containsKey(value.getName())) {
                        map.put(name, AstGenericUtils.resolveTypeReference((ClassNode)ScriptBytecodeAdapter.castToType((Object)boundTypes.get(value.getName()), ClassNode.class), boundTypes));
                    } else {
                        map.put(name, AstGenericUtils.resolveTypeReference(value.getType(), boundTypes));
                    }
                }
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AstGenericUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public static ClassNode resolveTypeReference(ClassNode classNode) {
        return AstGenericUtils.resolveTypeReference(classNode, Collections.emptyMap());
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

