/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.util.Assert;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

class DefaultMvcResult
implements MvcResult {
    private static final Object RESULT_NONE = new Object();
    private final MockHttpServletRequest mockRequest;
    private final MockHttpServletResponse mockResponse;
    @Nullable
    private Object handler;
    @Nullable
    private HandlerInterceptor[] interceptors;
    @Nullable
    private ModelAndView modelAndView;
    @Nullable
    private Exception resolvedException;
    private final AtomicReference<Object> asyncResult = new AtomicReference<Object>(RESULT_NONE);
    @Nullable
    private CountDownLatch asyncDispatchLatch;

    public DefaultMvcResult(MockHttpServletRequest request2, MockHttpServletResponse response) {
        this.mockRequest = request2;
        this.mockResponse = response;
    }

    @Override
    public MockHttpServletRequest getRequest() {
        return this.mockRequest;
    }

    @Override
    public MockHttpServletResponse getResponse() {
        return this.mockResponse;
    }

    public void setHandler(@Nullable Object handler) {
        this.handler = handler;
    }

    @Override
    @Nullable
    public Object getHandler() {
        return this.handler;
    }

    public void setInterceptors(HandlerInterceptor ... interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    @Nullable
    public HandlerInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setResolvedException(Exception resolvedException) {
        this.resolvedException = resolvedException;
    }

    @Override
    @Nullable
    public Exception getResolvedException() {
        return this.resolvedException;
    }

    public void setModelAndView(@Nullable ModelAndView mav) {
        this.modelAndView = mav;
    }

    @Override
    @Nullable
    public ModelAndView getModelAndView() {
        return this.modelAndView;
    }

    @Override
    public FlashMap getFlashMap() {
        return RequestContextUtils.getOutputFlashMap((HttpServletRequest)this.mockRequest);
    }

    public void setAsyncResult(Object asyncResult) {
        this.asyncResult.set(asyncResult);
    }

    @Override
    public Object getAsyncResult() {
        return this.getAsyncResult(-1L);
    }

    @Override
    public Object getAsyncResult(long timeToWait) {
        if (this.mockRequest.getAsyncContext() != null && timeToWait == -1L) {
            long requestTimeout = this.mockRequest.getAsyncContext().getTimeout();
            long l = timeToWait = requestTimeout == -1L ? Long.MAX_VALUE : requestTimeout;
        }
        if (!this.awaitAsyncDispatch(timeToWait)) {
            throw new IllegalStateException("Async result for handler [" + this.handler + "] was not set during the specified timeToWait=" + timeToWait);
        }
        Object result = this.asyncResult.get();
        Assert.state((result != RESULT_NONE ? 1 : 0) != 0, () -> "Async result for handler [" + this.handler + "] was not set");
        return this.asyncResult.get();
    }

    private boolean awaitAsyncDispatch(long timeout) {
        Assert.state((this.asyncDispatchLatch != null ? 1 : 0) != 0, (String)"The asyncDispatch CountDownLatch was not set by the TestDispatcherServlet.");
        try {
            return this.asyncDispatchLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    void setAsyncDispatchLatch(CountDownLatch asyncDispatchLatch) {
        this.asyncDispatchLatch = asyncDispatchLatch;
    }
}

