/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.internal.impl.synccontext.named.DiscriminatingNameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.FileGAVNameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.GAVNameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactorySelectorSupport;
import org.eclipse.aether.internal.impl.synccontext.named.StaticNameMapper;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import org.eclipse.aether.named.providers.NoopNamedLockFactory;

@Singleton
@Named
public final class SimpleNamedLockFactorySelector
extends NamedLockFactorySelectorSupport {
    private static final Map<String, NamedLockFactory> FACTORIES = new HashMap<String, NamedLockFactory>();
    private static final Map<String, NameMapper> NAME_MAPPERS;

    public SimpleNamedLockFactorySelector() {
        this(FACTORIES, NAME_MAPPERS);
    }

    @Inject
    public SimpleNamedLockFactorySelector(Map<String, NamedLockFactory> factories, Map<String, NameMapper> nameMappers) {
        super(factories, "rwlock-local", nameMappers, "gav");
    }

    static {
        FACTORIES.put("noop", (NamedLockFactory)new NoopNamedLockFactory());
        FACTORIES.put("rwlock-local", (NamedLockFactory)new LocalReadWriteLockNamedLockFactory());
        FACTORIES.put("semaphore-local", (NamedLockFactory)new LocalSemaphoreNamedLockFactory());
        FACTORIES.put("file-lock", (NamedLockFactory)new FileLockNamedLockFactory());
        NAME_MAPPERS = new HashMap<String, NameMapper>();
        NAME_MAPPERS.put("static", new StaticNameMapper());
        NAME_MAPPERS.put("gav", new GAVNameMapper());
        NAME_MAPPERS.put("discriminating", new DiscriminatingNameMapper(new GAVNameMapper()));
        NAME_MAPPERS.put("file-gav", new FileGAVNameMapper());
    }
}

