/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.graal;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectionConfig;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.CollectionUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;

@Internal
public interface GraalReflectionConfigurer
extends AnnotationMetadataProvider {
    public static final String CLASS_SUFFIX = "$ReflectConfig";

    default public void configure(ReflectionConfigurationContext context) {
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        List<AnnotationValue<ReflectionConfig>> values = annotationMetadata.getAnnotationValuesByType(ReflectionConfig.class);
        for (AnnotationValue<ReflectionConfig> reflectConfig : values) {
            reflectConfig.stringValue("type").ifPresent(className -> {
                Constructor<?>[] constructors;
                Field[] fields;
                Class<?> t = context.findClassByName((String)className);
                if (t == null) {
                    return;
                }
                context.register(t);
                Set<Enum> accessType = CollectionUtils.setOf(reflectConfig.enumValues("accessType", TypeHint.AccessType.class));
                if (accessType.contains((Object)TypeHint.AccessType.ALL_PUBLIC_METHODS)) {
                    Method[] methods = t.getMethods();
                    for (AccessibleObject accessibleObject : methods) {
                        if (!Modifier.isPublic(((Method)accessibleObject).getModifiers())) continue;
                        context.register(new Method[]{accessibleObject});
                    }
                }
                if (accessType.contains((Object)TypeHint.AccessType.ALL_DECLARED_METHODS)) {
                    Method[] declaredMethods = t.getDeclaredMethods();
                    context.register(declaredMethods);
                }
                if (accessType.contains((Object)TypeHint.AccessType.ALL_PUBLIC_FIELDS)) {
                    fields = t.getFields();
                    for (AccessibleObject accessibleObject : fields) {
                        if (!Modifier.isPublic(((Field)accessibleObject).getModifiers())) continue;
                        context.register(new Field[]{accessibleObject});
                    }
                }
                if (accessType.contains((Object)TypeHint.AccessType.ALL_DECLARED_FIELDS)) {
                    fields = t.getDeclaredFields();
                    context.register(fields);
                }
                if (accessType.contains((Object)TypeHint.AccessType.ALL_PUBLIC_CONSTRUCTORS)) {
                    constructors = t.getConstructors();
                    for (Constructor<?> constructor : constructors) {
                        if (!Modifier.isPublic(constructor.getModifiers())) continue;
                        context.register(constructor);
                    }
                }
                if (accessType.contains((Object)TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS)) {
                    constructors = t.getDeclaredConstructors();
                    context.register(constructors);
                }
                List<AnnotationValue<ReflectionConfig.ReflectiveMethodConfig>> methodConfig = reflectConfig.getAnnotations("methods", ReflectionConfig.ReflectiveMethodConfig.class);
                for (AnnotationValue annotationValue : methodConfig) {
                    annotationValue.stringValue("name").ifPresent(n -> {
                        String[] typeNames = mrc.stringValues("parameterTypes");
                        Class[] parameterTypes = new Class[typeNames.length];
                        for (int i = 0; i < typeNames.length; ++i) {
                            String typeName = typeNames[i];
                            Class<?> pt = context.findClassByName(typeName);
                            if (pt == null) {
                                return;
                            }
                            parameterTypes[i] = pt;
                        }
                        if (n.equals("<init>")) {
                            ReflectionUtils.findConstructor(t, parameterTypes).ifPresent(xva$0 -> context.register((Constructor<?>)xva$0));
                        } else {
                            ReflectionUtils.findMethod(t, n, parameterTypes).ifPresent(xva$0 -> context.register((Method)xva$0));
                        }
                    });
                }
                List<AnnotationValue<ReflectionConfig.ReflectiveFieldConfig>> fields2 = reflectConfig.getAnnotations("fields", ReflectionConfig.ReflectiveFieldConfig.class);
                for (AnnotationValue<ReflectionConfig.ReflectiveFieldConfig> field : fields2) {
                    field.stringValue("name").flatMap(n -> ReflectionUtils.findField(t, n)).ifPresent(xva$0 -> context.register((Field)xva$0));
                }
            });
        }
    }

    public static interface ReflectionConfigurationContext {
        @Nullable
        public Class<?> findClassByName(@NonNull String var1);

        public void register(Class<?> ... var1);

        public void register(Method ... var1);

        public void register(Field ... var1);

        public void register(Constructor<?> ... var1);
    }
}

