/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.graal.StaticServiceDefinitions;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(className="io.micronaut.core.io.service.ServiceScanner")
@Internal
final class ServiceLoaderInitialization {
    private ServiceLoaderInitialization() {
    }

    @Substitute
    private static Set<String> computeMicronautServiceTypeNames(URI uri, String path) {
        StaticServiceDefinitions ssd = (StaticServiceDefinitions)ImageSingletons.lookup(StaticServiceDefinitions.class);
        return ssd.serviceTypeMap.getOrDefault(path, Collections.emptySet());
    }
}

