/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.loadbalancer;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.loadbalancer.Connection;
import org.mortbay.loadbalancer.NonBlockingQueue;
import org.mortbay.loadbalancer.Server;

public class Policy {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$loadbalancer$Policy == null ? (class$org$mortbay$loadbalancer$Policy = Policy.class$("org.mortbay.loadbalancer.Policy")) : class$org$mortbay$loadbalancer$Policy));
    private Server[] _server;
    private int _next;
    private Map _stickyInet = new HashMap();
    static /* synthetic */ Class class$org$mortbay$loadbalancer$Policy;

    public Policy(Server[] server) {
        this._server = server;
    }

    public void deallocate(Connection connection, NonBlockingQueue queue, int tries) throws IOException {
        InetAddress client = connection.getClientSocketChannel().socket().getInetAddress();
        Object sticky = this._stickyInet.remove(client);
        log.info((Object)("Unstick " + client + " from " + sticky));
        if (tries + 1 < this._server.length) {
            this.allocate(connection, queue, tries + 1);
        } else {
            connection.close();
        }
    }

    public void allocate(Connection connection, NonBlockingQueue queue, int tries) throws IOException {
        Integer s;
        InetAddress client = connection.getClientSocketChannel().socket().getInetAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Allocate " + client + " size=" + queue.size()));
        }
        if ((s = (Integer)this._stickyInet.get(client)) == null) {
            this._next = (this._next + 1) % this._server.length;
            log.info((Object)("Stick " + client + " to " + this._next));
            connection.allocate(this._server[this._next], tries);
            this._stickyInet.put(client, new Integer(this._next));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(client + " stuck to " + s));
            }
            connection.allocate(this._server[s], tries);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

