/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.Token;

public class KeyDuplicates
extends TokenRule {
    private static final String STACK_KEY = "stack";

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (!context.containsKey(STACK_KEY)) {
            context.put(STACK_KEY, new ArrayList());
        }
        List stack = (List)context.get(STACK_KEY);
        if (token instanceof BlockMappingStartToken || token instanceof FlowMappingStartToken) {
            stack.add(new Parent(TYPE.MAP));
        } else if (token instanceof BlockSequenceStartToken || token instanceof FlowSequenceStartToken) {
            stack.add(new Parent(TYPE.SEQ));
        } else if (token instanceof BlockEndToken || token instanceof FlowMappingEndToken || token instanceof FlowSequenceEndToken) {
            stack.remove(stack.size() - 1);
        } else if (token instanceof KeyToken && next instanceof ScalarToken && !stack.isEmpty() && ((Parent)stack.get((int)(stack.size() - 1))).type == TYPE.MAP) {
            if (((Parent)stack.get((int)(stack.size() - 1))).keys.contains(((ScalarToken)next).getValue()) && !"<<".equals(((ScalarToken)next).getValue())) {
                problems.add(new LintProblem(next.getStartMark().getLine() + 1, next.getStartMark().getColumn() + 1, "duplication of key '" + ((ScalarToken)next).getValue() + "' in mapping"));
            } else {
                ((Parent)stack.get((int)(stack.size() - 1))).keys.add(((ScalarToken)next).getValue());
            }
        }
        return problems;
    }

    private class Parent {
        TYPE type;
        List<String> keys;

        public Parent(TYPE type) {
            this.type = type;
            this.keys = new ArrayList<String>();
        }
    }

    private static enum TYPE {
        MAP,
        SEQ;

    }
}

