/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryTool;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.model.SpecRepository;
import org.jreleaser.util.StringUtils;

public class Spec
extends AbstractRepositoryTool {
    public static final String NAME = "spec";
    private final List<String> requires = new ArrayList<String>();
    private final SpecRepository repository = new SpecRepository();
    private String release;

    public Spec() {
        super(NAME);
    }

    void setAll(Spec spec) {
        super.setAll(spec);
        this.release = spec.release;
        this.setRepository(spec.repository);
        this.setRequires(spec.requires);
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public SpecRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SpecRepository repository) {
        this.repository.setAll(repository);
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public void setRequires(List<String> requires) {
        this.requires.clear();
        this.requires.addAll(requires);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("release", this.release);
        props.put("requires", this.requires);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return distribution.getType() == Distribution.DistributionType.JAVA_BINARY;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(".tar.gz");
        set.add(".tgz");
        set.add(".tar");
        return set;
    }
}

