/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.assemblers.AssemblerUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JavaAssembler;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.util.FileType;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public class JlinkAssemblerProcessor
extends AbstractAssemblerProcessor<org.jreleaser.model.api.assemble.JlinkAssembler, JlinkAssembler> {
    public JlinkAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void fillAssemblerProperties(TemplateContext props) {
        super.fillAssemblerProperties(props);
        if (StringUtils.isNotBlank((String)((JlinkAssembler)this.assembler).getMainJar().getPath())) {
            props.set("distributionJavaMainJar", (Object)((JlinkAssembler)this.assembler).getMainJar().getEffectivePath(this.context, this.assembler).getFileName());
        } else {
            props.set("distributionJavaMainJar", (Object)"");
        }
        props.set("distributionJavaMainClass", (Object)((JlinkAssembler)this.assembler).getJava().getMainClass());
        props.set("distributionJavaMainModule", (Object)((JlinkAssembler)this.assembler).getJava().getMainModule());
        Set javaOptions = ((JlinkAssembler)this.assembler).getJava().getOptions();
        props.set("distributionJavaOptions", (Object)(!javaOptions.isEmpty() ? MustacheUtils.passThrough((String)String.join((CharSequence)" ", javaOptions)) : ""));
        props.set("distributionExecutable", (Object)((JlinkAssembler)this.assembler).getExecutable());
    }

    @Override
    protected void doAssemble(TemplateContext props) throws AssemblerProcessingException {
        boolean hasJavaArchive;
        Path jdkPath = ((JlinkAssembler)this.assembler).getJdk().getEffectivePath(this.context, this.assembler);
        SemanticVersion jdkVersion = SemanticVersion.of((String)AssemblerUtils.readJavaVersion(jdkPath));
        this.context.getLogger().debug(RB.$((String)"assembler.jlink.jdk", (Object[])new Object[0]), new Object[]{jdkVersion, jdkPath.toAbsolutePath().toString()});
        boolean selectedJdks = false;
        for (Artifact targetJdk : ((JlinkAssembler)this.assembler).getTargetJdks()) {
            if (!targetJdk.isActiveAndSelected()) continue;
            selectedJdks = true;
            Path targetJdkPath = targetJdk.getEffectivePath(this.context, this.assembler);
            SemanticVersion targetJdkVersion = SemanticVersion.of((String)AssemblerUtils.readJavaVersion(targetJdkPath));
            this.context.getLogger().debug(RB.$((String)"assembler.jlink.target", (Object[])new Object[0]), new Object[]{jdkVersion, targetJdkPath.toAbsolutePath().toString()});
            if (jdkVersion.getMajor() == targetJdkVersion.getMajor()) continue;
            throw new AssemblerProcessingException(RB.$((String)"ERROR_jlink_target_not_compatible", (Object[])new Object[]{targetJdkVersion, jdkVersion}));
        }
        if (!selectedJdks) {
            return;
        }
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path inputsDirectory = assembleDirectory.resolve("inputs");
        this.copyTemplates(this.context, props, inputsDirectory);
        String imageName = ((JlinkAssembler)this.assembler).getResolvedImageName(this.context);
        if (StringUtils.isNotBlank((String)((JlinkAssembler)this.assembler).getImageNameTransform())) {
            imageName = ((JlinkAssembler)this.assembler).getResolvedImageNameTransform(this.context);
        }
        if (hasJavaArchive = ((JlinkAssembler)this.assembler).getJavaArchive().isSet()) {
            String archiveFile = Templates.resolveTemplate((String)((JlinkAssembler)this.assembler).getJavaArchive().getPath(), (TemplateContext)props);
            Path archivePath = this.context.getBasedir().resolve(Paths.get(archiveFile, new String[0]));
            if (!Files.exists(archivePath, new LinkOption[0])) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{archivePath}));
            }
            Path archiveDirectory = inputsDirectory.resolve("archive");
            try {
                FileUtils.unpackArchive((Path)archivePath, (Path)archiveDirectory, (boolean)true);
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
            }
        }
        Path jarsDirectory = inputsDirectory.resolve("jars");
        Path universalJarsDirectory = jarsDirectory.resolve("universal");
        if (hasJavaArchive) {
            String libDirectoryName = Templates.resolveTemplate((String)((JlinkAssembler)this.assembler).getJavaArchive().getLibDirectoryName(), (TemplateContext)props);
            Path libPath = inputsDirectory.resolve("archive").resolve(libDirectoryName);
            try {
                FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)libPath, (Path)universalJarsDirectory);
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
            }
        }
        this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(universalJarsDirectory)});
        AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, universalJarsDirectory, "");
        for (Artifact targetJdk : ((JlinkAssembler)this.assembler).getTargetJdks()) {
            if (!targetJdk.isActiveAndSelected()) continue;
            String platform = targetJdk.getPlatform();
            Path platformJarsDirectory = jarsDirectory.resolve(platform);
            this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(platformJarsDirectory)});
            AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, platformJarsDirectory, platform);
            TreeSet<String> moduleNames = new TreeSet<String>(this.resolveModuleNames(this.context, jdkPath, jarsDirectory, platform, props));
            this.context.getLogger().debug(RB.$((String)"assembler.resolved.module.names", (Object[])new Object[0]), new Object[]{moduleNames});
            if (moduleNames.isEmpty()) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_no_module_names", (Object[])new Object[0]));
            }
            moduleNames.addAll(((JlinkAssembler)this.assembler).getAdditionalModuleNames());
            if (StringUtils.isNotBlank((String)((JlinkAssembler)this.assembler).getJava().getMainModule())) {
                moduleNames.add(((JlinkAssembler)this.assembler).getJava().getMainModule());
            }
            this.context.getLogger().debug(RB.$((String)"assembler.module.names", (Object[])new Object[0]), new Object[]{moduleNames});
            String str = targetJdk.getExtraProperties().getOrDefault("archiveFormat", ((JlinkAssembler)this.assembler).getArchiveFormat()).toString();
            Archive.Format archiveFormat = Archive.Format.of((String)str);
            this.jlink(props, assembleDirectory, jdkPath, targetJdk, moduleNames, imageName, archiveFormat);
        }
    }

    private void jlink(TemplateContext props, Path assembleDirectory, Path jdkPath, Artifact targetJdk, Set<String> moduleNames, String imageName, Archive.Format archiveFormat) throws AssemblerProcessingException {
        String platform = targetJdk.getPlatform();
        String platformReplaced = ((JlinkAssembler)this.assembler).getPlatform().applyReplacements(platform);
        String finalImageName = imageName + "-" + platformReplaced;
        this.context.getLogger().info("- {}", new Object[]{finalImageName});
        boolean hasJavaArchive = ((JlinkAssembler)this.assembler).getJavaArchive().isSet();
        Path inputsDirectory = assembleDirectory.resolve("inputs");
        Path archiveDirectory = inputsDirectory.resolve("archive");
        Path jarsDirectory = inputsDirectory.resolve("jars");
        Path workDirectory = assembleDirectory.resolve("work-" + platform);
        Path imageDirectory = workDirectory.resolve(finalImageName).toAbsolutePath();
        try {
            FileUtils.deleteFiles((Path)imageDirectory);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_image", (Object[])new Object[]{finalImageName}), (Throwable)e);
        }
        String moduleName = ((JlinkAssembler)this.assembler).getJava().getMainModule();
        String modulePath = this.maybeQuote(targetJdk.getEffectivePath(this.context, this.assembler).resolve("jmods").toAbsolutePath().toString());
        if (StringUtils.isNotBlank((String)moduleName) || ((JlinkAssembler)this.assembler).isCopyJars()) {
            modulePath = modulePath + File.pathSeparator + this.maybeQuote(jarsDirectory.resolve("universal").toAbsolutePath().toString());
            try {
                Path platformJarsDirectory = jarsDirectory.resolve(platform).toAbsolutePath();
                if (FileUtils.listFilesAndProcess((Path)platformJarsDirectory, Stream::count).orElse(0L) > 1L) {
                    modulePath = modulePath + File.pathSeparator + this.maybeQuote(platformJarsDirectory.toString());
                }
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[]{e}));
            }
        }
        Path jlinkExecutable = jdkPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "jlink.exe" : "jlink").toAbsolutePath();
        Command cmd = new Command(jlinkExecutable.toString(), true).args((Collection)((JlinkAssembler)this.assembler).getArgs()).arg("--module-path").arg(modulePath).arg("--add-modules").arg(String.join((CharSequence)",", moduleNames));
        if (StringUtils.isNotBlank((String)moduleName)) {
            cmd.arg("--launcher").arg(((JlinkAssembler)this.assembler).getExecutable() + "=" + moduleName + "/" + ((JlinkAssembler)this.assembler).getJava().getMainClass());
        }
        cmd.arg("--output").arg(this.maybeQuote(imageDirectory.toString()));
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        this.executeCommand(cmd);
        if (StringUtils.isBlank((String)moduleName)) {
            if (((JlinkAssembler)this.assembler).isCopyJars()) {
                Path outputJarsDirectory = imageDirectory.resolve("jars");
                try {
                    Files.createDirectory(outputJarsDirectory, new FileAttribute[0]);
                    FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)jarsDirectory.resolve("universal"), (Path)outputJarsDirectory);
                    FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)jarsDirectory.resolve(platform), (Path)outputJarsDirectory);
                }
                catch (IOException e) {
                    throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copy_jars", (Object[])new Object[]{this.context.relativizeToBasedir(outputJarsDirectory)}), (Throwable)e);
                }
            }
            Path binDirectory = imageDirectory.resolve("bin");
            try {
                Files.createDirectories(binDirectory, new FileAttribute[0]);
                Optional launchers = FileUtils.listFilesAndProcess((Path)inputsDirectory.resolve("bin"), files -> files.collect(Collectors.toSet()));
                if (launchers.isPresent()) {
                    for (Path srcLauncher : (Set)launchers.get()) {
                        Path destLauncher = binDirectory.resolve(srcLauncher.getFileName());
                        Files.copy(srcLauncher, destLauncher, new CopyOption[0]);
                        FileUtils.grantExecutableAccess((Path)destLauncher);
                    }
                }
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copy_launcher", (Object[])new Object[]{this.context.relativizeToBasedir(binDirectory)}), (Throwable)e);
            }
        }
        try {
            Path imageArchive = assembleDirectory.resolve(finalImageName + "." + archiveFormat.extension());
            FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)this.context.getBasedir(), (Path)imageDirectory, path -> path.getFileName().startsWith("LICENSE"));
            FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)inputsDirectory, (Path)imageDirectory, path -> {
                if (!"bin".equals(path.getParent().getFileName().toString())) {
                    return true;
                }
                String fileName = path.getFileName().toString();
                if (fileName.endsWith(FileType.JAR.extension()) && "jars".equals(path.getParent().getParent().getFileName().toString())) {
                    return false;
                }
                Path candidateBinary = imageDirectory.resolve("bin").resolve(fileName);
                return !Files.exists(candidateBinary, new LinkOption[0]);
            });
            if (hasJavaArchive) {
                String libDirectory = Templates.resolveTemplate((String)((JlinkAssembler)this.assembler).getJavaArchive().getLibDirectoryName(), (TemplateContext)props);
                String archivePathName = archiveDirectory.toString();
                FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)archiveDirectory, (Path)imageDirectory, path -> {
                    String fileName = path.getFileName().toString();
                    if (!fileName.endsWith(FileType.JAR.extension())) {
                        return true;
                    }
                    return !path.getParent().toString().substring(archivePathName.length()).contains(libDirectory);
                });
            }
            this.copyArtifacts(this.context, imageDirectory, platform, true);
            this.copyFiles(this.context, imageDirectory);
            this.copyFileSets(this.context, imageDirectory);
            FileUtils.packArchive((Path)workDirectory, (Path)imageArchive, (FileUtils.ArchiveOptions)((JlinkAssembler)this.assembler).getOptions().toOptions());
            this.context.getLogger().debug("- {}", new Object[]{imageArchive.getFileName()});
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private Set<String> resolveModuleNames(JReleaserContext context, Path jdkPath, Path jarsDirectory, String platform, TemplateContext props) throws AssemblerProcessingException {
        if (!((JlinkAssembler)this.assembler).getModuleNames().isEmpty()) {
            return ((JlinkAssembler)this.assembler).getModuleNames();
        }
        Path jdepsExecutable = jdkPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "jdeps.exe" : "jdeps").toAbsolutePath();
        Command cmd = new Command(jdepsExecutable.toAbsolutePath().toString());
        String multiRelease = ((JlinkAssembler)this.assembler).getJdeps().getMultiRelease();
        if (StringUtils.isNotBlank((String)multiRelease)) {
            cmd.arg("--multi-release").arg(multiRelease);
        }
        if (((JlinkAssembler)this.assembler).getJdeps().isIgnoreMissingDeps()) {
            cmd.arg("--ignore-missing-deps");
        }
        cmd.arg("--print-module-deps");
        String moduleName = ((JlinkAssembler)this.assembler).getJava().getMainModule();
        if (StringUtils.isNotBlank((String)moduleName)) {
            cmd.arg("--module").arg(moduleName).arg("--module-path");
            this.calculateJarPath(jarsDirectory, platform, cmd, true);
        } else if (!((JlinkAssembler)this.assembler).getJdeps().getTargets().isEmpty()) {
            cmd.arg("--class-path");
            if (((JlinkAssembler)this.assembler).getJdeps().isUseWildcardInPath()) {
                cmd.arg("universal" + File.separator + "*" + File.pathSeparator + platform + File.separator + "*");
            } else {
                this.calculateJarPath(jarsDirectory, platform, cmd, true);
            }
            ((JlinkAssembler)this.assembler).getJdeps().getTargets().stream().map(target -> Templates.resolveTemplate((String)target, (TemplateContext)props)).filter(StringUtils::isNotBlank).map(AssemblerUtils::maybeAdjust).map(arg_0 -> ((JReleaserContext)context).relativizeToBasedir(arg_0)).map(p -> p.toAbsolutePath().normalize().toString()).forEach(arg_0 -> ((Command)cmd).arg(arg_0));
        } else {
            this.calculateJarPath(jarsDirectory, platform, cmd, false);
        }
        context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        Command.Result result = this.executeCommand(jarsDirectory, cmd);
        String output = result.getOut();
        long lineCount = Arrays.stream(output.split(System.lineSeparator())).map(String::trim).count();
        if (lineCount == 1L && StringUtils.isNotBlank((String)output)) {
            return Arrays.stream(output.split(",")).collect(Collectors.toSet());
        }
        throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_jdeps_error", (Object[])new Object[]{output}));
    }

    private void calculateJarPath(Path jarsDirectory, String platform, Command cmd, boolean join) throws AssemblerProcessingException {
        try {
            if (join) {
                StringBuilder pathBuilder = new StringBuilder();
                FileUtils.listFilesAndProcess((Path)jarsDirectory.resolve("universal"), files -> files.map(Path::toAbsolutePath).map(Object::toString).collect(Collectors.joining(File.pathSeparator))).ifPresent(pathBuilder::append);
                FileUtils.listFilesAndProcess((Path)jarsDirectory.resolve(platform), files -> files.map(Path::toAbsolutePath).map(Object::toString).collect(Collectors.joining(File.pathSeparator))).ifPresent(platformSpecific -> {
                    if (StringUtils.isNotBlank((String)platformSpecific)) {
                        pathBuilder.append(File.pathSeparator).append((String)platformSpecific);
                    }
                });
                cmd.arg(pathBuilder.toString());
            } else {
                FileUtils.listFilesAndConsume((Path)jarsDirectory.resolve("universal"), files -> files.map(Path::toAbsolutePath).map(Object::toString).forEach(arg_0 -> ((Command)cmd).arg(arg_0)));
                FileUtils.listFilesAndConsume((Path)jarsDirectory.resolve(platform), files -> files.map(Path::toAbsolutePath).map(Object::toString).forEach(arg_0 -> ((Command)cmd).arg(arg_0)));
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_jdeps_error", (Object[])new Object[]{e.getMessage(), e}));
        }
    }

    @Override
    protected Path resolveOutputFile(TemplateContext props, Path targetDirectory, String fileName) throws AssemblerProcessingException {
        String executableName = ((JlinkAssembler)this.assembler).getExecutable();
        return "bin/launcher.bat".equals(fileName) ? targetDirectory.resolve("bin").resolve(executableName.concat(FileType.BAT.extension())) : ("bin/launcher".equals(fileName) ? targetDirectory.resolve("bin").resolve(executableName) : targetDirectory.resolve(fileName));
    }
}

