/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.database;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.database.DatabaseMetadata;
import org.javacs.kt.database.DatabaseMetadataEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0014\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u000e\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001d\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\f0\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0011R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/javacs/kt/database/DatabaseService;", "", "<init>", "()V", "value", "Lorg/jetbrains/exposed/sql/Database;", "db", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "setup", "", "storagePath", "Ljava/nio/file/Path;", "getDbFromFile", "deleteDb", "getDbFilePath", "kotlin.jvm.PlatformType", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "Companion", "shared"})
@SourceDebugExtension(value={"SMAP\nDatabaseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseService.kt\norg/javacs/kt/database/DatabaseService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class DatabaseService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Database db;
    public static final int DB_VERSION = 4;
    @NotNull
    public static final String DB_FILENAME = "kls_database.db";

    @Nullable
    public final Database getDb() {
        return this.db;
    }

    public final void setup(@Nullable Path storagePath) {
        this.db = this.getDbFromFile(storagePath);
        int currentVersion = ((Number)ThreadLocalTransactionManagerKt.transaction((Database)this.db, DatabaseService::setup$lambda$0)).intValue();
        if (currentVersion != 4) {
            LoggerKt.getLOG().info("Database has version " + currentVersion + " != 4 (the required version), therefore it will be rebuilt...", new Object[0]);
            this.deleteDb(storagePath);
            this.db = this.getDbFromFile(storagePath);
            ThreadLocalTransactionManagerKt.transaction((Database)this.db, DatabaseService::setup$lambda$2);
        } else {
            LoggerKt.getLOG().info("Database has the correct version " + currentVersion + " and will be used as-is", new Object[0]);
        }
    }

    private final Database getDbFromFile(Path storagePath) {
        Database database;
        Path path = storagePath;
        if (path != null) {
            Path it = path;
            boolean bl = false;
            database = Files.isDirectory(it, new LinkOption[0]) ? Database.Companion.connect$default((Database.Companion)Database.Companion, (String)("jdbc:sqlite:" + this.getDbFilePath(it)), null, null, null, null, null, null, (int)126, null) : null;
        } else {
            database = null;
        }
        return database;
    }

    private final void deleteDb(Path storagePath) {
        block0: {
            Path path = storagePath;
            if (path == null) break block0;
            Path it = path;
            boolean bl = false;
            Files.deleteIfExists(this.getDbFilePath(it));
        }
    }

    private final Path getDbFilePath(Path storagePath) {
        String[] stringArray = new String[]{DB_FILENAME};
        return Path.of(((Object)storagePath).toString(), stringArray);
    }

    private static final int setup$lambda$0(Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{DatabaseMetadata.INSTANCE};
        SchemaUtils.createMissingTablesAndColumns$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (boolean)false, (int)6, null);
        DatabaseMetadataEntity databaseMetadataEntity = (DatabaseMetadataEntity)((Object)CollectionsKt.firstOrNull((Iterable)((Iterable)DatabaseMetadataEntity.Companion.all())));
        return databaseMetadataEntity != null ? databaseMetadataEntity.getVersion() : 0;
    }

    private static final Unit setup$lambda$2$lambda$1(DatabaseMetadata $this$insert, InsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$insert), (String)"$this$insert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($this$insert.getVersion(), (Object)4);
        return Unit.INSTANCE;
    }

    private static final InsertStatement setup$lambda$2(Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{DatabaseMetadata.INSTANCE};
        SchemaUtils.createMissingTablesAndColumns$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (boolean)false, (int)6, null);
        QueriesKt.deleteAll((Table)((Table)DatabaseMetadata.INSTANCE));
        return QueriesKt.insert((Table)((Table)DatabaseMetadata.INSTANCE), DatabaseService::setup$lambda$2$lambda$1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/javacs/kt/database/DatabaseService$Companion;", "", "<init>", "()V", "DB_VERSION", "", "DB_FILENAME", "", "shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

