/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.fir;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.lightTree.fir.modifier.Modifier;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u000bJ\u0006\u0010#\u001a\u00020\u000bJ\u0006\u0010$\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020\u000bJ\u0006\u0010&\u001a\u00020\u000bJ\b\u0010'\u001a\u00020\u000bH\u0002J\u0006\u0010(\u001a\u00020\u000bJ\u0006\u0010)\u001a\u00020\u000bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/fir/ClassWrapper;", "", "className", "Lorg/jetbrains/kotlin/name/Name;", "modifiers", "Lorg/jetbrains/kotlin/fir/lightTree/fir/modifier/Modifier;", "classKind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "classBuilder", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "hasPrimaryConstructor", "", "hasSecondaryConstructor", "hasDefaultConstructor", "delegatedSelfTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "delegatedSuperTypeRef", "superTypeCallEntry", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/fir/lightTree/fir/modifier/Modifier;Lorg/jetbrains/kotlin/descriptors/ClassKind;Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;ZZZLorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Ljava/util/List;)V", "getClassBuilder", "()Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "getDelegatedSelfTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getDelegatedSuperTypeRef", "getHasDefaultConstructor", "()Z", "getHasPrimaryConstructor", "getHasSecondaryConstructor", "getSuperTypeCallEntry", "()Ljava/util/List;", "defaultConstructorVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "hasExpect", "isEnum", "isEnumEntry", "isInner", "isInterface", "isObject", "isObjectLiteral", "isSealed", "light-tree2fir"})
public final class ClassWrapper {
    @NotNull
    private final Name className;
    @NotNull
    private final Modifier modifiers;
    @NotNull
    private final ClassKind classKind;
    @NotNull
    private final FirClassBuilder classBuilder;
    private final boolean hasPrimaryConstructor;
    private final boolean hasSecondaryConstructor;
    private final boolean hasDefaultConstructor;
    @NotNull
    private final FirTypeRef delegatedSelfTypeRef;
    @NotNull
    private final FirTypeRef delegatedSuperTypeRef;
    @NotNull
    private final List<FirExpression> superTypeCallEntry;

    public ClassWrapper(@NotNull Name className2, @NotNull Modifier modifiers2, @NotNull ClassKind classKind, @NotNull FirClassBuilder classBuilder2, boolean hasPrimaryConstructor, boolean hasSecondaryConstructor, boolean hasDefaultConstructor, @NotNull FirTypeRef delegatedSelfTypeRef, @NotNull FirTypeRef delegatedSuperTypeRef, @NotNull List<? extends FirExpression> superTypeCallEntry) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        Intrinsics.checkNotNullParameter((Object)modifiers2, (String)"modifiers");
        Intrinsics.checkNotNullParameter((Object)((Object)classKind), (String)"classKind");
        Intrinsics.checkNotNullParameter((Object)classBuilder2, (String)"classBuilder");
        Intrinsics.checkNotNullParameter((Object)delegatedSelfTypeRef, (String)"delegatedSelfTypeRef");
        Intrinsics.checkNotNullParameter((Object)delegatedSuperTypeRef, (String)"delegatedSuperTypeRef");
        Intrinsics.checkNotNullParameter(superTypeCallEntry, (String)"superTypeCallEntry");
        this.className = className2;
        this.modifiers = modifiers2;
        this.classKind = classKind;
        this.classBuilder = classBuilder2;
        this.hasPrimaryConstructor = hasPrimaryConstructor;
        this.hasSecondaryConstructor = hasSecondaryConstructor;
        this.hasDefaultConstructor = hasDefaultConstructor;
        this.delegatedSelfTypeRef = delegatedSelfTypeRef;
        this.delegatedSuperTypeRef = delegatedSuperTypeRef;
        this.superTypeCallEntry = superTypeCallEntry;
    }

    @NotNull
    public final FirClassBuilder getClassBuilder() {
        return this.classBuilder;
    }

    public final boolean getHasPrimaryConstructor() {
        return this.hasPrimaryConstructor;
    }

    public final boolean getHasSecondaryConstructor() {
        return this.hasSecondaryConstructor;
    }

    public final boolean getHasDefaultConstructor() {
        return this.hasDefaultConstructor;
    }

    @NotNull
    public final FirTypeRef getDelegatedSelfTypeRef() {
        return this.delegatedSelfTypeRef;
    }

    @NotNull
    public final FirTypeRef getDelegatedSuperTypeRef() {
        return this.delegatedSuperTypeRef;
    }

    @NotNull
    public final List<FirExpression> getSuperTypeCallEntry() {
        return this.superTypeCallEntry;
    }

    public final boolean isObjectLiteral() {
        return Intrinsics.areEqual((Object)this.className, (Object)SpecialNames.NO_NAME_PROVIDED) && this.isObject();
    }

    public final boolean isEnumEntry() {
        return this.classKind == ClassKind.ENUM_ENTRY;
    }

    private final boolean isObject() {
        return this.classKind == ClassKind.OBJECT;
    }

    public final boolean isSealed() {
        return this.modifiers.hasModality(Modality.SEALED);
    }

    public final boolean isEnum() {
        return this.modifiers.isEnum();
    }

    public final boolean isInterface() {
        return this.classKind == ClassKind.INTERFACE;
    }

    public final boolean isInner() {
        return this.modifiers.isInner();
    }

    public final boolean hasExpect() {
        return this.modifiers.hasExpect();
    }

    @NotNull
    public final Visibility defaultConstructorVisibility() {
        return this.isObject() || this.isEnum() || this.isEnumEntry() ? (Visibility)Visibilities.Private.INSTANCE : (this.isSealed() ? (Visibility)Visibilities.Protected.INSTANCE : (Visibility)Visibilities.Unknown.INSTANCE);
    }
}

