/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.ClassPathEntry;
import org.javacs.kt.classpath.ClassPathResolver;
import org.javacs.kt.classpath.ShellClassPathResolver;
import org.javacs.kt.util.ShellPathUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/javacs/kt/classpath/ShellClassPathResolver;", "Lorg/javacs/kt/classpath/ClassPathResolver;", "script", "Ljava/nio/file/Path;", "workingDir", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "classpath", "", "Lorg/javacs/kt/classpath/ClassPathEntry;", "getClasspath", "()Ljava/util/Set;", "resolverType", "", "getResolverType", "()Ljava/lang/String;", "Companion", "shared"})
@SourceDebugExtension(value={"SMAP\nShellClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellClassPathResolver.kt\norg/javacs/kt/classpath/ShellClassPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class ShellClassPathResolver
implements ClassPathResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Path script;
    @Nullable
    private final Path workingDir;
    @NotNull
    private final String resolverType;
    @NotNull
    private static final List<String> scriptExtensions;
    @NotNull
    private static final Path globalConfigRoot;

    public ShellClassPathResolver(@NotNull Path script, @Nullable Path workingDir) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.script = script;
        this.workingDir = workingDir;
        this.resolverType = "Shell";
    }

    public /* synthetic */ ShellClassPathResolver(Path path, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path2 = null;
        }
        this(path, path2);
    }

    @Override
    @NotNull
    public String getResolverType() {
        return this.resolverType;
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspath() {
        Comparable<Path> comparable = this.workingDir;
        if (comparable == null || (comparable = comparable.toFile()) == null) {
            comparable = this.script.toAbsolutePath().getParent().toFile();
        }
        Comparable<Path> workingDirectory = comparable;
        String cmd = ((Object)this.script).toString();
        Object[] objectArray = new Object[]{cmd, workingDirectory};
        LoggerKt.getLOG().info("Run {} in {}", objectArray);
        String[] stringArray = new String[]{cmd};
        Process process = new ProcessBuilder(stringArray).directory((File)workingDirectory).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        stringArray = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)stringArray, charset);
        int n = 8192;
        CharSequence charSequence = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null)), (Function1)classpath.1.INSTANCE), (Function1)classpath.2.INSTANCE), (Function1)classpath.3.INSTANCE));
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getClasspathOrEmpty(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspath() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspath(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspathOrEmpty(this);
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathWithSources() {
        return ClassPathResolver.DefaultImpls.getClasspathWithSources(this);
    }

    static {
        Path path;
        Path path2;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{"sh", "bat", "cmd"};
        scriptExtensions = CollectionsKt.listOf((Object[])objectArray);
        String string = System.getenv("XDG_CONFIG_HOME");
        if (string != null) {
            String it = string;
            boolean bl = false;
            path2 = Paths.get(it, new String[0]);
        } else {
            path2 = path = null;
        }
        if (path2 == null) {
            Path path3 = ShellPathUtilsKt.getUserHome().resolve(".config");
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"userHome.resolve(\".config\")");
        }
        globalConfigRoot = path;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/javacs/kt/classpath/ShellClassPathResolver$Companion;", "", "()V", "globalConfigRoot", "Ljava/nio/file/Path;", "scriptExtensions", "", "", "global", "Lorg/javacs/kt/classpath/ClassPathResolver;", "workingDir", "maybeCreate", "Lorg/javacs/kt/classpath/ShellClassPathResolver;", "file", "shared"})
    @SourceDebugExtension(value={"SMAP\nShellClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellClassPathResolver.kt\norg/javacs/kt/classpath/ShellClassPathResolver$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1#2:56\n1747#3,3:57\n1549#3:60\n1620#3,3:61\n288#3,2:64\n*S KotlinDebug\n*F\n+ 1 ShellClassPathResolver.kt\norg/javacs/kt/classpath/ShellClassPathResolver$Companion\n*L\n36#1:57,3\n48#1:60\n48#1:61,3\n49#1:64,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ShellClassPathResolver maybeCreate(@NotNull Path file) {
            ShellClassPathResolver shellClassPathResolver;
            Path path;
            boolean bl;
            Path it;
            Path path2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                it = path2 = file;
                boolean bl2 = false;
                Iterable $this$any$iv = scriptExtensions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it2 = (String)element$iv;
                        boolean bl3 = false;
                        if (!file.endsWith("kotlinLspClasspath." + it2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            Path path3 = path = bl ? path2 : null;
            if (path != null) {
                it = path;
                boolean bl4 = false;
                shellClassPathResolver = new ShellClassPathResolver(it, null, 2, null);
            } else {
                shellClassPathResolver = null;
            }
            return shellClassPathResolver;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public final ClassPathResolver global(@Nullable Path workingDir) {
            ClassPathResolver classPathResolver;
            Path path = globalConfigRoot.resolve("KotlinLanguageServer");
            if (path != null) {
                Path path2;
                Object v0;
                block4: {
                    void $this$firstOrNull$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    Path root = path;
                    boolean bl = false;
                    Iterable iterable = scriptExtensions;
                    boolean $i$f$map = false;
                    Iterator iterator = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(root.resolve("classpath." + (String)it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Path it = (Path)element$iv;
                        boolean bl3 = false;
                        if (!Files.exists(it, new LinkOption[0])) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                if ((path2 = (Path)v0) != null) {
                    Path it = path2;
                    boolean bl = false;
                    classPathResolver = new ShellClassPathResolver(it, workingDir);
                    return classPathResolver;
                }
            }
            classPathResolver = ClassPathResolver.Companion.getEmpty();
            return classPathResolver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

