/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt;

import com.intellij.lang.Language;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.NotifySourcePath;
import org.javacs.kt.ScriptsConfiguration;
import org.javacs.kt.SourceExclusions;
import org.javacs.kt.SourceFiles;
import org.javacs.kt.SourceFilesKt;
import org.javacs.kt.SourcePath;
import org.javacs.kt.SourceVersion;
import org.javacs.kt.URIContentProvider;
import org.javacs.kt.util.KotlinLSException;
import org.javacs.kt.util.URIsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000fJ$\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0!2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u000fJ\u0010\u0010$\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u001e\u0010\r\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001cJ\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020#H\u0002J\u000e\u0010-\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\b\u0010.\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/javacs/kt/SourceFiles;", "", "sp", "Lorg/javacs/kt/SourcePath;", "contentProvider", "Lorg/javacs/kt/URIContentProvider;", "scriptsConfig", "Lorg/javacs/kt/ScriptsConfiguration;", "(Lorg/javacs/kt/SourcePath;Lorg/javacs/kt/URIContentProvider;Lorg/javacs/kt/ScriptsConfiguration;)V", "exclusions", "Lorg/javacs/kt/SourceExclusions;", "files", "Lorg/javacs/kt/NotifySourcePath;", "open", "", "Ljava/net/URI;", "workspaceRoots", "Ljava/nio/file/Path;", "addWorkspaceRoot", "", "root", "changedOnDisk", "uri", "close", "createdOnDisk", "deletedOnDisk", "edit", "newVersion", "", "contentChanges", "", "Lorg/eclipse/lsp4j/TextDocumentContentChangeEvent;", "findSourceFiles", "", "isOpen", "", "isSource", "languageOf", "Lcom/intellij/lang/Language;", "content", "", "version", "readFromDisk", "Lorg/javacs/kt/SourceVersion;", "temporary", "removeWorkspaceRoot", "updateExclusions", "server"})
@SourceDebugExtension(value={"SMAP\nSourceFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFiles.kt\norg/javacs/kt/SourceFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n766#2:247\n857#2,2:248\n*S KotlinDebug\n*F\n+ 1 SourceFiles.kt\norg/javacs/kt/SourceFiles\n*L\n170#1:247\n170#1:248,2\n*E\n"})
public final class SourceFiles {
    @NotNull
    private final SourcePath sp;
    @NotNull
    private final URIContentProvider contentProvider;
    @NotNull
    private final ScriptsConfiguration scriptsConfig;
    @NotNull
    private final Set<Path> workspaceRoots;
    @NotNull
    private SourceExclusions exclusions;
    @NotNull
    private final NotifySourcePath files;
    @NotNull
    private final Set<URI> open;

    public SourceFiles(@NotNull SourcePath sp, @NotNull URIContentProvider contentProvider, @NotNull ScriptsConfiguration scriptsConfig) {
        Intrinsics.checkNotNullParameter((Object)sp, (String)"sp");
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        Intrinsics.checkNotNullParameter((Object)scriptsConfig, (String)"scriptsConfig");
        this.sp = sp;
        this.contentProvider = contentProvider;
        this.scriptsConfig = scriptsConfig;
        this.workspaceRoots = new LinkedHashSet();
        this.exclusions = new SourceExclusions((Collection)this.workspaceRoots);
        this.files = new NotifySourcePath(this.sp);
        this.open = new LinkedHashSet();
    }

    public final void open(@NotNull URI uri, @NotNull String content, int version) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.files.set(uri, new SourceVersion(content, version, this.languageOf(uri), !this.exclusions.isURIIncluded(uri)));
        this.open.add(uri);
    }

    public final void close(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (this.open.contains(uri)) {
            this.open.remove(uri);
            boolean removed = this.files.removeIfTemporary(uri);
            if (!removed) {
                SourceVersion disk = this.readFromDisk(uri, false);
                if (disk != null) {
                    this.files.set(uri, disk);
                } else {
                    this.files.remove(uri);
                }
            }
        }
    }

    public final void edit(@NotNull URI uri, int newVersion, @NotNull List<? extends TextDocumentContentChangeEvent> contentChanges) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(contentChanges, (String)"contentChanges");
        if (this.exclusions.isURIIncluded(uri)) {
            SourceVersion sourceVersion = this.files.get(uri);
            Intrinsics.checkNotNull((Object)sourceVersion);
            SourceVersion existing = sourceVersion;
            String newText = existing.getContent();
            if (newVersion <= existing.getVersion()) {
                Object[] objectArray = new Object[]{URIsKt.describeURI((URI)uri), newVersion};
                LoggerKt.getLOG().warn("Ignored {} version {}", objectArray);
                return;
            }
            for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : contentChanges) {
                if (textDocumentContentChangeEvent.getRange() == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)textDocumentContentChangeEvent.getText(), (String)"getText(...)");
                    continue;
                }
                newText = SourceFilesKt.access$patch(newText, textDocumentContentChangeEvent);
            }
            this.files.set(uri, new SourceVersion(newText, newVersion, existing.getLanguage(), existing.isTemporary()));
        }
    }

    public final void createdOnDisk(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.changedOnDisk(uri);
    }

    public final void deletedOnDisk(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (this.isSource(uri)) {
            this.files.remove(uri);
        }
    }

    public final void changedOnDisk(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (this.isSource(uri)) {
            SourceVersion sourceVersion = this.files.get(uri);
            SourceVersion sourceVersion2 = this.readFromDisk(uri, sourceVersion != null ? sourceVersion.isTemporary() : true);
            if (sourceVersion2 == null) {
                throw new KotlinLSException("Could not read source file '" + uri + "' after being changed on disk");
            }
            this.files.set(uri, sourceVersion2);
        }
    }

    private final SourceVersion readFromDisk(URI uri, boolean temporary) {
        SourceVersion sourceVersion;
        try {
            String content = this.contentProvider.contentOf(uri);
            sourceVersion = new SourceVersion(content, -1, this.languageOf(uri), temporary);
        }
        catch (FileNotFoundException e) {
            sourceVersion = null;
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{URIsKt.describeURI((URI)uri)};
            LoggerKt.getLOG().warn("Exception while reading source file {}", objectArray);
            sourceVersion = null;
        }
        return sourceVersion;
    }

    private final boolean isSource(URI uri) {
        return this.exclusions.isURIIncluded(uri) && this.languageOf(uri) != null;
    }

    private final Language languageOf(URI uri) {
        Object object = URIsKt.getFilePath((URI)uri);
        if (object == null || (object = object.getFileName()) == null || (object = object.toString()) == null) {
            return null;
        }
        Object fileName = object;
        return StringsKt.endsWith$default((String)fileName, (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".kts", (boolean)false, (int)2, null) ? (Language)KotlinLanguage.INSTANCE : null;
    }

    public final void addWorkspaceRoot(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Set<URI> addSources = this.findSourceFiles(root);
        SourceFilesKt.access$logAdded(addSources, root);
        for (URI uri : addSources) {
            Unit unit;
            if (this.readFromDisk(uri, false) != null) {
                SourceVersion it;
                boolean bl = false;
                this.files.set(uri, it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) continue;
            Object[] objectArray = new Object[]{uri.getPath()};
            LoggerKt.getLOG().warn("Could not read source file '{}'", objectArray);
        }
        this.workspaceRoots.add(root);
        this.updateExclusions();
    }

    /*
     * WARNING - void declaration
     */
    public final void removeWorkspaceRoot(@NotNull Path root) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Iterable $this$filter$iv = this.files.getKeys();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            URI it = (URI)element$iv$iv;
            boolean bl = false;
            Path path = URIsKt.getFilePath((URI)it);
            if (!(path != null ? path.startsWith(root) : false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rmSources = (List)destination$iv$iv;
        SourceFilesKt.access$logRemoved(rmSources, root);
        this.files.removeAll(rmSources);
        this.workspaceRoots.remove(root);
        this.updateExclusions();
    }

    private final Set<URI> findSourceFiles(Path root) {
        String glob = this.scriptsConfig.getEnabled() ? "*.{kt,kts}" : "*.kt";
        PathMatcher sourceMatcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)new SourceExclusions(root).walkIncluded(), (Function1)((Function1)new Function1<Path, Boolean>(sourceMatcher, this){
            final /* synthetic */ PathMatcher $sourceMatcher;
            final /* synthetic */ SourceFiles this$0;
            {
                this.$sourceMatcher = $sourceMatcher;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$sourceMatcher.matches(it.getFileName()) && (SourceFiles.access$getScriptsConfig$p(this.this$0).getBuildScriptsEnabled() || !it.endsWith(".gradle.kts"));
            }
        })), (Function1)findSourceFiles.2.INSTANCE));
    }

    private final void updateExclusions() {
        this.exclusions = new SourceExclusions((Collection)this.workspaceRoots);
    }

    public final boolean isOpen(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.open.contains(uri);
    }

    public static final /* synthetic */ ScriptsConfiguration access$getScriptsConfig$p(SourceFiles $this) {
        return $this.scriptsConfig;
    }
}

