/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.ClassPathEntry;
import org.javacs.kt.classpath.ClassPathResolver;
import org.javacs.kt.classpath.ShellClassPathResolver;
import org.javacs.kt.util.ShellPathUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/javacs/kt/classpath/ShellClassPathResolver;", "Lorg/javacs/kt/classpath/ClassPathResolver;", "script", "Ljava/nio/file/Path;", "workingDir", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "classpath", "", "Lorg/javacs/kt/classpath/ClassPathEntry;", "getClasspath", "()Ljava/util/Set;", "resolverType", "", "getResolverType", "()Ljava/lang/String;", "Companion", "shared"})
@SourceDebugExtension(value={"SMAP\nShellClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellClassPathResolver.kt\norg/javacs/kt/classpath/ShellClassPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class ShellClassPathResolver
implements ClassPathResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Path script;
    @Nullable
    private final Path workingDir;
    @NotNull
    private final String resolverType;
    @NotNull
    private static final List<String> configDirNames;
    @NotNull
    private static final List<String> scriptNames;
    @NotNull
    private static final List<String> scriptExtensions;
    @NotNull
    private static final Path globalConfigRoot;

    public ShellClassPathResolver(@NotNull Path script, @Nullable Path workingDir) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.script = script;
        this.workingDir = workingDir;
        this.resolverType = "Shell";
    }

    public /* synthetic */ ShellClassPathResolver(Path path, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path2 = null;
        }
        this(path, path2);
    }

    @Override
    @NotNull
    public String getResolverType() {
        return this.resolverType;
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspath() {
        Comparable<Path> comparable = this.workingDir;
        if (comparable == null || (comparable = comparable.toFile()) == null) {
            comparable = this.script.toAbsolutePath().getParent().toFile();
        }
        Comparable<Path> workingDirectory = comparable;
        String cmd = ((Object)this.script).toString();
        Object[] objectArray = new Object[]{cmd, workingDirectory};
        LoggerKt.getLOG().info("Run {} in {}", objectArray);
        String[] stringArray = new String[]{cmd};
        Process process = new ProcessBuilder(stringArray).directory((File)workingDirectory).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        stringArray = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)stringArray, charset);
        int n = 8192;
        CharSequence charSequence = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null)), (Function1)classpath.1.INSTANCE), (Function1)classpath.2.INSTANCE), (Function1)classpath.3.INSTANCE));
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getClasspathOrEmpty(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspath() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspath(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspathOrEmpty(this);
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathWithSources() {
        return ClassPathResolver.DefaultImpls.getClasspathWithSources(this);
    }

    @Override
    public long getCurrentBuildFileVersion() {
        return ClassPathResolver.DefaultImpls.getCurrentBuildFileVersion(this);
    }

    static {
        Path path;
        Path path2;
        List list;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{"kotlin-language-server", "KotlinLanguageServer"};
        configDirNames = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"kls-classpath", "kotlinLspClasspath"};
        scriptNames = CollectionsKt.listOf((Object[])objectArray);
        if (ShellPathUtilsKt.isOSWindows()) {
            objectArray = new String[]{".bat", ".cmd", ".ps1"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            objectArray = new String[]{"", ".sh", ".bash"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        scriptExtensions = list;
        String string = System.getenv("XDG_CONFIG_HOME");
        if (string != null) {
            String it = string;
            boolean bl = false;
            path2 = Paths.get(it, new String[0]);
        } else {
            path2 = path = null;
        }
        if (path2 == null) {
            Path path3 = ShellPathUtilsKt.getUserHome().resolve(".config");
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        }
        globalConfigRoot = path;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/javacs/kt/classpath/ShellClassPathResolver$Companion;", "", "()V", "configDirNames", "", "", "globalConfigRoot", "Ljava/nio/file/Path;", "scriptExtensions", "scriptNames", "global", "Lorg/javacs/kt/classpath/ClassPathResolver;", "workingDir", "maybeCreate", "Lorg/javacs/kt/classpath/ShellClassPathResolver;", "file", "shared"})
    @SourceDebugExtension(value={"SMAP\nShellClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellClassPathResolver.kt\norg/javacs/kt/classpath/ShellClassPathResolver$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1#2:64\n1747#3,3:65\n1549#3:68\n1620#3,3:69\n1360#3:72\n1446#3,2:73\n1549#3:75\n1620#3,3:76\n1448#3,3:79\n288#3,2:82\n*S KotlinDebug\n*F\n+ 1 ShellClassPathResolver.kt\norg/javacs/kt/classpath/ShellClassPathResolver$Companion\n*L\n39#1:65,3\n56#1:68\n56#1:69,3\n57#1:72\n57#1:73,2\n57#1:75\n57#1:76,3\n57#1:79,3\n58#1:82,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final ShellClassPathResolver maybeCreate(@NotNull Path file) {
            Path path;
            boolean bl;
            Path path2;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Path it = path2 = file;
            boolean bl2 = false;
            Iterable $this$any$iv = scriptNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return null;
            }
            Iterator iterator = $this$any$iv.iterator();
            block0: do {
                if (!iterator.hasNext()) return null;
                Object element$iv = iterator.next();
                String name = (String)element$iv;
                boolean bl3 = false;
                Iterable $this$any$iv2 = scriptExtensions;
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl = false;
                    continue;
                }
                for (Object element$iv2 : $this$any$iv2) {
                    String it2 = (String)element$iv2;
                    boolean bl4 = false;
                    if (!file.endsWith(name + it2)) continue;
                    bl = true;
                    continue block0;
                }
                bl = false;
            } while (!bl);
            boolean bl5 = true;
            if (!bl5) return null;
            Path path3 = path2;
            Path path4 = path3;
            if (path4 == null) return null;
            Path it3 = path = path4;
            boolean bl6 = false;
            boolean isExecutable = Files.isExecutable(it3);
            if (!isExecutable) {
                LoggerKt.getLOG().warn("Found classpath script " + it3 + " that is NOT executable and therefore cannot be used. Perhaps you'd want to chmod +x it?", new Object[0]);
            }
            if (!isExecutable) return null;
            Path path5 = path;
            path2 = path5;
            if (path2 == null) return null;
            it3 = path2;
            boolean bl7 = false;
            ShellClassPathResolver shellClassPathResolver = new ShellClassPathResolver(it3, null, 2, null);
            return shellClassPathResolver;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ClassPathResolver global(@Nullable Path workingDir) {
            ClassPathResolver classPathResolver;
            Object v0;
            block6: {
                Iterator $this$flatMapTo$iv$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = configDirNames;
                Path path = globalConfigRoot;
                boolean $i$f$map22 = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(path.resolve((String)p0));
                }
                Iterable $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                Iterable $i$f$map22 = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator $i$f$mapTo22 = $this$flatMapTo$iv$iv.iterator();
                while ($i$f$mapTo22.hasNext()) {
                    void $this$mapTo$iv$iv2;
                    Object element$iv$iv = $i$f$mapTo22.next();
                    Path root = (Path)element$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv2 = scriptExtensions;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl2 = false;
                        collection.add(root.resolve("classpath" + (String)it));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path p0 = (Path)element$iv;
                    boolean bl = false;
                    if (!Files.exists(p0, new LinkOption[0])) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            Path path = v0;
            if (path != null) {
                Path it = path;
                boolean bl = false;
                classPathResolver = new ShellClassPathResolver(it, workingDir);
            } else {
                classPathResolver = ClassPathResolver.Companion.getEmpty();
            }
            return classPathResolver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

