/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.Escaping;
import com.facebook.ktfmt.kdoc.KDocToken;
import com.facebook.ktfmt.kdoc.KDocWriter;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.lexer.KDocLexer;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0002J2\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0002J&\u0010\u0018\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u0006\u0010\u001c\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocFormatter;", "", "()V", "NUMBERED_LIST_PATTERN", "Lkotlin/text/Regex;", "ONE_CONTENT_LINE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "formatKDoc", "", "input", "blockIndent", "", "maxLineLength", "makeSingleLineIfPossible", "processToken", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "tokens", "", "Lcom/facebook/ktfmt/kdoc/KDocToken;", "tokenText", "previousType", "render", "", "tokenizeKdocText", "Lkotlin/sequences/Sequence;", "s", "ktfmt"})
public final class KDocFormatter {
    @NotNull
    public static final KDocFormatter INSTANCE = new KDocFormatter();
    private static final Pattern ONE_CONTENT_LINE_PATTERN = Pattern.compile(" */[*][*]\n *[*] (.*)\n *[*]/");
    @NotNull
    private static final Regex NUMBERED_LIST_PATTERN = new Regex("[0-9]+\\.");

    private KDocFormatter() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String formatKDoc(@NotNull String input, int blockIndent, int maxLineLength) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        escapedInput = Escaping.INSTANCE.escapeKDoc(input);
        kDocLexer = new KDocLexer();
        kDocLexer.start((CharSequence)escapedInput);
        tokens = new ArrayList<E>();
        previousType = null;
        while (kDocLexer.getTokenType() != null) {
            tokenType = kDocLexer.getTokenType();
            $this$formatKDoc_u24lambda_u2d0 = kDocLexer.getTokenText();
            $i$a$-with-KDocFormatter$formatKDoc$tokenText$1 = false;
            if (!Intrinsics.areEqual(previousType, (Object)KDocTokens.LEADING_ASTERISK)) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)$this$formatKDoc_u24lambda_u2d0, (String)"");
            if (StringsKt.first((CharSequence)$this$formatKDoc_u24lambda_u2d0) == ' ') {
                var12_12 = $this$formatKDoc_u24lambda_u2d0.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)var12_12, (String)"this as java.lang.String).substring(startIndex)");
                v0 = var12_12;
            } else lbl-1000:
            // 2 sources

            {
                Intrinsics.checkNotNullExpressionValue((Object)$this$formatKDoc_u24lambda_u2d0, (String)"this");
                v0 = $this$formatKDoc_u24lambda_u2d0;
            }
            tokenText = v0;
            this.processToken(tokenType, tokens, tokenText, previousType);
            previousType = tokenType;
            kDocLexer.advance();
        }
        result = this.render(tokens, blockIndent, maxLineLength);
        return this.makeSingleLineIfPossible(blockIndent, result, maxLineLength);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void processToken(IElementType tokenType, List<KDocToken> tokens, String tokenText, IElementType previousType) {
        block15: {
            CharSequence charSequence;
            int count$iv;
            block16: {
                block14: {
                    IElementType iElementType = tokenType;
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.START)) {
                        tokens.add(new KDocToken(KDocToken.Type.BEGIN_KDOC, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.END)) {
                        tokens.add(new KDocToken(KDocToken.Type.END_KDOC, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.LEADING_ASTERISK)) {
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.TAG_NAME)) {
                        tokens.add(new KDocToken(KDocToken.Type.TAG, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.CODE_BLOCK_TEXT)) {
                        tokens.add(new KDocToken(KDocToken.Type.CODE, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.MARKDOWN_INLINE_LINK) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.MARKDOWN_LINK)) {
                        tokens.add(new KDocToken(KDocToken.Type.MARKDOWN_LINK, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.TEXT)) break block14;
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.WHITE_SPACE)) throw new RuntimeException(Intrinsics.stringPlus((String)"Unexpected: ", (Object)tokenType));
                    if (Intrinsics.areEqual((Object)previousType, (Object)KDocTokens.LEADING_ASTERISK)) break block15;
                    CharSequence $this$count$iv = tokenText;
                    boolean $i$f$count = false;
                    count$iv = 0;
                    charSequence = $this$count$iv;
                    break block16;
                }
                boolean first = true;
                Iterator iterator = this.tokenizeKdocText(tokenText).iterator();
                while (iterator.hasNext()) {
                    String word = (String)iterator.next();
                    if (CharsKt.isWhitespace((char)StringsKt.first((CharSequence)word))) {
                        tokens.add(new KDocToken(KDocToken.Type.WHITESPACE, " "));
                        continue;
                    }
                    if (first) {
                        CharSequence charSequence2;
                        if (Intrinsics.areEqual((Object)word, (Object)"-") || Intrinsics.areEqual((Object)word, (Object)"*") || NUMBERED_LIST_PATTERN.matches(charSequence2 = (CharSequence)word)) {
                            tokens.add(new KDocToken(KDocToken.Type.LIST_ITEM_OPEN_TAG, ""));
                        }
                        first = false;
                    }
                    if (Intrinsics.areEqual((Object)word, (Object)"*/")) {
                        tokens.add(new KDocToken(KDocToken.Type.END_KDOC, word));
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)word, (String)"```", (boolean)false, (int)2, null)) {
                        tokens.add(new KDocToken(KDocToken.Type.CODE_BLOCK_MARKER, word));
                        continue;
                    }
                    tokens.add(new KDocToken(KDocToken.Type.LITERAL, word));
                }
                return;
            }
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            if (count$iv < 2) {
                tokens.add(new KDocToken(KDocToken.Type.WHITESPACE, " "));
                return;
            }
        }
        tokens.add(new KDocToken(KDocToken.Type.BLANK_LINE, ""));
    }

    private final String render(List<KDocToken> input, int blockIndent, int maxLineLength) {
        KDocWriter output2 = new KDocWriter(blockIndent, maxLineLength);
        block18: for (KDocToken token : input) {
            switch (WhenMappings.$EnumSwitchMapping$0[token.getType().ordinal()]) {
                case 1: {
                    output2.writeBeginJavadoc();
                    continue block18;
                }
                case 2: {
                    output2.writeEndJavadoc();
                    return Escaping.INSTANCE.unescapeKDoc(output2.toString());
                }
                case 3: {
                    output2.writeListItemOpen(token);
                    continue block18;
                }
                case 4: {
                    output2.writePreOpen(token);
                    continue block18;
                }
                case 5: {
                    output2.writePreClose(token);
                    continue block18;
                }
                case 6: {
                    output2.writeCodeOpen(token);
                    continue block18;
                }
                case 7: {
                    output2.writeCodeClose(token);
                    continue block18;
                }
                case 8: {
                    output2.writeTableOpen(token);
                    continue block18;
                }
                case 9: {
                    output2.writeTableClose(token);
                    continue block18;
                }
                case 10: {
                    output2.writeTag(token);
                    continue block18;
                }
                case 11: {
                    output2.writeCodeLine(token);
                    continue block18;
                }
                case 12: {
                    output2.writeExplicitCodeBlockMarker(token);
                    continue block18;
                }
                case 13: {
                    output2.requestBlankLine();
                    continue block18;
                }
                case 14: {
                    output2.requestWhitespace();
                    continue block18;
                }
                case 15: {
                    output2.writeLiteral(token);
                    continue block18;
                }
                case 16: {
                    output2.writeMarkdownLink(token);
                    continue block18;
                }
            }
            throw new AssertionError((Object)token.getType());
        }
        throw new AssertionError();
    }

    private final String makeSingleLineIfPossible(int blockIndent, String input, int maxLineLength) {
        int oneLinerContentLength = maxLineLength - "/**  */".length() - blockIndent;
        Matcher matcher = ONE_CONTENT_LINE_PATTERN.matcher(input);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
            if (((CharSequence)string).length() == 0) {
                return "/** */";
            }
        }
        if (matcher.matches() && matcher.group(1).length() <= oneLinerContentLength) {
            return "/** " + matcher.group(1) + " */";
        }
        return input;
    }

    @NotNull
    public final Sequence<String> tokenizeKdocText(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(s, null){
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            boolean Z$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $s;
            {
                this.$s = $s;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        if (((CharSequence)this.$s).length() == 0) {
                            return Unit.INSTANCE;
                        }
                        mark = 0;
                        inWhitespace = CharsKt.isWhitespace((char)this.$s.charAt(0));
                        var5_6 = 1;
                        var6_8 = StringsKt.getLastIndex((CharSequence)this.$s);
                        if (var5_6 <= var6_8) {
                            while (true) {
                                if (inWhitespace == CharsKt.isWhitespace((char)this.$s.charAt(i = var5_6++))) continue;
                                if (inWhitespace) {
                                    v0 = " ";
                                } else {
                                    var9_12 = this.$s.substring(mark, i);
                                    Intrinsics.checkNotNullExpressionValue((Object)var9_12, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                    v0 = var9_12;
                                }
                                result = v0;
                                inWhitespace = CharsKt.isWhitespace((char)this.$s.charAt(i));
                                mark = i;
                                this.L$0 = $this$sequence;
                                this.I$0 = mark;
                                this.Z$0 = inWhitespace;
                                this.I$1 = var5_6;
                                this.I$2 = var6_8;
                                this.I$3 = i;
                                this.label = 1;
                                v1 = $this$sequence.yield((Object)result, (Continuation)this);
                                if (v1 != var10_2) continue;
                                return var10_2;
                            }
                        }
                        ** GOTO lbl45
                    }
                    case 1: {
                        i = this.I$3;
                        var6_8 = this.I$2;
                        var5_6 = this.I$1;
                        inWhitespace = this.Z$0;
                        mark = this.I$0;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        if (i != var6_8) ** continue;
lbl45:
                        // 2 sources

                        if (inWhitespace) {
                            v2 = " ";
                        } else {
                            var5_7 = this.$s;
                            var6_8 = this.$s.length();
                            var7_10 = var5_7.substring(mark, var6_8);
                            Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            v2 = var7_10;
                        }
                        this.L$0 = null;
                        this.label = 2;
                        v3 = $this$sequence.yield((Object)v2, (Continuation)this);
                        if (v3 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl62
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl62:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KDocToken.Type.values().length];
            nArray[KDocToken.Type.BEGIN_KDOC.ordinal()] = 1;
            nArray[KDocToken.Type.END_KDOC.ordinal()] = 2;
            nArray[KDocToken.Type.LIST_ITEM_OPEN_TAG.ordinal()] = 3;
            nArray[KDocToken.Type.PRE_OPEN_TAG.ordinal()] = 4;
            nArray[KDocToken.Type.PRE_CLOSE_TAG.ordinal()] = 5;
            nArray[KDocToken.Type.CODE_OPEN_TAG.ordinal()] = 6;
            nArray[KDocToken.Type.CODE_CLOSE_TAG.ordinal()] = 7;
            nArray[KDocToken.Type.TABLE_OPEN_TAG.ordinal()] = 8;
            nArray[KDocToken.Type.TABLE_CLOSE_TAG.ordinal()] = 9;
            nArray[KDocToken.Type.TAG.ordinal()] = 10;
            nArray[KDocToken.Type.CODE.ordinal()] = 11;
            nArray[KDocToken.Type.CODE_BLOCK_MARKER.ordinal()] = 12;
            nArray[KDocToken.Type.BLANK_LINE.ordinal()] = 13;
            nArray[KDocToken.Type.WHITESPACE.ordinal()] = 14;
            nArray[KDocToken.Type.LITERAL.ordinal()] = 15;
            nArray[KDocToken.Type.MARKDOWN_LINK.ordinal()] = 16;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

