/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ControlFlowImpl
implements ControlFlow {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.ControlFlowImpl");
    private final List<Instruction> myInstructions = new ArrayList<Instruction>();
    private final ObjectIntHashMap<PsiElement> myElementToStartOffsetMap = new ObjectIntHashMap();
    private final ObjectIntHashMap<PsiElement> myElementToEndOffsetMap = new ObjectIntHashMap();
    private final List<PsiElement> myElementsForInstructions = new ArrayList<PsiElement>();
    private boolean myConstantConditionOccurred;
    private final Stack<PsiElement> myElementStack = new Stack();

    ControlFlowImpl() {
    }

    void addInstruction(Instruction instruction) {
        this.myInstructions.add(instruction);
        this.myElementsForInstructions.add(this.myElementStack.peek());
    }

    public void startElement(PsiElement element) {
        this.myElementStack.push(element);
        this.myElementToStartOffsetMap.put(element, this.myInstructions.size());
    }

    void finishElement(PsiElement element) {
        PsiElement popped = this.myElementStack.pop();
        LOG.assertTrue(popped.equals(element));
        this.myElementToEndOffsetMap.put(element, this.myInstructions.size());
    }

    @Override
    @NotNull
    public List<Instruction> getInstructions() {
        List<Instruction> list2 = this.myInstructions;
        if (list2 == null) {
            ControlFlowImpl.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    public int getSize() {
        return this.myInstructions.size();
    }

    @Override
    public int getStartOffset(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowImpl.$$$reportNull$$$0(1);
        }
        return this.myElementToStartOffsetMap.get(element, -1);
    }

    @Override
    public int getEndOffset(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowImpl.$$$reportNull$$$0(2);
        }
        return this.myElementToEndOffsetMap.get(element, -1);
    }

    @Override
    public PsiElement getElement(int offset2) {
        return this.myElementsForInstructions.get(offset2);
    }

    @Override
    public boolean isConstantConditionOccurred() {
        return this.myConstantConditionOccurred;
    }

    void setConstantConditionOccurred(boolean constantConditionOccurred) {
        this.myConstantConditionOccurred = constantConditionOccurred;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.myInstructions.size(); ++i) {
            Instruction instruction = this.myInstructions.get(i);
            buffer.append(Integer.toString(i));
            buffer.append(": ");
            buffer.append(instruction);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEndOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

