/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.IllegalAddException;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.filter.Filter;

final class ContentList
extends AbstractList<Content>
implements Serializable {
    private Content[] elementData;
    private int size;
    private Parent parent;

    ContentList(Parent parent2) {
        this.parent = parent2;
    }

    @Override
    public void add(int index2, Content obj) {
        if (obj == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        this.addImpl(index2, obj);
    }

    private void documentCanContain(int index2, Content child) throws IllegalAddException {
        if (child instanceof Element) {
            if (this.indexOfFirstElement() >= 0) {
                throw new IllegalAddException("Cannot add a second root element, only one is allowed");
            }
            if (this.indexOfDocType() >= index2) {
                throw new IllegalAddException("A root element cannot be added before the DocType");
            }
        }
        if (child instanceof DocType) {
            if (this.indexOfDocType() >= 0) {
                throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
            }
            int firstElt = this.indexOfFirstElement();
            if (firstElt != -1 && firstElt < index2) {
                throw new IllegalAddException("A DocType cannot be added after the root element");
            }
        }
        if (child instanceof CDATA) {
            throw new IllegalAddException("A CDATA is not allowed at the document root");
        }
        if (child instanceof Text) {
            throw new IllegalAddException("A Text is not allowed at the document root");
        }
        if (child instanceof EntityRef) {
            throw new IllegalAddException("An EntityRef is not allowed at the document root");
        }
    }

    private static void elementCanContain(int index2, Content child) throws IllegalAddException {
        if (child instanceof DocType) {
            throw new IllegalAddException("A DocType is not allowed except at the document level");
        }
    }

    void addImpl(int index2, Content child) {
        if (child == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.parent instanceof Document) {
            this.documentCanContain(index2, child);
        } else {
            ContentList.elementCanContain(index2, child);
        }
        if (child.getParent() != null) {
            Parent p = child.getParent();
            if (p instanceof Document) {
                throw new IllegalAddException((Element)child, "The Content already has an existing parent document");
            }
            throw new IllegalAddException("The Content already has an existing parent \"" + ((Element)p).getQualifiedName() + "\"");
        }
        if (child == this.parent) {
            throw new IllegalAddException("The Element cannot be added to itself");
        }
        if (this.parent instanceof Element && child instanceof Element && ((Element)child).isAncestor((Element)this.parent)) {
            throw new IllegalAddException("The Element cannot be added as a descendent of itself");
        }
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        child.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (index2 == this.size) {
            this.elementData[this.size++] = child;
        } else {
            System.arraycopy(this.elementData, index2, this.elementData, index2 + 1, this.size - index2);
            this.elementData[index2] = child;
            ++this.size;
        }
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Content> collection) {
        return this.addAll(this.size(), collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index2, Collection<? extends Content> collection) {
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        this.ensureCapacity(this.size() + collection.size());
        int count2 = 0;
        try {
            for (Content content : collection) {
                this.add(index2 + count2, content);
                ++count2;
            }
        }
        catch (RuntimeException exception) {
            void var5_8;
            boolean bl = false;
            while (var5_8 < count2) {
                this.remove(index2);
                ++var5_8;
            }
            throw exception;
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                Content obj = this.elementData[i];
                ContentList.removeParent(obj);
            }
            this.elementData = null;
            this.size = 0;
        }
        ++this.modCount;
    }

    void ensureCapacity(int minCapacity) {
        if (this.elementData == null) {
            this.elementData = new Content[Math.max(minCapacity, 5)];
        } else {
            int oldCapacity = this.elementData.length;
            if (minCapacity > oldCapacity) {
                Content[] oldData = this.elementData;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.elementData = new Content[newCapacity];
                System.arraycopy(oldData, 0, this.elementData, 0, this.size);
            }
        }
    }

    @Override
    public Content get(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        return this.elementData[index2];
    }

    <T extends Content> List<T> getView(Filter<T> filter2) {
        return new FilterList<T>(filter2);
    }

    int indexOfFirstElement() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof Element)) continue;
                return i;
            }
        }
        return -1;
    }

    int indexOfDocType() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof DocType)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Content remove(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        Content old = this.elementData[index2];
        ContentList.removeParent(old);
        int numMoved = this.size - index2 - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index2 + 1, this.elementData, index2, numMoved);
        }
        this.elementData[--this.size] = null;
        ++this.modCount;
        return old;
    }

    private static void removeParent(Content c) {
        c.setParent(null);
    }

    @Override
    public Content set(int index2, Content obj) {
        int docTypeIndex;
        int root2;
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        if (obj instanceof Element && this.parent instanceof Document && (root2 = this.indexOfFirstElement()) >= 0 && root2 != index2) {
            throw new IllegalAddException("Cannot add a second root element, only one is allowed");
        }
        if (obj instanceof DocType && this.parent instanceof Document && (docTypeIndex = this.indexOfDocType()) >= 0 && docTypeIndex != index2) {
            throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
        }
        Content old = this.remove(index2);
        try {
            this.add(index2, obj);
        }
        catch (RuntimeException exception) {
            this.add(index2, old);
            throw exception;
        }
        return old;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private int getModCount() {
        return this.modCount;
    }

    class FilterListIterator<E extends Content>
    implements ListIterator<E> {
        Filter<E> filter;
        private boolean forward = false;
        private boolean canremove = false;
        private boolean canset = false;
        private int cursor = -1;
        private int tmpcursor = -1;
        private int index = -1;
        private int expected = -1;
        private int fsize = 0;

        FilterListIterator(Filter filter2, int start) {
            this.filter = filter2;
            this.expected = ContentList.this.getModCount();
            this.forward = false;
            if (start < 0) {
                throw new IndexOutOfBoundsException("Index: " + start);
            }
            this.fsize = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                if (!filter2.matches(ContentList.this.get(i))) continue;
                if (start == this.fsize) {
                    this.cursor = i;
                    this.index = this.fsize;
                }
                ++this.fsize;
            }
            if (start > this.fsize) {
                throw new IndexOutOfBoundsException("Index: " + start + " Size: " + this.fsize);
            }
            if (this.cursor == -1) {
                this.cursor = ContentList.this.size();
                this.index = this.fsize;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.fsize;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() is beyond the end of the Iterator");
            }
            this.index = this.nextIndex();
            this.cursor = this.tmpcursor;
            this.forward = true;
            this.canremove = true;
            this.canset = true;
            return (E)ContentList.this.get(this.cursor);
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("previous() is before the start of the Iterator");
            }
            this.index = this.previousIndex();
            this.cursor = this.tmpcursor;
            this.forward = false;
            this.canremove = true;
            this.canset = true;
            return (E)ContentList.this.get(this.cursor);
        }

        @Override
        public int nextIndex() {
            this.checkConcurrentModification();
            if (this.forward) {
                for (int i = this.cursor + 1; i < ContentList.this.size(); ++i) {
                    if (!this.filter.matches(ContentList.this.get(i))) continue;
                    this.tmpcursor = i;
                    return this.index + 1;
                }
                this.tmpcursor = ContentList.this.size();
                return this.index + 1;
            }
            this.tmpcursor = this.cursor;
            return this.index;
        }

        @Override
        public int previousIndex() {
            this.checkConcurrentModification();
            if (!this.forward) {
                for (int i = this.cursor - 1; i >= 0; --i) {
                    if (!this.filter.matches(ContentList.this.get(i))) continue;
                    this.tmpcursor = i;
                    return this.index - 1;
                }
                this.tmpcursor = -1;
                return this.index - 1;
            }
            this.tmpcursor = this.cursor;
            return this.index;
        }

        @Override
        public void add(E obj) {
            if (!this.filter.matches(obj)) {
                throw new IllegalAddException("Filter won't allow the " + obj.getClass().getName() + " '" + obj + "' to be added to the list");
            }
            this.nextIndex();
            ContentList.this.add(this.tmpcursor, (Content)obj);
            this.expected = ContentList.this.getModCount();
            this.canset = false;
            this.canremove = false;
            if (this.forward) {
                ++this.index;
            } else {
                this.forward = true;
            }
            ++this.fsize;
            this.cursor = this.tmpcursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (!this.canremove) {
                throw new IllegalStateException("Can not remove an element unless either next() or previous() has been called since the last remove()");
            }
            boolean dir = this.forward;
            this.forward = true;
            try {
                this.nextIndex();
                ContentList.this.remove(this.cursor);
            }
            finally {
                this.forward = dir;
            }
            this.cursor = this.tmpcursor - 1;
            this.expected = ContentList.this.getModCount();
            this.forward = false;
            this.canremove = false;
            this.canset = false;
            --this.fsize;
        }

        @Override
        public void set(E obj) {
            if (!this.canset) {
                throw new IllegalStateException("Can not set an element unless either next() or previous() has been called since the last remove() or set()");
            }
            this.checkConcurrentModification();
            if (!this.filter.matches(obj)) {
                throw new IllegalAddException("Filter won't allow index " + this.index + " to be set to " + obj.getClass().getName());
            }
            ContentList.this.set(this.cursor, (Content)obj);
            this.expected = ContentList.this.getModCount();
        }

        private void checkConcurrentModification() {
            if (this.expected != ContentList.this.getModCount()) {
                throw new ConcurrentModificationException();
            }
        }
    }

    class FilterList<E extends Content>
    extends AbstractList<E>
    implements Serializable {
        Filter<E> filter;
        int count = 0;
        int expected = -1;

        FilterList(Filter<E> filter2) {
            this.filter = filter2;
        }

        @Override
        public void add(int index2, E obj) {
            if (this.filter.matches(obj)) {
                int adjusted = this.getAdjustedIndex(index2);
                ContentList.this.add(adjusted, (Content)obj);
                ++this.expected;
                ++this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + obj.getClass().getName() + " '" + obj + "' to be added to the list");
            }
        }

        @Override
        public E get(int index2) {
            int adjusted = this.getAdjustedIndex(index2);
            return (E)ContentList.this.get(adjusted);
        }

        @Override
        public Iterator<E> iterator() {
            return new FilterListIterator(this.filter, 0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new FilterListIterator(this.filter, 0);
        }

        @Override
        public ListIterator<E> listIterator(int index2) {
            return new FilterListIterator(this.filter, index2);
        }

        @Override
        public E remove(int index2) {
            int adjusted = this.getAdjustedIndex(index2);
            Content old = ContentList.this.get(adjusted);
            if (this.filter.matches(old)) {
                old = ContentList.this.remove(adjusted);
                ++this.expected;
                --this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + old.getClass().getName() + " '" + old + "' (index " + index2 + ") to be removed");
            }
            return (E)old;
        }

        @Override
        public E set(int index2, Content obj) {
            Content old = null;
            if (this.filter.matches(obj)) {
                int adjusted = this.getAdjustedIndex(index2);
                old = ContentList.this.get(adjusted);
                if (!this.filter.matches(old)) {
                    throw new IllegalAddException("Filter won't allow the " + old.getClass().getName() + " '" + old + "' (index " + index2 + ") to be removed");
                }
                old = ContentList.this.set(adjusted, obj);
                this.expected += 2;
            } else {
                throw new IllegalAddException("Filter won't allow index " + index2 + " to be set to " + obj.getClass().getName());
            }
            return (E)old;
        }

        @Override
        public int size() {
            if (this.expected == ContentList.this.getModCount()) {
                return this.count;
            }
            this.count = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                Content obj = ContentList.this.elementData[i];
                if (!this.filter.matches(obj)) continue;
                ++this.count;
            }
            this.expected = ContentList.this.getModCount();
            return this.count;
        }

        private int getAdjustedIndex(int index2) {
            int adjusted = 0;
            for (int i = 0; i < ContentList.this.size; ++i) {
                Content obj = ContentList.this.elementData[i];
                if (!this.filter.matches(obj)) continue;
                if (index2 == adjusted) {
                    return i;
                }
                ++adjusted;
            }
            if (index2 == adjusted) {
                return ContentList.this.size;
            }
            return ContentList.this.size + 1;
        }
    }
}

