/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;

public class KtProperty
extends KtTypeParameterListOwnerStub<KotlinPropertyStub>
implements PsiModifiableCodeBlock,
KtVariableDeclaration {
    private static final Logger LOG = Logger.getInstance(KtProperty.class);
    private static final TokenSet VAL_VAR_TOKEN_SET = TokenSet.create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD);

    public KtProperty(@NotNull ASTNode node) {
        super(node);
    }

    public KtProperty(@NotNull KotlinPropertyStub stub) {
        super(stub, KtStubElementTypes.PROPERTY);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitProperty(this, data);
    }

    @Override
    public boolean isVar() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isVar();
        }
        return this.getNode().findChildByType(KtTokens.VAR_KEYWORD) != null;
    }

    public boolean isLocal() {
        return !this.isTopLevel() && !this.isMember();
    }

    public boolean isMember() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof KtClassOrObject || parent2 instanceof KtClassBody || parent2 instanceof KtBlockExpression && parent2.getParent() instanceof KtScript;
    }

    public boolean isTopLevel() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isTopLevel();
        }
        return this.getParent() instanceof KtFile;
    }

    @Override
    @Nullable
    public KtParameterList getValueParameterList() {
        return null;
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public KtTypeReference getReceiverTypeReference() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            if (!stub.isExtension()) {
                return null;
            }
            return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
        }
        return this.getReceiverTypeRefByTree();
    }

    @Nullable
    private KtTypeReference getReceiverTypeRefByTree() {
        IElementType tt;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && (tt = node.getElementType()) != KtTokens.COLON; node = node.getTreeNext()) {
            if (tt != KtNodeTypes.TYPE_REFERENCE) continue;
            return (KtTypeReference)node.getPsi();
        }
        return null;
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            int returnTypeRefPositionInPsi;
            if (!stub.hasReturnTypeRef()) {
                return null;
            }
            List typeReferences = this.getStubOrPsiChildrenAsList(KtStubElementTypes.TYPE_REFERENCE);
            int n = returnTypeRefPositionInPsi = stub.isExtension() ? 1 : 0;
            if (typeReferences.size() <= returnTypeRefPositionInPsi) {
                LOG.error("Invalid stub structure built for property:\n" + this.getText());
                return null;
            }
            return (KtTypeReference)typeReferences.get(returnTypeRefPositionInPsi);
        }
        return TypeRefHelpersKt.getTypeReference(this);
    }

    @Override
    @Nullable
    public KtTypeReference setTypeReference(@Nullable KtTypeReference typeRef) {
        return TypeRefHelpersKt.setTypeReference(this, this.getNameIdentifier(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @NotNull
    public List<KtPropertyAccessor> getAccessors() {
        return this.getStubOrPsiChildrenAsList(KtStubElementTypes.PROPERTY_ACCESSOR);
    }

    @Nullable
    public KtPropertyAccessor getGetter() {
        for (KtPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isGetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public KtPropertyAccessor getSetter() {
        for (KtPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isSetter()) continue;
            return accessor;
        }
        return null;
    }

    public boolean hasDelegate() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasDelegate();
        }
        return this.getDelegate() != null;
    }

    @Nullable
    public KtPropertyDelegate getDelegate() {
        return (KtPropertyDelegate)this.findChildByType(KtNodeTypes.PROPERTY_DELEGATE);
    }

    public boolean hasDelegateExpression() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasDelegateExpression();
        }
        return this.getDelegateExpression() != null;
    }

    @Nullable
    public KtExpression getDelegateExpression() {
        KtPropertyDelegate delegate2 = this.getDelegate();
        if (delegate2 != null) {
            return delegate2.getExpression();
        }
        return null;
    }

    @Override
    public boolean hasInitializer() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasInitializer();
        }
        return this.getInitializer() != null;
    }

    @Override
    @Nullable
    public KtExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.findChildByType(KtTokens.EQ), KtExpression.class);
    }

    public boolean hasDelegateExpressionOrInitializer() {
        return this.hasDelegateExpression() || this.hasInitializer();
    }

    @Nullable
    public KtExpression setInitializer(@Nullable KtExpression initializer2) {
        KtExpression oldInitializer = this.getInitializer();
        if (oldInitializer != null) {
            if (initializer2 != null) {
                return (KtExpression)oldInitializer.replace(initializer2);
            }
            PsiElement nextSibling = oldInitializer.getNextSibling();
            KtExpression last2 = nextSibling != null && nextSibling.getNode() != null && nextSibling.getNode().getElementType() == KtTokens.SEMICOLON ? nextSibling : oldInitializer;
            this.deleteChildRange((PsiElement)this.findChildByType(KtTokens.EQ), last2);
            return null;
        }
        if (initializer2 != null) {
            PsiElement addAfter = this.getTypeReference();
            if (addAfter == null) {
                addAfter = this.getNameIdentifier();
            }
            PsiElement eq = this.addAfter(new KtPsiFactory(this.getProject()).createEQ(), addAfter);
            return (KtExpression)this.addAfter(initializer2, eq);
        }
        return null;
    }

    @Nullable
    public KtExpression getDelegateExpressionOrInitializer() {
        KtExpression expression2 = this.getDelegateExpression();
        if (expression2 == null) {
            return this.getInitializer();
        }
        return expression2;
    }

    @Override
    @NotNull
    public PsiElement getValOrVarKeyword() {
        Object element = this.findChildByType(VAL_VAR_TOKEN_SET);
        assert (element != null) : "Val or var should always exist for property" + this.getText();
        return element;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }

    public boolean hasBody() {
        if (this.hasDelegateExpressionOrInitializer()) {
            return true;
        }
        KtPropertyAccessor getter2 = this.getGetter();
        if (getter2 != null && getter2.hasBody()) {
            return true;
        }
        KtPropertyAccessor setter2 = this.getSetter();
        return setter2 != null && setter2.hasBody();
    }
}

