/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallableReferenceCompatibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class CallableReferenceCompatibilityChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        LanguageFeature typeInferenceForCallableReferencesFeature = LanguageFeature.TypeInferenceOnGenericsForCallableReferences;
        if (context.getLanguageVersionSettings().supportsFeature(typeInferenceForCallableReferencesFeature)) {
            return;
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, "resolvedCall.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = map2;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedArgument;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ResolvedValueArgument resolvedValueArgument = resolvedArgument = entry2.getValue();
            Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument, "resolvedArgument");
            for (ValueArgument argument : resolvedValueArgument.getArguments()) {
                ResolvedCall<? extends CallableDescriptor> callableReferenceResolvedCall;
                KtCallableReferenceExpression argumentExpression;
                KtExpression ktExpression = argument.getArgumentExpression();
                if (!(ktExpression instanceof KtCallableReferenceExpression)) {
                    ktExpression = null;
                }
                if ((KtCallableReferenceExpression)ktExpression == null) {
                    continue;
                }
                KtElement ktElement = argumentExpression.getCallableReference();
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
                if (CallUtilKt.getResolvedCall(ktElement, bindingContext) == null) {
                    continue;
                }
                Call call2 = callableReferenceResolvedCall.getCall();
                Intrinsics.checkExpressionValueIsNotNull(call2, "callableReferenceResolvedCall.call");
                if (!CallUtilKt.isCallableReference(call2)) continue;
                List<TypeParameterDescriptor> list2 = callableReferenceResolvedCall.getCandidateDescriptor().getTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, "callableReferenceResolve\u2026Descriptor.typeParameters");
                Collection collection = list2;
                if (!(!collection.isEmpty())) continue;
                context.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(argumentExpression, TuplesKt.to(typeInferenceForCallableReferencesFeature, context.getLanguageVersionSettings())));
            }
        }
    }
}

