/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FCTSBackedLighterAST;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.AstSpine;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.CharTable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileElement
extends LazyParseableElement
implements FileASTNode,
Getter<FileElement> {
    public static final FileElement[] EMPTY_ARRAY = new FileElement[0];
    private volatile CharTable myCharTable;
    private volatile boolean myDetached;
    private volatile AstSpine myStubbedSpine;

    @Override
    protected PsiElement createPsiNoLock() {
        return this.myDetached ? null : super.createPsiNoLock();
    }

    public void detachFromFile() {
        this.myDetached = true;
        this.clearPsi();
    }

    @Override
    @NotNull
    public CharTable getCharTable() {
        CharTable charTable = this.myCharTable;
        if (charTable == null) {
            FileElement.$$$reportNull$$$0(0);
        }
        return charTable;
    }

    @Override
    @NotNull
    public LighterAST getLighterAST() {
        IElementType contentType = this.getElementType();
        if (!this.isParsed() && contentType instanceof ILightStubFileElementType) {
            FCTSBackedLighterAST fCTSBackedLighterAST = new FCTSBackedLighterAST(this.getCharTable(), ((ILightStubFileElementType)contentType).parseContentsLight(this));
            if (fCTSBackedLighterAST == null) {
                FileElement.$$$reportNull$$$0(1);
            }
            return fCTSBackedLighterAST;
        }
        TreeBackedLighterAST treeBackedLighterAST = new TreeBackedLighterAST(this);
        if (treeBackedLighterAST == null) {
            FileElement.$$$reportNull$$$0(2);
        }
        return treeBackedLighterAST;
    }

    public FileElement(@NotNull IElementType type2, CharSequence text2) {
        if (type2 == null) {
            FileElement.$$$reportNull$$$0(3);
        }
        super(type2, text2);
        this.myCharTable = new CharTableImpl();
    }

    @Override
    public PsiManagerEx getManager() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent != null) {
            return treeParent.getManager();
        }
        return (PsiManagerEx)this.getPsi().getManager();
    }

    @Override
    public ASTNode copyElement() {
        PsiFileImpl psiElement = (PsiFileImpl)this.getPsi();
        PsiFileImpl psiElementCopy = (PsiFileImpl)psiElement.copy();
        return psiElementCopy.getTreeElement();
    }

    public void setCharTable(@NotNull CharTable table) {
        if (table == null) {
            FileElement.$$$reportNull$$$0(4);
        }
        this.myCharTable = table;
    }

    @Override
    public FileElement get() {
        return this;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myStubbedSpine = null;
    }

    @NotNull
    public final AstSpine getStubbedSpine() {
        AstSpine result2 = this.myStubbedSpine;
        if (result2 == null) {
            PsiFileImpl file2 = (PsiFileImpl)this.getPsi();
            IStubFileElementType type2 = file2.getElementTypeForStubBuilder();
            if (type2 == null) {
                AstSpine astSpine = AstSpine.EMPTY_SPINE;
                if (astSpine == null) {
                    FileElement.$$$reportNull$$$0(5);
                }
                return astSpine;
            }
            result2 = RecursionManager.doPreventingRecursion(file2, false, () -> new AstSpine(this.calcStubbedDescendants(type2.getBuilder())));
            if (result2 == null) {
                throw new StackOverflowPreventedException("Endless recursion prevented");
            }
            this.myStubbedSpine = result2;
        }
        AstSpine astSpine = result2;
        if (astSpine == null) {
            FileElement.$$$reportNull$$$0(6);
        }
        return astSpine;
    }

    private List<CompositeElement> calcStubbedDescendants(final StubBuilder builder) {
        final ArrayList<CompositeElement> result2 = new ArrayList<CompositeElement>();
        result2.add(this);
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitComposite(CompositeElement node) {
                CompositeElement parent2 = node.getTreeParent();
                if (parent2 != null && builder.skipChildProcessingWhenBuildingStubs(parent2, node)) {
                    return;
                }
                IElementType type2 = node.getElementType();
                if (type2 instanceof IStubElementType && ((IStubElementType)type2).shouldCreateStub(node)) {
                    result2.add(node);
                }
                super.visitNode(node);
            }
        });
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLighterAST";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCharTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

