/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.MavenComparableVersion;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004<=>?B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ \u0010\u0016\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001dH\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010)\u001a\u00020&H\u0002J\u0016\u0010*\u001a\u00020#2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001eH\u0002J\u0012\u0010.\u001a\u00020(2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J'\u00101\u001a\u0002H2\"\u0004\b\u0000\u00102*\u0004\u0018\u0001H22\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000404H\u0002\u00a2\u0006\u0002\u00105J\f\u00106\u001a\u00020!*\u000200H\u0002J(\u00107\u001a\u00020\u0017*\u00020\u00192\b\u00108\u001a\u0004\u0018\u00010\u001e2\u0006\u00109\u001a\u00020\u00042\b\b\u0002\u0010:\u001a\u00020;H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker;", "", "()V", "KOTLIN_REFLECT_MODULE", "", "KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE", "KOTLIN_RUNTIME_COMPONENT_CORE", "KOTLIN_RUNTIME_COMPONENT_MAIN", "KOTLIN_STDLIB_JRE_7_MODULE", "KOTLIN_STDLIB_JRE_8_MODULE", "KOTLIN_STDLIB_MODULE", "KOTLIN_VERSION_ATTRIBUTE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MANIFEST_KOTLIN_RUNTIME_COMPONENT", "MANIFEST_KOTLIN_RUNTIME_COMPONENT_CORE", "MANIFEST_KOTLIN_RUNTIME_COMPONENT_MAIN", "MANIFEST_KOTLIN_VERSION_ATTRIBUTE", "MANIFEST_MF", "META_INF", "RUNTIME_IMPLEMENTATION_TITLES", "", "checkCompilerClasspathConsistency", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "classpathJarRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "apiVersion", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "runtimeJarsInfo", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$RuntimeJarsInfo;", "checkMatchingVersionsAndGetRuntimeVersion", "jars", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "checkNotNewerThanCompiler", "", "jar", "collectRuntimeJarsInfo", "determineFileKind", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "jarRoot", "isGenuineKotlinRuntime", "manifest", "Ljava/util/jar/Manifest;", "assertNotNull", "T", "lazyMessage", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getKotlinLanguageVersion", "issue", "file", "message", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "ClasspathConsistency", "FileKind", "KotlinLibraryFile", "RuntimeJarsInfo", "cli"})
public final class JvmRuntimeVersionsConsistencyChecker {
    private static final Logger LOG;
    private static final Set<String> RUNTIME_IMPLEMENTATION_TITLES;
    private static final String KOTLIN_VERSION_ATTRIBUTE;
    private static final String KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE;
    private static final String KOTLIN_RUNTIME_COMPONENT_CORE;
    private static final String KOTLIN_RUNTIME_COMPONENT_MAIN;
    public static final JvmRuntimeVersionsConsistencyChecker INSTANCE;

    private final <T> T assertNotNull(@Nullable T $receiver, Function0<String> lazyMessage) {
        T t = $receiver;
        if (t == null) {
            String string = lazyMessage.invoke();
            boolean bl = false;
            boolean bl2 = false;
            String message2 = string;
            boolean bl3 = false;
            LOG.error(message2);
            throw (Throwable)((Object)new AssertionError((Object)message2));
        }
        return t;
    }

    public final void checkCompilerClasspathConsistency(@NotNull MessageCollector messageCollector, @NotNull CompilerConfiguration configuration, @NotNull List<? extends VirtualFile> classpathJarRoots) {
        Iterator<KotlinLibraryFile> actualApi;
        Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(classpathJarRoots, "classpathJarRoots");
        RuntimeJarsInfo runtimeJarsInfo = this.collectRuntimeJarsInfo(classpathJarRoots);
        if (runtimeJarsInfo.getJars().isEmpty()) {
            return;
        }
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(configuration);
        ApiVersion currentApi = languageVersionSettings.getApiVersion();
        ClasspathConsistency consistency = this.checkCompilerClasspathConsistency(messageCollector, currentApi.getVersion(), runtimeJarsInfo);
        if (consistency instanceof ClasspathConsistency.InconsistentWithApiVersion) {
            MavenComparableVersion actualRuntimeVersion = ((ClasspathConsistency.InconsistentWithApiVersion)consistency).getActualRuntimeVersion();
            if (currentApi.isStable()) {
                JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Runtime JAR files in the classpath have the version " + actualRuntimeVersion + ", " + "which is older than the API version " + currentApi.getVersion() + ". " + "Consider using the runtime of version " + currentApi.getVersion() + ", or pass '-api-version " + actualRuntimeVersion + "' " + "explicitly to restrict the available APIs to the runtime of version " + actualRuntimeVersion + ". " + "You can also pass '-language-version " + actualRuntimeVersion + "' instead, which will restrict " + "not only the APIs to the specified version, but also the language features", null, 4, null);
                for (KotlinLibraryFile jar : ((ClasspathConsistency.InconsistentWithApiVersion)consistency).getIncompatibleJars()) {
                    JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, jar.getFile(), "Runtime JAR file has version " + jar.getVersion() + " which is older than required for API version " + currentApi.getVersion(), null, 4, null);
                }
            }
            String string = actualRuntimeVersion.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "actualRuntimeVersion.toString()");
            actualApi = ApiVersion.Companion.parse(string);
            if (actualApi == null) {
                JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Could not parse runtime JAR version: " + actualRuntimeVersion, null, 4, null);
            } else if (!languageVersionSettings.getFlag(AnalysisFlags.getExplicitApiVersion()).booleanValue() && ((ApiVersion)((Object)actualApi)).compareTo(currentApi) < 0) {
                LanguageVersionSettings newSettings2 = new LanguageVersionSettings((ApiVersion)((Object)actualApi), languageVersionSettings){
                    private final /* synthetic */ LanguageVersionSettings $$delegate_0;
                    final /* synthetic */ ApiVersion $actualApi;
                    final /* synthetic */ LanguageVersionSettings $languageVersionSettings;

                    @NotNull
                    public ApiVersion getApiVersion() {
                        return this.$actualApi;
                    }
                    {
                        this.$actualApi = $captured_local_variable$0;
                        this.$languageVersionSettings = $captured_local_variable$1;
                        this.$$delegate_0 = $captured_local_variable$1;
                    }

                    @NotNull
                    public LanguageVersion getLanguageVersion() {
                        return this.$$delegate_0.getLanguageVersion();
                    }

                    @NotNull
                    public LanguageFeature.State getFeatureSupport(@NotNull LanguageFeature feature) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)feature), "feature");
                        return this.$$delegate_0.getFeatureSupport(feature);
                    }

                    public <T> T getFlag(@NotNull AnalysisFlag<? extends T> flag) {
                        Intrinsics.checkParameterIsNotNull(flag, "flag");
                        return this.$$delegate_0.getFlag(flag);
                    }

                    public boolean isPreRelease() {
                        return this.$$delegate_0.isPreRelease();
                    }

                    public boolean supportsFeature(@NotNull LanguageFeature feature) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)feature), "feature");
                        return this.$$delegate_0.supportsFeature(feature);
                    }
                };
                this.issue(messageCollector, null, "Old runtime has been found in the classpath. " + "Initial language version settings: " + languageVersionSettings + ". " + "Updated language version settings: " + newSettings2, CompilerMessageSeverity.LOGGING);
                CommonConfigurationKeysKt.setLanguageVersionSettings(configuration, newSettings2);
            }
        } else if (Intrinsics.areEqual(consistency, ClasspathConsistency.Consistent.INSTANCE) ^ true) {
            JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Some runtime JAR files in the classpath have an incompatible version. Consider removing them from the classpath", null, 4, null);
        }
        if (CommonConfigurationKeysKt.getLanguageVersionSettings(configuration).getApiVersion().compareTo(ApiVersion.KOTLIN_1_2) >= 0) {
            for (KotlinLibraryFile stdlibJre7 : runtimeJarsInfo.getStdlibJre7()) {
                JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, stdlibJre7.getFile(), "kotlin-stdlib-jre7 is deprecated. Please use kotlin-stdlib-jdk7 instead", null, 4, null);
            }
            for (KotlinLibraryFile stdlibJre8 : runtimeJarsInfo.getStdlibJre8()) {
                JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, stdlibJre8.getFile(), "kotlin-stdlib-jre8 is deprecated. Please use kotlin-stdlib-jdk8 instead", null, 4, null);
            }
        }
        List<VirtualFile> librariesWithBundled = runtimeJarsInfo.getOtherLibrariesWithBundledRuntime();
        actualApi = librariesWithBundled;
        boolean bl = false;
        if (!actualApi.isEmpty()) {
            JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Some JAR files in the classpath have the Kotlin Runtime library bundled into them. This may cause difficult to debug problems if there's a different version of the Kotlin Runtime library in the classpath. Consider removing these libraries from the classpath", null, 4, null);
            for (VirtualFile library : librariesWithBundled) {
                JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, library, "Library has Kotlin runtime bundled into it", null, 4, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ClasspathConsistency checkCompilerClasspathConsistency(MessageCollector messageCollector, MavenComparableVersion apiVersion, RuntimeJarsInfo runtimeJarsInfo) {
        void $this$filterTo$iv$iv;
        boolean bl;
        block9: {
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv = runtimeJarsInfo.getCoreJars();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                KotlinLibraryFile kotlinLibraryFile = (KotlinLibraryFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Boolean bl3 = INSTANCE.checkNotNewerThanCompiler(messageCollector, (KotlinLibraryFile)it);
                collection.add(bl3);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl4 = false;
                    if (!it) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return ClasspathConsistency.InconsistentWithCompilerVersion.INSTANCE;
        }
        List<KotlinLibraryFile> jars = runtimeJarsInfo.getJars();
        if (jars.isEmpty()) {
            return ClasspathConsistency.Consistent.INSTANCE;
        }
        MavenComparableVersion mavenComparableVersion = this.checkMatchingVersionsAndGetRuntimeVersion(messageCollector, jars);
        if (mavenComparableVersion == null) {
            return ClasspathConsistency.InconsistentBecauseOfRuntimesWithDifferentVersions.INSTANCE;
        }
        MavenComparableVersion runtimeVersion = mavenComparableVersion;
        Iterable $this$filter$iv = jars;
        boolean $i$f$filter = false;
        Iterable bl4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinLibraryFile it = (KotlinLibraryFile)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getVersion().compareTo(apiVersion) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List jarsIncompatibleWithApiVersion = (List)destination$iv$iv;
        Collection collection = jarsIncompatibleWithApiVersion;
        boolean bl6 = false;
        if (!collection.isEmpty()) {
            return new ClasspathConsistency.InconsistentWithApiVersion(runtimeVersion, jarsIncompatibleWithApiVersion);
        }
        return ClasspathConsistency.Consistent.INSTANCE;
    }

    private final boolean checkNotNewerThanCompiler(MessageCollector messageCollector, KotlinLibraryFile jar) {
        if (jar.getVersion().compareTo(ApiVersion.LATEST_STABLE.getVersion()) > 0) {
            this.issue(messageCollector, jar.getFile(), "Runtime JAR file has version " + jar.getVersion() + " which is newer than compiler version " + ApiVersion.LATEST_STABLE.getVersion(), CompilerMessageSeverity.ERROR);
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final MavenComparableVersion checkMatchingVersionsAndGetRuntimeVersion(MessageCollector messageCollector, List<KotlinLibraryFile> jars) {
        var3_3 = jars;
        var4_6 = false;
        var3_4 = var3_3.isEmpty() == false;
        var4_6 = false;
        if (_Assertions.ENABLED && !var3_4) {
            $i$a$-assert-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$1 = false;
            $i$a$-assert-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$1 = "'jars' must not be empty";
            throw (Throwable)new AssertionError((Object)$i$a$-assert-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$1);
        }
        $this$minBy$iv = jars;
        $i$f$minBy = false;
        iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                it = (KotlinLibraryFile)minElem$iv;
                $i$a$-minBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$oldestVersion$1 = false;
                minValue$iv = it.getVersion();
                do {
                    e$iv = iterator$iv.next();
                    it = (KotlinLibraryFile)e$iv;
                    $i$a$-minBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$oldestVersion$1 = false;
                    v$iv = it.getVersion();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        oldestVersion = ((KotlinLibraryFile)v0).getVersion();
        $this$maxBy$iv = jars;
        $i$f$maxBy = false;
        iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                it = (KotlinLibraryFile)maxElem$iv;
                $i$a$-maxBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$newestVersion$1 = false;
                maxValue$iv = it.getVersion();
                do {
                    e$iv = iterator$iv.next();
                    it = (KotlinLibraryFile)e$iv;
                    $i$a$-maxBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$newestVersion$1 = false;
                    v$iv = it.getVersion();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(oldestVersion, newestVersion = ((KotlinLibraryFile)v1).getVersion())) {
            return oldestVersion;
        }
        var18_44 = null;
        var17_45 = messageCollector;
        var16_46 = this;
        $this$maxBy$iv = false;
        $i$f$maxBy = new StringBuilder();
        iterator$iv = false;
        maxElem$iv = false;
        $receiver = $i$f$maxBy;
        $i$a$-buildString-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$2 = false;
        v$iv = $receiver;
        $i$a$-maxBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$newestVersion$1 = "Runtime JAR files in the classpath should have the same version. These files were found in the classpath:";
        var13_47 = false;
        v2 = v$iv.append($i$a$-maxBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$newestVersion$1);
        Intrinsics.checkExpressionValueIsNotNull(v2, "append(value)");
        StringsKt.appendln(v2);
        for (Object jar : jars) {
            var13_48 = $receiver;
            var14_52 = "    " + jar.getFile().getPath() + " (version " + jar.getVersion() + ')';
            var15_56 = false;
            v3 = var13_48.append(var14_52);
            Intrinsics.checkExpressionValueIsNotNull(v3, "append(value)");
            StringsKt.appendln(v3);
        }
        v4 = $i$f$maxBy.toString();
        Intrinsics.checkExpressionValueIsNotNull(v4, "StringBuilder().apply(builderAction).toString()");
        $this$maxBy$iv = var19_57 = v4;
        $i$f$maxBy = false;
        v5 = $this$maxBy$iv;
        if (v5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        var19_57 = StringsKt.trimEnd((CharSequence)v5).toString();
        JvmRuntimeVersionsConsistencyChecker.issue$default(var16_46, var17_45, var18_44, var19_57, null, 4, null);
        $this$filter$iv = jars;
        $i$f$filter = false;
        maxElem$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            it = (KotlinLibraryFile)element$iv$iv;
            $i$a$-filter-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$minReflectJar$1 = false;
            v6 = it.getFile().getName();
            Intrinsics.checkExpressionValueIsNotNull(v6, "it.file.name");
            if (!StringsKt.startsWith$default(v6, "kotlin-reflect", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$minBy$iv = (List)destination$iv$iv;
        $i$f$minBy = false;
        iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v7 = null;
        } else {
            minElem$iv /* !! */  = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v7 = minElem$iv /* !! */ ;
            } else {
                it = (KotlinLibraryFile)minElem$iv /* !! */ ;
                $i$a$-minBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$minReflectJar$2 = false;
                minValue$iv = it.getVersion();
                do {
                    e$iv = iterator$iv.next();
                    it = (KotlinLibraryFile)e$iv;
                    $i$a$-minBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$minReflectJar$2 = false;
                    v$iv = it.getVersion();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv /* !! */  = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v7 = minElem$iv /* !! */ ;
            }
        }
        minReflectJar = v7;
        $this$filter$iv = jars;
        $i$f$filter = false;
        minElem$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (KotlinLibraryFile)element$iv$iv;
            $i$a$-filter-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$maxStdlibJar$1 = false;
            v8 = it.getFile().getName();
            Intrinsics.checkExpressionValueIsNotNull(v8, "it.file.name");
            if (StringsKt.startsWith$default(v8, "kotlin-runtime", false, 2, null)) ** GOTO lbl-1000
            v9 = it.getFile().getName();
            Intrinsics.checkExpressionValueIsNotNull(v9, "it.file.name");
            if (StringsKt.startsWith$default(v9, "kotlin-stdlib", false, 2, null)) lbl-1000:
            // 2 sources

            {
                v10 = true;
            } else {
                v10 = false;
            }
            if (!v10) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$maxBy$iv = (List)destination$iv$iv;
        $i$f$maxBy = false;
        iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v11 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v11 = maxElem$iv;
            } else {
                it = (KotlinLibraryFile)maxElem$iv;
                $i$a$-maxBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$maxStdlibJar$2 = false;
                maxValue$iv = it.getVersion();
                do {
                    e$iv = iterator$iv.next();
                    it = (KotlinLibraryFile)e$iv;
                    $i$a$-maxBy-JvmRuntimeVersionsConsistencyChecker$checkMatchingVersionsAndGetRuntimeVersion$maxStdlibJar$2 = false;
                    v$iv = it.getVersion();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v11 = maxElem$iv;
            }
        }
        maxStdlibJar = v11;
        if (minReflectJar != null && maxStdlibJar != null && minReflectJar.getVersion().compareTo(maxStdlibJar.getVersion()) < 0) {
            JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Consider providing an explicit dependency on kotlin-reflect " + maxStdlibJar.getVersion() + " to prevent strange errors", null, 4, null);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final void issue(@NotNull MessageCollector $receiver, VirtualFile file, String message, CompilerMessageSeverity severity) {
        v0 = $receiver;
        v1 = severity;
        v2 = message;
        v3 = CompilerMessageLocation.Companion;
        v4 = file;
        if (v4 == null) ** GOTO lbl-1000
        var5_5 = v4;
        var13_6 = v3;
        var12_7 = v2;
        var11_8 = v1;
        var10_9 = v0;
        var6_10 = false;
        var7_11 = false;
        p1 = var5_5;
        $i$a$-unknown-JvmRuntimeVersionsConsistencyChecker$issue$1 = false;
        var14_14 = VfsUtilCore.virtualToIoFile(p1);
        v0 = var10_9;
        v1 = var11_8;
        v2 = var12_7;
        v3 = var13_6;
        v4 = var14_14;
        if (v4 != null) {
            v5 = v4.getPath();
        } else lbl-1000:
        // 2 sources

        {
            v5 = null;
        }
        v0.report(v1, v2, v3.create(v5));
    }

    static /* synthetic */ void issue$default(JvmRuntimeVersionsConsistencyChecker jvmRuntimeVersionsConsistencyChecker, MessageCollector messageCollector, VirtualFile virtualFile2, String string, CompilerMessageSeverity compilerMessageSeverity, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageSeverity = CompilerMessageSeverity.STRONG_WARNING;
        }
        jvmRuntimeVersionsConsistencyChecker.issue(messageCollector, virtualFile2, string, compilerMessageSeverity);
    }

    private final RuntimeJarsInfo collectRuntimeJarsInfo(List<? extends VirtualFile> classpathJarRoots) {
        ArrayList<KotlinLibraryFile> jars = new ArrayList<KotlinLibraryFile>(2);
        ArrayList<KotlinLibraryFile> coreJars = new ArrayList<KotlinLibraryFile>(2);
        ArrayList<VirtualFile> otherLibrariesWithBundledRuntime = new ArrayList<VirtualFile>(0);
        ArrayList<KotlinLibraryFile> stdlibJre7 = new ArrayList<KotlinLibraryFile>(0);
        ArrayList<KotlinLibraryFile> stdlibJre8 = new ArrayList<KotlinLibraryFile>(0);
        boolean bl = false;
        HashSet<String> visitedPaths = new HashSet<String>();
        for (VirtualFile virtualFile2 : classpathJarRoots) {
            VirtualFile jarFile;
            FileKind fileKind = this.determineFileKind(virtualFile2);
            if (fileKind instanceof FileKind.Irrelevant) continue;
            if (VfsUtilCore.getVirtualFileForJar(virtualFile2) == null) {
                continue;
            }
            VirtualFile virtualFile3 = jarFile;
            Intrinsics.checkExpressionValueIsNotNull(virtualFile3, "jarFile");
            if (!visitedPaths.add(virtualFile3.getPath())) continue;
            FileKind fileKind2 = fileKind;
            if (fileKind2 instanceof FileKind.Runtime) {
                KotlinLibraryFile file2 = new KotlinLibraryFile(jarFile, ((FileKind.Runtime)fileKind).getVersion());
                jars.add(file2);
                if (((FileKind.Runtime)fileKind).isCoreComponent()) {
                    coreJars.add(file2);
                }
                if (((FileKind.Runtime)fileKind).isStdlibJre7()) {
                    stdlibJre7.add(file2);
                }
                if (!((FileKind.Runtime)fileKind).isStdlibJre8()) continue;
                stdlibJre8.add(file2);
                continue;
            }
            if (Intrinsics.areEqual(fileKind2, FileKind.OldRuntime.INSTANCE)) {
                jars.add(new KotlinLibraryFile(jarFile, ApiVersion.KOTLIN_1_0.getVersion()));
                continue;
            }
            if (!Intrinsics.areEqual(fileKind2, FileKind.LibraryWithBundledRuntime.INSTANCE)) continue;
            otherLibrariesWithBundledRuntime.add(jarFile);
        }
        return new RuntimeJarsInfo((List<KotlinLibraryFile>)jars, (List<KotlinLibraryFile>)coreJars, (List<? extends VirtualFile>)otherLibrariesWithBundledRuntime, (List<KotlinLibraryFile>)stdlibJre7, (List<KotlinLibraryFile>)stdlibJre8);
    }

    private final FileKind determineFileKind(VirtualFile jarRoot) {
        VirtualFile virtualFile2;
        VirtualFile manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
        try {
            Manifest manifest2;
            VirtualFile virtualFile3 = manifestFile;
            if (virtualFile3 != null) {
                virtualFile2 = virtualFile3;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile2;
                boolean bl3 = false;
                VirtualFile virtualFile4 = it;
                Intrinsics.checkExpressionValueIsNotNull(virtualFile4, "it");
                manifest2 = new Manifest(virtualFile4.getInputStream());
            } else {
                manifest2 = null;
            }
            virtualFile2 = manifest2;
        }
        catch (IOException e) {
            return FileKind.Irrelevant.INSTANCE;
        }
        VirtualFile manifest3 = virtualFile2;
        Cloneable cloneable2 = manifest3;
        String runtimeComponent = cloneable2 != null && (cloneable2 = ((Manifest)cloneable2).getMainAttributes()) != null ? ((Attributes)cloneable2).getValue(KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE) : null;
        boolean isStdlibJre7 = jarRoot.findFileByRelativePath("META-INF/kotlin-stdlib-jre7.kotlin_module") != null;
        boolean isStdlibJre8 = jarRoot.findFileByRelativePath("META-INF/kotlin-stdlib-jre8.kotlin_module") != null;
        String string = runtimeComponent;
        return Intrinsics.areEqual(string, KOTLIN_RUNTIME_COMPONENT_MAIN) ? (FileKind)new FileKind.Runtime(this.getKotlinLanguageVersion((Manifest)((Object)manifest3)), isStdlibJre7, isStdlibJre8, false) : (Intrinsics.areEqual(string, KOTLIN_RUNTIME_COMPONENT_CORE) ? (FileKind)new FileKind.Runtime(this.getKotlinLanguageVersion((Manifest)((Object)manifest3)), isStdlibJre7, isStdlibJre8, true) : (string == null ? (jarRoot.findFileByRelativePath("META-INF/kotlin-stdlib.kotlin_module") == null && jarRoot.findFileByRelativePath("META-INF/kotlin-reflection.kotlin_module") == null ? (FileKind)FileKind.Irrelevant.INSTANCE : (this.isGenuineKotlinRuntime((Manifest)((Object)manifest3)) ? (FileKind)FileKind.OldRuntime.INSTANCE : (FileKind)FileKind.LibraryWithBundledRuntime.INSTANCE)) : (FileKind)FileKind.Irrelevant.INSTANCE));
    }

    private final boolean isGenuineKotlinRuntime(Manifest manifest2) {
        return manifest2 != null && RUNTIME_IMPLEMENTATION_TITLES.contains(manifest2.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE));
    }

    private final MavenComparableVersion getKotlinLanguageVersion(@NotNull Manifest $receiver) {
        Object object;
        block3: {
            block2: {
                object = $receiver.getMainAttributes().getValue(KOTLIN_VERSION_ATTRIBUTE);
                if (object == null) break block2;
                String string = object;
                ApiVersion.Companion companion = ApiVersion.Companion;
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string;
                boolean bl3 = false;
                object = companion.parse(p1);
                if (object != null) break block3;
            }
            object = ApiVersion.KOTLIN_1_0;
        }
        return ((ApiVersion)object).getVersion();
    }

    private JvmRuntimeVersionsConsistencyChecker() {
    }

    static {
        Object object;
        JvmRuntimeVersionsConsistencyChecker jvmRuntimeVersionsConsistencyChecker;
        INSTANCE = jvmRuntimeVersionsConsistencyChecker = new JvmRuntimeVersionsConsistencyChecker();
        LOG = Logger.getInstance(JvmRuntimeVersionsConsistencyChecker.class);
        RUNTIME_IMPLEMENTATION_TITLES = SetsKt.setOf("kotlin-runtime", "kotlin-stdlib", "kotlin-reflect", "Kotlin Runtime", "Kotlin Standard Library", "Kotlin Reflect");
        try {
            object = JvmRuntimeVersionsConsistencyChecker.class.getResourceAsStream("/kotlinManifest.properties");
            boolean bl = false;
            boolean bl2 = false;
            InputStream input = object;
            boolean bl3 = false;
            Properties properties2 = new Properties();
            boolean bl4 = false;
            boolean bl5 = false;
            Properties $receiver = properties2;
            boolean bl6 = false;
            $receiver.load(input);
            object = properties2;
        }
        catch (Exception e) {
            LOG.error(e);
            throw (Throwable)e;
        }
        Object manifestProperties = object;
        KOTLIN_VERSION_ATTRIBUTE = jvmRuntimeVersionsConsistencyChecker.assertNotNull(((Properties)manifestProperties).getProperty("manifest.impl.attribute.kotlin.version"), 1.INSTANCE);
        KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE = jvmRuntimeVersionsConsistencyChecker.assertNotNull(((Properties)manifestProperties).getProperty("manifest.impl.attribute.kotlin.runtime.component"), 2.INSTANCE);
        KOTLIN_RUNTIME_COMPONENT_CORE = jvmRuntimeVersionsConsistencyChecker.assertNotNull(((Properties)manifestProperties).getProperty("manifest.impl.value.kotlin.runtime.component.core"), 3.INSTANCE);
        KOTLIN_RUNTIME_COMPONENT_MAIN = jvmRuntimeVersionsConsistencyChecker.assertNotNull(((Properties)manifestProperties).getProperty("manifest.impl.value.kotlin.runtime.component.main"), 4.INSTANCE);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "version", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/config/MavenComparableVersion;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getVersion", "()Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "toString", "", "cli"})
    private static final class KotlinLibraryFile {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final MavenComparableVersion version;

        @NotNull
        public String toString() {
            return this.file.getName() + ':' + this.version;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final MavenComparableVersion getVersion() {
            return this.version;
        }

        public KotlinLibraryFile(@NotNull VirtualFile file2, @NotNull MavenComparableVersion version) {
            Intrinsics.checkParameterIsNotNull(file2, "file");
            Intrinsics.checkParameterIsNotNull(version, "version");
            this.file = file2;
            this.version = version;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$RuntimeJarsInfo;", "", "jars", "", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "coreJars", "otherLibrariesWithBundledRuntime", "Lcom/intellij/openapi/vfs/VirtualFile;", "stdlibJre7", "stdlibJre8", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getCoreJars", "()Ljava/util/List;", "getJars", "getOtherLibrariesWithBundledRuntime", "getStdlibJre7", "getStdlibJre8", "cli"})
    private static final class RuntimeJarsInfo {
        @NotNull
        private final List<KotlinLibraryFile> jars;
        @NotNull
        private final List<KotlinLibraryFile> coreJars;
        @NotNull
        private final List<VirtualFile> otherLibrariesWithBundledRuntime;
        @NotNull
        private final List<KotlinLibraryFile> stdlibJre7;
        @NotNull
        private final List<KotlinLibraryFile> stdlibJre8;

        @NotNull
        public final List<KotlinLibraryFile> getJars() {
            return this.jars;
        }

        @NotNull
        public final List<KotlinLibraryFile> getCoreJars() {
            return this.coreJars;
        }

        @NotNull
        public final List<VirtualFile> getOtherLibrariesWithBundledRuntime() {
            return this.otherLibrariesWithBundledRuntime;
        }

        @NotNull
        public final List<KotlinLibraryFile> getStdlibJre7() {
            return this.stdlibJre7;
        }

        @NotNull
        public final List<KotlinLibraryFile> getStdlibJre8() {
            return this.stdlibJre8;
        }

        public RuntimeJarsInfo(@NotNull List<KotlinLibraryFile> jars, @NotNull List<KotlinLibraryFile> coreJars, @NotNull List<? extends VirtualFile> otherLibrariesWithBundledRuntime, @NotNull List<KotlinLibraryFile> stdlibJre7, @NotNull List<KotlinLibraryFile> stdlibJre8) {
            Intrinsics.checkParameterIsNotNull(jars, "jars");
            Intrinsics.checkParameterIsNotNull(coreJars, "coreJars");
            Intrinsics.checkParameterIsNotNull(otherLibrariesWithBundledRuntime, "otherLibrariesWithBundledRuntime");
            Intrinsics.checkParameterIsNotNull(stdlibJre7, "stdlibJre7");
            Intrinsics.checkParameterIsNotNull(stdlibJre8, "stdlibJre8");
            this.jars = jars;
            this.coreJars = coreJars;
            this.otherLibrariesWithBundledRuntime = otherLibrariesWithBundledRuntime;
            this.stdlibJre7 = stdlibJre7;
            this.stdlibJre8 = stdlibJre8;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "", "()V", "Consistent", "InconsistentBecauseOfRuntimesWithDifferentVersions", "InconsistentWithApiVersion", "InconsistentWithCompilerVersion", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$Consistent;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentWithApiVersion;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentWithCompilerVersion;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentBecauseOfRuntimesWithDifferentVersions;", "cli"})
    private static abstract class ClasspathConsistency {
        private ClasspathConsistency() {
        }

        public /* synthetic */ ClasspathConsistency(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$Consistent;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "()V", "cli"})
        public static final class Consistent
        extends ClasspathConsistency {
            public static final Consistent INSTANCE;

            private Consistent() {
                super(null);
            }

            static {
                Consistent consistent;
                INSTANCE = consistent = new Consistent();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentWithApiVersion;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "actualRuntimeVersion", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "incompatibleJars", "", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "(Lorg/jetbrains/kotlin/config/MavenComparableVersion;Ljava/util/List;)V", "getActualRuntimeVersion", "()Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "getIncompatibleJars", "()Ljava/util/List;", "cli"})
        public static final class InconsistentWithApiVersion
        extends ClasspathConsistency {
            @NotNull
            private final MavenComparableVersion actualRuntimeVersion;
            @NotNull
            private final List<KotlinLibraryFile> incompatibleJars;

            @NotNull
            public final MavenComparableVersion getActualRuntimeVersion() {
                return this.actualRuntimeVersion;
            }

            @NotNull
            public final List<KotlinLibraryFile> getIncompatibleJars() {
                return this.incompatibleJars;
            }

            public InconsistentWithApiVersion(@NotNull MavenComparableVersion actualRuntimeVersion, @NotNull List<KotlinLibraryFile> incompatibleJars) {
                Intrinsics.checkParameterIsNotNull(actualRuntimeVersion, "actualRuntimeVersion");
                Intrinsics.checkParameterIsNotNull(incompatibleJars, "incompatibleJars");
                super(null);
                this.actualRuntimeVersion = actualRuntimeVersion;
                this.incompatibleJars = incompatibleJars;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentWithCompilerVersion;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "()V", "cli"})
        public static final class InconsistentWithCompilerVersion
        extends ClasspathConsistency {
            public static final InconsistentWithCompilerVersion INSTANCE;

            private InconsistentWithCompilerVersion() {
                super(null);
            }

            static {
                InconsistentWithCompilerVersion inconsistentWithCompilerVersion;
                INSTANCE = inconsistentWithCompilerVersion = new InconsistentWithCompilerVersion();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentBecauseOfRuntimesWithDifferentVersions;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "()V", "cli"})
        public static final class InconsistentBecauseOfRuntimesWithDifferentVersions
        extends ClasspathConsistency {
            public static final InconsistentBecauseOfRuntimesWithDifferentVersions INSTANCE;

            private InconsistentBecauseOfRuntimesWithDifferentVersions() {
                super(null);
            }

            static {
                InconsistentBecauseOfRuntimesWithDifferentVersions inconsistentBecauseOfRuntimesWithDifferentVersions;
                INSTANCE = inconsistentBecauseOfRuntimesWithDifferentVersions = new InconsistentBecauseOfRuntimesWithDifferentVersions();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "", "()V", "Irrelevant", "LibraryWithBundledRuntime", "OldRuntime", "Runtime", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$Runtime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$OldRuntime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$LibraryWithBundledRuntime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$Irrelevant;", "cli"})
    private static abstract class FileKind {
        private FileKind() {
        }

        public /* synthetic */ FileKind(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$Runtime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "version", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "isStdlibJre7", "", "isStdlibJre8", "isCoreComponent", "(Lorg/jetbrains/kotlin/config/MavenComparableVersion;ZZZ)V", "()Z", "getVersion", "()Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "cli"})
        public static final class Runtime
        extends FileKind {
            @NotNull
            private final MavenComparableVersion version;
            private final boolean isStdlibJre7;
            private final boolean isStdlibJre8;
            private final boolean isCoreComponent;

            @NotNull
            public final MavenComparableVersion getVersion() {
                return this.version;
            }

            public final boolean isStdlibJre7() {
                return this.isStdlibJre7;
            }

            public final boolean isStdlibJre8() {
                return this.isStdlibJre8;
            }

            public final boolean isCoreComponent() {
                return this.isCoreComponent;
            }

            public Runtime(@NotNull MavenComparableVersion version, boolean isStdlibJre7, boolean isStdlibJre8, boolean isCoreComponent) {
                Intrinsics.checkParameterIsNotNull(version, "version");
                super(null);
                this.version = version;
                this.isStdlibJre7 = isStdlibJre7;
                this.isStdlibJre8 = isStdlibJre8;
                this.isCoreComponent = isCoreComponent;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$OldRuntime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "()V", "cli"})
        public static final class OldRuntime
        extends FileKind {
            public static final OldRuntime INSTANCE;

            private OldRuntime() {
                super(null);
            }

            static {
                OldRuntime oldRuntime;
                INSTANCE = oldRuntime = new OldRuntime();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$LibraryWithBundledRuntime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "()V", "cli"})
        public static final class LibraryWithBundledRuntime
        extends FileKind {
            public static final LibraryWithBundledRuntime INSTANCE;

            private LibraryWithBundledRuntime() {
                super(null);
            }

            static {
                LibraryWithBundledRuntime libraryWithBundledRuntime;
                INSTANCE = libraryWithBundledRuntime = new LibraryWithBundledRuntime();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$Irrelevant;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "()V", "cli"})
        public static final class Irrelevant
        extends FileKind {
            public static final Irrelevant INSTANCE;

            private Irrelevant() {
                super(null);
            }

            static {
                Irrelevant irrelevant;
                INSTANCE = irrelevant = new Irrelevant();
            }
        }
    }
}

