/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedImportImpl;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J/\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "()V", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;", "resolveToPackageOrClass", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer$PackageOrClass;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformImport", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "import", "transformImportForFqName", "delegate", "PackageOrClass", "resolve"})
public final class FirImportResolveTransformer
extends FirAbstractTreeTransformer {
    private FirSymbolProvider symbolProvider;
    private FirSession session;

    @Override
    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        E $this$compose$iv = element;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public CompositeTransformResult<FirFile> transformFile(@NotNull FirFile file2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        this.session = file2.getFileSession();
        this.symbolProvider = FirSymbolProvider.Companion.getInstance(file2.getFileSession());
        FirFile firFile = file2;
        boolean bl = false;
        boolean bl2 = false;
        FirFile it = firFile;
        boolean bl3 = false;
        it.transformChildren(this, null);
        FirElement $this$compose$iv = firFile;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public CompositeTransformResult<FirImport> transformImport(@NotNull FirImport firImport, @Nullable Void data) {
        FqName fqName2;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull(firImport, "import");
                fqName2 = firImport.getImportedFqName();
                if (fqName2 == null) break block4;
                FqName fqName3 = fqName2;
                boolean bl = false;
                boolean bl2 = false;
                FqName it = fqName3;
                boolean bl3 = false;
                fqName2 = !it.isRoot() ? fqName3 : null;
                if (fqName2 != null) break block5;
            }
            FirElement $this$compose$iv = firImport;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        FqName fqName4 = fqName2;
        if (firImport.isAllUnder()) {
            return this.transformImportForFqName(fqName4, firImport);
        }
        FqName fqName5 = fqName4.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName5, "fqName.parent()");
        FqName parentFqName = fqName5;
        return this.transformImportForFqName(parentFqName, firImport);
    }

    /*
     * WARNING - void declaration
     */
    private final CompositeTransformResult<FirImport> transformImportForFqName(FqName fqName2, FirImport delegate) {
        void packageFqName;
        PackageOrClass packageOrClass = this.resolveToPackageOrClass(fqName2);
        if (packageOrClass == null) {
            FirElement $this$compose$iv = delegate;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        PackageOrClass packageOrClass2 = packageOrClass;
        FqName fqName3 = packageOrClass2.component1();
        FqName relativeClassFqName = packageOrClass2.component2();
        FirSession firSession = this.session;
        if (firSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException("session");
        }
        FirElement $this$compose$iv = new FirResolvedImportImpl(firSession, delegate, (FqName)packageFqName, relativeClassFqName);
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final PackageOrClass resolveToPackageOrClass(FqName fqName2) {
        void $this$mapTo$iv$iv;
        FqName currentPackage = fqName2;
        List<Name> list2 = fqName2.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "fqName.pathSegments()");
        List<Name> pathSegments = list2;
        int prefixSize = pathSegments.size();
        while (!currentPackage.isRoot()) {
            FirSymbolProvider firSymbolProvider = this.symbolProvider;
            if (firSymbolProvider == null) {
                Intrinsics.throwUninitializedPropertyAccessException("symbolProvider");
            }
            if (firSymbolProvider.getPackage(currentPackage) != null) break;
            Intrinsics.checkExpressionValueIsNotNull(currentPackage.parent(), "currentPackage.parent()");
            --prefixSize;
        }
        if (Intrinsics.areEqual(currentPackage, fqName2)) {
            return new PackageOrClass(currentPackage, null);
        }
        Iterable $this$map$iv = RangesKt.until(prefixSize, pathSegments.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = pathSegments.get((int)it).asString();
            collection.add(string);
        }
        FqName fqName3 = FqName.fromSegments((List)destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "FqName.fromSegments((pre\u2026egments[it].asString() })");
        FqName relativeClassFqName = fqName3;
        ClassId classId = new ClassId(currentPackage, relativeClassFqName, false);
        FirSymbolProvider firSymbolProvider = this.symbolProvider;
        if (firSymbolProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException("symbolProvider");
        }
        if (firSymbolProvider.getClassLikeSymbolByFqName(classId) == null) {
            return null;
        }
        return new PackageOrClass(currentPackage, relativeClassFqName);
    }

    public FirImportResolveTransformer() {
    }

    public FirImportResolveTransformer(@NotNull FirSession session) {
        Intrinsics.checkParameterIsNotNull(session, "session");
        this();
        this.session = session;
        this.symbolProvider = FirSymbolProvider.Companion.getInstance(session);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer$PackageOrClass;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "relativeClassFqName", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getRelativeClassFqName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolve"})
    private static final class PackageOrClass {
        @NotNull
        private final FqName packageFqName;
        @Nullable
        private final FqName relativeClassFqName;

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @Nullable
        public final FqName getRelativeClassFqName() {
            return this.relativeClassFqName;
        }

        public PackageOrClass(@NotNull FqName packageFqName, @Nullable FqName relativeClassFqName) {
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            this.packageFqName = packageFqName;
            this.relativeClassFqName = relativeClassFqName;
        }

        @NotNull
        public final FqName component1() {
            return this.packageFqName;
        }

        @Nullable
        public final FqName component2() {
            return this.relativeClassFqName;
        }

        @NotNull
        public final PackageOrClass copy(@NotNull FqName packageFqName, @Nullable FqName relativeClassFqName) {
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            return new PackageOrClass(packageFqName, relativeClassFqName);
        }

        public static /* synthetic */ PackageOrClass copy$default(PackageOrClass packageOrClass, FqName fqName2, FqName fqName3, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = packageOrClass.packageFqName;
            }
            if ((n & 2) != 0) {
                fqName3 = packageOrClass.relativeClassFqName;
            }
            return packageOrClass.copy(fqName2, fqName3);
        }

        @NotNull
        public String toString() {
            return "PackageOrClass(packageFqName=" + this.packageFqName + ", relativeClassFqName=" + this.relativeClassFqName + ")";
        }

        public int hashCode() {
            FqName fqName2 = this.packageFqName;
            FqName fqName3 = this.relativeClassFqName;
            return (fqName2 != null ? ((Object)fqName2).hashCode() : 0) * 31 + (fqName3 != null ? ((Object)fqName3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PackageOrClass)) break block3;
                    PackageOrClass packageOrClass = (PackageOrClass)object;
                    if (!Intrinsics.areEqual(this.packageFqName, packageOrClass.packageFqName) || !Intrinsics.areEqual(this.relativeClassFqName, packageOrClass.relativeClassFqName)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

