/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.definitions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.scripting.compiler.plugin.definitions.CliScriptDependenciesProviderKt;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDependenciesProvider;
import org.jetbrains.kotlin.scripting.resolve.ScriptContentLoader;
import org.jetbrains.kotlin.scripting.resolve.ScriptContentLoaderKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptReportSink;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R.\u0010\u0005\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptDependenciesProvider;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDependenciesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/HashMap;", "", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "Lkotlin/collections/HashMap;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "scriptContentLoader", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptContentLoader;", "calculateExternalDependencies", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getScriptDependencies", "kotlin-scripting-compiler"})
public final class CliScriptDependenciesProvider
implements ScriptDependenciesProvider {
    private final ReentrantReadWriteLock cacheLock;
    private final HashMap<String, ScriptDependencies> cache;
    private final ScriptContentLoader scriptContentLoader;
    private final Project project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ScriptDependencies getScriptDependencies(@NotNull VirtualFile file) {
        ScriptDependencies scriptDependencies;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            scriptDependencies = this.calculateExternalDependencies(file);
        }
        finally {
            readLock.unlock();
        }
        return scriptDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ScriptDependencies calculateExternalDependencies(VirtualFile file) {
        ScriptDependencies scriptDependencies;
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        String path = string;
        ScriptDependencies cached = this.cache.get(path);
        if (cached != null) {
            scriptDependencies = cached;
        } else {
            KotlinScriptDefinition scriptDef = DefinitionsKt.findScriptDefinition((VirtualFile)file, (Project)this.project);
            if (scriptDef != null) {
                int n;
                int n2;
                ScriptDependencies deps;
                DependenciesResolver.ResolveResult result = this.scriptContentLoader.loadContentsAndResolveDependencies(scriptDef, file);
                ScriptReportSink scriptReportSink = (ScriptReportSink)ServiceManager.getService((Project)this.project, ScriptReportSink.class);
                if (scriptReportSink != null) {
                    scriptReportSink.attachReports(file, result.getReports());
                }
                ScriptDependencies scriptDependencies2 = result.getDependencies();
                Object object = deps = scriptDependencies2 != null ? ScriptContentLoaderKt.adjustByDefinition((ScriptDependencies)scriptDependencies2, (KotlinScriptDefinition)scriptDef) : null;
                if (deps != null) {
                    Logger logger = CliScriptDependenciesProviderKt.access$getLog$p();
                    StringBuilder stringBuilder = new StringBuilder().append("[kts] new cached deps for ").append(path).append(": ");
                    Iterable iterable = deps.getClasspath();
                    String string2 = File.pathSeparator;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
                    logger.info(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null)).toString());
                }
                ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
                boolean bl = false;
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                boolean bl2 = false;
                int n4 = 0;
                n4 = 0;
                int n5 = n3;
                while (n4 < n5) {
                    n2 = n4++;
                    n = 0;
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    boolean bl3 = false;
                    ScriptDependencies scriptDependencies3 = this.cache.put(path, deps);
                }
                finally {
                    n5 = 0;
                    n2 = 0;
                    n2 = 0;
                    n = n3;
                    while (n2 < n) {
                        int n6 = n2++;
                        boolean bl4 = false;
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
                scriptDependencies = deps;
            } else {
                scriptDependencies = null;
            }
        }
        return scriptDependencies;
    }

    public CliScriptDependenciesProvider(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.cacheLock = new ReentrantReadWriteLock();
        CliScriptDependenciesProvider cliScriptDependenciesProvider = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        cliScriptDependenciesProvider.cache = hashMap;
        this.scriptContentLoader = new ScriptContentLoader(this.project);
    }

    @Nullable
    public ScriptDependencies getScriptDependencies(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return ScriptDependenciesProvider.DefaultImpls.getScriptDependencies((ScriptDependenciesProvider)this, (PsiFile)file);
    }
}

