/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectNode;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ObjectTree {
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();
    private final Set<Disposable> myRootObjects = ContainerUtil.newIdentityTroveSet();
    private final Map<Disposable, ObjectNode> myObject2NodeMap = ContainerUtil.newIdentityTroveMap();
    private final Map<Disposable, Object> myDisposedObjects = ContainerUtil.createWeakMap(100, 0.5f, ContainerUtil.identityStrategy());
    private final List<ObjectNode> myExecutedNodes = new ArrayList<ObjectNode>();
    private final List<Disposable> myExecutedUnregisteredObjects = new ArrayList<Disposable>();
    final Object treeLock = new Object();

    ObjectTree() {
    }

    private ObjectNode getNode(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(0);
        }
        return this.myObject2NodeMap.get(object);
    }

    void putNode(@NotNull Disposable object, @Nullable(value="null means remove") ObjectNode node) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(1);
        }
        if (node == null) {
            this.myObject2NodeMap.remove(object);
        } else {
            this.myObject2NodeMap.put(object, node);
        }
    }

    @NotNull
    final List<ObjectNode> getNodesInExecution() {
        List<ObjectNode> list2 = this.myExecutedNodes;
        if (list2 == null) {
            ObjectTree.$$$reportNull$$$0(2);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void register(@NotNull Disposable parent2, @NotNull Disposable child) {
        if (parent2 == null) {
            ObjectTree.$$$reportNull$$$0(3);
        }
        if (child == null) {
            ObjectTree.$$$reportNull$$$0(4);
        }
        if (parent2 == child) {
            throw new IllegalArgumentException("Cannot register to itself: " + parent2);
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode childNode;
            Object wasDisposed = this.getDisposalInfo(parent2);
            if (wasDisposed != null) {
                throw new IncorrectOperationException("Sorry but parent: " + parent2 + " has already been disposed (see the cause for stacktrace) so the child: " + child + " will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            if (this.isDisposing(parent2)) {
                throw new IncorrectOperationException("Sorry but parent: " + parent2 + " is being disposed so the child: " + child + " will never be disposed");
            }
            this.myDisposedObjects.remove(child);
            ObjectNode parentNode = this.getNode(parent2);
            if (parentNode == null) {
                parentNode = this.createNodeFor(parent2, null);
            }
            if ((childNode = this.getNode(child)) == null) {
                childNode = this.createNodeFor(child, parentNode);
            } else {
                ObjectNode oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            ObjectTree.checkWasNotAddedAlready(parentNode, childNode);
            parentNode.addChild(childNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDisposalInfo(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(5);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myDisposedObjects.get(object);
        }
    }

    private static void checkWasNotAddedAlready(@NotNull ObjectNode childNode, @NotNull ObjectNode parentNode) {
        if (childNode == null) {
            ObjectTree.$$$reportNull$$$0(6);
        }
        if (parentNode == null) {
            ObjectTree.$$$reportNull$$$0(7);
        }
        for (ObjectNode node = childNode; node != null; node = node.getParent()) {
            if (node != parentNode) continue;
            throw new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
    }

    @NotNull
    private ObjectNode createNodeFor(@NotNull Disposable object, @Nullable ObjectNode parentNode) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(8);
        }
        ObjectNode newNode = new ObjectNode(this, parentNode, object);
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        ObjectNode objectNode = newNode;
        if (objectNode == null) {
            ObjectTree.$$$reportNull$$$0(9);
        }
        return objectNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void executeAll(@NotNull Disposable object, boolean processUnregistered) {
        block15: {
            boolean needTrace;
            ObjectNode node;
            if (object == null) {
                ObjectTree.$$$reportNull$$$0(10);
            }
            Object object2 = this.treeLock;
            synchronized (object2) {
                node = this.getNode(object);
            }
            boolean bl = needTrace = (node != null || processUnregistered) && Disposer.isDebugMode() && ourTopmostDisposeTrace.get() == null;
            if (needTrace) {
                ourTopmostDisposeTrace.set(ThrowableInterner.intern(new Throwable()));
            }
            try {
                if (node == null) {
                    if (processUnregistered) {
                        this.rememberDisposedTrace(object);
                        this.executeUnregistered(object);
                    }
                    break block15;
                }
                ObjectNode parent2 = node.getParent();
                SmartList exceptions = new SmartList();
                node.execute(exceptions);
                if (parent2 != null) {
                    Object object3 = this.treeLock;
                    synchronized (object3) {
                        parent2.removeChild(node);
                    }
                }
                ObjectTree.handleExceptions(exceptions);
            }
            finally {
                if (needTrace) {
                    ourTopmostDisposeTrace.remove();
                }
            }
        }
    }

    private static void handleExceptions(@NotNull List<? extends Throwable> exceptions) {
        if (exceptions == null) {
            ObjectTree.$$$reportNull$$$0(11);
        }
        if (!exceptions.isEmpty()) {
            for (Throwable throwable : exceptions) {
                if (throwable instanceof ProcessCanceledException) continue;
                ObjectTree.getLogger().error(throwable);
            }
            ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
            if (pce != null) {
                throw pce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposing(@NotNull Disposable disposable) {
        List<ObjectNode> guard;
        if (disposable == null) {
            ObjectTree.$$$reportNull$$$0(12);
        }
        List<ObjectNode> list2 = guard = this.getNodesInExecution();
        synchronized (list2) {
            for (ObjectNode node : guard) {
                if (node.getObject() != disposable) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull Consumer<? super T> action) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(13);
        }
        if (recursiveGuard == null) {
            ObjectTree.$$$reportNull$$$0(14);
        }
        if (action == null) {
            ObjectTree.$$$reportNull$$$0(15);
        }
        List<T> list2 = recursiveGuard;
        synchronized (list2) {
            if (ArrayUtil.indexOf(recursiveGuard, object, ContainerUtil.identityStrategy()) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.accept(object);
        }
        finally {
            list2 = recursiveGuard;
            synchronized (list2) {
                int i = ArrayUtil.lastIndexOf(recursiveGuard, object, ContainerUtil.identityStrategy());
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull Disposable disposable) {
        if (disposable == null) {
            ObjectTree.$$$reportNull$$$0(16);
        }
        ObjectTree.executeActionWithRecursiveGuard(disposable, this.myExecutedUnregisteredObjects, Disposable::dispose);
    }

    void removeRootObject(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(18);
        }
        this.myRootObjects.remove(object);
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
        if (logger == null) {
            ObjectTree.$$$reportNull$$$0(19);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberDisposedTrace(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(20);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            Throwable trace = ourTopmostDisposeTrace.get();
            this.myDisposedObjects.put(object, trace != null ? trace : Boolean.TRUE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ObjectTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveGuard";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ObjectTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesInExecution";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeFor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putNode";
                break;
            }
            case 2: 
            case 9: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkWasNotAddedAlready";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNodeFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleExceptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDisposing";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeActionWithRecursiveGuard";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeUnregistered";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferenceKeptInTree";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeRootObject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "rememberDisposedTrace";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 9: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

