/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.BitUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");
    private static final JBTreeTraverser<Class<?>> CLASS_TRAVERSER = JBTreeTraverser.from(aClass2 -> JBIterable.of(aClass2.getSuperclass()).append(aClass2.getInterfaces()));

    private ReflectionUtil() {
    }

    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(14);
        }
        ArrayList<Field> result2 = new ArrayList<Field>();
        for (Class clazz2 : ReflectionUtil.classTraverser(clazz)) {
            ContainerUtil.addAll(result2, clazz2.getDeclaredFields());
        }
        ArrayList<Field> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Field findField(@NotNull Class<?> clazz, @Nullable Class<?> type2, @NotNull String name) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(17);
        }
        if ((result2 = ReflectionUtil.findFieldInHierarchy(clazz, field -> name.equals(field.getName()) && (type2 == null || field.getType().equals(type2)))) != null) {
            Field field2 = result2;
            if (field2 == null) {
                ReflectionUtil.$$$reportNull$$$0(18);
            }
            return field2;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type2);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, @Nullable(value="null means any type") Class<?> fieldType, @NotNull String fieldName) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(19);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(20);
        }
        if ((result2 = ReflectionUtil.findFieldInHierarchy(clazz, field -> fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType())))) != null) {
            Field field2 = result2;
            if (field2 == null) {
                ReflectionUtil.$$$reportNull$$$0(21);
            }
            return field2;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    @Nullable
    private static Field findFieldInHierarchy(@NotNull Class<?> clazz, @NotNull Condition<? super Field> checker) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(22);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(23);
        }
        for (Class clazz2 : ReflectionUtil.classTraverser(clazz)) {
            Field field = ContainerUtil.find(clazz2.getDeclaredFields(), checker);
            if (field == null) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    public static void resetField(@NotNull Class<?> clazz, @Nullable(value="null means of any type") Class<?> type2, @NotNull String name) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(24);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(25);
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type2, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(30);
        }
        field.setAccessible(true);
        Class<?> type2 = field.getType();
        try {
            if (type2.isPrimitive()) {
                if (Boolean.TYPE.equals(type2)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type2)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type2)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type2)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> aClass2, @NonNls @NotNull String name, Class<?> ... parameters2) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(34);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(35);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(36);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass2.getMethod(name, parameters2));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class<?> aClass2, @NonNls @NotNull String name, Class<?> ... parameters2) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(38);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(39);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass2.getDeclaredMethod(name, parameters2));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class<?> aClass2, @NonNls @NotNull String name) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(40);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(41);
        }
        return ReflectionUtil.findFieldInHierarchy(aClass2, field -> name.equals(field.getName()));
    }

    @Nullable
    public static Class<?> getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class<?> ... parameters2) {
        Method method;
        if (instanceClass == null) {
            ReflectionUtil.$$$reportNull$$$0(50);
        }
        if (methodName == null) {
            ReflectionUtil.$$$reportNull$$$0(51);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(52);
        }
        return (method = ReflectionUtil.getMethod(instanceClass, methodName, parameters2)) == null ? null : method.getDeclaringClass();
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(53);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(54);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return (T)field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class<?> objectClass, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(55);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(56);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            return (T)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(63);
        }
        return ReflectionUtil.newInstance(aClass2, true);
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass2, boolean isKotlinDataClassesSupported) {
        Constructor<T> constructor;
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(64);
        }
        try {
            constructor = aClass2.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException e) {
                T t = aClass2.newInstance();
                if (t == null) {
                    ReflectionUtil.$$$reportNull$$$0(65);
                }
                return t;
            }
        }
        catch (Exception e) {
            T t;
            Throwable targetException;
            if (e instanceof InvocationTargetException && (targetException = ((InvocationTargetException)e).getTargetException()) instanceof ControlFlowException && targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (isKotlinDataClassesSupported && (t = ReflectionUtil.createAsDataClass(aClass2)) != null) {
                T t2 = t;
                if (t2 == null) {
                    ReflectionUtil.$$$reportNull$$$0(67);
                }
                return t2;
            }
            ExceptionUtil.rethrow(e);
            if (null == null) {
                ReflectionUtil.$$$reportNull$$$0(68);
            }
            return null;
        }
        T t = constructor.newInstance(new Object[0]);
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(66);
        }
        return t;
    }

    @Nullable
    private static <T> T createAsDataClass(@NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(69);
        }
        for (Annotation annotation2 : aClass2.getAnnotations()) {
            String name = annotation2.annotationType().getName();
            if (!name.equals("kotlin.Metadata") && !name.equals("kotlin.jvm.internal.KotlinClass")) continue;
            Constructor<?>[] constructors2 = aClass2.getDeclaredConstructors();
            Exception exception = null;
            SmartList defaultCtors = new SmartList();
            for (Constructor<?> constructor : constructors2) {
                try {
                    block14: {
                        Class<?>[] parameterTypes;
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        for (Class<?> type2 : parameterTypes = constructor.getParameterTypes()) {
                            if (!type2.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) {
                                continue;
                            }
                            break block14;
                        }
                        return (T)constructor.newInstance(new Object[parameterTypes.length]);
                    }
                    defaultCtors.add(constructor);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            for (Constructor constructor : defaultCtors) {
                try {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception == null) continue;
            ExceptionUtil.rethrow(exception);
        }
        return null;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args) {
        T t;
        if (constructor == null) {
            ReflectionUtil.$$$reportNull$$$0(70);
        }
        if (args == null) {
            ReflectionUtil.$$$reportNull$$$0(71);
        }
        try {
            t = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(72);
        }
        return t;
    }

    @NotNull
    public static <T, V> Field getTheOnlyVolatileInstanceFieldOfClass(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            ReflectionUtil.$$$reportNull$$$0(92);
        }
        if (fieldType == null) {
            ReflectionUtil.$$$reportNull$$$0(93);
        }
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found2 = null;
        for (Field field : declaredFields) {
            int modifiers2 = field.getModifiers();
            if (BitUtil.isSet(modifiers2, 8) || !BitUtil.isSet(modifiers2, 64) || !fieldType.isAssignableFrom(field.getType())) continue;
            if (found2 == null) {
                found2 = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found2 + " and " + field);
        }
        if (found2 == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        Field field = found2;
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(94);
        }
        return field;
    }

    @Nullable
    public static Class<?> findCallerClass(int framesToSkip) {
        try {
            Class<?>[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            ReflectionUtil.$$$reportNull$$$0(95);
        }
        if (descendant == null) {
            ReflectionUtil.$$$reportNull$$$0(96);
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    @NotNull
    public static JBTreeTraverser<Class<?>> classTraverser(@Nullable Class<?> root2) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)CLASS_TRAVERSER.unique()).withRoot(root2);
        if (jBTreeTraverser == null) {
            ReflectionUtil.$$$reportNull$$$0(97);
        }
        return jBTreeTraverser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 47: 
            case 49: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 47: 
            case 49: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 47: 
            case 49: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ReflectionUtil";
                break;
            }
            case 6: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterizedType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 54: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 30: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 31: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 33: 
            case 36: 
            case 39: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceClass";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 53: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 74: 
            case 77: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 75: 
            case 78: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSettings";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useField";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ReflectionUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationToString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualTypeArguments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findField";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findAssignableField";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclaredFields";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRealMethods";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructor";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "forName";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "classTraverser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "declarationToString";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 47: 
            case 49: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRawType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActualTypeArguments";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "substituteGenericType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAssignableField";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFieldInHierarchy";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resetField";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredMethod";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredField";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getClassPublicMethods";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredMethods";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredFields";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "filterRealMethods";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclaringClass";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFieldValue";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setField";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariableInHierarchy";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructor";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createAsDataClass";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "copyFields";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "comparePublicNonFinalFields";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "compareFields";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldValue";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "forName";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 47: 
            case 49: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        Class<?>[] getStack() {
            return this.getClassContext();
        }
    }
}

