/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSealedClass;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0006\u001b\u001c\u001d\u001e\u001f B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002J/\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "checkBooleanExhaustiveness", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "nullable", "checkEnumExhaustiveness", "enum", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkSealedClassExhaustiveness", "sealedClass", "Lorg/jetbrains/kotlin/fir/declarations/FirSealedClass;", "processExhaustivenessCheck", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformWhenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "BooleanExhaustivenessFlags", "BooleanExhaustivenessVisitor", "EnumExhaustivenessData", "EnumExhaustivenessVisitor", "SealedExhaustivenessData", "SealedExhaustivenessVisitor", "resolve"})
public final class FirWhenExhaustivenessTransformer
extends FirTransformer {
    private final BodyResolveComponents bodyResolveComponents;

    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        throw (Throwable)new IllegalArgumentException("Should not be there");
    }

    @NotNull
    public CompositeTransformResult<FirStatement> transformWhenExpression(@NotNull FirWhenExpression whenExpression, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(whenExpression, "whenExpression");
        FirWhenExpression firWhenExpression = this.processExhaustivenessCheck(whenExpression);
        if (firWhenExpression == null) {
            firWhenExpression = whenExpression;
        }
        FirWhenExpression resultExpression = firWhenExpression;
        FirElement $this$compose$iv = resultExpression;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    private final FirWhenExpression processExhaustivenessCheck(FirWhenExpression whenExpression) {
        FirWhenExpression firWhenExpression;
        boolean bl;
        Object object;
        FirAnnotationContainer firAnnotationContainer;
        boolean bl2;
        block22: {
            Iterable $this$any$iv = whenExpression.getBranches();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirWhenBranch it = (FirWhenBranch)element$iv;
                    boolean bl3 = false;
                    if (!(it.getCondition() instanceof FirElseIfTrueCondition)) continue;
                    bl2 = true;
                    break block22;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            whenExpression.replaceIsExhaustive(true);
            return whenExpression;
        }
        FirAnnotationContainer firAnnotationContainer2 = whenExpression.getSubjectVariable();
        if (firAnnotationContainer2 == null || (firAnnotationContainer2 = firAnnotationContainer2.getReturnTypeRef()) == null) {
            FirExpression firExpression2 = whenExpression.getSubject();
            if (!(firExpression2 instanceof FirQualifiedAccessExpression)) {
                firExpression2 = null;
            }
            FirQualifiedAccessExpression firQualifiedAccessExpression = (FirQualifiedAccessExpression)firExpression2;
            firAnnotationContainer2 = firAnnotationContainer = firQualifiedAccessExpression != null ? firQualifiedAccessExpression.getTypeRef() : null;
        }
        if (!(firAnnotationContainer2 instanceof FirResolvedTypeRef)) {
            firAnnotationContainer = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firAnnotationContainer;
        if (firResolvedTypeRef == null) {
            return null;
        }
        FirResolvedTypeRef typeRef = firResolvedTypeRef;
        ConeKotlinType coneKotlinType = typeRef.getType();
        if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeLookupTagBasedType)coneKotlinType) == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
            return null;
        }
        Object lookupTag = object;
        boolean nullable = typeRef.getType().getNullability() == ConeNullability.NULLABLE;
        Object object2 = lookupTag;
        if (!(object2 instanceof ConeClassLikeLookupTag)) {
            object2 = null;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = (ConeClassLikeLookupTag)object2;
        if (Intrinsics.areEqual(coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null, this.bodyResolveComponents.getSession().getBuiltinTypes().getBooleanType().getId())) {
            bl = this.checkBooleanExhaustiveness(whenExpression, nullable);
        } else {
            FirClassifierSymbol<?> firClassifierSymbol = ResolveUtilsKt.toSymbol((ConeClassifierLookupTag)lookupTag, this.bodyResolveComponents.getSession());
            Object object3 = firClassifierSymbol != null ? firClassifierSymbol.getFir() : null;
            if (!(object3 instanceof FirRegularClass)) {
                object3 = null;
            }
            FirRegularClass firRegularClass = (FirRegularClass)object3;
            if (firRegularClass == null) {
                return null;
            }
            FirRegularClass klass2 = firRegularClass;
            if (klass2.getClassKind() == ClassKind.ENUM_CLASS) {
                bl = this.checkEnumExhaustiveness(whenExpression, klass2, nullable);
            } else {
                FirMemberDeclaration $this$modality$iv = klass2;
                boolean $i$f$getModality = false;
                if ($this$modality$iv.getStatus().getModality() == Modality.SEALED) {
                    FirRegularClass firRegularClass2 = klass2;
                    if (firRegularClass2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSealedClass");
                    }
                    bl = this.checkSealedClassExhaustiveness(whenExpression, (FirSealedClass)firRegularClass2, nullable);
                } else {
                    return null;
                }
            }
        }
        boolean isExhaustive = bl;
        if (isExhaustive) {
            whenExpression.replaceIsExhaustive(true);
            firWhenExpression = whenExpression;
        } else {
            firWhenExpression = null;
        }
        return firWhenExpression;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkEnumExhaustiveness(FirWhenExpression whenExpression, FirRegularClass firRegularClass, boolean nullable) {
        boolean it;
        void $this$associateByTo$iv;
        Iterable iterable = FirDeclarationUtilKt.collectEnumEntries(firRegularClass);
        boolean bl = false;
        Map map2 = new LinkedHashMap();
        Map destination$iv = map2;
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            FirEnumEntry it2;
            FirEnumEntry firEnumEntry = (FirEnumEntry)element$iv;
            map2 = destination$iv;
            boolean bl2 = false;
            ClassId classId = FirDeclarationUtilKt.getClassId(it2);
            it2 = (FirEnumEntry)element$iv;
            boolean bl3 = false;
            Boolean bl4 = false;
            map2.put(classId, bl4);
        }
        map2 = destination$iv;
        boolean bl5 = !nullable;
        Map map3 = map2;
        EnumExhaustivenessData data = new EnumExhaustivenessData(map3, bl5);
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.getCondition().accept(EnumExhaustivenessVisitor.INSTANCE, data);
        }
        if (!data.getContainsNull()) return false;
        Iterable $this$all$iv = data.getVisitedEntries().values();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (Boolean)element$iv;
            boolean bl6 = false;
        } while (it);
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkSealedClassExhaustiveness(FirWhenExpression whenExpression, FirSealedClass sealedClass, boolean nullable) {
        boolean it;
        Iterator<FirWhenBranch> destination$iv;
        void $this$associateByTo$iv;
        Map map2;
        if (sealedClass.getInheritors().isEmpty()) {
            return true;
        }
        Iterable iterable = sealedClass.getInheritors();
        FirSymbolProvider firSymbolProvider = ResolveUtilsKt.getFirSymbolProvider(sealedClass.getSession());
        boolean bl = false;
        Map map3 = map2 = (Map)new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            ClassId it2;
            ClassId classId = (ClassId)element$iv;
            map2 = destination$iv;
            boolean bl2 = false;
            void var16_19 = it2;
            it2 = (ClassId)element$iv;
            boolean bl3 = false;
            Boolean bl4 = false;
            map2.put(var16_19, bl4);
        }
        map2 = destination$iv;
        boolean bl5 = !nullable;
        Map map4 = map2;
        FirSymbolProvider firSymbolProvider2 = firSymbolProvider;
        SealedExhaustivenessData data = new SealedExhaustivenessData(firSymbolProvider2, map4, bl5);
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.getCondition().accept(SealedExhaustivenessVisitor.INSTANCE, data);
        }
        if (!data.getContainsNull()) return false;
        Iterable $this$all$iv = data.getVisitedInheritors().values();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (Boolean)element$iv;
            boolean bl6 = false;
        } while (it);
        return false;
    }

    private final boolean checkBooleanExhaustiveness(FirWhenExpression whenExpression, boolean nullable) {
        BooleanExhaustivenessFlags flags = new BooleanExhaustivenessFlags(!nullable);
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.getCondition().accept(BooleanExhaustivenessVisitor.INSTANCE, flags);
        }
        return flags.getContainsTrue() && flags.getContainsFalse() && flags.getContainsNull();
    }

    public FirWhenExhaustivenessTransformer(@NotNull BodyResolveComponents bodyResolveComponents) {
        Intrinsics.checkParameterIsNotNull(bodyResolveComponents, "bodyResolveComponents");
        this.bodyResolveComponents = bodyResolveComponents;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$EnumExhaustivenessData;", "", "visitedEntries", "", "Lorg/jetbrains/kotlin/name/ClassId;", "", "containsNull", "(Ljava/util/Map;Z)V", "getContainsNull", "()Z", "setContainsNull", "(Z)V", "getVisitedEntries", "()Ljava/util/Map;", "resolve"})
    private static final class EnumExhaustivenessData {
        @NotNull
        private final Map<ClassId, Boolean> visitedEntries;
        private boolean containsNull;

        @NotNull
        public final Map<ClassId, Boolean> getVisitedEntries() {
            return this.visitedEntries;
        }

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }

        public EnumExhaustivenessData(@NotNull Map<ClassId, Boolean> visitedEntries, boolean containsNull) {
            Intrinsics.checkParameterIsNotNull(visitedEntries, "visitedEntries");
            this.visitedEntries = visitedEntries;
            this.containsNull = containsNull;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$EnumExhaustivenessVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$EnumExhaustivenessData;", "()V", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitOperatorCall", "operatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirOperatorCall;", "resolve"})
    private static final class EnumExhaustivenessVisitor
    extends FirVisitor<Unit, EnumExhaustivenessData> {
        public static final EnumExhaustivenessVisitor INSTANCE;

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull EnumExhaustivenessData data) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            Intrinsics.checkParameterIsNotNull(data, "data");
        }

        @Override
        public void visitOperatorCall(@NotNull FirOperatorCall operatorCall, @NotNull EnumExhaustivenessData data) {
            block1: {
                FirExpression argument;
                block2: {
                    Intrinsics.checkParameterIsNotNull(operatorCall, "operatorCall");
                    Intrinsics.checkParameterIsNotNull(data, "data");
                    if (operatorCall.getOperation() != FirOperation.EQ) break block1;
                    argument = operatorCall.getArguments().get(1);
                    if (!(argument instanceof FirConstExpression)) break block2;
                    if (((FirConstExpression)argument).getValue() != null) break block1;
                    data.setContainsNull(true);
                    break block1;
                }
                if (!(argument instanceof FirResolvedQualifier)) break block1;
                ClassId classId = ((FirResolvedQualifier)argument).getClassId();
                if (classId == null) {
                    return;
                }
                ClassId classId2 = classId;
                data.getVisitedEntries().replace(classId2, true);
            }
        }

        @Override
        public void visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @NotNull EnumExhaustivenessData data) {
            Intrinsics.checkParameterIsNotNull(binaryLogicExpression, "binaryLogicExpression");
            Intrinsics.checkParameterIsNotNull(data, "data");
            if (binaryLogicExpression.getKind() == LogicOperationKind.OR) {
                binaryLogicExpression.acceptChildren(this, data);
            }
        }

        private EnumExhaustivenessVisitor() {
        }

        static {
            EnumExhaustivenessVisitor enumExhaustivenessVisitor;
            INSTANCE = enumExhaustivenessVisitor = new EnumExhaustivenessVisitor();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedExhaustivenessData;", "", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;", "visitedInheritors", "", "Lorg/jetbrains/kotlin/name/ClassId;", "", "containsNull", "(Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;Ljava/util/Map;Z)V", "getContainsNull", "()Z", "setContainsNull", "(Z)V", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;", "getVisitedInheritors", "()Ljava/util/Map;", "resolve"})
    private static final class SealedExhaustivenessData {
        @NotNull
        private final FirSymbolProvider symbolProvider;
        @NotNull
        private final Map<ClassId, Boolean> visitedInheritors;
        private boolean containsNull;

        @NotNull
        public final FirSymbolProvider getSymbolProvider() {
            return this.symbolProvider;
        }

        @NotNull
        public final Map<ClassId, Boolean> getVisitedInheritors() {
            return this.visitedInheritors;
        }

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }

        public SealedExhaustivenessData(@NotNull FirSymbolProvider symbolProvider2, @NotNull Map<ClassId, Boolean> visitedInheritors, boolean containsNull) {
            Intrinsics.checkParameterIsNotNull(symbolProvider2, "symbolProvider");
            Intrinsics.checkParameterIsNotNull(visitedInheritors, "visitedInheritors");
            this.symbolProvider = symbolProvider2;
            this.visitedInheritors = visitedInheritors;
            this.containsNull = containsNull;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedExhaustivenessVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedExhaustivenessData;", "()V", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitOperatorCall", "operatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirOperatorCall;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "resolve"})
    private static final class SealedExhaustivenessVisitor
    extends FirDefaultVisitor<Unit, SealedExhaustivenessData> {
        public static final SealedExhaustivenessVisitor INSTANCE;

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            Intrinsics.checkParameterIsNotNull(data, "data");
        }

        @Override
        public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkParameterIsNotNull(typeOperatorCall, "typeOperatorCall");
            Intrinsics.checkParameterIsNotNull(data, "data");
            if (typeOperatorCall.getOperation() == FirOperation.IS) {
                typeOperatorCall.getConversionTypeRef().accept(this, data);
            }
        }

        @Override
        public void visitOperatorCall(@NotNull FirOperatorCall operatorCall, @NotNull SealedExhaustivenessData data) {
            FirExpression argument;
            Intrinsics.checkParameterIsNotNull(operatorCall, "operatorCall");
            Intrinsics.checkParameterIsNotNull(data, "data");
            if (operatorCall.getOperation() == FirOperation.EQ && (argument = operatorCall.getArguments().get(1)) instanceof FirConstExpression && ((FirConstExpression)argument).getValue() == null) {
                data.setContainsNull(true);
            }
        }

        @Override
        public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull SealedExhaustivenessData data) {
            Object object;
            Intrinsics.checkParameterIsNotNull(resolvedTypeRef, "resolvedTypeRef");
            Intrinsics.checkParameterIsNotNull(data, "data");
            ConeKotlinType coneKotlinType = resolvedTypeRef.getType();
            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                coneKotlinType = null;
            }
            if ((object = (ConeLookupTagBasedType)coneKotlinType) == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
                return;
            }
            Object lookupTag = object;
            FirClassifierSymbol<?> firClassifierSymbol = data.getSymbolProvider().getSymbolByLookupTag((ConeClassifierLookupTag)lookupTag);
            if (!(firClassifierSymbol instanceof FirClassSymbol)) {
                firClassifierSymbol = null;
            }
            FirClassSymbol firClassSymbol = (FirClassSymbol)firClassifierSymbol;
            if (firClassSymbol == null) {
                return;
            }
            FirClassSymbol symbol2 = firClassSymbol;
            data.getVisitedInheritors().replace(symbol2.getClassId(), true);
        }

        @Override
        public void visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkParameterIsNotNull(binaryLogicExpression, "binaryLogicExpression");
            Intrinsics.checkParameterIsNotNull(data, "data");
            if (binaryLogicExpression.getKind() == LogicOperationKind.OR) {
                binaryLogicExpression.acceptChildren(this, data);
            }
        }

        private SealedExhaustivenessVisitor() {
        }

        static {
            SealedExhaustivenessVisitor sealedExhaustivenessVisitor;
            INSTANCE = sealedExhaustivenessVisitor = new SealedExhaustivenessVisitor();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0004R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u0004\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$BooleanExhaustivenessFlags;", "", "containsNull", "", "(Z)V", "containsFalse", "getContainsFalse", "()Z", "setContainsFalse", "getContainsNull", "setContainsNull", "containsTrue", "getContainsTrue", "setContainsTrue", "resolve"})
    private static final class BooleanExhaustivenessFlags {
        private boolean containsTrue;
        private boolean containsFalse;
        private boolean containsNull;

        public final boolean getContainsTrue() {
            return this.containsTrue;
        }

        public final void setContainsTrue(boolean bl) {
            this.containsTrue = bl;
        }

        public final boolean getContainsFalse() {
            return this.containsFalse;
        }

        public final void setContainsFalse(boolean bl) {
            this.containsFalse = bl;
        }

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }

        public BooleanExhaustivenessFlags(boolean containsNull) {
            this.containsNull = containsNull;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$BooleanExhaustivenessVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$BooleanExhaustivenessFlags;", "()V", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitOperatorCall", "operatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirOperatorCall;", "resolve"})
    private static final class BooleanExhaustivenessVisitor
    extends FirVisitor<Unit, BooleanExhaustivenessFlags> {
        public static final BooleanExhaustivenessVisitor INSTANCE;

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull BooleanExhaustivenessFlags data) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            Intrinsics.checkParameterIsNotNull(data, "data");
        }

        @Override
        public void visitOperatorCall(@NotNull FirOperatorCall operatorCall, @NotNull BooleanExhaustivenessFlags data) {
            block0: {
                Object t;
                block2: {
                    block1: {
                        FirExpression argument;
                        Intrinsics.checkParameterIsNotNull(operatorCall, "operatorCall");
                        Intrinsics.checkParameterIsNotNull(data, "data");
                        if (operatorCall.getOperation() != FirOperation.EQ || !((argument = operatorCall.getArguments().get(1)) instanceof FirConstExpression)) break block0;
                        t = ((FirConstExpression)argument).getValue();
                        if (!Intrinsics.areEqual(t, true)) break block1;
                        data.setContainsTrue(true);
                        break block0;
                    }
                    if (!Intrinsics.areEqual(t, false)) break block2;
                    data.setContainsFalse(true);
                    break block0;
                }
                if (t != null) break block0;
                data.setContainsNull(true);
            }
        }

        private BooleanExhaustivenessVisitor() {
        }

        static {
            BooleanExhaustivenessVisitor booleanExhaustivenessVisitor;
            INSTANCE = booleanExhaustivenessVisitor = new BooleanExhaustivenessVisitor();
        }
    }
}

