/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.xmlb.XIncludeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDOMXIncluder {
    private static final Logger LOG = Logger.getInstance(JDOMXIncluder.class);
    public static final PathResolver DEFAULT_PATH_RESOLVER = new PathResolver(){

        @Override
        @NotNull
        public URL resolvePath(@NotNull String relativePath, @Nullable URL base) throws MalformedURLException {
            if (relativePath == null) {
                1.$$$reportNull$$$0(0);
            }
            return base == null ? new URL(relativePath) : new URL(base, relativePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/util/xmlb/JDOMXIncluder$1", "resolvePath"));
        }
    };
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace("xi", "http://www.w3.org/2001/XInclude");
    private final boolean myIgnoreMissing;
    private final PathResolver myPathResolver;
    @NonNls
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");

    private JDOMXIncluder(boolean ignoreMissing, @NotNull PathResolver pathResolver) {
        if (pathResolver == null) {
            JDOMXIncluder.$$$reportNull$$$0(0);
        }
        this.myIgnoreMissing = ignoreMissing;
        this.myPathResolver = pathResolver;
    }

    public static void resolveNonXIncludeElement(@NotNull Element original, @Nullable URL base, boolean ignoreMissing, @NotNull PathResolver pathResolver) throws XIncludeException, MalformedURLException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(4);
        }
        if (pathResolver == null) {
            JDOMXIncluder.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(!JDOMXIncluder.isIncludeElement(original));
        Stack<URL> bases = new Stack<URL>();
        if (base != null) {
            bases.push(base);
        }
        new JDOMXIncluder(ignoreMissing, pathResolver).resolveNonXIncludeElement(original, bases);
    }

    protected static boolean isIncludeElement(Element element) {
        return element.getName().equals("include") && element.getNamespace().equals(XINCLUDE_NAMESPACE);
    }

    @NotNull
    private List<Element> resolve(@NotNull Element original, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(8);
        }
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(9);
        }
        if (JDOMXIncluder.isIncludeElement(original)) {
            List<Element> list2 = this.resolveXIncludeElement(original, bases);
            if (list2 == null) {
                JDOMXIncluder.$$$reportNull$$$0(10);
            }
            return list2;
        }
        this.resolveNonXIncludeElement(original, bases);
        List<Element> list3 = Collections.singletonList(original);
        if (list3 == null) {
            JDOMXIncluder.$$$reportNull$$$0(11);
        }
        return list3;
    }

    @NotNull
    protected List<Element> resolveXIncludeElement(@NotNull Element element, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        String parseAttribute;
        if (element == null) {
            JDOMXIncluder.$$$reportNull$$$0(12);
        }
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(13);
        }
        URL base = null;
        if (!bases.isEmpty()) {
            base = bases.peek();
        }
        String href = element.getAttributeValue("href");
        assert (href != null) : "Missing href attribute";
        String baseAttribute = element.getAttributeValue("base", Namespace.XML_NAMESPACE);
        if (baseAttribute != null) {
            base = new URL(baseAttribute);
        }
        if ((parseAttribute = element.getAttributeValue("parse")) != null) {
            LOG.assertTrue(parseAttribute.equals("xml"), parseAttribute + " is not a legal value for the parse attribute");
        }
        URL remote = this.myPathResolver.resolvePath(href, base);
        assert (!bases.contains(remote)) : "Circular XInclude Reference to " + remote.toExternalForm();
        Element fallbackElement = element.getChild("fallback", element.getNamespace());
        List<Element> remoteParsed = this.parseRemote(bases, remote, fallbackElement);
        if (!remoteParsed.isEmpty()) {
            remoteParsed = JDOMXIncluder.extractNeededChildren(element, remoteParsed);
        }
        for (int i = 0; i < remoteParsed.size(); ++i) {
            Element o = remoteParsed.get(i);
            if (JDOMXIncluder.isIncludeElement(o)) {
                List<Element> list2 = this.resolveXIncludeElement(o, bases);
                remoteParsed.addAll(i, list2);
                remoteParsed.remove(i += list2.size() - 1);
                continue;
            }
            this.resolveNonXIncludeElement(o, bases);
        }
        for (Content content : remoteParsed) {
            content.detach();
        }
        List<Element> list3 = remoteParsed;
        if (list3 == null) {
            JDOMXIncluder.$$$reportNull$$$0(14);
        }
        return list3;
    }

    @NotNull
    private static List<Element> extractNeededChildren(@NotNull Element element, @NotNull List<Element> remoteElements) {
        String xpointer;
        if (element == null) {
            JDOMXIncluder.$$$reportNull$$$0(15);
        }
        if (remoteElements == null) {
            JDOMXIncluder.$$$reportNull$$$0(16);
        }
        if ((xpointer = element.getAttributeValue("xpointer")) == null) {
            List<Element> list2 = remoteElements;
            if (list2 == null) {
                JDOMXIncluder.$$$reportNull$$$0(17);
            }
            return list2;
        }
        Matcher matcher2 = XPOINTER_PATTERN.matcher(xpointer);
        if (!matcher2.matches()) {
            throw new XIncludeException("Unsupported XPointer: " + xpointer);
        }
        String pointer = matcher2.group(1);
        if (!(matcher2 = CHILDREN_PATTERN.matcher(pointer)).matches()) {
            throw new XIncludeException("Unsupported pointer: " + pointer);
        }
        String rootTagName = matcher2.group(1);
        assert (remoteElements.size() == 1);
        Element e = remoteElements.get(0);
        if (!e.getName().equals(rootTagName)) {
            List<Element> list3 = Collections.emptyList();
            if (list3 == null) {
                JDOMXIncluder.$$$reportNull$$$0(18);
            }
            return list3;
        }
        String subTagName = matcher2.group(2);
        if (subTagName != null) {
            e = e.getChild(subTagName.substring(1));
            assert (e != null);
        }
        return new ArrayList<Element>(e.getChildren());
    }

    @NotNull
    private List<Element> parseRemote(@NotNull Stack<URL> bases, @NotNull URL remote, @Nullable Element fallbackElement) {
        List<Element> list2;
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(19);
        }
        if (remote == null) {
            JDOMXIncluder.$$$reportNull$$$0(20);
        }
        try {
            bases.push(remote);
            Element root2 = JDOMUtil.loadResource(remote);
            List<Element> list3 = this.resolve(root2, bases);
            bases.pop();
            list2 = list3;
        }
        catch (JDOMException e) {
            throw new XIncludeException(e);
        }
        catch (IOException e) {
            if (fallbackElement != null) {
                List<Element> list4 = Collections.emptyList();
                if (list4 == null) {
                    JDOMXIncluder.$$$reportNull$$$0(22);
                }
                return list4;
            }
            if (this.myIgnoreMissing) {
                LOG.info(remote.toExternalForm() + " include ignored: " + e.getMessage());
                List<Element> list5 = Collections.emptyList();
                if (list5 == null) {
                    JDOMXIncluder.$$$reportNull$$$0(23);
                }
                return list5;
            }
            throw new XIncludeException(e);
        }
        if (list2 == null) {
            JDOMXIncluder.$$$reportNull$$$0(21);
        }
        return list2;
    }

    private void resolveNonXIncludeElement(@NotNull Element original, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(24);
        }
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(25);
        }
        List<Content> contentList = original.getContent();
        for (int i = contentList.size() - 1; i >= 0; --i) {
            Content content = contentList.get(i);
            if (!(content instanceof Element)) continue;
            Element element = (Element)content;
            if (JDOMXIncluder.isIncludeElement(element)) {
                original.setContent(i, this.resolveXIncludeElement(element, bases));
                continue;
            }
            this.resolveNonXIncludeElement(element, bases);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/JDOMXIncluder";
                break;
            }
            case 9: 
            case 13: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bases";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteElements";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/JDOMXIncluder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRoot";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveXIncludeElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNeededChildren";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveRoot";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 4: 
            case 5: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveNonXIncludeElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveXIncludeElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractNeededChildren";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseRemote";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PathResolver {
        @NotNull
        public URL resolvePath(@NotNull String var1, @Nullable URL var2) throws MalformedURLException;
    }
}

