/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.fir.resolve.inference.ResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a>\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a$\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0012\u0010\u001b\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010\u001c\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001a\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u001e"}, d2={"receiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "getReceiverType", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "returnType", "getReturnType", "extractLambdaInfoFromFunctionalType", "Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedLambdaAtom;", "expectedType", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "argument", "returnTypeVariable", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConeTypeVariableForLambdaReturnType;", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "extractLambdaParameters", "", "expectedTypeIsExtensionFunctionType", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "extractParametersForFunctionalType", "isExtensionFunctionType", "isBuiltinFunctionalType", "isSuspendFunctionType", "valueParameterTypesIncludingReceiver", "resolve"})
public final class InferenceUtilsKt {
    public static final boolean isBuiltinFunctionalType(@NotNull ConeKotlinType $this$isBuiltinFunctionalType, @NotNull FirSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isBuiltinFunctionalType, "$this$isBuiltinFunctionalType");
        Intrinsics.checkNotNullParameter(session, "session");
        ConeKotlinType coneKotlinType = $this$isBuiltinFunctionalType;
        if (coneKotlinType instanceof ConeClassLikeType) {
            ClassId classId = ResolveUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$isBuiltinFunctionalType, session, null, 2, null).getLookupTag().getClassId();
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
            String string2 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "classId.relativeClassName.asString()");
            FunctionClassDescriptor.Kind kind = FunctionClassDescriptor.Kind.Companion.byClassNamePrefix(fqName2, string2);
            if (kind == null) {
                return false;
            }
            FunctionClassDescriptor.Kind kind2 = kind;
            bl = kind2 == FunctionClassDescriptor.Kind.Function || kind2 == FunctionClassDescriptor.Kind.SuspendFunction;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isSuspendFunctionType(@NotNull ConeKotlinType $this$isSuspendFunctionType, @NotNull FirSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionType, "$this$isSuspendFunctionType");
        Intrinsics.checkNotNullParameter(session, "session");
        ConeKotlinType type2 = $this$isSuspendFunctionType;
        if (type2 instanceof ConeClassLikeType) {
            ClassId classId = ResolveUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, session, null, 2, null).getLookupTag().getClassId();
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
            String string2 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "classId.relativeClassName.asString()");
            FunctionClassDescriptor.Kind kind = FunctionClassDescriptor.Kind.Companion.byClassNamePrefix(fqName2, string2);
            if (kind == null) {
                return false;
            }
            FunctionClassDescriptor.Kind kind2 = kind;
            bl = kind2 == FunctionClassDescriptor.Kind.SuspendFunction;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final ConeKotlinType receiverType(@NotNull ConeKotlinType $this$receiverType, @NotNull FirTypeRef expectedTypeRef, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$receiverType, "$this$receiverType");
        Intrinsics.checkNotNullParameter(expectedTypeRef, "expectedTypeRef");
        Intrinsics.checkNotNullParameter(session, "session");
        if (InferenceUtilsKt.isBuiltinFunctionalType($this$receiverType, session) && ArgumentsKt.isExtensionFunctionType(expectedTypeRef, session)) {
            ConeTypeProjection coneTypeProjection = ArraysKt.first(ResolveUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$receiverType, session, null, 2, null).getTypeArguments());
            if (coneTypeProjection == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection");
            }
            return ((ConeKotlinTypeProjection)coneTypeProjection).getType();
        }
        return null;
    }

    @Nullable
    public static final ConeKotlinType returnType(@NotNull ConeKotlinType $this$returnType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$returnType, "$this$returnType");
        Intrinsics.checkNotNullParameter(session, "session");
        boolean bl = $this$returnType instanceof ConeClassLikeType;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ConeTypeProjection projection = ArraysKt.last(ResolveUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$returnType, session, null, 2, null).getTypeArguments());
        ConeTypeProjection coneTypeProjection = projection;
        if (!(coneTypeProjection instanceof ConeKotlinTypeProjection)) {
            coneTypeProjection = null;
        }
        ConeKotlinTypeProjection coneKotlinTypeProjection = (ConeKotlinTypeProjection)coneTypeProjection;
        return coneKotlinTypeProjection != null ? coneKotlinTypeProjection.getType() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeKotlinType> valueParameterTypesIncludingReceiver(@NotNull ConeKotlinType $this$valueParameterTypesIncludingReceiver, @NotNull FirSession session) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$valueParameterTypesIncludingReceiver, "$this$valueParameterTypesIncludingReceiver");
        Intrinsics.checkNotNullParameter(session, "session");
        boolean bl = $this$valueParameterTypesIncludingReceiver instanceof ConeClassLikeType;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Iterable $this$map$iv = ArraysKt.dropLast(ResolveUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$valueParameterTypesIncludingReceiver, session, null, 2, null).getTypeArguments(), 1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            Object v0 = it;
            if (!(v0 instanceof ConeKotlinTypeProjection)) {
                v0 = null;
            }
            ConeKotlinTypeProjection coneKotlinTypeProjection = v0;
            ConeKotlinType coneKotlinType = coneKotlinTypeProjection != null ? coneKotlinTypeProjection.getType() : null;
            collection.add(coneKotlinType);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ConeKotlinType getReturnType(@NotNull FirAnonymousFunction $this$returnType) {
        Intrinsics.checkNotNullParameter($this$returnType, "$this$returnType");
        FirTypeRef $this$coneTypeSafe$iv = $this$returnType.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ConeKotlinType getReceiverType(@NotNull FirAnonymousFunction $this$receiverType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$receiverType, "$this$receiverType");
        FirTypeRef firTypeRef = $this$receiverType.getReceiverTypeRef();
        if (firTypeRef != null) {
            FirTypeRef $this$coneTypeSafe$iv = firTypeRef;
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            FirTypeRef firTypeRef2 = $this$coneTypeSafe$iv;
            if (!(firTypeRef2 instanceof FirResolvedTypeRef)) {
                firTypeRef2 = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef2;
            coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ResolvedLambdaAtom extractLambdaInfoFromFunctionalType(@Nullable ConeKotlinType expectedType2, @NotNull FirTypeRef expectedTypeRef, @NotNull FirAnonymousFunction argument, @Nullable ConeTypeVariableForLambdaReturnType returnTypeVariable, @NotNull BodyResolveComponents components, @Nullable Candidate candidate2) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType receiverType;
        Intrinsics.checkNotNullParameter(expectedTypeRef, "expectedTypeRef");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(components, "components");
        FirSession session = components.getSession();
        if (expectedType2 == null) {
            return null;
        }
        if (expectedType2 instanceof ConeFlexibleType) {
            return InferenceUtilsKt.extractLambdaInfoFromFunctionalType(((ConeFlexibleType)expectedType2).getLowerBound(), expectedTypeRef, argument, returnTypeVariable, components, candidate2);
        }
        if (!InferenceUtilsKt.isBuiltinFunctionalType(expectedType2, session)) {
            return null;
        }
        ConeKotlinType coneKotlinType2 = InferenceUtilsKt.getReceiverType(argument);
        if (coneKotlinType2 == null) {
            coneKotlinType2 = receiverType = InferenceUtilsKt.receiverType(expectedType2, expectedTypeRef, session);
        }
        if ((coneKotlinType = InferenceUtilsKt.getReturnType(argument)) == null) {
            coneKotlinType = InferenceUtilsKt.returnType(expectedType2, session);
        }
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType returnType2 = coneKotlinType;
        List<ConeKotlinType> parameters2 = InferenceUtilsKt.extractLambdaParameters(expectedType2, argument, ArgumentsKt.isExtensionFunctionType(expectedTypeRef, session), session);
        return new ResolvedLambdaAtom(argument, expectedType2, InferenceUtilsKt.isSuspendFunctionType(expectedType2, session), receiverType, parameters2, returnType2, returnTypeVariable, candidate2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConeKotlinType> extractLambdaParameters(ConeKotlinType expectedType2, FirAnonymousFunction argument, boolean expectedTypeIsExtensionFunctionType, FirSession session) {
        void $this$mapIndexedTo$iv$iv;
        List<FirValueParameter> parameters2 = argument.getValueParameters();
        List<ConeKotlinType> expectedParameters = InferenceUtilsKt.extractParametersForFunctionalType(expectedType2, expectedTypeIsExtensionFunctionType, session);
        ConeClassLikeType nullableAnyType = argument.getSession().getBuiltinTypes().getNullableAnyType().getType();
        if (parameters2.isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = expectedParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConeKotlinType coneKotlinType = (ConeKotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ConeKotlinType coneKotlinType2 = it;
                if (coneKotlinType2 == null || (coneKotlinType2 = coneKotlinType2.getType()) == null) {
                    coneKotlinType2 = nullableAnyType;
                }
                ConeKotlinType coneKotlinType3 = coneKotlinType2;
                collection.add(coneKotlinType3);
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$mapIndexed$iv = parameters2;
        boolean $i$f$mapIndexed = false;
        Iterable $this$mapTo$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            ConeKotlinType coneKotlinType;
            ConeKotlinType coneKotlinType4;
            void parameter;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            FirTypeRef $this$coneTypeSafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            boolean bl3 = false;
            FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            ConeKotlinType coneKotlinType5 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType5 instanceof ConeKotlinType)) {
                coneKotlinType5 = coneKotlinType4 = null;
            }
            if (coneKotlinType5 == null) {
                void index2;
                coneKotlinType4 = coneKotlinType = CollectionsKt.getOrNull(expectedParameters, (int)index2);
            }
            if (coneKotlinType4 == null) {
                coneKotlinType = nullableAnyType;
            }
            ConeKotlinType coneKotlinType6 = coneKotlinType;
            collection.add(coneKotlinType6);
        }
        return (List)destination$iv$iv;
    }

    private static final List<ConeKotlinType> extractParametersForFunctionalType(ConeKotlinType $this$extractParametersForFunctionalType, boolean isExtensionFunctionType, FirSession session) {
        List<ConeKotlinType> list2 = InferenceUtilsKt.valueParameterTypesIncludingReceiver($this$extractParametersForFunctionalType, session);
        boolean bl = false;
        boolean bl2 = false;
        List<ConeKotlinType> it = list2;
        boolean bl3 = false;
        return isExtensionFunctionType ? CollectionsKt.drop((Iterable)it, 1) : it;
    }
}

