/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ?2\u00020\u0001:\u0001?B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J.\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u001e\u001a\u00020\u00102\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0014J$\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0014J$\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J \u0010'\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010(2\u0006\u0010\u001a\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010(2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0002J \u0010-\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010(2\u0006\u0010\u001a\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020&H\u0002J&\u00101\u001a\u00020\u00182\u0014\u00102\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010!0(2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u00103\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J1\u00104\u001a\u0012\u0012\u0004\u0012\u000206\u0012\b\u0012\u0006\u0012\u0002\b\u00030!052\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b7J2\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0(2\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010=\u001a\u00020>2\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/openapi/project/Project;)V", "getLanguageVersionSettings$frontend", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getModule$frontend", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "checkCompileTimeConstant", "", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "useDeprecationWarning", "", "checkExperimentalityOfConstantLiteral", "expression", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expectedType", "checkInnerPartsOfCompileTimeConstant", "evaluateExpression", "evaluateToConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getAnnotationArgumentValue", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "getArgumentExpressionsForArrayCall", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getArgumentExpressionsForArrayLikeCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getArgumentExpressionsForCollectionLiteralCall", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "hasSpread", "argument", "isArrayPassedInNamedForm", "constants", "reportDeprecationWarningOnNonConst", "resolveAnnotationArguments", "", "Lorg/jetbrains/kotlin/name/Name;", "resolveAnnotationArguments$frontend", "resolveAnnotationValueArguments", "resolvedValueArgument", "deprecatedExpectedType", "updateNumberType", "numberType", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "Companion", "frontend"})
public final class ConstantExpressionEvaluator {
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private static final ExperimentalUsageChecker.ExperimentalityDiagnostics EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS;
    public static final Companion Companion;

    public final void updateNumberType(@NotNull KotlinType numberType, @Nullable KtExpression expression2, @NotNull StatementFilter statementFilter, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(numberType, "numberType");
        Intrinsics.checkNotNullParameter(statementFilter, "statementFilter");
        Intrinsics.checkNotNullParameter(trace, "trace");
        if (expression2 == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression2, trace, false);
        if (!(expression2 instanceof KtConstantExpression)) {
            KtExpression deparenthesized = KtPsiUtil.getLastElementDeparenthesized(expression2, statementFilter);
            if (deparenthesized != expression2) {
                this.updateNumberType(numberType, deparenthesized, statementFilter, trace);
            }
            return;
        }
        this.evaluateExpression(expression2, trace, numberType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Name, ConstantValue<?>> resolveAnnotationArguments$frontend(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(trace, "trace");
        HashMap arguments2 = new HashMap();
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = resolvedCall2.getValueArguments().entrySet().iterator();
        while (iterator2.hasNext()) {
            void parameterDescriptor;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            boolean bl = false;
            ValueParameterDescriptor valueParameterDescriptor = entry2.getKey();
            entry2 = entry;
            bl = false;
            ResolvedValueArgument resolvedArgument = entry2.getValue();
            void v0 = parameterDescriptor;
            Intrinsics.checkNotNullExpressionValue(v0, "parameterDescriptor");
            ResolvedValueArgument resolvedValueArgument = resolvedArgument;
            Intrinsics.checkNotNullExpressionValue(resolvedValueArgument, "resolvedArgument");
            ConstantValue<?> value2 = this.getAnnotationArgumentValue(trace, (ValueParameterDescriptor)v0, resolvedValueArgument);
            if (value2 == null) continue;
            arguments2.put(parameterDescriptor.getName(), value2);
        }
        return arguments2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkNotNullParameter(resolvedArgument, "resolvedArgument");
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        boolean argumentsAsVararg = varargElementType != null && !this.hasSpread(resolvedArgument);
        KotlinType constantType = argumentsAsVararg ? varargElementType : parameterDescriptor.getType();
        KotlinType expectedType2 = CallResolverUtilKt.getEffectiveExpectedType(parameterDescriptor, resolvedArgument, this.languageVersionSettings, trace);
        KotlinType kotlinType = constantType;
        Intrinsics.checkNotNull(kotlinType);
        List<CompileTimeConstant<?>> compileTimeConstants = this.resolveAnnotationValueArguments(resolvedArgument, kotlinType, expectedType2, trace);
        Iterable $this$map$iv = compileTimeConstants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConstantValue constantValue = it.toConstantValue(expectedType2);
            collection.add(constantValue);
        }
        List constants = (List)destination$iv$iv;
        if (argumentsAsVararg) {
            if (this.isArrayPassedInNamedForm(constants, resolvedArgument)) {
                return (ConstantValue)CollectionsKt.single(constants);
            }
            if (parameterDescriptor.declaresDefaultValue() && compileTimeConstants.isEmpty()) {
                return null;
            }
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "parameterDescriptor.type");
            return ConstantValueFactory.INSTANCE.createArrayValue(constants, kotlinType2);
        }
        return (ConstantValue)CollectionsKt.lastOrNull(constants);
    }

    private final boolean isArrayPassedInNamedForm(List<? extends ConstantValue<? extends Object>> constants, ResolvedValueArgument resolvedArgument) {
        ConstantValue<? extends Object> constantValue = CollectionsKt.singleOrNull(constants);
        if (constantValue == null) {
            return false;
        }
        ConstantValue<? extends Object> constant = constantValue;
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "resolvedArgument.arguments");
        ValueArgument valueArgument = CollectionsKt.singleOrNull(list2);
        if (valueArgument == null) {
            return false;
        }
        ValueArgument argument = valueArgument;
        return constant instanceof ArrayValue && argument.isNamed();
    }

    private final void checkCompileTimeConstant(KtExpression argumentExpression, KotlinType expressionType, BindingTrace trace, boolean useDeprecationWarning) {
        DiagnosticFactory0<KtExpression> diagnosticFactory;
        DiagnosticFactory0<KtExpression> diagnosticFactory0;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> constant = Companion.getConstant(argumentExpression, bindingContext);
        if (constant != null && constant.getCanBeUsedInAnnotations()) {
            this.checkInnerPartsOfCompileTimeConstant(constant, trace, argumentExpression, useDeprecationWarning);
            return;
        }
        ClassifierDescriptor descriptor2 = expressionType.getConstructor().getDeclarationDescriptor();
        if (DescriptorUtils.isEnumClass(descriptor2)) {
            diagnosticFactory0 = Errors.ANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST;
        } else if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
            TypeProjection typeProjection = CollectionsKt.singleOrNull(expressionType.getArguments());
            diagnosticFactory0 = Companion.isTypeParameterOrArrayOfTypeParameter$frontend(typeProjection != null ? typeProjection.getType() : null) ? Errors.ANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR : Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL;
        } else {
            diagnosticFactory0 = diagnosticFactory = Errors.ANNOTATION_ARGUMENT_MUST_BE_CONST;
        }
        if (useDeprecationWarning) {
            this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
        } else {
            trace.report(diagnosticFactory.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    private final void checkInnerPartsOfCompileTimeConstant(CompileTimeConstant<?> constant, BindingTrace trace, KtExpression argumentExpression, boolean useDeprecationWarning) {
        KtExpression lhsExpression;
        List<KtExpression> callArguments;
        KtExpression ktExpression = argumentExpression;
        List<KtExpression> list2 = ktExpression instanceof KtCallExpression ? this.getArgumentExpressionsForArrayCall((KtCallExpression)argumentExpression, trace) : (callArguments = ktExpression instanceof KtCollectionLiteralExpression ? this.getArgumentExpressionsForCollectionLiteralCall((KtCollectionLiteralExpression)argumentExpression, trace) : null);
        if (callArguments != null) {
            for (KtExpression argument : callArguments) {
                KotlinType type2;
                if (trace.getType(argument) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(type2, "trace.getType(argument) ?: continue");
                this.checkCompileTimeConstant(argument, type2, trace, useDeprecationWarning);
            }
        }
        if (constant.getUsesNonConstValAsConstant()) {
            if (useDeprecationWarning) {
                this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
            } else {
                trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)argumentExpression)));
            }
        }
        if (argumentExpression instanceof KtClassLiteralExpression && (lhsExpression = ((KtClassLiteralExpression)argumentExpression).getReceiverExpression()) != null) {
            DoubleColonLHS doubleColonLhs = (DoubleColonLHS)trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, lhsExpression);
            if (doubleColonLhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)doubleColonLhs).isObjectQualifier()) {
                if (useDeprecationWarning) {
                    this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
                } else {
                    trace.report(Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
                }
            } else if (doubleColonLhs instanceof DoubleColonLHS.Type && Companion.isTypeParameterOrArrayOfTypeParameter$frontend(doubleColonLhs.getType())) {
                trace.report(Errors.ANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER.on((KtExpression)((PsiElement)argumentExpression)));
            }
        }
    }

    private final void reportDeprecationWarningOnNonConst(KtExpression expression2, BindingTrace trace) {
        trace.report(Errors.ANNOTATION_ARGUMENT_IS_NON_CONST.on((KtExpression)((PsiElement)expression2)));
    }

    private final List<KtExpression> getArgumentExpressionsForArrayCall(KtCallExpression expression2, BindingTrace trace) {
        KtElement ktElement = expression2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForCollectionLiteralCall(KtCollectionLiteralExpression expression2, BindingTrace trace) {
        ResolvedCall resolvedCall2 = (ResolvedCall)trace.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, "trace[COLLECTION_LITERAL\u2026xpression] ?: return null");
        ResolvedCall resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForArrayLikeCall(ResolvedCall<?> resolvedCall2) {
        if (!CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2)) {
            return null;
        }
        boolean bl = false;
        ArrayList<KtExpression> result2 = new ArrayList<KtExpression>();
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map2, "resolvedCall.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = map2;
        boolean bl2 = false;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedValueArgument;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            boolean bl3 = false;
            ResolvedValueArgument resolvedValueArgument2 = resolvedValueArgument = entry2.getValue();
            Intrinsics.checkNotNullExpressionValue(resolvedValueArgument2, "resolvedValueArgument");
            for (ValueArgument valueArgument : resolvedValueArgument2.getArguments()) {
                KtExpression valueArgumentExpression = valueArgument.getArgumentExpression();
                if (valueArgumentExpression == null) continue;
                result2.add(valueArgumentExpression);
            }
        }
        return result2;
    }

    private final boolean hasSpread(ResolvedValueArgument argument) {
        List<ValueArgument> list2 = argument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "argument.arguments");
        List<ValueArgument> arguments2 = list2;
        return arguments2.size() == 1 && arguments2.get(0).getSpreadElement() != null;
    }

    private final List<CompileTimeConstant<?>> resolveAnnotationValueArguments(ResolvedValueArgument resolvedValueArgument, KotlinType deprecatedExpectedType, KotlinType expectedType2, BindingTrace trace) {
        ArrayList constants = new ArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            KotlinType expressionType;
            KtExpression argumentExpression;
            if (argument.getArgumentExpression() == null) {
                continue;
            }
            CompileTimeConstant<?> constant = this.evaluateExpression(argumentExpression, trace, expectedType2);
            if (constant instanceof IntegerValueTypeConstant) {
                KotlinType defaultType2 = ((IntegerValueTypeConstant)constant).getType(expectedType2);
                this.updateNumberType(defaultType2, argumentExpression, StatementFilter.NONE, trace);
            }
            if (constant != null) {
                constants.add(constant);
            }
            if (trace.getType(argumentExpression) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(expressionType, "trace.getType(argumentExpression) ?: continue");
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonConstValuesAsVarargsInAnnotations) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, deprecatedExpectedType)) {
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType2)) continue;
                this.checkCompileTimeConstant(argumentExpression, expressionType, trace, true);
                continue;
            }
            this.checkCompileTimeConstant(argumentExpression, expressionType, trace, false);
        }
        return constants;
    }

    @Nullable
    public final CompileTimeConstant<?> evaluateExpression(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @Nullable KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(trace, "trace");
        ConstantExpressionEvaluatorVisitor visitor2 = new ConstantExpressionEvaluatorVisitor(this, trace);
        CompileTimeConstant<?> compileTimeConstant = visitor2.evaluate(expression2, expectedType2);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        this.checkExperimentalityOfConstantLiteral(expression2, constant, expectedType2, trace);
        return !constant.isError() ? constant : null;
    }

    public static /* synthetic */ CompileTimeConstant evaluateExpression$default(ConstantExpressionEvaluator constantExpressionEvaluator, KtExpression ktExpression, BindingTrace bindingTrace, KotlinType kotlinType, int n, Object object) {
        if ((n & 4) != 0) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        return constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, kotlinType);
    }

    @Nullable
    public final ConstantValue<?> evaluateToConstantValue(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @NotNull KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(expectedType2, "expectedType");
        CompileTimeConstant<?> compileTimeConstant = this.evaluateExpression(expression2, trace, expectedType2);
        return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType2) : null;
    }

    private final void checkExperimentalityOfConstantLiteral(KtExpression expression2, CompileTimeConstant<?> constant, KotlinType expectedType2, BindingTrace trace) {
        KotlinType kotlinType;
        if (constant.isError()) {
            return;
        }
        if (!constant.getParameters().isUnsignedNumberLiteral() && !constant.getParameters().isUnsignedLongNumberLiteral()) {
            return;
        }
        if (constant instanceof TypedCompileTimeConstant) {
            kotlinType = ((TypedCompileTimeConstant)constant).getType();
        } else if (expectedType2 != null) {
            kotlinType = constant.toConstantValue(expectedType2).getType(this.module);
        } else {
            return;
        }
        KotlinType constantType = kotlinType;
        if (!UnsignedTypes.isUnsignedType(constantType)) {
            return;
        }
        ExperimentalUsageChecker.Companion companion = ExperimentalUsageChecker.Companion;
        boolean bl = false;
        boolean bl2 = false;
        ExperimentalUsageChecker.Companion $this$with = companion;
        boolean bl3 = false;
        ClassifierDescriptor classifierDescriptor = constantType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(classifierDescriptor, "constantType.constructor\u2026ationDescriptor ?: return");
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        Set<ExperimentalUsageChecker.Experimentality> experimentalities = $this$with.loadExperimentalities(descriptor2, this.moduleAnnotationsResolver, this.languageVersionSettings);
        $this$with.reportNotAcceptedExperimentalities((Collection<ExperimentalUsageChecker.Experimentality>)experimentalities, expression2, this.languageVersionSettings, trace, EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS);
    }

    @NotNull
    public final ModuleDescriptor getModule$frontend() {
        return this.module;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings$frontend() {
        return this.languageVersionSettings;
    }

    public ConstantExpressionEvaluator(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(project, "project");
        this.module = module2;
        this.languageVersionSettings = languageVersionSettings;
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    static {
        Companion = new Companion(null);
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, "Errors.EXPERIMENTAL_UNSIGNED_LITERALS");
        ExperimentalUsageChecker.ExperimentalityDiagnostic experimentalityDiagnostic = new Companion.ExperimentalityDiagnostic1(diagnosticFactory1, "should");
        DiagnosticFactory1<PsiElement, String> diagnosticFactory12 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory12, "Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR");
        EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS = new ExperimentalUsageChecker.ExperimentalityDiagnostics(experimentalityDiagnostic, new Companion.ExperimentalityDiagnostic1(diagnosticFactory12, "must"));
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
        return Companion.getConstant(expression2, bindingContext);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
        return Companion.getPossiblyErrorConstant(expression2, bindingContext);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0017\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion;", "", "()V", "EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "getConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getPossiblyErrorConstant", "isTypeParameterOrArrayOfTypeParameter", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isTypeParameterOrArrayOfTypeParameter$frontend", "ExperimentalityDiagnostic1", "frontend"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            CompileTimeConstant<?> compileTimeConstant = this.getPossiblyErrorConstant(expression2, bindingContext);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> constant = compileTimeConstant;
            return !constant.isError() ? constant : null;
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            return (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        }

        public final boolean isTypeParameterOrArrayOfTypeParameter$frontend(@Nullable KotlinType type2) {
            boolean bl;
            if (type2 == null) {
                bl = false;
            } else if (KotlinBuiltIns.isArray(type2)) {
                TypeProjection typeProjection = CollectionsKt.singleOrNull(type2.getArguments());
                bl = this.isTypeParameterOrArrayOfTypeParameter$frontend(typeProjection != null ? typeProjection.getType() : null);
            } else {
                bl = type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion$ExperimentalityDiagnostic1;", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lcom/intellij/psi/PsiElement;", "", "verb", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;Ljava/lang/String;)V", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "getVerb", "()Ljava/lang/String;", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "message", "frontend"})
        private static final class ExperimentalityDiagnostic1
        implements ExperimentalUsageChecker.ExperimentalityDiagnostic {
            @NotNull
            private final DiagnosticFactory1<PsiElement, String> factory;
            @NotNull
            private final String verb;

            @Override
            public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName2, @Nullable String message2) {
                Intrinsics.checkNotNullParameter(trace, "trace");
                Intrinsics.checkNotNullParameter(element, "element");
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                Function1<FqName, String> defaultMessage = ExperimentalUsageChecker.Companion.getDefaultDiagnosticMessage$frontend("Unsigned literals are experimental and their usages " + this.verb + " be marked");
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = this.factory.on(element, defaultMessage.invoke(fqName2));
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "factory.on(element, defaultMessage(fqName))");
                DiagnosticUtilsKt.reportDiagnosticOnce(trace, parametrizedDiagnostic);
            }

            @NotNull
            public final DiagnosticFactory1<PsiElement, String> getFactory() {
                return this.factory;
            }

            @NotNull
            public final String getVerb() {
                return this.verb;
            }

            public ExperimentalityDiagnostic1(@NotNull DiagnosticFactory1<PsiElement, String> factory2, @NotNull String verb) {
                Intrinsics.checkNotNullParameter(factory2, "factory");
                Intrinsics.checkNotNullParameter(verb, "verb");
                this.factory = factory2;
                this.verb = verb;
            }
        }
    }
}

