/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkJvmDefaultsInHierarchy", "", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "processMember", "inheritedFun", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "actualImplementation", "frontend.java"})
public final class JvmDefaultChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block32: {
            Object $this$flatMapTo$iv$iv232;
            JvmDefaultMode jvmDefaultMode;
            block30: {
                Object element$iv$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                Collection destination$iv$iv;
                block31: {
                    boolean bl;
                    block29: {
                        boolean $i$f$any;
                        Intrinsics.checkNotNullParameter(declaration2, "declaration");
                        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                        Intrinsics.checkNotNullParameter(context2, "context");
                        jvmDefaultMode = context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getJvmDefaultMode());
                        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME());
                        if (annotationDescriptor != null) {
                            KtElement reportOn;
                            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            AnnotationDescriptor annotationDescriptor3 = annotationDescriptor2;
                            boolean bl4 = false;
                            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor3);
                            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2;
                            if (!DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_NOT_IN_INTERFACE.on(reportOn));
                            } else if (this.jvmTarget == JvmTarget.JVM_1_6) {
                                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn, "JvmDefault"));
                            } else if (!jvmDefaultMode.isEnabled()) {
                                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)declaration2), "JvmDefault"));
                            }
                            return;
                        }
                        AnnotationDescriptor annotationDescriptor2 = descriptor2.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME());
                        if (annotationDescriptor2 != null) {
                            KtElement reportOn;
                            AnnotationDescriptor annotationDescriptor5 = annotationDescriptor2;
                            boolean bl5 = false;
                            boolean bl4 = false;
                            AnnotationDescriptor annotationDescriptor6 = annotationDescriptor5;
                            boolean bl7 = false;
                            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor6);
                            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2;
                            if (this.jvmTarget == JvmTarget.JVM_1_6) {
                                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn, "JvmDefaultWithoutCompatibility"));
                            } else if (!jvmDefaultMode.isEnabled()) {
                                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)reportOn), "JvmDefaultWithoutCompatibility"));
                            }
                            return;
                        }
                        if (descriptor2 instanceof ClassDescriptor) {
                            boolean hasDeclaredJvmDefaults;
                            block28: {
                                boolean bl5;
                                Iterable object = ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null);
                                boolean $i$f$filterIsInstance = false;
                                Iterable annotationDescriptor6 = object;
                                destination$iv$iv = new ArrayList();
                                boolean $i$f$filterIsInstanceTo = false;
                                Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                                while (iterator2.hasNext()) {
                                    element$iv$iv = iterator2.next();
                                    if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                Iterable iterable = (List)destination$iv$iv;
                                $i$f$any = false;
                                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                                    bl5 = false;
                                } else {
                                    for (Object element$iv : iterable) {
                                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                                        boolean bl9 = false;
                                        CallableMemberDescriptor.Kind kind = it.getKind();
                                        Intrinsics.checkNotNullExpressionValue((Object)kind, "it.kind");
                                        if (!(kind.isReal() && JvmAnnotationUtilKt.isCompiledToJvmDefault(it, jvmDefaultMode))) continue;
                                        bl5 = true;
                                        break block28;
                                    }
                                    bl5 = hasDeclaredJvmDefaults = false;
                                }
                            }
                            if (!hasDeclaredJvmDefaults && !this.checkJvmDefaultsInHierarchy(descriptor2, jvmDefaultMode)) {
                                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_THROUGH_INHERITANCE.on((KtDeclaration)((PsiElement)declaration2)));
                            }
                        }
                        if (!DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) break block30;
                        DeclarationDescriptor declarationDescriptor = descriptor2;
                        if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                            declarationDescriptor = null;
                        }
                        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
                        if (callableMemberDescriptor == null) {
                            return;
                        }
                        CallableMemberDescriptor memberDescriptor = callableMemberDescriptor;
                        if (descriptor2 instanceof PropertyAccessorDescriptor) {
                            return;
                        }
                        Collection<? extends CallableMemberDescriptor> collection = memberDescriptor.getOverriddenDescriptors();
                        Intrinsics.checkNotNullExpressionValue(collection, "memberDescriptor.overriddenDescriptors");
                        Iterable iterable = collection;
                        $i$f$any = false;
                        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : iterable) {
                                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                                boolean bl10 = false;
                                if (!it.getAnnotations().hasAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME())) continue;
                                bl = true;
                                break block29;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block31;
                    context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_REQUIRED_FOR_OVERRIDE.on((KtDeclaration)((PsiElement)declaration2)));
                    break block32;
                }
                if (!jvmDefaultMode.isEnabled()) break block32;
                Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, "descriptor.overriddenDescriptors");
                Iterable iterable = collection;
                boolean $i$f$flatMap = false;
                $this$filterIsInstanceTo$iv$iv = iterable;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator<Object> bl10 = $this$flatMapTo$iv$iv232.iterator();
                while (bl10.hasNext()) {
                    element$iv$iv = bl10.next();
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = OverridingUtil.getOverriddenDeclarations(it);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                Set set = CollectionsKt.toSet((List)destination$iv$iv);
                boolean bl = false;
                boolean $this$flatMapTo$iv$iv232 = false;
                Set it = set;
                boolean bl11 = false;
                for (CallableMemberDescriptor realDescriptor : OverridingUtil.filterOutOverridden(it)) {
                    if (!(realDescriptor instanceof JavaMethodDescriptor) || ((JavaMethodDescriptor)realDescriptor).getModality() == Modality.ABSTRACT) continue;
                    context2.getTrace().report(ErrorsJvm.NON_JVM_DEFAULT_OVERRIDES_JAVA_DEFAULT.on((KtDeclaration)((PsiElement)declaration2)));
                    return;
                }
                break block32;
            }
            if (jvmDefaultMode.isCompatibility() && !DescriptorUtils.isInterface(descriptor2) && !DescriptorUtils.isAnnotationClass(descriptor2) && descriptor2 instanceof ClassDescriptor && !JvmAnnotationUtilKt.hasJvmDefaultNoCompatibilityAnnotation(descriptor2)) {
                Modality modality = ((ClassDescriptor)descriptor2).getModality();
                Intrinsics.checkNotNullExpressionValue((Object)modality, "descriptor.modality");
                Modality modality2 = modality;
                if (modality2 != Modality.OPEN && modality2 != Modality.ABSTRACT || DescriptorUtilsKt.isEffectivelyPrivateApi((DeclarationDescriptorWithVisibility)descriptor2)) {
                    return;
                }
                $this$flatMapTo$iv$iv232 = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation((ClassDescriptor)descriptor2, true);
                boolean it = false;
                Iterator<Map.Entry<CallableMemberDescriptor, CallableMemberDescriptor>> iterator3 = $this$flatMapTo$iv$iv232.entrySet().iterator();
                while (iterator3.hasNext()) {
                    void inheritedMember;
                    Map.Entry<CallableMemberDescriptor, CallableMemberDescriptor> entry;
                    Map.Entry<CallableMemberDescriptor, CallableMemberDescriptor> bl11 = entry = iterator3.next();
                    boolean bl10 = false;
                    $this$flatMapTo$iv$iv232 = bl11.getKey();
                    bl11 = entry;
                    bl10 = false;
                    CallableMemberDescriptor actualImplementation = bl11.getValue();
                    if (!JvmAnnotationUtilKt.isCallableMemberCompiledToJvmDefault(actualImplementation, jvmDefaultMode)) continue;
                    if (actualImplementation instanceof FunctionDescriptor && inheritedMember instanceof FunctionDescriptor) {
                        this.processMember((FunctionDescriptor)inheritedMember, (FunctionDescriptor)actualImplementation, context2, declaration2);
                        continue;
                    }
                    if (!(actualImplementation instanceof PropertyDescriptor) || !(inheritedMember instanceof PropertyDescriptor)) continue;
                    PropertyGetterDescriptor getterImpl = ((PropertyDescriptor)actualImplementation).getGetter();
                    PropertyGetterDescriptor getterInherited = ((PropertyDescriptor)inheritedMember).getGetter();
                    if (getterImpl != null && getterInherited != null && !this.processMember(getterImpl, getterImpl, context2, declaration2) || !((PropertyDescriptor)actualImplementation).isVar() || !((PropertyDescriptor)inheritedMember).isVar()) continue;
                    PropertySetterDescriptor setterImpl = ((PropertyDescriptor)actualImplementation).getSetter();
                    PropertySetterDescriptor setterInherited = ((PropertyDescriptor)inheritedMember).getSetter();
                    if (setterImpl == null || setterInherited == null) continue;
                    this.processMember(setterImpl, setterImpl, context2, declaration2);
                }
            }
        }
    }

    private final boolean processMember(FunctionDescriptor inheritedFun, FunctionDescriptor actualImplementation, DeclarationCheckerContext context2, KtDeclaration declaration2) {
        String inheritedSignature = MethodSignatureMappingKt.computeJvmDescriptor(inheritedFun, true, false);
        FunctionDescriptor functionDescriptor = actualImplementation.getOriginal();
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "actualImplementation.original");
        FunctionDescriptor originalImplementation = functionDescriptor;
        String actualSignature = MethodSignatureMappingKt.computeJvmDescriptor(originalImplementation, true, false);
        if (Intrinsics.areEqual(inheritedSignature, actualSignature) ^ true) {
            context2.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_COMPATIBILITY_MODE.on((KtDeclaration)((PsiElement)declaration2), DescriptorUtils.getDirectMember(inheritedFun), DescriptorUtils.getDirectMember(originalImplementation)));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkJvmDefaultsInHierarchy(DeclarationDescriptor descriptor2, JvmDefaultMode jvmDefaultMode) {
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv;
        if (jvmDefaultMode.isEnabled()) {
            return true;
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return true;
        }
        Iterable $this$filterIsInstance$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null);
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$all$iv = (List)destination$iv$iv;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        object = $this$all$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)element$iv;
            boolean bl2 = false;
            CallableMemberDescriptor.Kind kind = memberDescriptor.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)kind, "memberDescriptor.kind");
            if (!kind.isReal()) {
                boolean bl3;
                Collection<? extends CallableMemberDescriptor> collection = memberDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, "memberDescriptor.overriddenDescriptors");
                Set set = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((Iterable)collection));
                Intrinsics.checkNotNullExpressionValue(set, "OverridingUtil.filterOut\u2026iddenDescriptors.toSet())");
                Iterable $this$all$iv2 = set;
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv2;
                        boolean bl4 = false;
                        CallableMemberDescriptor callableMemberDescriptor = it;
                        Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "it");
                        if (DescriptorUtils.isInterface(callableMemberDescriptor.getContainingDeclaration()) && JvmAnnotationUtilKt.isCompiledToJvmDefault(it, jvmDefaultMode)) {
                            if (it.getModality() != Modality.ABSTRACT) return false;
                        }
                        boolean bl5 = true;
                        if (bl5) continue;
                        return false;
                    }
                    bl3 = true;
                }
                if (!bl3) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public JvmDefaultChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter(jvmTarget, "jvmTarget");
        this.jvmTarget = jvmTarget;
    }
}

