/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaToKotlinClassMap {
    private static final String NUMBERED_FUNCTION_PREFIX;
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    private static final ClassId FUNCTION_N_CLASS_ID;
    @NotNull
    private static final FqName FUNCTION_N_FQ_NAME;
    private static final ClassId K_FUNCTION_CLASS_ID;
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    @NotNull
    private static final List<PlatformMutabilityMapping> mutabilityMappings;
    public static final JavaToKotlinClassMap INSTANCE;

    @NotNull
    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    @NotNull
    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    @Nullable
    public final ClassId mapJavaToKotlin(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return javaToKotlin.get(fqName2.toUnsafe());
    }

    @Nullable
    public final ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns, @Nullable Integer functionTypeArity) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassId kotlinClassId = functionTypeArity != null && Intrinsics.areEqual((Object)fqName2, (Object)FUNCTION_N_FQ_NAME) ? KotlinBuiltIns.getFunctionClassId(functionTypeArity) : this.mapJavaToKotlin(fqName2);
        return kotlinClassId != null ? builtIns.getBuiltInClassByFqName(kotlinClassId.asSingleFqName()) : null;
    }

    public static /* synthetic */ ClassDescriptor mapJavaToKotlin$default(JavaToKotlinClassMap javaToKotlinClassMap, FqName fqName2, KotlinBuiltIns kotlinBuiltIns, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return javaToKotlinClassMap.mapJavaToKotlin(fqName2, kotlinBuiltIns, n);
    }

    @Nullable
    public final ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        Intrinsics.checkNotNullParameter((Object)kotlinFqName, (String)"kotlinFqName");
        return this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_SUSPEND_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_SUSPEND_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : kotlinToJava.get(kotlinFqName))));
    }

    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe kotlinFqName, String prefix) {
        String string = kotlinFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinFqName.asString()");
        String arityString = StringsKt.substringAfter((String)string, (String)prefix, (String)"");
        CharSequence charSequence = arityString;
        boolean bl = false;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((CharSequence)arityString, (char)'0', (boolean)false, (int)2, null)) {
            Integer arity = StringsKt.toIntOrNull((String)arityString);
            return arity != null && arity >= 23;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        void readOnlyClassId;
        void javaClassId;
        PlatformMutabilityMapping platformMutabilityMapping2 = platformMutabilityMapping;
        ClassId classId = platformMutabilityMapping2.component1();
        ClassId classId2 = platformMutabilityMapping2.component2();
        ClassId mutableClassId = platformMutabilityMapping2.component3();
        this.add((ClassId)javaClassId, (ClassId)readOnlyClassId);
        FqName fqName2 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"mutableClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, (ClassId)javaClassId);
        FqName fqName3 = readOnlyClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"readOnlyClassId.asSingleFqName()");
        FqName readOnlyFqName = fqName3;
        FqName fqName4 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"mutableClassId.asSingleFqName()");
        FqName mutableFqName = fqName4;
        Map map2 = mutableToReadOnly;
        FqNameUnsafe fqNameUnsafe = mutableClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"mutableClassId.asSingleFqName().toUnsafe()");
        map2.put(fqNameUnsafe, readOnlyFqName);
        Map map3 = readOnlyToMutable;
        FqNameUnsafe fqNameUnsafe2 = readOnlyFqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe2, (String)"readOnlyFqName.toUnsafe()");
        map3.put(fqNameUnsafe2, mutableFqName);
    }

    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        FqName fqName2 = kotlinClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
    }

    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        FqName fqName2 = kotlinFqName.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinFqName.toSafe()");
        this.addTopLevel(javaClass, fqName2);
    }

    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        ClassId classId = this.classId(javaClass);
        ClassId classId2 = ClassId.topLevel(kotlinFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"ClassId.topLevel(kotlinFqName)");
        this.add(classId, classId2);
    }

    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        Map map2 = javaToKotlin;
        FqNameUnsafe fqNameUnsafe = javaClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"javaClassId.asSingleFqName().toUnsafe()");
        map2.put(fqNameUnsafe, kotlinClassId);
    }

    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        Map map2 = kotlinToJava;
        FqNameUnsafe fqNameUnsafe = kotlinFqNameUnsafe.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"kotlinFqNameUnsafe.toUnsafe()");
        map2.put(fqNameUnsafe, javaClassId);
    }

    @NotNull
    public final Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassDescriptor classDescriptor = JavaToKotlinClassMap.mapJavaToKotlin$default(this, fqName2, builtIns, null, 4, null);
        if (classDescriptor == null) {
            return SetsKt.emptySet();
        }
        ClassDescriptor kotlinAnalog = classDescriptor;
        FqName fqName3 = readOnlyToMutable.get(DescriptorUtilsKt.getFqNameUnsafe(kotlinAnalog));
        if (fqName3 == null) {
            return SetsKt.setOf((Object)kotlinAnalog);
        }
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"readOnlyToMutable[kotlin\u2026eturn setOf(kotlinAnalog)");
        FqName kotlinMutableAnalogFqName = fqName3;
        Object[] objectArray = new ClassDescriptor[2];
        objectArray[0] = kotlinAnalog;
        ClassDescriptor classDescriptor2 = builtIns.getBuiltInClassByFqName(kotlinMutableAnalogFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"builtIns.getBuiltInClass\u2026otlinMutableAnalogFqName)");
        objectArray[1] = classDescriptor2;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final boolean isMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = mutableToReadOnly;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(fqNameUnsafe);
    }

    public final boolean isMutable(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkNotNullParameter((Object)mutable, (String)"mutable");
        return this.isMutable(DescriptorUtils.getFqName(mutable));
    }

    public final boolean isMutable(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isMutable(classDescriptor);
    }

    public final boolean isReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = readOnlyToMutable;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(fqNameUnsafe);
    }

    public final boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkNotNullParameter((Object)readOnly, (String)"readOnly");
        return this.isReadOnly(DescriptorUtils.getFqName(readOnly));
    }

    public final boolean isReadOnly(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isReadOnly(classDescriptor);
    }

    @NotNull
    public final ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkNotNullParameter((Object)mutable, (String)"mutable");
        return this.convertToOppositeMutability(mutable, (Map<FqNameUnsafe, FqName>)mutableToReadOnly, "mutable");
    }

    @NotNull
    public final ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkNotNullParameter((Object)readOnly, (String)"readOnly");
        return this.convertToOppositeMutability(readOnly, (Map<FqNameUnsafe, FqName>)readOnlyToMutable, "read-only");
    }

    private final ClassId classId(Class<?> clazz) {
        ClassId classId;
        boolean bl = !clazz.isPrimitive() && !clazz.isArray();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Invalid class: " + clazz;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Class<?> outer = clazz.getDeclaringClass();
        if (outer == null) {
            ClassId classId2 = ClassId.topLevel(new FqName(clazz.getCanonicalName()));
            classId = classId2;
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"ClassId.topLevel(FqName(clazz.canonicalName))");
        } else {
            ClassId classId3 = this.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
            classId = classId3;
            Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"classId(outer).createNes\u2026tifier(clazz.simpleName))");
        }
        return classId;
    }

    private final ClassDescriptor convertToOppositeMutability(ClassDescriptor descriptor2, Map<FqNameUnsafe, FqName> map2, String mutabilityKindName) {
        FqName fqName2 = map2.get(DescriptorUtils.getFqName(descriptor2));
        if (fqName2 == null) {
            throw (Throwable)new IllegalArgumentException("Given class " + descriptor2 + " is not a " + mutabilityKindName + " collection");
        }
        FqName oppositeClassFqName = fqName2;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getBuiltIns(descriptor2).getBuiltInClassByFqName(oppositeClassFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"descriptor.builtIns.getB\u2026Name(oppositeClassFqName)");
        return classDescriptor;
    }

    private JavaToKotlinClassMap() {
    }

    static {
        int i;
        JavaToKotlinClassMap this_$iv;
        ClassId kotlinReadOnly$iv;
        JavaToKotlinClassMap javaToKotlinClassMap;
        INSTANCE = javaToKotlinClassMap = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionClassDescriptor.Kind.Function.getPackageFqName().toString() + "." + FunctionClassDescriptor.Kind.Function.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionClassDescriptor.Kind.KFunction.getPackageFqName().toString() + "." + FunctionClassDescriptor.Kind.KFunction.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionClassDescriptor.Kind.SuspendFunction.getPackageFqName().toString() + "." + FunctionClassDescriptor.Kind.SuspendFunction.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionClassDescriptor.Kind.KSuspendFunction.getPackageFqName().toString() + "." + FunctionClassDescriptor.Kind.KSuspendFunction.getClassNamePrefix();
        ClassId classId = ClassId.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"ClassId.topLevel(FqName(\u2026vm.functions.FunctionN\"))");
        FUNCTION_N_CLASS_ID = classId;
        FqName fqName2 = FUNCTION_N_CLASS_ID.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FUNCTION_N_CLASS_ID.asSingleFqName()");
        FUNCTION_N_FQ_NAME = fqName2;
        ClassId classId2 = ClassId.topLevel(new FqName("kotlin.reflect.KFunction"));
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"ClassId.topLevel(FqName(\u2026tlin.reflect.KFunction\"))");
        K_FUNCTION_CLASS_ID = classId2;
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        Object[] objectArray = new PlatformMutabilityMapping[8];
        JavaToKotlinClassMap javaToKotlinClassMap2 = javaToKotlinClassMap;
        ClassId classId3 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterable);
        Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"ClassId.topLevel(FQ_NAMES.iterable)");
        ClassId classId4 = classId3;
        Intrinsics.checkNotNullExpressionValue((Object)KotlinBuiltIns.FQ_NAMES.mutableIterable, (String)"FQ_NAMES.mutableIterable");
        JvmPrimitiveType[] kotlinMutable$iv = KotlinBuiltIns.FQ_NAMES.mutableIterable;
        int $i$f$mutabilityMapping = 0;
        FqName fqName3 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName4 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"kotlinReadOnly.packageFqName");
        ClassId mutableClassId$iv = new ClassId(fqName3, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName4), false);
        objectArray[0] = new PlatformMutabilityMapping(this_$iv.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId5 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterator);
        Intrinsics.checkNotNullExpressionValue((Object)classId5, (String)"ClassId.topLevel(FQ_NAMES.iterator)");
        kotlinReadOnly$iv = classId5;
        FqName fqName5 = KotlinBuiltIns.FQ_NAMES.mutableIterator;
        Intrinsics.checkNotNullExpressionValue((Object)fqName5, (String)"FQ_NAMES.mutableIterator");
        kotlinMutable$iv = fqName5;
        $i$f$mutabilityMapping = 0;
        FqName fqName6 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName7 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName7, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName6, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName7), false);
        objectArray[1] = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId6 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.collection);
        Intrinsics.checkNotNullExpressionValue((Object)classId6, (String)"ClassId.topLevel(FQ_NAMES.collection)");
        kotlinReadOnly$iv = classId6;
        FqName fqName8 = KotlinBuiltIns.FQ_NAMES.mutableCollection;
        Intrinsics.checkNotNullExpressionValue((Object)fqName8, (String)"FQ_NAMES.mutableCollection");
        kotlinMutable$iv = fqName8;
        $i$f$mutabilityMapping = 0;
        FqName fqName9 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName10 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName10, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName9, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName10), false);
        objectArray[2] = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId7 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.list);
        Intrinsics.checkNotNullExpressionValue((Object)classId7, (String)"ClassId.topLevel(FQ_NAMES.list)");
        kotlinReadOnly$iv = classId7;
        FqName fqName11 = KotlinBuiltIns.FQ_NAMES.mutableList;
        Intrinsics.checkNotNullExpressionValue((Object)fqName11, (String)"FQ_NAMES.mutableList");
        kotlinMutable$iv = fqName11;
        $i$f$mutabilityMapping = 0;
        FqName fqName12 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName13 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName13, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName12, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName13), false);
        objectArray[3] = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId8 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.set);
        Intrinsics.checkNotNullExpressionValue((Object)classId8, (String)"ClassId.topLevel(FQ_NAMES.set)");
        kotlinReadOnly$iv = classId8;
        FqName fqName14 = KotlinBuiltIns.FQ_NAMES.mutableSet;
        Intrinsics.checkNotNullExpressionValue((Object)fqName14, (String)"FQ_NAMES.mutableSet");
        kotlinMutable$iv = fqName14;
        $i$f$mutabilityMapping = 0;
        FqName fqName15 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName16 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName16, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName15, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName16), false);
        objectArray[4] = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId9 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.listIterator);
        Intrinsics.checkNotNullExpressionValue((Object)classId9, (String)"ClassId.topLevel(FQ_NAMES.listIterator)");
        kotlinReadOnly$iv = classId9;
        FqName fqName17 = KotlinBuiltIns.FQ_NAMES.mutableListIterator;
        Intrinsics.checkNotNullExpressionValue((Object)fqName17, (String)"FQ_NAMES.mutableListIterator");
        kotlinMutable$iv = fqName17;
        $i$f$mutabilityMapping = 0;
        FqName fqName18 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName19 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName19, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName18, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName19), false);
        objectArray[5] = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId10 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.map);
        Intrinsics.checkNotNullExpressionValue((Object)classId10, (String)"ClassId.topLevel(FQ_NAMES.map)");
        kotlinReadOnly$iv = classId10;
        FqName fqName20 = KotlinBuiltIns.FQ_NAMES.mutableMap;
        Intrinsics.checkNotNullExpressionValue((Object)fqName20, (String)"FQ_NAMES.mutableMap");
        kotlinMutable$iv = fqName20;
        $i$f$mutabilityMapping = 0;
        FqName fqName21 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName22 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName22, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName21, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName22), false);
        objectArray[6] = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId11 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.map).createNestedClassId(KotlinBuiltIns.FQ_NAMES.mapEntry.shortName());
        Intrinsics.checkNotNullExpressionValue((Object)classId11, (String)"ClassId.topLevel(FQ_NAME\u2026MES.mapEntry.shortName())");
        kotlinReadOnly$iv = classId11;
        FqName fqName23 = KotlinBuiltIns.FQ_NAMES.mutableMapEntry;
        Intrinsics.checkNotNullExpressionValue((Object)fqName23, (String)"FQ_NAMES.mutableMapEntry");
        kotlinMutable$iv = fqName23;
        $i$f$mutabilityMapping = 0;
        FqName fqName24 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName25 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName25, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName24, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName25), false);
        objectArray[7] = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf((Object[])objectArray);
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.any;
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"FQ_NAMES.any");
        javaToKotlinClassMap.addTopLevel(Object.class, fqNameUnsafe);
        FqNameUnsafe fqNameUnsafe2 = KotlinBuiltIns.FQ_NAMES.string;
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe2, (String)"FQ_NAMES.string");
        javaToKotlinClassMap.addTopLevel(String.class, fqNameUnsafe2);
        FqNameUnsafe fqNameUnsafe3 = KotlinBuiltIns.FQ_NAMES.charSequence;
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe3, (String)"FQ_NAMES.charSequence");
        javaToKotlinClassMap.addTopLevel(CharSequence.class, fqNameUnsafe3);
        FqName fqName26 = KotlinBuiltIns.FQ_NAMES.throwable;
        Intrinsics.checkNotNullExpressionValue((Object)fqName26, (String)"FQ_NAMES.throwable");
        javaToKotlinClassMap.addTopLevel(Throwable.class, fqName26);
        FqNameUnsafe fqNameUnsafe4 = KotlinBuiltIns.FQ_NAMES.cloneable;
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe4, (String)"FQ_NAMES.cloneable");
        javaToKotlinClassMap.addTopLevel(Cloneable.class, fqNameUnsafe4);
        FqNameUnsafe fqNameUnsafe5 = KotlinBuiltIns.FQ_NAMES.number;
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe5, (String)"FQ_NAMES.number");
        javaToKotlinClassMap.addTopLevel(Number.class, fqNameUnsafe5);
        FqName fqName27 = KotlinBuiltIns.FQ_NAMES.comparable;
        Intrinsics.checkNotNullExpressionValue((Object)fqName27, (String)"FQ_NAMES.comparable");
        javaToKotlinClassMap.addTopLevel(Comparable.class, fqName27);
        FqNameUnsafe fqNameUnsafe6 = KotlinBuiltIns.FQ_NAMES._enum;
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe6, (String)"FQ_NAMES._enum");
        javaToKotlinClassMap.addTopLevel(Enum.class, fqNameUnsafe6);
        FqName fqName28 = KotlinBuiltIns.FQ_NAMES.annotation;
        Intrinsics.checkNotNullExpressionValue((Object)fqName28, (String)"FQ_NAMES.annotation");
        javaToKotlinClassMap.addTopLevel(Annotation.class, fqName28);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            javaToKotlinClassMap.addMapping(platformCollection);
        }
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            ClassId classId12 = ClassId.topLevel(jvmType.getWrapperFqName());
            Intrinsics.checkNotNullExpressionValue((Object)classId12, (String)"ClassId.topLevel(jvmType.wrapperFqName)");
            ClassId classId13 = ClassId.topLevel(KotlinBuiltIns.getPrimitiveFqName(jvmType.getPrimitiveType()));
            Intrinsics.checkNotNullExpressionValue((Object)classId13, (String)"ClassId.topLevel(KotlinB\u2026e(jvmType.primitiveType))");
            javaToKotlinClassMap.add(classId12, classId13);
        }
        for (ClassId classId14 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            ClassId classId15 = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId14.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkNotNullExpressionValue((Object)classId15, (String)"ClassId.topLevel(FqName(\u2026g() + \"CompanionObject\"))");
            ClassId classId16 = classId14.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkNotNullExpressionValue((Object)classId16, (String)"classId.createNestedClas\u2026AME_FOR_COMPANION_OBJECT)");
            javaToKotlinClassMap.add(classId15, classId16);
        }
        int classId14 = 0;
        int n = 23;
        while (classId14 < n) {
            ClassId classId17 = ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + i));
            Intrinsics.checkNotNullExpressionValue((Object)classId17, (String)"ClassId.topLevel(FqName(\u2026m.functions.Function$i\"))");
            ClassId classId18 = KotlinBuiltIns.getFunctionClassId(i);
            Intrinsics.checkNotNullExpressionValue((Object)classId18, (String)"KotlinBuiltIns.getFunctionClassId(i)");
            javaToKotlinClassMap.add(classId17, classId18);
            javaToKotlinClassMap.addKotlinToJava(new FqName(NUMBERED_K_FUNCTION_PREFIX + i), K_FUNCTION_CLASS_ID);
            ++i;
        }
        n = 22;
        for (i = 0; i < n; ++i) {
            FunctionClassDescriptor.Kind kSuspendFunction = FunctionClassDescriptor.Kind.KSuspendFunction;
            String kSuspendFun = kSuspendFunction.getPackageFqName().toString() + "." + kSuspendFunction.getClassNamePrefix();
            javaToKotlinClassMap.addKotlinToJava(new FqName(kSuspendFun + i), K_FUNCTION_CLASS_ID);
        }
        FqName fqName29 = KotlinBuiltIns.FQ_NAMES.nothing.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName29, (String)"FQ_NAMES.nothing.toSafe()");
        javaToKotlinClassMap.addKotlinToJava(fqName29, javaToKotlinClassMap.classId(Void.class));
    }

    public static final class PlatformMutabilityMapping {
        @NotNull
        private final ClassId javaClass;
        @NotNull
        private final ClassId kotlinReadOnly;
        @NotNull
        private final ClassId kotlinMutable;

        @NotNull
        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        public PlatformMutabilityMapping(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinReadOnly, (String)"kotlinReadOnly");
            Intrinsics.checkNotNullParameter((Object)kotlinMutable, (String)"kotlinMutable");
            this.javaClass = javaClass;
            this.kotlinReadOnly = kotlinReadOnly;
            this.kotlinMutable = kotlinMutable;
        }

        @NotNull
        public final ClassId component1() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId component3() {
            return this.kotlinMutable;
        }

        @NotNull
        public String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ")";
        }

        public int hashCode() {
            ClassId classId = this.javaClass;
            ClassId classId2 = this.kotlinReadOnly;
            ClassId classId3 = this.kotlinMutable;
            return ((classId != null ? ((Object)classId).hashCode() : 0) * 31 + (classId2 != null ? ((Object)classId2).hashCode() : 0)) * 31 + (classId3 != null ? ((Object)classId3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PlatformMutabilityMapping)) break block3;
                    PlatformMutabilityMapping platformMutabilityMapping = (PlatformMutabilityMapping)object;
                    if (!Intrinsics.areEqual((Object)this.javaClass, (Object)platformMutabilityMapping.javaClass) || !Intrinsics.areEqual((Object)this.kotlinReadOnly, (Object)platformMutabilityMapping.kotlinReadOnly) || !Intrinsics.areEqual((Object)this.kotlinMutable, (Object)platformMutabilityMapping.kotlinMutable)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

