/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.wasm.ast.WasmBlock;
import org.jetbrains.kotlin.backend.wasm.ast.WasmCall;
import org.jetbrains.kotlin.backend.wasm.ast.WasmDrop;
import org.jetbrains.kotlin.backend.wasm.ast.WasmElse;
import org.jetbrains.kotlin.backend.wasm.ast.WasmF32Const;
import org.jetbrains.kotlin.backend.wasm.ast.WasmF64Const;
import org.jetbrains.kotlin.backend.wasm.ast.WasmGetGlobal;
import org.jetbrains.kotlin.backend.wasm.ast.WasmGetLocal;
import org.jetbrains.kotlin.backend.wasm.ast.WasmI32Const;
import org.jetbrains.kotlin.backend.wasm.ast.WasmI64Const;
import org.jetbrains.kotlin.backend.wasm.ast.WasmIf;
import org.jetbrains.kotlin.backend.wasm.ast.WasmInstruction;
import org.jetbrains.kotlin.backend.wasm.ast.WasmNop;
import org.jetbrains.kotlin.backend.wasm.ast.WasmReturn;
import org.jetbrains.kotlin.backend.wasm.ast.WasmSetGlobal;
import org.jetbrains.kotlin.backend.wasm.ast.WasmSetLocal;
import org.jetbrains.kotlin.backend.wasm.ast.WasmSimpleInstruction;
import org.jetbrains.kotlin.backend.wasm.ast.WasmThen;
import org.jetbrains.kotlin.backend.wasm.codegen.BaseTransformer;
import org.jetbrains.kotlin.backend.wasm.codegen.ExpressionTransformerKt;
import org.jetbrains.kotlin.backend.wasm.codegen.WasmCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J$\u0010\u000f\u001a\u00020\u0002\"\u0004\b\u0000\u0010\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020 2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020*2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020,2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020.2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u00020\u00022\u0006\u0010\r\u001a\u0002002\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00101\u001a\u00020\u00022\u0006\u0010\r\u001a\u0002022\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u0010\r\u001a\u0002042\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00105\u001a\u00020\u00022\u0006\u0010\r\u001a\u0002062\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00107\u001a\u00020\u00022\u0006\u0010\r\u001a\u0002082\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020:2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010;\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020<2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010@\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020A2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010B\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020C2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010D\u001a\u00020\u00022\u0006\u0010E\u001a\u00020F2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010G\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020H2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010I\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020J2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/codegen/ExpressionTransformer;", "Lorg/jetbrains/kotlin/backend/wasm/codegen/BaseTransformer;", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmInstruction;", "Lorg/jetbrains/kotlin/backend/wasm/codegen/WasmCodegenContext;", "()V", "visitBlockBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "data", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConst", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitDynamicMemberExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "visitDynamicOperatorExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitExpressionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitSyntheticBody", "Lorg/jetbrains/kotlin/ir/expressions/IrSyntheticBody;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "visitVariable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "backend.wasm"})
public final class ExpressionTransformer
implements BaseTransformer<WasmInstruction, WasmCodegenContext> {
    @Override
    @NotNull
    public WasmInstruction visitVararg(@NotNull IrVararg expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "Support arrays";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(data, "data");
        return (WasmInstruction)body2.getExpression().accept(this, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "?";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public <T> WasmInstruction visitConst(@NotNull IrConst<T> expression2, @NotNull WasmCodegenContext data) {
        WasmInstruction wasmInstruction;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        IrConstKind<T> kind = expression2.getKind();
        if (kind instanceof IrConstKind.Null) {
            boolean bl = false;
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        if (kind instanceof IrConstKind.String) {
            String value2 = (String)((IrConstKind.String)kind).valueOf(expression2);
            int index2 = data.getStringLiterals().size();
            data.getStringLiterals().add(value2);
            String funName = data.getGlobalName((IrDeclarationWithName)data.getBackendContext().getWasmSymbols().getStringGetLiteral().getOwner());
            WasmI32Const operand = new WasmI32Const(index2);
            wasmInstruction = new WasmCall(funName, CollectionsKt.listOf(operand));
        } else if (kind instanceof IrConstKind.Boolean) {
            wasmInstruction = new WasmI32Const((Boolean)((IrConstKind.Boolean)kind).valueOf(expression2) != false ? 1 : 0);
        } else if (kind instanceof IrConstKind.Byte) {
            wasmInstruction = new WasmI32Const(((Number)((IrConstKind.Byte)kind).valueOf(expression2)).byteValue());
        } else if (kind instanceof IrConstKind.Short) {
            wasmInstruction = new WasmI32Const(((Number)((IrConstKind.Short)kind).valueOf(expression2)).shortValue());
        } else if (kind instanceof IrConstKind.Int) {
            wasmInstruction = new WasmI32Const(((Number)((IrConstKind.Int)kind).valueOf(expression2)).intValue());
        } else if (kind instanceof IrConstKind.Long) {
            wasmInstruction = new WasmI64Const(((Number)((IrConstKind.Long)kind).valueOf(expression2)).longValue());
        } else if (kind instanceof IrConstKind.Char) {
            wasmInstruction = new WasmI32Const(((Character)((IrConstKind.Char)kind).valueOf(expression2)).charValue());
        } else if (kind instanceof IrConstKind.Float) {
            wasmInstruction = new WasmF32Const(((Number)((IrConstKind.Float)kind).valueOf(expression2)).floatValue());
        } else if (kind instanceof IrConstKind.Double) {
            wasmInstruction = new WasmF64Const(((Number)((IrConstKind.Double)kind).valueOf(expression2)).doubleValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return wasmInstruction;
    }

    @Override
    @NotNull
    public WasmInstruction visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "Implement kotlin.String";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitGetField(@NotNull IrGetField expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String fieldName = data.getGlobalName((IrDeclarationWithName)expression2.getSymbol().getOwner());
        if (expression2.getReceiver() != null) {
            String string2 = "Support member fields";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return new WasmGetGlobal(fieldName);
    }

    @Override
    @NotNull
    public WasmInstruction visitGetValue(@NotNull IrGetValue expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return new WasmGetLocal(data.getLocalName(expression2.getSymbol().getOwner()));
    }

    @Override
    @NotNull
    public WasmInstruction visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrGetObjectValue";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitSetField(@NotNull IrSetField expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String fieldName = data.getGlobalName((IrDeclarationWithName)expression2.getSymbol().getOwner());
        if (expression2.getReceiver() != null) {
            String string2 = "Support member fields";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        WasmInstruction value2 = (WasmInstruction)expression2.getValue().accept(this, data);
        return new WasmSetGlobal(fieldName, value2);
    }

    @Override
    @NotNull
    public WasmInstruction visitSetValue(@NotNull IrSetValue expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String fieldName = data.getLocalName(expression2.getSymbol().getOwner());
        WasmInstruction value2 = (WasmInstruction)expression2.getValue().accept(this, data);
        return new WasmSetLocal(fieldName, value2);
    }

    @Override
    @NotNull
    public WasmInstruction visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrConstructorCall";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WasmInstruction visitCall(@NotNull IrCall expression2, @NotNull WasmCodegenContext data) {
        void $this$mapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        IrSimpleFunction function2 = IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)expression2.getSymbol().getOwner());
        Iterable $this$mapNotNull$iv = RangesKt.until(0, expression2.getValueArgumentsCount());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrExpression irExpression;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            if (expression2.getValueArgument(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            IrExpression it$iv$iv = irExpression;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List valueArgs = (List)destination$iv$iv;
        List irArguments = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(expression2.getDispatchReceiver(), expression2.getExtensionReceiver()), (Iterable)valueArgs);
        Iterable $this$map$iv = irArguments;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrExpression element$iv$iv = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            WasmInstruction wasmInstruction = ExpressionTransformerKt.expressionToWasmInstruction((IrExpression)it, data);
            collection.add(wasmInstruction);
        }
        List wasmArguments = (List)destination$iv$iv2;
        String wasmInstruction = AnnotationsKt.getWasmInstructionAnnotation(function2);
        if (wasmInstruction != null) {
            if (Intrinsics.areEqual(wasmInstruction, "nop")) {
                return (WasmInstruction)CollectionsKt.single(wasmArguments);
            }
            return new WasmSimpleInstruction(wasmInstruction, wasmArguments);
        }
        String name = data.getGlobalName(function2);
        return new WasmCall(name, wasmArguments);
    }

    @Override
    @NotNull
    public WasmInstruction visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        WasmInstruction wasmArgument = ExpressionTransformerKt.expressionToWasmInstruction(expression2.getArgument(), data);
        if (expression2.getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT) {
            return wasmArgument;
        }
        String string2 = "IrTypeOperatorCall:\n " + DumpIrTreeKt.dump$default(expression2, false, 1, null);
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrGetEnumValue";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitBlockBody(@NotNull IrBlockBody body2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(data, "data");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WasmInstruction visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull WasmCodegenContext data) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        Iterable $this$map$iv = expression2.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            WasmInstruction wasmInstruction = (WasmInstruction)it.accept(this, data);
            collection.add(wasmInstruction);
        }
        List expressions = (List)destination$iv$iv;
        if (!IrTypePredicatesKt.isUnit(expression2.getType())) {
            return new WasmBlock(CollectionsKt.plus((Collection)expressions, (Iterable)CollectionsKt.listOf(new WasmDrop(CollectionsKt.emptyList()))));
        }
        return new WasmBlock(expressions);
    }

    @Override
    @NotNull
    public WasmInstruction visitExpression(@NotNull IrExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return ExpressionTransformerKt.expressionToWasmInstruction(expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitBreak(@NotNull IrBreak jump, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        Intrinsics.checkNotNullParameter(data, "data");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public WasmInstruction visitContinue(@NotNull IrContinue jump, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        Intrinsics.checkNotNullParameter(data, "data");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public WasmInstruction visitReturn(@NotNull IrReturn expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        if (IrTypePredicatesKt.isUnit(expression2.getValue().getType())) {
            return new WasmReturn(CollectionsKt.emptyList());
        }
        return new WasmReturn(CollectionsKt.listOf(ExpressionTransformerKt.expressionToWasmInstruction(expression2.getValue(), data)));
    }

    @Override
    @NotNull
    public WasmInstruction visitThrow(@NotNull IrThrow expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrThrow";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitVariable(@NotNull IrVariable declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        IrExpression irExpression = declaration2.getInitializer();
        if (irExpression == null) {
            return new WasmNop();
        }
        IrExpression init2 = irExpression;
        String varName = data.getLocalName(declaration2);
        return new WasmSetLocal(varName, ExpressionTransformerKt.expressionToWasmInstruction(init2, data));
    }

    @Override
    @NotNull
    public WasmInstruction visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrDelegatingConstructorCall";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrInstanceInitializerCall";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitTry(@NotNull IrTry aTry, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(aTry, "aTry");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrTry";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WasmInstruction visitWhen(@NotNull IrWhen expression2, @NotNull WasmCodegenContext data) {
        void $this$foldRight$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        List<IrBranch> list2 = expression2.getBranches();
        WasmInstruction initial$iv = null;
        boolean $i$f$foldRight = false;
        WasmInstruction accumulator$iv = initial$iv;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                WasmInstruction wasmInstruction;
                WasmInstruction wasmInstruction2 = accumulator$iv;
                IrBranch br = (IrBranch)iterator$iv.previous();
                boolean bl = false;
                WasmInstruction body2 = ExpressionTransformerKt.expressionToWasmInstruction(br.getResult(), data);
                if (IrUtilsKt.isElseBranch(br)) {
                    wasmInstruction = body2;
                } else {
                    WasmElse wasmElse;
                    void inst;
                    WasmInstruction condition;
                    WasmInstruction wasmInstruction3 = condition = ExpressionTransformerKt.expressionToWasmInstruction(br.getCondition(), data);
                    WasmThen wasmThen = new WasmThen(body2);
                    if (inst != null) {
                        void var13_13;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        void var16_16 = var13_13;
                        WasmThen wasmThen2 = wasmThen;
                        WasmInstruction wasmInstruction4 = wasmInstruction3;
                        boolean bl4 = false;
                        WasmElse wasmElse2 = new WasmElse((WasmInstruction)inst);
                        wasmInstruction3 = wasmInstruction4;
                        wasmThen = wasmThen2;
                        wasmElse = wasmElse2;
                    } else {
                        wasmElse = null;
                    }
                    WasmElse wasmElse3 = wasmElse;
                    WasmThen wasmThen3 = wasmThen;
                    WasmInstruction wasmInstruction5 = wasmInstruction3;
                    wasmInstruction = new WasmIf(wasmInstruction5, wasmThen3, wasmElse3);
                }
                accumulator$iv = wasmInstruction;
            }
        }
        WasmInstruction wasmInstruction = accumulator$iv;
        Intrinsics.checkNotNull(wasmInstruction);
        return wasmInstruction;
    }

    @Override
    @NotNull
    public WasmInstruction visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(loop2, "loop");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrWhileLoop";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(loop2, "loop");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrDoWhileLoop";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "IrSyntheticBody";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public WasmInstruction visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "Dynamic operators are not supported for WASM target";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @Override
    @NotNull
    public WasmInstruction visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        String string2 = "Dynamic operators are not supported for WASM target";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @Override
    @NotNull
    public WasmInstruction visitElement(@NotNull IrElement element, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitBlock(@NotNull IrBlock expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitBody(@NotNull IrBody body2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitBranch(@NotNull IrBranch branch, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(branch, "branch");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitCatch(@NotNull IrCatch aCatch, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(aCatch, "aCatch");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitClass(@NotNull IrClass declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitClassReference(@NotNull IrClassReference expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitComposite(@NotNull IrComposite expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitConstructor(@NotNull IrConstructor declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitDeclaration(@NotNull IrDeclarationBase declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitElseBranch(@NotNull IrElseBranch branch, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(branch, "branch");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitField(@NotNull IrField declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitFile(@NotNull IrFile declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitFunction(@NotNull IrFunction declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitGetClass(@NotNull IrGetClass expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitLoop(@NotNull IrLoop loop2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(loop2, "loop");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitProperty(@NotNull IrProperty declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitScript(@NotNull IrScript declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitScript(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(spread, "spread");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public WasmInstruction visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull WasmCodegenContext data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        return BaseTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
    }
}

