/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/BuilderFunctionsCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class BuilderFunctionsCallChecker
implements CallChecker {
    @NotNull
    public static final BuilderFunctionsCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context2, "context");
            Object obj = resolvedCall2.getCandidateDescriptor();
            if (!(obj instanceof FunctionDescriptor)) {
                obj = null;
            }
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)obj;
            if (functionDescriptor == null) {
                return;
            }
            FunctionDescriptor descriptor2 = functionDescriptor;
            List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "descriptor.valueParameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    ValueParameterDescriptor valueParameterDescriptor = it;
                    Intrinsics.checkNotNullExpressionValue(valueParameterDescriptor, "it");
                    if (!CoroutineUtilKt.getHasSuspendFunctionType(valueParameterDescriptor)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            CoroutineCallCheckerKt.checkCoroutinesFeature(context2.getLanguageVersionSettings(), context2.getTrace(), reportOn);
        }
    }

    private BuilderFunctionsCallChecker() {
    }

    static {
        BuilderFunctionsCallChecker builderFunctionsCallChecker;
        INSTANCE = builderFunctionsCallChecker = new BuilderFunctionsCallChecker();
    }
}

