/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/FunInterfaceDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSingleAbstractMember", "abstractMember", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "funInterfaceKeyword", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class FunInterfaceDeclarationChecker
implements DeclarationChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        void $this$filterIsInstanceTo$iv$iv;
        Object reportOn;
        CallableMemberDescriptor abstractMember2;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(declaration2 instanceof KtClass)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isFun()) {
            return;
        }
        PsiElement psiElement = ((KtClass)declaration2).getFunKeyword();
        if (psiElement == null) {
            return;
        }
        PsiElement funKeyword = psiElement;
        List<CallableMemberDescriptor> abstractMembers = SamConversionResolverImplKt.getAbstractMembers((ClassDescriptor)descriptor2);
        for (CallableMemberDescriptor abstractMember2 : abstractMembers) {
            PsiElement psiElement2;
            if (!(abstractMember2 instanceof PropertyDescriptor)) continue;
            boolean reportOnProperty = Intrinsics.areEqual(((PropertyDescriptor)abstractMember2).getContainingDeclaration(), descriptor2);
            if (reportOnProperty) {
                SourceElement sourceElement = ((PropertyDescriptor)abstractMember2).getSource();
                Intrinsics.checkNotNullExpressionValue(sourceElement, "abstractMember.source");
                PsiElement psiElement3 = KotlinSourceElementKt.getPsi(sourceElement);
                if (!(psiElement3 instanceof KtProperty)) {
                    psiElement3 = null;
                }
                if ((psiElement2 = (KtProperty)psiElement3) == null || (psiElement2 = ((KtProperty)psiElement2).getValOrVarKeyword()) == null) {
                    psiElement2 = funKeyword;
                }
            } else {
                psiElement2 = funKeyword;
            }
            Intrinsics.checkNotNullExpressionValue(psiElement2, "if (reportOnProperty) {\n\u2026 funKeyword\n            }");
            reportOn = psiElement2;
            context2.getTrace().report(Errors.FUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES.on((PsiElement)reportOn));
            if (reportOnProperty) continue;
            return;
        }
        Iterable $this$filterIsInstance$iv = abstractMembers;
        boolean $i$f$filterIsInstance = false;
        reportOn = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        abstractMember2 = (FunctionDescriptor)CollectionsKt.singleOrNull((List)destination$iv$iv);
        if (abstractMember2 == null) {
            context2.getTrace().report(Errors.FUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS.on(funKeyword));
            return;
        }
        this.checkSingleAbstractMember((FunctionDescriptor)abstractMember2, funKeyword, context2);
    }

    private final void checkSingleAbstractMember(FunctionDescriptor abstractMember, PsiElement funInterfaceKeyword, DeclarationCheckerContext context2) {
        SourceElement sourceElement = abstractMember.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "abstractMember.source");
        PsiElement psiElement = KotlinSourceElementKt.getPsi(sourceElement);
        if (!(psiElement instanceof KtNamedFunction)) {
            psiElement = null;
        }
        KtNamedFunction ktFunction = (KtNamedFunction)psiElement;
        if (abstractMember.isSuspend()) {
            PsiElement psiElement2 = ktFunction;
            if (psiElement2 == null || (psiElement2 = ((KtModifierListOwnerStub)psiElement2).getModifierList()) == null || (psiElement2 = ((KtModifierList)psiElement2).getModifier(KtTokens.SUSPEND_KEYWORD)) == null) {
                psiElement2 = funInterfaceKeyword;
            }
            Intrinsics.checkNotNullExpressionValue(psiElement2, "ktFunction?.modifierList\u2026D) ?: funInterfaceKeyword");
            PsiElement reportOn = psiElement2;
            context2.getTrace().report(Errors.FUN_INTERFACE_WITH_SUSPEND_FUNCTION.on(reportOn));
            return;
        }
        List<TypeParameterDescriptor> list2 = abstractMember.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "abstractMember.typeParameters");
        Object reportOn = list2;
        boolean bl = false;
        if (!reportOn.isEmpty()) {
            PsiElement psiElement3;
            PsiElement psiElement4;
            KtElementImplStub ktElementImplStub = ktFunction;
            if (ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getTypeParameterList()) != null) {
                psiElement4 = ktElementImplStub;
            } else {
                KtNamedFunction ktNamedFunction = ktFunction;
                psiElement4 = psiElement3 = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
            }
            if (psiElement4 == null) {
                psiElement3 = funInterfaceKeyword;
            }
            Intrinsics.checkNotNullExpressionValue(psiElement3, "ktFunction?.typeParamete\u2026rd ?: funInterfaceKeyword");
            reportOn = psiElement3;
            context2.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS.on((PsiElement)reportOn));
            return;
        }
        Iterator<ValueParameterDescriptor> iterator2 = abstractMember.getValueParameters().iterator();
        while (iterator2.hasNext()) {
            PsiElement psiElement5;
            ValueParameterDescriptor parameter;
            ValueParameterDescriptor valueParameterDescriptor = parameter = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(valueParameterDescriptor, "parameter");
            if (!ArgumentsUtilsKt.hasDefaultValue(valueParameterDescriptor)) continue;
            SourceElement sourceElement2 = parameter.getSource();
            Intrinsics.checkNotNullExpressionValue(sourceElement2, "parameter.source");
            PsiElement psiElement6 = KotlinSourceElementKt.getPsi(sourceElement2);
            if (psiElement6 == null) {
                KtNamedFunction ktNamedFunction = ktFunction;
                psiElement6 = psiElement5 = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
            }
            if (psiElement6 == null) {
                psiElement5 = funInterfaceKeyword;
            }
            PsiElement reportOn2 = psiElement5;
            context2.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE.on(reportOn2));
            return;
        }
    }
}

