/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.builder.FirResolvedImportBuilder;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageOrClass;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ/\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001cH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "isAcceptable", "", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformImport", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "import", "transformImportForFqName", "fqName", "delegate", "resolve"})
public class FirImportResolveTransformer
extends FirAbstractTreeTransformer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;

    protected FirImportResolveTransformer(@NotNull FirSession session2, @NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter((Object)phase, "phase");
        super(phase);
        this.session = session2;
        this.symbolProvider = MainSessionComponentsKt.getFirSymbolProvider(this.session);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, "element");
        E $this$compose$iv = element;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    public FirImportResolveTransformer(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this(session2, FirResolvePhase.IMPORTS);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirFile> transformFile(@NotNull FirFile file2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.checkSessionConsistency(file2);
        file2.replaceResolvePhase(this.getTransformerPhase());
        FirFile firFile = file2;
        boolean bl = false;
        boolean bl2 = false;
        FirFile it = firFile;
        boolean bl3 = false;
        it.transformChildren(this, null);
        FirElement $this$compose$iv = firFile;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirImport> transformImport(@NotNull FirImport firImport, @Nullable Void data) {
        FqName fqName2;
        FqName fqName3;
        Intrinsics.checkNotNullParameter(firImport, "import");
        FqName fqName4 = firImport.getImportedFqName();
        if (fqName4 == null) {
            fqName3 = null;
        } else {
            FqName fqName5 = fqName4;
            boolean bl = false;
            boolean bl2 = false;
            FqName it = fqName5;
            boolean bl3 = false;
            fqName3 = fqName2 = !it.isRoot() ? fqName5 : null;
        }
        if (fqName2 == null) {
            FirElement $this$compose$iv = firImport;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        FqName fqName6 = fqName2;
        if (!this.isAcceptable(fqName6)) {
            FirElement $this$compose$iv = firImport;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        if (firImport.isAllUnder()) {
            return this.transformImportForFqName(fqName6, firImport);
        }
        fqName4 = fqName6.parent();
        Intrinsics.checkNotNullExpressionValue(fqName4, "fqName.parent()");
        FqName parentFqName = fqName4;
        return this.transformImportForFqName(parentFqName, firImport);
    }

    protected boolean isAcceptable(@NotNull FqName $this$isAcceptable) {
        Intrinsics.checkNotNullParameter($this$isAcceptable, "<this>");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final CompositeTransformResult<FirImport> transformImportForFqName(FqName fqName2, FirImport delegate) {
        void $this$compose$iv;
        PackageOrClass packageOrClass = FirImportResolveTransformerKt.resolveToPackageOrClass(this.symbolProvider, fqName2);
        if (packageOrClass == null) {
            FirElement $this$compose$iv2 = delegate;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv2);
        }
        PackageOrClass packageOrClass2 = packageOrClass;
        FqName packageFqName = packageOrClass2.component1();
        FqName relativeClassFqName = packageOrClass2.component2();
        boolean $i$f$buildResolvedImport22 = false;
        boolean bl = false;
        FirResolvedImportBuilder firResolvedImportBuilder = new FirResolvedImportBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirResolvedImportBuilder $this$transformImportForFqName_u24lambda_u2d2 = firResolvedImportBuilder;
        boolean bl4 = false;
        $this$transformImportForFqName_u24lambda_u2d2.setDelegate(delegate);
        $this$transformImportForFqName_u24lambda_u2d2.setPackageFqName(packageFqName);
        $this$transformImportForFqName_u24lambda_u2d2.setRelativeClassName(relativeClassFqName);
        FirElement $i$f$buildResolvedImport22 = firResolvedImportBuilder.build();
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }
}

