/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.impl.KotlinLibraryImplKt;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JF\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\f\u001a\u00020\u00072#\u0010\u0013\u001a\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0006\u0012\u0004\u0018\u0001H\u00110\u0014H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/library/ToolingSingleFileKlibResolveStrategy;", "Lorg/jetbrains/kotlin/library/SingleFileKlibResolveStrategy;", "()V", "NONEXISTENT_COMPONENT_NAME", "", "looksLikeKlibComponent", "", "Lorg/jetbrains/kotlin/konan/file/File;", "getLooksLikeKlibComponent", "(Lorg/jetbrains/kotlin/konan/file/File;)Z", "fakeLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "libraryFile", "resolve", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "withSafeAccess", "T", "", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "localRoot", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-util-klib"})
public final class ToolingSingleFileKlibResolveStrategy
implements SingleFileKlibResolveStrategy {
    @NotNull
    public static final ToolingSingleFileKlibResolveStrategy INSTANCE = new ToolingSingleFileKlibResolveStrategy();

    private ToolingSingleFileKlibResolveStrategy() {
    }

    @Override
    @NotNull
    public KotlinLibrary resolve(@NotNull File libraryFile, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(libraryFile, "libraryFile");
        Intrinsics.checkNotNullParameter(logger, "logger");
        KotlinLibrary kotlinLibrary = (KotlinLibrary)this.withSafeAccess(libraryFile, (Function1)new Function1<File, KotlinLibrary>(this, libraryFile, logger){
            final /* synthetic */ ToolingSingleFileKlibResolveStrategy this$0;
            final /* synthetic */ File $libraryFile;
            final /* synthetic */ Logger $logger;
            {
                this.this$0 = $receiver;
                this.$libraryFile = $libraryFile;
                this.$logger = $logger;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final KotlinLibrary invoke(@NotNull File localRoot) {
                KotlinLibrary kotlinLibrary;
                Intrinsics.checkNotNullParameter(localRoot, "localRoot");
                if (ToolingSingleFileKlibResolveStrategy.access$getLooksLikeKlibComponent(this.this$0, localRoot)) {
                    kotlinLibrary = null;
                } else {
                    File it;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = localRoot.getListFiles();
                    Object object = this.this$0;
                    boolean $i$f$filter = false;
                    void var6_6 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (File)element$iv$iv;
                        boolean bl = false;
                        if (!ToolingSingleFileKlibResolveStrategy.access$getLooksLikeKlibComponent((ToolingSingleFileKlibResolveStrategy)object, it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List components2 = (List)destination$iv$iv;
                    int n = components2.size();
                    switch (n) {
                        case 0: {
                            kotlinLibrary = null;
                            break;
                        }
                        case 1: {
                            kotlinLibrary = KotlinLibraryImplKt.createKotlinLibrary$default(this.$libraryFile, ((File)CollectionsKt.single(components2)).getName(), false, false, 12, null);
                            break;
                        }
                        default: {
                            Collection<String> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            object = components2;
                            StringBuilder stringBuilder2 = new StringBuilder().append("Library ").append(this.$libraryFile).append(" can not be read. Multiple components found: ");
                            Logger logger = this.$logger;
                            boolean $i$f$map = false;
                            $this$filterTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                it = (File)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl = false;
                                String string2 = StringsKt.substringAfter$default(it.getPath(), localRoot.getPath(), null, 2, null);
                                collection.add(string2);
                            }
                            collection = (List)destination$iv$iv;
                            logger.warning(stringBuilder2.append(collection).toString());
                            kotlinLibrary = null;
                        }
                    }
                }
                return kotlinLibrary;
            }
        });
        return kotlinLibrary == null ? this.fakeLibrary(libraryFile) : kotlinLibrary;
    }

    private final KotlinLibrary fakeLibrary(File libraryFile) {
        return KotlinLibraryImplKt.createKotlinLibrary$default(libraryFile, "__nonexistent_component_name__", false, false, 12, null);
    }

    private final <T> T withSafeAccess(File libraryFile, Function1<? super File, ? extends T> action) {
        Object r;
        Function0 function0;
        String extension = libraryFile.getExtension();
        if (libraryFile.isDirectory()) {
            function0 = new Function0<T>(action, libraryFile){
                final /* synthetic */ Function1<File, T> $action;
                final /* synthetic */ File $libraryFile;
                {
                    this.$action = $action;
                    this.$libraryFile = $libraryFile;
                    super(0);
                }

                @Nullable
                public final T invoke() {
                    return this.$action.invoke(this.$libraryFile);
                }
            };
        } else if (libraryFile.isFile() && Intrinsics.areEqual(extension, "klib")) {
            function0 = new Function0<T>(libraryFile, action){
                final /* synthetic */ File $libraryFile;
                final /* synthetic */ Function1<File, T> $action;
                {
                    this.$libraryFile = $libraryFile;
                    this.$action = $action;
                    super(0);
                }

                @Nullable
                public final T invoke() {
                    return ZipUtilKt.withZipFileSystem(this.$libraryFile, (Function1)new Function1<FileSystem, T>(this.$action){
                        final /* synthetic */ Function1<File, T> $action;
                        {
                            this.$action = $action;
                            super(1);
                        }

                        @Nullable
                        public final T invoke(@NotNull FileSystem fs) {
                            Intrinsics.checkNotNullParameter(fs, "fs");
                            return this.$action.invoke(ZipUtilKt.file(fs, "/"));
                        }
                    });
                }
            };
        } else {
            return null;
        }
        Function0 wrappedAction2 = function0;
        try {
            r = wrappedAction2.invoke();
        }
        catch (IOException _) {
            r = null;
        }
        return (T)r;
    }

    private final boolean getLooksLikeKlibComponent(File $this$looksLikeKlibComponent) {
        return $this$looksLikeKlibComponent.child("manifest").isFile();
    }

    public static final /* synthetic */ boolean access$getLooksLikeKlibComponent(ToolingSingleFileKlibResolveStrategy $this, File $receiver) {
        return $this.getLooksLikeKlibComponent($receiver);
    }
}

