/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AbstractValueUsageTransformer;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.InlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0014\u0010\u001f\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010 \u001a\u00020\u0012H\u0014J\u0014\u0010!\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010 \u001a\u00020\u0012H\u0014J\u001c\u0010\"\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0014J\u0014\u0010%\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010 \u001a\u00020&H\u0014J\u001c\u0010'\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001eH&R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\r*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/AbstractValueUsageLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractValueUsageTransformer;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "icUtils", "Lorg/jetbrains/kotlin/ir/backend/js/InlineClassesUtils;", "getIcUtils", "()Lorg/jetbrains/kotlin/ir/backend/js/InlineClassesUtils;", "callTarget", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getCallTarget", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "target", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getTarget", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "useAs", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "useAsDispatchReceiver", "expression", "useAsExtensionReceiver", "useAsValueArgument", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "useAsVarargElement", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "useExpressionAsType", "actualType", "expectedType", "backend.js"})
public abstract class AbstractValueUsageLowering
extends AbstractValueUsageTransformer
implements BodyLoweringPass {
    @NotNull
    private final JsCommonBackendContext context;
    @NotNull
    private final InlineClassesUtils icUtils;

    public AbstractValueUsageLowering(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2.getIrBuiltIns());
        this.context = context2;
        this.icUtils = this.context.getInlineClassesUtils();
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final InlineClassesUtils getIcUtils() {
        return this.icUtils;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container2, "container");
        if (container2.getParent() instanceof IrFunction) {
            return;
        }
        IrDeclaration replacement = (IrDeclaration)container2.transform(this, null);
        if (container2 != replacement) {
            String string2 = Intrinsics.stringPlus("Declaration has changed: ", container2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        IrDeclarationParent irDeclarationParent = container2 instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container2) : null;
        PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irBody, irDeclarationParent == null ? container2.getParent() : irDeclarationParent);
    }

    @NotNull
    public abstract IrExpression useExpressionAsType(@NotNull IrExpression var1, @NotNull IrType var2, @NotNull IrType var3);

    @Override
    @NotNull
    protected IrExpression useAs(@NotNull IrExpression $this$useAs, @NotNull IrType type2) {
        IrValueDeclaration value2;
        Intrinsics.checkNotNullParameter($this$useAs, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        IrExpression irExpression = $this$useAs;
        IrType irType = irExpression instanceof IrConstructorCall ? ((IrConstructor)((IrConstructorCall)$this$useAs).getSymbol().getOwner()).getReturnType() : (irExpression instanceof IrCall ? IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)((IrCall)$this$useAs).getSymbol().getOwner()).getReturnType() : (irExpression instanceof IrGetField ? ((IrField)((IrGetField)$this$useAs).getSymbol().getOwner()).getType() : (irExpression instanceof IrTypeOperatorCall ? (((IrTypeOperatorCall)$this$useAs).getOperator() == IrTypeOperator.REINTERPRET_CAST ? ((IrTypeOperatorCall)$this$useAs).getTypeOperand() : $this$useAs.getType()) : (irExpression instanceof IrGetValue ? ((value2 = ((IrGetValue)$this$useAs).getSymbol().getOwner()) instanceof IrValueParameter && this.icUtils.shouldValueParameterBeBoxed((IrValueParameter)value2) ? this.getIrBuiltIns().getAnyType() : $this$useAs.getType()) : $this$useAs.getType()))));
        IrType actualType = irType;
        return this.useExpressionAsType($this$useAs, actualType, type2);
    }

    private final IrFunction getTarget(IrFunctionAccessExpression $this$target) {
        Object object;
        IrFunctionAccessExpression irFunctionAccessExpression = $this$target;
        if (irFunctionAccessExpression instanceof IrConstructorCall) {
            object = ((IrConstructorCall)$this$target).getSymbol().getOwner();
        } else if (irFunctionAccessExpression instanceof IrDelegatingConstructorCall) {
            object = ((IrDelegatingConstructorCall)$this$target).getSymbol().getOwner();
        } else if (irFunctionAccessExpression instanceof IrCall) {
            object = this.getCallTarget((IrCall)$this$target);
        } else {
            String string2 = RenderIrElementKt.render($this$target);
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return object;
    }

    private final IrFunction getCallTarget(IrCall $this$callTarget) {
        return IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)$this$callTarget.getSymbol().getOwner());
    }

    @Override
    @NotNull
    protected IrExpression useAsDispatchReceiver(@NotNull IrExpression $this$useAsDispatchReceiver, @NotNull IrFunctionAccessExpression expression2) {
        IrExpression irExpression;
        Boolean bl;
        Intrinsics.checkNotNullParameter($this$useAsDispatchReceiver, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrValueParameter irValueParameter = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getDispatchReceiverParameter();
        if (irValueParameter == null) {
            bl = null;
        } else {
            IrValueParameter irValueParameter2 = irValueParameter;
            boolean bl2 = false;
            boolean bl3 = false;
            IrValueParameter it = irValueParameter2;
            boolean bl4 = false;
            bl = this.getIcUtils().shouldValueParameterBeBoxed(it);
        }
        if (Intrinsics.areEqual(bl, true)) {
            irExpression = this.useAs($this$useAsDispatchReceiver, this.getIrBuiltIns().getAnyType());
        } else {
            irValueParameter = this.getTarget(expression2).getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            irExpression = this.useAsArgument($this$useAsDispatchReceiver, irValueParameter);
        }
        return irExpression;
    }

    @Override
    @NotNull
    protected IrExpression useAsExtensionReceiver(@NotNull IrExpression $this$useAsExtensionReceiver, @NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter($this$useAsExtensionReceiver, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrValueParameter irValueParameter = this.getTarget(expression2).getExtensionReceiverParameter();
        Intrinsics.checkNotNull(irValueParameter);
        return this.useAsArgument($this$useAsExtensionReceiver, irValueParameter);
    }

    @Override
    @NotNull
    protected IrExpression useAsValueArgument(@NotNull IrExpression $this$useAsValueArgument, @NotNull IrFunctionAccessExpression expression2, @NotNull IrValueParameter parameter) {
        Intrinsics.checkNotNullParameter($this$useAsValueArgument, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        return this.useAsArgument($this$useAsValueArgument, this.getTarget(expression2).getValueParameters().get(parameter.getIndex()));
    }

    @Override
    @NotNull
    protected IrExpression useAsVarargElement(@NotNull IrExpression $this$useAsVarargElement, @NotNull IrVararg expression2) {
        Intrinsics.checkNotNullParameter($this$useAsVarargElement, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return this.useAs($this$useAsVarargElement, this.icUtils.isTypeInlined($this$useAsVarargElement.getType()) && !this.icUtils.isTypeInlined(expression2.getType()) && !IrTypeUtilsKt.isPrimitiveArray(expression2.getType()) ? this.getIrBuiltIns().getAnyNType() : expression2.getVarargElementType());
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

