/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.BackingFieldSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.backend.js.utils.ParameterTypeBasedSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.Signature;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNameSignature;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0019\u0010\t\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0007\u001a\u0002H\n\u00a2\u0006\u0002\u0010\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a\u0010\u0010\u000e\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"SYNTHETIC_LOOP_LABEL", "", "fieldSignature", "Lorg/jetbrains/kotlin/ir/backend/js/utils/Signature;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "jsFunctionSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "mapToKey", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "sanitizeName", "name", "dump", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isPublic", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsManglerIr;", "backend.js"})
public final class NameTablesKt {
    @NotNull
    public static final <T> String mapToKey(T declaration2) {
        JsManglerIr jsManglerIr = JsManglerIr.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        JsManglerIr $this$mapToKey_u24lambda_u2d0 = jsManglerIr;
        boolean bl3 = false;
        return declaration2 instanceof IrDeclaration && NameTablesKt.isPublic($this$mapToKey_u24lambda_u2d0, (IrDeclaration)declaration2) ? String.valueOf($this$mapToKey_u24lambda_u2d0.getHashedMangle(declaration2)) : (declaration2 instanceof Signature ? String.valueOf($this$mapToKey_u24lambda_u2d0.getHashMangle(declaration2.toString())) : "key_have_not_generated");
    }

    public static final boolean isPublic(@NotNull JsManglerIr $this$isPublic, @NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter($this$isPublic, "<this>");
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return $this$isPublic.isExported(declaration2) && !(declaration2 instanceof IrScript) && !(declaration2 instanceof IrVariable) && !(declaration2 instanceof IrValueParameter);
    }

    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, "<this>");
        return Intrinsics.stringPlus("Names: \n", CollectionsKt.joinToString$default(MapsKt.toList($this$dump.getNames()), "\n", null, null, 0, null, dump.1.INSTANCE, 30, null));
    }

    @NotNull
    public static final Signature fieldSignature(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter(field, "field");
        if (IrUtilsKt.isEffectivelyExternal(field)) {
            String string2 = field.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string2, "field.name.identifier");
            return new StableNameSignature(string2);
        }
        return new BackingFieldSignature(field);
    }

    @NotNull
    public static final Signature jsFunctionSignature(@NotNull IrFunction declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        boolean bl = !IrFunctionKt.isStaticMethodOfClass(declaration2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl = declaration2.getDispatchReceiverParameter() != null;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string3 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        String string4 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration2).asString();
        Intrinsics.checkNotNullExpressionValue(string4, "declaration.getJsNameOrKotlinName().asString()");
        String declarationName = string4;
        StableNameSignature stableName = new StableNameSignature(declarationName);
        if (Intrinsics.areEqual(declaration2.getOrigin(), JsLoweredDeclarationOrigin.BRIDGE_TO_EXTERNAL_FUNCTION.INSTANCE)) {
            return stableName;
        }
        if (IrUtilsKt.isEffectivelyExternal(declaration2)) {
            return stableName;
        }
        if (AnnotationUtilsKt.getJsName(declaration2) != null) {
            return stableName;
        }
        if (declaration2 instanceof IrSimpleFunction && org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isMethodOfAny((IrSimpleFunction)declaration2)) {
            return stableName;
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(declarationName);
        Object $this$ifNotEmpty$iv = declaration2.getTypeParameters();
        boolean $i$f$ifNotEmpty2 = false;
        Object object = $this$ifNotEmpty$iv;
        boolean bl7 = false;
        if (!object.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d1 = (List)$this$ifNotEmpty$iv;
            boolean bl8 = false;
            nameBuilder.append("_$t");
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default($this$jsFunctionSignature_u24lambda_u2d1, nameBuilder, "", null, null, 0, null, jsFunctionSignature.1.1.INSTANCE, 60, null);
        }
        if (($this$ifNotEmpty$iv = declaration2.getExtensionReceiverParameter()) != null) {
            Object $i$f$ifNotEmpty2 = $this$ifNotEmpty$iv;
            boolean bl9 = false;
            bl7 = false;
            Object it = $i$f$ifNotEmpty2;
            boolean bl10 = false;
            nameBuilder.append(Intrinsics.stringPlus("_r$", IrTypeUtilsKt.asString(((IrValueDeclaration)it).getType())));
        }
        $this$ifNotEmpty$iv = declaration2.getValueParameters();
        boolean $i$f$ifNotEmpty3 = false;
        object = $this$ifNotEmpty$iv;
        bl7 = false;
        if (!object.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d3 = (List)$this$ifNotEmpty$iv;
            boolean bl11 = false;
            StringBuilder cfr_ignored_1 = (StringBuilder)CollectionsKt.joinTo$default($this$jsFunctionSignature_u24lambda_u2d3, nameBuilder, "", null, null, 0, null, jsFunctionSignature.3.1.INSTANCE, 60, null);
        }
        $this$ifNotEmpty$iv = declaration2.getReturnType();
        boolean bl12 = false;
        boolean bl13 = false;
        Object it = $this$ifNotEmpty$iv;
        boolean bl14 = false;
        if (IrTypeUtilsKt.getJsInlinedClass((IrType)it) != null || IrTypePredicatesKt.isUnit((IrType)it)) {
            nameBuilder.append(Intrinsics.stringPlus("_ret$", IrTypeUtilsKt.asString((IrType)it)));
        }
        String string5 = nameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "nameBuilder.toString()");
        String signature2 = string5;
        return new ParameterTypeBasedSignature(signature2, declarationName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeName(@NotNull String name) {
        Collection<Character> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        CharSequence charSequence = name;
        char c = '\u0000';
        if (charSequence.length() == 0) {
            return "_";
        }
        c = StringsKt.first(name);
        boolean bl = false;
        boolean bl2 = false;
        char it = c;
        boolean bl3 = false;
        char first = NameSuggestionKt.isES5IdentifierStart(it) ? it : (char)'_';
        CharSequence charSequence2 = StringsKt.drop(name, 1);
        StringBuilder stringBuilder2 = new StringBuilder().append(first);
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var7_12 = $this$mapTo$iv$iv;
        for (int i = 0; i < var7_12.length(); ++i) {
            char it2;
            char item$iv$iv;
            char c2 = item$iv$iv = var7_12.charAt(i);
            collection = destination$iv$iv;
            boolean bl4 = false;
            Character c3 = Character.valueOf(NameSuggestionKt.isES5IdentifierPart(it2) ? it2 : (char)'_');
            collection.add(c3);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder2.append(CollectionsKt.joinToString$default(collection, "", null, null, 0, null, null, 62, null)).toString();
    }
}

