/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import com.intellij.openapi.project.Project;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.js.JsProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.ApproximatingStringTable;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinDeserializedFileMetadata;
import org.jetbrains.kotlin.serialization.js.KotlinFileMetadata;
import org.jetbrains.kotlin.serialization.js.KotlinFileRegistry;
import org.jetbrains.kotlin.serialization.js.KotlinJavaScriptLibraryParts;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragmentProviderKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtilKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializerExtension;
import org.jetbrains.kotlin.serialization.js.KotlinPsiFileMetadata;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.serialization.js.PackagesWithHeaderMetadata;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J.\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007JD\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020*J \u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\"2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\u0002022\u0006\u0010\b\u001a\u00020\t2\b\u00103\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020'J4\u00104\u001a\u0002052\u0006\u0010!\u001a\u00020\"2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\t072\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil;", "", "()V", "CLASS_METADATA_FILE_EXTENSION", "", "getPackagesFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getSubPackagesFqNames", "", "packageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "fqName", "result", "", "readDescriptors", "metadata", "Lorg/jetbrains/kotlin/serialization/js/PackagesWithHeaderMetadata;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "configuration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "readModuleAsProto", "Lorg/jetbrains/kotlin/serialization/js/KotlinJavaScriptLibraryParts;", "", "metadataVersion", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "serializeDescriptors", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "scope", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "serializeFiles", "Lorg/jetbrains/kotlin/metadata/js/JsProtoBuf$Files;", "fileRegistry", "Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;", "serializer", "Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "serializeHeader", "Lorg/jetbrains/kotlin/metadata/js/JsProtoBuf$Header;", "packageFqName", "serializeMetadata", "Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil$SerializedMetadata;", "jsDescriptor", "Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;", "SerializedMetadata", "js.serializer"})
public final class KotlinJavascriptSerializationUtil {
    @NotNull
    public static final KotlinJavascriptSerializationUtil INSTANCE = new KotlinJavascriptSerializationUtil();
    @NotNull
    public static final String CLASS_METADATA_FILE_EXTENSION = "kjsm";

    private KotlinJavascriptSerializationUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PackageFragmentProvider readDescriptors(@NotNull PackagesWithHeaderMetadata metadata, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module2, @NotNull DeserializationConfiguration configuration, @NotNull LookupTracker lookupTracker) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(lookupTracker, "lookupTracker");
        Iterable $this$map$iv = metadata.getPackages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProtoBuf.PackageFragment packageFragment = ProtoBuf.PackageFragment.parseFrom((byte[])it, JsSerializerProtocol.INSTANCE.getExtensionRegistry());
            collection.add(packageFragment);
        }
        List scopeProto = (List)destination$iv$iv;
        JsProtoBuf.Header headerProto = JsProtoBuf.Header.parseFrom(CodedInputStream.newInstance(metadata.getHeader()), JsSerializerProtocol.INSTANCE.getExtensionRegistry());
        Intrinsics.checkNotNullExpressionValue(headerProto, "headerProto");
        return KotlinJavascriptPackageFragmentProviderKt.createKotlinJavascriptPackageFragmentProvider(storageManager, module2, headerProto, scopeProto, metadata.getMetadataVersion(), configuration, lookupTracker);
    }

    @NotNull
    public final SerializedMetadata serializeMetadata(@NotNull BindingContext bindingContext, @NotNull JsModuleDescriptor<? extends ModuleDescriptor> jsDescriptor, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull JsMetadataVersion metadataVersion, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(jsDescriptor, "jsDescriptor");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Intrinsics.checkNotNullParameter(project, "project");
        Map<FqName, byte[]> serializedFragments = KotlinJavascriptSerializationUtilKt.missingMetadata(MapsKt.emptyMap(), bindingContext, jsDescriptor.getData(), languageVersionSettings, metadataVersion, project);
        return new SerializedMetadata(serializedFragments, jsDescriptor, languageVersionSettings, metadataVersion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProtoBuf.PackageFragment serializeDescriptors(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, @NotNull Collection<? extends DeclarationDescriptor> scope2, @NotNull FqName fqName2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Project project, @NotNull BinaryVersion metadataVersion) {
        void $this$filterNotTo$iv$iv;
        void $this$sortedBy$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        ProtoBuf.PackageFragment.Builder builder2 = ProtoBuf.PackageFragment.newBuilder();
        Function1 skip2 = new Function1<DeclarationDescriptor, Boolean>(module2){
            final /* synthetic */ ModuleDescriptor $module;
            {
                this.$module = $module;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DeclarationDescriptor descriptor2) {
                Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                if (!Intrinsics.areEqual(DescriptorUtilsKt.getModule(descriptor2), this.$module)) {
                    return true;
                }
                if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect()) {
                    return !(descriptor2 instanceof ClassDescriptor) || !OptionalAnnotationUtil.shouldGenerateExpectClass((ClassDescriptor)descriptor2);
                }
                return false;
            }
        };
        KotlinFileRegistry fileRegistry = new KotlinFileRegistry();
        KotlinJavascriptSerializerExtension extension = new KotlinJavascriptSerializerExtension(fileRegistry, languageVersionSettings, metadataVersion);
        Iterable $this$filterIsInstance$iv = scope2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ClassDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean $this$filterIsInstanceTo$iv$iv2 = false;
        List classDescriptors2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ClassDescriptor it = (ClassDescriptor)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)DescriptorUtilsKt.getFqNameSafe(it).asString());
                it = (ClassDescriptor)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string2 = DescriptorUtilsKt.getFqNameSafe(it).asString();
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string2));
            }
        });
        DescriptorSerializer serializer2 = DescriptorSerializer.Companion.createTopLevel(extension);
        KotlinJavascriptSerializationUtil.serializeDescriptors$serializeClasses(skip2, extension, project, builder2, classDescriptors2, serializer2);
        ApproximatingStringTable stringTable = extension.getStringTable();
        Iterable $this$filterNot$iv = scope2;
        boolean $i$f$filterNot = false;
        Iterable iterable2 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            if (((Boolean)skip2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List members = (List)destination$iv$iv2;
        builder2.setPackage(serializer2.packagePartProto(fqName2, members).build());
        builder2.setExtension(JsProtoBuf.packageFragmentFiles, this.serializeFiles(fileRegistry, bindingContext, new AnnotationSerializer(stringTable)));
        Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = stringTable.buildProto();
        ProtoBuf.StringTable strings2 = pair.component1();
        ProtoBuf.QualifiedNameTable qualifiedNames = pair.component2();
        builder2.setStrings(strings2);
        builder2.setQualifiedNames(qualifiedNames);
        ProtoBuf.PackageFragment packageFragment = builder2.build();
        Intrinsics.checkNotNullExpressionValue(packageFragment, "builder.build()");
        return packageFragment;
    }

    /*
     * WARNING - void declaration
     */
    private final JsProtoBuf.Files serializeFiles(KotlinFileRegistry fileRegistry, BindingContext bindingContext, AnnotationSerializer serializer2) {
        JsProtoBuf.Files.Builder filesProto = JsProtoBuf.Files.newBuilder();
        Iterable $this$sortedBy$iv = fileRegistry.getFileIds().entrySet();
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Object object = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = (Integer)it.getValue();
                return ComparisonsKt.compareValues(comparable2, (Comparable)n);
            }
        }).iterator();
        while (object.hasNext()) {
            List list2;
            Object object2;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)object.next();
            boolean bl2 = false;
            KotlinFileMetadata file2 = (KotlinFileMetadata)entry2.getKey();
            Map.Entry entry3 = entry;
            boolean bl3 = false;
            int id = ((Number)entry3.getValue()).intValue();
            JsProtoBuf.File.Builder fileProto = JsProtoBuf.File.newBuilder();
            if (id != filesProto.getFileCount()) {
                fileProto.setId(id);
            }
            if ((object2 = file2) instanceof KotlinPsiFileMetadata) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((KotlinPsiFileMetadata)file2).getKtFile().getAnnotationEntries();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    Object v = bindingContext.get(BindingContext.ANNOTATION, it);
                    Intrinsics.checkNotNull(v);
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)v;
                    collection.add(annotationDescriptor);
                }
                list2 = (List)destination$iv$iv;
            } else if (object2 instanceof KotlinDeserializedFileMetadata) {
                KotlinJavascriptPackageFragment.FileHolder fileHolder = ((KotlinDeserializedFileMetadata)file2).getPackageFragment().getFileMap().get(((KotlinDeserializedFileMetadata)file2).getFileId());
                Intrinsics.checkNotNull(fileHolder);
                list2 = fileHolder.getAnnotations();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List annotations2 = list2;
            object2 = DescriptorUtilsKt.filterOutSourceAnnotations(annotations2).iterator();
            while (object2.hasNext()) {
                AnnotationDescriptor annotation2 = (AnnotationDescriptor)object2.next();
                fileProto.addAnnotation(serializer2.serializeAnnotation(annotation2));
            }
            filesProto.addFile(fileProto);
        }
        object = filesProto.build();
        Intrinsics.checkNotNullExpressionValue(object, "filesProto.build()");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsProtoBuf.Header serializeHeader(@NotNull ModuleDescriptor module2, @Nullable FqName packageFqName, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        JsProtoBuf.Header.Builder header = JsProtoBuf.Header.newBuilder();
        if (packageFqName != null) {
            header.setPackageFqName(packageFqName.asString());
        }
        if (languageVersionSettings.isPreRelease()) {
            header.setFlags(1);
        }
        List<String> experimentalAnnotationFqNames = languageVersionSettings.getFlag(AnalysisFlags.getExperimental());
        Object object = experimentalAnnotationFqNames;
        boolean bl = false;
        if (!object.isEmpty()) {
            StringTableImpl stringTable = new StringTableImpl();
            for (String fqName2 : experimentalAnnotationFqNames) {
                void $this$serializeHeader_u24lambda_u2d4;
                Object object2 = DescriptorUtilKt.resolveClassByFqName(module2, new FqName(fqName2), NoLookupLocation.FOR_ALREADY_TRACKED);
                if (object2 == null) continue;
                ClassDescriptor descriptor2 = object2;
                object2 = ProtoBuf.Annotation.newBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                Object object3 = object2;
                JsProtoBuf.Header.Builder builder2 = header;
                boolean bl4 = false;
                $this$serializeHeader_u24lambda_u2d4.setId(stringTable.getFqNameIndex(descriptor2));
                Unit unit = Unit.INSTANCE;
                builder2.addAnnotation((ProtoBuf.Annotation.Builder)object2);
            }
            Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = stringTable.buildProto();
            ProtoBuf.StringTable strings2 = (ProtoBuf.StringTable)pair.component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = (ProtoBuf.QualifiedNameTable)pair.component2();
            header.setStrings(strings2);
            header.setQualifiedNames(qualifiedNames);
        }
        object = header.build();
        Intrinsics.checkNotNullExpressionValue(object, "header.build()");
        return object;
    }

    @NotNull
    public final Set<FqName> getPackagesFqNames(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        boolean bl = false;
        Set set = new LinkedHashSet();
        boolean bl2 = false;
        boolean bl3 = false;
        Set $this$getPackagesFqNames_u24lambda_u2d5 = set;
        boolean bl4 = false;
        PackageFragmentProvider packageFragmentProvider = KotlinJavascriptSerializationUtilKt.access$getPackageFragmentProviderForModuleContentWithoutDependencies(module2);
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue(fqName2, "ROOT");
        INSTANCE.getSubPackagesFqNames(packageFragmentProvider, fqName2, $this$getPackagesFqNames_u24lambda_u2d5);
        fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue(fqName2, "ROOT");
        $this$getPackagesFqNames_u24lambda_u2d5.add(fqName2);
        return set;
    }

    private final void getSubPackagesFqNames(PackageFragmentProvider packageFragmentProvider, FqName fqName2, Set<FqName> result2) {
        if (!fqName2.isRoot()) {
            result2.add(fqName2);
        }
        for (FqName subPackage : packageFragmentProvider.getSubPackagesOf(fqName2, getSubPackagesFqNames.1.INSTANCE)) {
            this.getSubPackagesFqNames(packageFragmentProvider, subPackage, result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final KotlinJavaScriptLibraryParts readModuleAsProto(@NotNull byte[] metadata, @NotNull JsMetadataVersion metadataVersion) {
        ModuleKind moduleKind;
        ProtocolStringList protocolStringList;
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Closeable closeable = new GZIPInputStream(new ByteArrayInputStream(metadata));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            GZIPInputStream stream = (GZIPInputStream)closeable;
            boolean bl3 = false;
            protocolStringList = TuplesKt.to(JsProtoBuf.Header.parseDelimitedFrom(stream, JsSerializerProtocol.INSTANCE.getExtensionRegistry()), JsProtoBuf.Library.parseFrom(stream, JsSerializerProtocol.INSTANCE.getExtensionRegistry()));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Pair<JsProtoBuf.Header, JsProtoBuf.Library> pair = protocolStringList;
        JsProtoBuf.Header header = pair.component1();
        JsProtoBuf.Library content = pair.component2();
        protocolStringList = content.getKind();
        int n = protocolStringList == null ? -1 : WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)protocolStringList)).ordinal()];
        switch (n) {
            case -1: 
            case 1: {
                moduleKind = ModuleKind.PLAIN;
                break;
            }
            case 2: {
                moduleKind = ModuleKind.AMD;
                break;
            }
            case 3: {
                moduleKind = ModuleKind.COMMON_JS;
                break;
            }
            case 4: {
                moduleKind = ModuleKind.UMD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ModuleKind moduleKind2 = moduleKind;
        Intrinsics.checkNotNullExpressionValue(header, "header");
        protocolStringList = content.getPackageFragmentList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList, "content.packageFragmentList");
        ProtocolStringList protocolStringList2 = protocolStringList;
        protocolStringList = content.getImportedModuleList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList, "content.importedModuleList");
        return new KotlinJavaScriptLibraryParts(header, protocolStringList2, moduleKind2, protocolStringList, metadataVersion);
    }

    private static final void serializeDescriptors$serializeClasses(Function1<? super DeclarationDescriptor, Boolean> skip2, KotlinJavascriptSerializerExtension extension, Project $project, ProtoBuf.PackageFragment.Builder builder2, Collection<? extends DeclarationDescriptor> descriptors, DescriptorSerializer parentSerializer) {
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            if (!(declarationDescriptor instanceof ClassDescriptor) || skip2.invoke(declarationDescriptor).booleanValue()) continue;
            DescriptorSerializer serializer2 = DescriptorSerializer.Companion.create((ClassDescriptor)declarationDescriptor, extension, parentSerializer, $project);
            MemberScope memberScope2 = ((ClassDescriptor)declarationDescriptor).getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue(memberScope2, "descriptor.unsubstitutedInnerClassesScope");
            KotlinJavascriptSerializationUtil.serializeDescriptors$serializeClasses(skip2, extension, $project, builder2, ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, null, null, 3, null), serializer2);
            ProtoBuf.Class clazz = serializer2.classProto((ClassDescriptor)declarationDescriptor).build();
            if (clazz == null) {
                String string2 = Intrinsics.stringPlus("Class not serialized: ", declarationDescriptor);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            ProtoBuf.Class classProto = clazz;
            builder2.addClass_(classProto);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB7\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0005H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil$SerializedMetadata;", "", "serializedFragments", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "jsDescriptor", "Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "metadataVersion", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/utils/JsMetadataVersion;)V", "asByteArray", "asLibrary", "Lorg/jetbrains/kotlin/metadata/js/JsProtoBuf$Library;", "asString", "", "serializedPackages", "", "Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil$SerializedMetadata$SerializedPackage;", "appendPackageFragments", "", "Ljava/io/OutputStream;", "writeProto", "fieldNumber", "", "content", "SerializedPackage", "js.serializer"})
    public static final class SerializedMetadata {
        @NotNull
        private final Map<FqName, byte[]> serializedFragments;
        @NotNull
        private final JsModuleDescriptor<ModuleDescriptor> jsDescriptor;
        @NotNull
        private final LanguageVersionSettings languageVersionSettings;
        @NotNull
        private final JsMetadataVersion metadataVersion;

        public SerializedMetadata(@NotNull Map<FqName, byte[]> serializedFragments, @NotNull JsModuleDescriptor<? extends ModuleDescriptor> jsDescriptor, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull JsMetadataVersion metadataVersion) {
            Intrinsics.checkNotNullParameter(serializedFragments, "serializedFragments");
            Intrinsics.checkNotNullParameter(jsDescriptor, "jsDescriptor");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
            this.serializedFragments = serializedFragments;
            this.jsDescriptor = jsDescriptor;
            this.languageVersionSettings = languageVersionSettings;
            this.metadataVersion = metadataVersion;
        }

        @NotNull
        public final List<SerializedPackage> serializedPackages() {
            boolean bl = false;
            ArrayList<SerializedPackage> packages2 = new ArrayList<SerializedPackage>();
            Object object = this.serializedFragments;
            boolean bl2 = false;
            Iterator<Map.Entry<FqName, byte[]>> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object2 = object = iterator2.next();
                boolean bl3 = false;
                FqName fqName2 = (FqName)object2.getKey();
                Object object3 = object;
                boolean bl4 = false;
                byte[] part = (byte[])object3.getValue();
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Object object4 = new DataOutputStream(stream);
                boolean bl5 = false;
                boolean bl6 = false;
                DataOutputStream $this$serializedPackages_u24lambda_u2d0 = object4;
                boolean bl7 = false;
                int[] version = this.metadataVersion.toArray();
                $this$serializedPackages_u24lambda_u2d0.writeInt(version.length);
                int[] $this$forEach$iv = version;
                boolean $i$f$forEach = false;
                int[] nArray = $this$forEach$iv;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int p0 = element$iv = nArray[i];
                    boolean bl8 = false;
                    $this$serializedPackages_u24lambda_u2d0.writeInt(p0);
                }
                INSTANCE.serializeHeader(this.jsDescriptor.getData(), fqName2, this.languageVersionSettings).writeDelimitedTo(stream);
                stream.write(part);
                object4 = stream.toByteArray();
                Intrinsics.checkNotNullExpressionValue(object4, "stream.toByteArray()");
                packages2.add(new SerializedPackage(fqName2, (byte[])object4));
            }
            return packages2;
        }

        @NotNull
        public final String asString() {
            return KotlinJavascriptMetadataUtils.INSTANCE.formatMetadataAsString(this.jsDescriptor.getName(), this.asByteArray(), this.metadataVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final byte[] asByteArray() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = false;
            boolean bl2 = false;
            ByteArrayOutputStream $this$asByteArray_u24lambda_u2d3 = byteArrayOutputStream;
            boolean bl3 = false;
            Closeable closeable = new GZIPOutputStream($this$asByteArray_u24lambda_u2d3);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                GZIPOutputStream stream = (GZIPOutputStream)closeable;
                boolean bl6 = false;
                INSTANCE.serializeHeader(this.jsDescriptor.getData(), null, this.languageVersionSettings).writeDelimitedTo(stream);
                this.asLibrary().writeTo(stream);
                this.appendPackageFragments(stream);
                Iterable $this$forEach$iv = this.jsDescriptor.getImported();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl7 = false;
                    OutputStream outputStream2 = stream;
                    String string2 = it;
                    Charset charset = Charsets.UTF_8;
                    boolean bl8 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string3.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
                    this.writeProto(outputStream2, 3, byArray);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "ByteArrayOutputStream().\u2026          }.toByteArray()");
            return byArray;
        }

        private final JsProtoBuf.Library asLibrary() {
            JsProtoBuf.Library.Kind kind;
            ModuleKind moduleKind = this.jsDescriptor.getKind();
            JsProtoBuf.Library.Builder builder2 = JsProtoBuf.Library.newBuilder();
            Object object = moduleKind;
            int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
            switch (n) {
                case 1: {
                    kind = JsProtoBuf.Library.Kind.PLAIN;
                    break;
                }
                case 2: {
                    kind = JsProtoBuf.Library.Kind.AMD;
                    break;
                }
                case 3: {
                    kind = JsProtoBuf.Library.Kind.COMMON_JS;
                    break;
                }
                case 4: {
                    kind = JsProtoBuf.Library.Kind.UMD;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            JsProtoBuf.Library.Kind moduleProtoKind = kind;
            if (builder2.getKind() != moduleProtoKind) {
                builder2.setKind(moduleProtoKind);
            }
            object = builder2.build();
            Intrinsics.checkNotNullExpressionValue(object, "builder.build()");
            return object;
        }

        private final void writeProto(OutputStream $this$writeProto, int fieldNumber, byte[] content) {
            int size;
            $this$writeProto.write(fieldNumber << 3 | 2);
            for (size = content.length; size > 127; size >>>= 7) {
                $this$writeProto.write(0x80 | size & 0x7F);
            }
            $this$writeProto.write(size);
            $this$writeProto.write(content);
        }

        private final void appendPackageFragments(OutputStream $this$appendPackageFragments) {
            Iterable $this$sortedBy$iv = this.serializedFragments.entrySet();
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            Iterator iterator2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry $dstr$fqName$_u24__u24 = (Map.Entry)a;
                    boolean bl2 = false;
                    Map.Entry entry = $dstr$fqName$_u24__u24;
                    boolean bl3 = false;
                    FqName fqName2 = (FqName)entry.getKey();
                    $dstr$fqName$_u24__u24 = (Map.Entry)b;
                    Comparable comparable = (Comparable)((Object)fqName2.asString());
                    bl2 = false;
                    entry = $dstr$fqName$_u24__u24;
                    bl3 = false;
                    fqName2 = (FqName)entry.getKey();
                    String string2 = fqName2.asString();
                    return ComparisonsKt.compareValues(comparable, (Comparable)((Object)string2));
                }
            }).iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
                boolean bl2 = false;
                byte[] fragment = (byte[])entry2.getValue();
                this.writeProto($this$appendPackageFragments, 2, fragment);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil$SerializedMetadata$SerializedPackage;", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "bytes", "", "(Lorg/jetbrains/kotlin/name/FqName;[B)V", "getBytes", "()[B", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "js.serializer"})
        public static final class SerializedPackage {
            @NotNull
            private final FqName fqName;
            @NotNull
            private final byte[] bytes;

            public SerializedPackage(@NotNull FqName fqName2, @NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                Intrinsics.checkNotNullParameter(bytes, "bytes");
                this.fqName = fqName2;
                this.bytes = bytes;
            }

            @NotNull
            public final FqName getFqName() {
                return this.fqName;
            }

            @NotNull
            public final byte[] getBytes() {
                return this.bytes;
            }
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ModuleKind.values().length];
                nArray[ModuleKind.PLAIN.ordinal()] = 1;
                nArray[ModuleKind.AMD.ordinal()] = 2;
                nArray[ModuleKind.COMMON_JS.ordinal()] = 3;
                nArray[ModuleKind.UMD.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsProtoBuf.Library.Kind.values().length];
            nArray[JsProtoBuf.Library.Kind.PLAIN.ordinal()] = 1;
            nArray[JsProtoBuf.Library.Kind.AMD.ordinal()] = 2;
            nArray[JsProtoBuf.Library.Kind.COMMON_JS.ordinal()] = 3;
            nArray[JsProtoBuf.Library.Kind.UMD.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

