/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.LeafNode;

public class DocumentType
extends LeafNode {
    public DocumentType(String name, String publicId, String systemId) {
        Validate.notNull(name);
        Validate.notNull(publicId);
        Validate.notNull(systemId);
        this.attr("name", name);
        this.attr("publicId", publicId);
        if (this.has("publicId")) {
            this.attr("pubSysKey", "PUBLIC");
        }
        this.attr("systemId", systemId);
    }

    public void setPubSysKey(String value) {
        if (value != null) {
            this.attr("pubSysKey", value);
        }
    }

    @Override
    public String nodeName() {
        return "#doctype";
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (out.syntax() == Document.OutputSettings.Syntax.html && !this.has("publicId") && !this.has("systemId")) {
            accum.append("<!doctype");
        } else {
            accum.append("<!DOCTYPE");
        }
        if (this.has("name")) {
            accum.append(" ").append(this.attr("name"));
        }
        if (this.has("pubSysKey")) {
            accum.append(" ").append(this.attr("pubSysKey"));
        }
        if (this.has("publicId")) {
            accum.append(" \"").append(this.attr("publicId")).append('\"');
        }
        if (this.has("systemId")) {
            accum.append(" \"").append(this.attr("systemId")).append('\"');
        }
        accum.append('>');
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    private boolean has(String attribute) {
        return !StringUtil.isBlank(this.attr(attribute));
    }
}

