/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.backend.jvm.serialization.proto.JvmIr;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.protobuf.AbstractMessageLite;
import org.jetbrains.kotlin.protobuf.ByteString;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "expectDescriptorToSymbol", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "externallyVisibleOnly", "", "skipExpects", "(Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;Ljava/util/Map;ZZ)V", "serializeAuxTables", "Lorg/jetbrains/kotlin/backend/jvm/serialization/proto/JvmIr$AuxTables;", "serializeJvmIrFile", "Lorg/jetbrains/kotlin/backend/jvm/serialization/proto/JvmIr$JvmIrFile;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "serializeTopLevelClass", "Lorg/jetbrains/kotlin/backend/jvm/serialization/proto/JvmIr$JvmIrClass;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ir.serialization.jvm"})
public final class JvmIrSerializerSession
extends IrFileSerializer {
    @NotNull
    private final DeclarationTable declarationTable;

    public JvmIrSerializerSession(@NotNull IrMessageLogger messageLogger, @NotNull DeclarationTable declarationTable, @NotNull Map<DeclarationDescriptor, IrSymbol> expectDescriptorToSymbol, boolean externallyVisibleOnly, boolean skipExpects) {
        Intrinsics.checkNotNullParameter(messageLogger, "messageLogger");
        Intrinsics.checkNotNullParameter(declarationTable, "declarationTable");
        Intrinsics.checkNotNullParameter(expectDescriptorToSymbol, "expectDescriptorToSymbol");
        super(messageLogger, declarationTable, expectDescriptorToSymbol, CompatibilityMode.Companion.getCURRENT(), externallyVisibleOnly, skipExpects, false, false, false, 448, null);
        this.declarationTable = declarationTable;
    }

    public /* synthetic */ JvmIrSerializerSession(IrMessageLogger irMessageLogger, DeclarationTable declarationTable, Map map, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(irMessageLogger, declarationTable, map, bl, bl2);
    }

    @NotNull
    public final JvmIr.JvmIrFile serializeJvmIrFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        JvmIr.JvmIrFile.Builder proto = JvmIr.JvmIrFile.newBuilder();
        this.declarationTable.inFile(irFile, new Function0<Unit>(irFile, proto, this){
            final /* synthetic */ IrFile $irFile;
            final /* synthetic */ JvmIr.JvmIrFile.Builder $proto;
            final /* synthetic */ JvmIrSerializerSession this$0;
            {
                this.$irFile = $irFile;
                this.$proto = $proto;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.$irFile.getDeclarations();
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv$iv;
                    boolean bl = false;
                    if (!(!(it instanceof IrClass))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                JvmIr.JvmIrFile.Builder builder2 = this.$proto;
                object = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrDeclaration declaration2 = (IrDeclaration)element$iv;
                    boolean bl = false;
                    builder2.addDeclaration(((IrFileSerializer)object).serializeDeclaration(declaration2));
                }
                this.$proto.addAllAnnotation(JvmIrSerializerSession.access$serializeAnnotations(this.this$0, this.$irFile.getAnnotations()));
            }
        });
        proto.setAuxTables(this.serializeAuxTables());
        JvmIr.JvmIrFile jvmIrFile = proto.build();
        Intrinsics.checkNotNullExpressionValue(jvmIrFile, "proto.build()");
        return jvmIrFile;
    }

    @NotNull
    public final JvmIr.JvmIrClass serializeTopLevelClass(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        JvmIr.JvmIrClass.Builder proto = JvmIr.JvmIrClass.newBuilder();
        this.declarationTable.inFile((IrFile)irClass2.getParent(), new Function0<Unit>(proto, this, irClass2){
            final /* synthetic */ JvmIr.JvmIrClass.Builder $proto;
            final /* synthetic */ JvmIrSerializerSession this$0;
            final /* synthetic */ IrClass $irClass;
            {
                this.$proto = $proto;
                this.this$0 = $receiver;
                this.$irClass = $irClass;
                super(0);
            }

            public final void invoke() {
                this.$proto.setIrClass(JvmIrSerializerSession.access$serializeIrClass(this.this$0, this.$irClass));
            }
        });
        proto.setAuxTables(this.serializeAuxTables());
        JvmIr.JvmIrClass jvmIrClass = proto.build();
        Intrinsics.checkNotNullExpressionValue(jvmIrClass, "proto.build()");
        return jvmIrClass;
    }

    private final JvmIr.AuxTables serializeAuxTables() {
        Object it;
        JvmIr.AuxTables.Builder proto = JvmIr.AuxTables.newBuilder();
        Iterable $this$forEach$iv = this.getProtoTypeArray();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrType)element$iv;
            boolean bl = false;
            proto.addType(((AbstractMessageLite)it).toByteString());
        }
        $this$forEach$iv = this.getProtoIdSignatureArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IdSignature)element$iv;
            boolean bl = false;
            proto.addSignature(((AbstractMessageLite)it).toByteString());
        }
        $this$forEach$iv = this.getProtoStringArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            proto.addString(ByteString.copyFromUtf8((String)it));
        }
        $this$forEach$iv = this.getProtoBodyArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrFileSerializer.XStatementOrExpression)element$iv;
            boolean bl = false;
            proto.addBody(ByteString.copyFrom(((IrFileSerializer.XStatementOrExpression)it).toByteArray()));
        }
        $this$forEach$iv = this.getProtoDebugInfoArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            proto.addDebugInfo(ByteString.copyFromUtf8((String)it));
        }
        JvmIr.AuxTables auxTables = proto.build();
        Intrinsics.checkNotNullExpressionValue(auxTables, "proto.build()");
        return auxTables;
    }

    public static final /* synthetic */ List access$serializeAnnotations(JvmIrSerializerSession $this, List annotations2) {
        return $this.serializeAnnotations(annotations2);
    }

    public static final /* synthetic */ org.jetbrains.kotlin.backend.common.serialization.proto.IrClass access$serializeIrClass(JvmIrSerializerSession $this, IrClass clazz) {
        return $this.serializeIrClass(clazz);
    }
}

