/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenSubjectChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirWhenSubjectChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirWhenSubjectChecker INSTANCE = new FirWhenSubjectChecker();

    private FirWhenSubjectChecker() {
    }

    @Override
    public void check(@NotNull FirWhenExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirExpression subject = expression2.getSubject();
        FirVariable subjectVariable = expression2.getSubjectVariable();
        Object object2 = subjectVariable;
        Object object3 = object2 == null ? (FirElement)subject : (FirElement)object2;
        Object object4 = object = object3 == null ? null : ((FirStatement)object3).getSource();
        if (object == null) {
            return;
        }
        FirSourceElement source = object;
        object = subject;
        if (Intrinsics.areEqual(object == null ? null : ((object3 = ((FirExpression)object).getSource()) == null ? null : ((FirSourceElement)object3).getElementType()), KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"destructuring declaration", context2, null, 16, null);
        } else {
            FirSourceElement firSourceElement;
            object = subjectVariable;
            if (object == null) {
                firSourceElement = null;
            } else {
                object3 = ((FirVariable)object).getSource();
                if (object3 == null) {
                    firSourceElement = null;
                } else {
                    object2 = KtTokens.VAR_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(object2, "VAR_KEYWORD");
                    firSourceElement = FirSourceUtilsKt.getChild$default((FirSourceElement)object3, (IElementType)object2, 0, 0, 6, null);
                }
            }
            if (firSourceElement != null) {
                DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"var", context2, null, 16, null);
            } else {
                FirSourceElement firSourceElement2;
                object = subjectVariable;
                if (object == null) {
                    firSourceElement2 = null;
                } else {
                    object3 = ((FirVariable)object).getSource();
                    if (object3 == null) {
                        firSourceElement2 = null;
                    } else {
                        object2 = KtNodeTypes.PROPERTY_DELEGATE;
                        Intrinsics.checkNotNullExpressionValue(object2, "PROPERTY_DELEGATE");
                        firSourceElement2 = FirSourceUtilsKt.getChild$default((FirSourceElement)object3, (IElementType)object2, 0, 0, 6, null);
                    }
                }
                if (firSourceElement2 != null) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"delegated property", context2, null, 16, null);
                } else if (subjectVariable != null && subjectVariable.getInitializer() == null) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"variable without initializer", context2, null, 16, null);
                }
            }
        }
    }
}

