/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutineFunctionTransformer;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.declaration.InlineCoroutineUtilKt;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00102\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00112\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "()V", "functionName", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "", "getFunctionName", "()Ljava/util/Map;", "endVisit", "", "x", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "visit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "js.translator"})
public final class CoroutineTransformer
extends JsVisitorWithContextImpl {
    @NotNull
    private final Map<JsFunction, String> functionName = new LinkedHashMap();

    @NotNull
    public final Map<JsFunction, String> getFunctionName() {
        return this.functionName;
    }

    public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        JsExpression jsExpression = x.getExpression();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "x.expression");
        JsExpression expression2 = jsExpression;
        Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(expression2);
        if (assignment != null) {
            JsExpression lhs = assignment.component1();
            JsExpression rhs = assignment.component2();
            Intrinsics.checkNotNullExpressionValue(rhs, "rhs");
            FunctionWithWrapper functionWithWrapper = InlineMetadata.Companion.tryExtractFunction(rhs);
            if (functionWithWrapper != null) {
                FunctionWithWrapper wrapper = functionWithWrapper;
                boolean bl = false;
                JsFunction function2 = wrapper.getFunction();
                HasMetadata hasMetadata = lhs instanceof JsNameRef ? (JsNameRef)lhs : null;
                if (hasMetadata == null || (hasMetadata = ((JsNameRef)hasMetadata).getName()) == null) {
                    hasMetadata = function2.getName();
                }
                String name = hasMetadata != null ? ((JsName)hasMetadata).getIdent() : null;
                this.functionName.put(function2, name);
            }
        } else if (expression2 instanceof JsFunction) {
            Map<JsFunction, String> map = this.functionName;
            JsExpression jsExpression2 = expression2;
            JsName jsName = ((JsFunction)expression2).getName();
            String string2 = jsName != null ? jsName.getIdent() : null;
            map.put((JsFunction)jsExpression2, string2);
        }
        return super.visit(x, ctx);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        if (MetadataProperties.isInlineableCoroutineBody(x)) {
            x.setBody((JsBlock)InlineCoroutineUtilKt.transformCoroutineMetadataToSpecialFunctions((JsNode)x.getBody()));
        }
        if (MetadataProperties.getCoroutineMetadata(x) != null) {
            this.getLastStatementLevelContext().addPrevious(new CoroutineFunctionTransformer(x, this.functionName.get(x)).transform());
            MetadataProperties.setCoroutineMetadata(x, null);
        }
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        block1: {
            Intrinsics.checkNotNullParameter(x, "x");
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            JsExpression initExpression = x.getInitExpression();
            if (initExpression == null) break block1;
            FunctionWithWrapper functionWithWrapper = InlineMetadata.Companion.tryExtractFunction(initExpression);
            if (functionWithWrapper != null) {
                FunctionWithWrapper wrapper = functionWithWrapper;
                boolean bl = false;
                this.functionName.put(wrapper.getFunction(), x.getName().getIdent());
            }
        }
        return super.visit(x, ctx);
    }
}

