/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DelegateFieldsMapKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationArgumentMapping;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirEmptyExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirDelegatedMemberScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;
import org.jetbrains.kotlin.resolve.AnnotationTargetLists;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;
import org.jetbrains.kotlin.util.ImplementationStatus;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00c2\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u000206H\u0000\u001a@\u00107\u001a\u0002012\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u0002032\u0006\u00104\u001a\u00020\t2\u0006\u0010=\u001a\u00020\r2\u0006\u00105\u001a\u0002062\u0006\u0010>\u001a\u00020\u0011\u001a\u0018\u0010?\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010+2\b\u0010A\u001a\u0004\u0018\u00010B\u001a\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010=\u001a\u00020DH\u0002\u001a\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\b\u001a\u001e\u0010H\u001a\u00020\u00112\u0006\u00104\u001a\u00020I2\u0006\u0010J\u001a\u0002092\u0006\u0010K\u001a\u000209\u001a\u0014\u0010L\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010M\u001a\u00020\b\u001a\u0018\u0010N\u001a\u0010\u0012\u0004\u0012\u00020B\u0012\u0006\u0012\u0004\u0018\u00010P0O*\u00020Q\u001a \u0010R\u001a\b\u0012\u0004\u0012\u00020!0+*\u00020!2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V\u001a\u0018\u0010R\u001a\b\u0012\u0004\u0012\u00020!0+*\u00020!2\u0006\u00104\u001a\u00020\t\u001a\n\u0010W\u001a\u00020\u0011*\u00020X\u001a\f\u0010Y\u001a\u0004\u0018\u00010Q*\u00020\t\u001a\u0014\u0010Z\u001a\u0004\u0018\u00010B*\u00020Q2\u0006\u00104\u001a\u00020\t\u001a \u0010[\u001a\u0004\u0018\u00010\\*\u0006\u0012\u0002\b\u00030-2\u0006\u0010]\u001a\u00020\u00012\u0006\u0010S\u001a\u00020T\u001a\u0018\u0010^\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u00020\b2\u0006\u0010S\u001a\u00020T\u001a\u001c\u0010^\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030-2\u0006\u0010S\u001a\u00020T\u001a\u001c\u0010_\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030`2\u0006\u0010S\u001a\u00020T\u001a\"\u0010a\u001a\u00020b*\u0006\u0012\u0002\b\u00030c2\u0006\u0010d\u001a\u00020e2\n\u0010f\u001a\u0006\u0012\u0002\b\u00030`\u001a\u0012\u0010g\u001a\u000209*\u0002092\u0006\u0010S\u001a\u00020T\u001a\u001a\u0010h\u001a\u00020\u0011*\u00020\b2\u0006\u0010]\u001a\u00020\u00012\u0006\u0010S\u001a\u00020T\u001a\u001e\u0010h\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030-2\u0006\u0010]\u001a\u00020\u00012\u0006\u0010S\u001a\u00020T\u001a\f\u0010i\u001a\u00020\u0011*\u00020\bH\u0002\u001a\u0012\u0010j\u001a\u00020k*\u00020l2\u0006\u00104\u001a\u00020\t\u001a\u000e\u0010m\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030n\u001a\u0012\u0010o\u001a\u00020\u0011*\u00020l2\u0006\u0010S\u001a\u00020T\u001a\u0012\u0010p\u001a\u00020\u0011*\u0002092\u0006\u0010S\u001a\u00020T\u001a4\u0010q\u001a\u00020\u0011*\u0002092\u0016\u0010r\u001a\u0012\u0012\u0004\u0012\u0002090sj\b\u0012\u0004\u0012\u000209`t2\u0006\u0010S\u001a\u00020T2\u0006\u0010u\u001a\u00020\u0011H\u0002\u001a\u0012\u0010q\u001a\u00020\u0011*\u0002092\u0006\u0010S\u001a\u00020T\u001a\u0012\u0010v\u001a\u00020\u0011*\u0002092\u0006\u0010S\u001a\u00020T\u001a\u0012\u0010w\u001a\u00020\u0011*\u0002092\u0006\u0010S\u001a\u00020T\u001a\"\u0010x\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030`2\n\u0010y\u001a\u0006\u0012\u0002\b\u00030`2\u0006\u0010S\u001a\u00020T\u001a\u001c\u0010x\u001a\u00020\u0011*\u00020z2\u0006\u00104\u001a\u00020{2\b\u0010|\u001a\u0004\u0018\u00010z\u001a\u0012\u0010}\u001a\u00020\u0011*\u0002092\u0006\u0010S\u001a\u00020T\u001a\u0013\u0010~\u001a\u00020\u0011*\u00020\u007f2\u0007\u0010\u0080\u0001\u001a\u00020Q\u001a\u001a\u0010~\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030c2\n\u0010f\u001a\u0006\u0012\u0002\b\u00030`\u001a\r\u0010\u0081\u0001\u001a\u0004\u0018\u00010k*\u00020Q\u001a\u001d\u0010\u0082\u0001\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00042\u0006\u00104\u001a\u00020\t\u001a+\u0010\u0083\u0001\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030n0+*\u00030\u0084\u00012\u000b\u0010\u0085\u0001\u001a\u0006\u0012\u0002\b\u00030`2\u0006\u00104\u001a\u00020\t\u001a*\u0010\u0083\u0001\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030n0+*\u00020!2\u000b\u0010\u0085\u0001\u001a\u0006\u0012\u0002\b\u00030`2\u0006\u00104\u001a\u00020\t\u001a\u0016\u0010\u0086\u0001\u001a\u00020\u0011*\u00030\u0087\u00012\u0006\u0010d\u001a\u00020eH\u0002\u001a\u0019\u0010\u0088\u0001\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u00020B2\u0006\u0010S\u001a\u00020T\u001a\u0016\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u0001*\u00020B2\u0006\u0010S\u001a\u00020T\u001a\u0014\u0010\u008b\u0001\u001a\u00030\u008c\u0001*\u00020Q2\u0006\u00104\u001a\u00020\t\u001a\u0018\u0010\u008b\u0001\u001a\u00030\u008c\u0001*\u0006\u0012\u0002\b\u00030`2\u0006\u00104\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u0006\u0012\u0002\b\u00030\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001a\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u0011*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\u0011*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\"\u0015\u0010\u001b\u001a\u00020\u0011*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001d\"\u0015\u0010\u001e\u001a\u00020\u0011*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0018\u0010 \u001a\u00020\u0011*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u0018\u0010$\u001a\u00020\u0011*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#\"\u0018\u0010&\u001a\u00020\u0011*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010#\"\u0018\u0010(\u001a\u00020\u0011*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010#\"!\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+*\u0006\u0012\u0002\b\u00030-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/*\u000f\b\u0002\u0010\u008d\u0001\"\u00030\u008e\u00012\u00030\u008e\u0001\u00a8\u0006\u008f\u0001"}, d2={"INLINE_ONLY_ANNOTATION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "classKind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getClassKind", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Lorg/jetbrains/kotlin/descriptors/ClassKind;", "closestNonLocal", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getClosestNonLocal", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "defaultValueForParameter", "Lorg/jetbrains/kotlin/KtSourceElement;", "getDefaultValueForParameter", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/KtSourceElement;", "hasValOrVar", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getHasValOrVar", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Z", "isConflictingOrNotInvariant", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Z", "isDelegated", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/Name;)Z", "isIterator", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "isTopLevel", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "matchesDataClassSyntheticMemberSignatures", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "typeParameterSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getTypeParameterSymbols", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Ljava/util/List;", "checkCondition", "", "condition", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "context", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkTypeMismatch", "lValueOriginalType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "assignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "rValue", "source", "isInitializer", "extractArgumentsTypeRefAndSource", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirTypeRefSource;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "findDefaultValue", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "getActualTargetList", "Lorg/jetbrains/kotlin/resolve/AnnotationTargetList;", "annotated", "isSubtypeForTypeMismatch", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "subtype", "supertype", "closestNonLocalWith", "declaration", "collectSupertypesWithDelegates", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "directOverriddenFunctions", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "explicitReceiverIsNotSuperReference", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "findClosestClassOrObject", "findNonInterfaceSupertype", "getAnnotationStringParameter", "", "classId", "getContainingClassSymbol", "getContainingDeclarationSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getImplementationStatus", "Lorg/jetbrains/kotlin/util/ImplementationStatus;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "parentClassSymbol", "getInlineClassUnderlyingType", "hasAnnotationOrInsideAnnotatedClass", "hasBody", "implicitModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isFunctionForExpectTypeFromCastFeature", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "isInlineOnly", "isRecursiveSingleFieldValueClassType", "isRecursiveValueClassType", "visited", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "onlyInline", "isSingleFieldValueClass", "isSubtypeOfThrowable", "isSupertypeOf", "other", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "isValueClass", "isVisibleInClass", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "parentClass", "modality", "outerClassSymbol", "overriddenFunctions", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "containingClass", "subjectToManyNotImplemented", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirIntersectionCallableSymbol;", "toClassLikeSymbol", "toRegularClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "unsubstitutedScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "TargetLists", "Lorg/jetbrains/kotlin/resolve/AnnotationTargetLists;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirHelpersKt\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 7 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 8 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,742:1\n21#2,4:743\n66#3:747\n106#3:754\n24#3:762\n24#3:763\n24#3:764\n72#3:787\n40#3:788\n20#3,2:789\n63#3:791\n15#3:792\n13#3:793\n1#4:748\n288#5,2:749\n1747#5,3:751\n1559#5:755\n1590#5,4:756\n1747#5,2:765\n1749#5:782\n2624#5,2:783\n2626#5:786\n1747#5,3:794\n959#5,7:812\n959#5,7:819\n11#6:760\n40#6:761\n12#6:781\n12#6:785\n35#6:797\n63#6:798\n50#6:799\n35#6:800\n76#6:801\n88#7,4:767\n72#7:771\n60#7,7:772\n92#7,2:779\n483#8,4:802\n489#8,6:806\n*S KotlinDebug\n*F\n+ 1 FirHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirHelpersKt\n*L\n58#1:743,4\n95#1:747\n148#1:754\n310#1:762\n311#1:763\n314#1:764\n360#1:787\n364#1:788\n369#1:789,2\n372#1:791\n373#1:792\n386#1:793\n112#1:749,2\n116#1:751,3\n211#1:755\n211#1:756,4\n342#1:765,2\n342#1:782\n349#1:783,2\n349#1:786\n586#1:794,3\n721#1:812,7\n724#1:819,7\n219#1:760\n296#1:761\n345#1:781\n352#1:785\n599#1:797\n599#1:798\n599#1:799\n603#1:800\n635#1:801\n344#1:767,4\n344#1:771\n344#1:772,7\n344#1:779,2\n676#1:802,4\n698#1:806,6\n*E\n"})
public final class FirHelpersKt {
    @NotNull
    private static final ClassId INLINE_ONLY_ANNOTATION_CLASS_ID;

    @NotNull
    public static final FirTypeScope unsubstitutedScope(@NotNull FirClass $this$unsubstitutedScope, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$unsubstitutedScope, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return FirKotlinScopeProviderKt.unsubstitutedScope($this$unsubstitutedScope, context.getSessionHolder().getSession(), context.getSessionHolder().getScopeSession(), false);
    }

    @NotNull
    public static final FirTypeScope unsubstitutedScope(@NotNull FirClassSymbol<?> $this$unsubstitutedScope, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$unsubstitutedScope, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return FirKotlinScopeProviderKt.unsubstitutedScope($this$unsubstitutedScope, context.getSessionHolder().getSession(), context.getSessionHolder().getScopeSession(), false);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> toClassLikeSymbol(@NotNull FirTypeRef $this$toClassLikeSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toClassLikeSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirTypeRef $this$coneTypeSafe$iv = $this$toClassLikeSymbol;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
        return coneClassLikeType != null ? TypeUtilsKt.toSymbol(coneClassLikeType, session2) : null;
    }

    public static final boolean isSupertypeOf(@NotNull FirClassSymbol<?> $this$isSupertypeOf, @NotNull FirClassSymbol<?> other, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf, session2, other, new LinkedHashSet());
    }

    public static final boolean isValueClass(@NotNull ConeKotlinType $this$isValueClass, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isValueClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol($this$isValueClass, session2);
        if (firRegularClassSymbol != null) {
            FirClassSymbol $this$isInline$iv = firRegularClassSymbol;
            boolean $i$f$isInline = false;
            bl = $this$isInline$iv.getRawStatus().isInline();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isSingleFieldValueClass(@NotNull ConeKotlinType $this$isSingleFieldValueClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isSingleFieldValueClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeInferenceContext $this$isSingleFieldValueClass_u24lambda_u240 = TypeComponentsKt.getTypeContext(session2);
        boolean bl = false;
        return FirHelpersKt.isRecursiveSingleFieldValueClassType($this$isSingleFieldValueClass, session2) || $this$isSingleFieldValueClass_u24lambda_u240.isInlineClass($this$isSingleFieldValueClass_u24lambda_u240.typeConstructor($this$isSingleFieldValueClass));
    }

    public static final boolean isRecursiveSingleFieldValueClassType(@NotNull ConeKotlinType $this$isRecursiveSingleFieldValueClassType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isRecursiveSingleFieldValueClassType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.isRecursiveValueClassType($this$isRecursiveSingleFieldValueClassType, new HashSet<ConeKotlinType>(), session2, true);
    }

    public static final boolean isRecursiveValueClassType(@NotNull ConeKotlinType $this$isRecursiveValueClassType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isRecursiveValueClassType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.isRecursiveValueClassType($this$isRecursiveValueClassType, new HashSet<ConeKotlinType>(), session2, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRecursiveValueClassType(ConeKotlinType $this$isRecursiveValueClassType, HashSet<ConeKotlinType> visited2, FirSession session2, boolean onlyInline) {
        boolean bl;
        boolean bl2;
        block8: {
            Object v3;
            block7: {
                void $this$firstOrNull$iv;
                FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol($this$isRecursiveValueClassType, session2);
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol;
                if (firRegularClassSymbol == null) return false;
                Object object = firRegularClassSymbol2;
                FirRegularClassSymbol it = object;
                boolean bl3 = false;
                if (!org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.isInlineOrValueClass(it)) return false;
                FirRegularClassSymbol firRegularClassSymbol3 = object;
                firRegularClassSymbol2 = firRegularClassSymbol3;
                if (firRegularClassSymbol3 == null) {
                    return false;
                }
                FirRegularClassSymbol asRegularClass = firRegularClassSymbol2;
                object = asRegularClass.getDeclarationSymbols();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirBasedSymbol it2 = (FirBasedSymbol)element$iv;
                    boolean bl4 = false;
                    if (!(it2 instanceof FirConstructorSymbol && ((FirConstructorSymbol)it2).isPrimary())) continue;
                    v3 = element$iv;
                    break block7;
                }
                v3 = null;
            }
            FirConstructorSymbol firConstructorSymbol = v3;
            if (firConstructorSymbol == null) {
                return false;
            }
            FirConstructorSymbol primaryConstructor2 = firConstructorSymbol;
            if (primaryConstructor2.getValueParameterSymbols().size() > 1 && onlyInline) {
                return false;
            }
            if (!visited2.add($this$isRecursiveValueClassType)) return true;
            Iterable $this$any$iv = primaryConstructor2.getValueParameterSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl5 = false;
                    if (!FirHelpersKt.isRecursiveValueClassType(FirTypeUtilsKt.getConeType(it.getResolvedReturnTypeRef()), visited2, session2, onlyInline)) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
        }
        boolean it = bl = bl2;
        boolean bl6 = false;
        visited2.remove($this$isRecursiveValueClassType);
        if (!bl) return false;
        return true;
    }

    @Nullable
    public static final FirRegularClassSymbol toRegularClassSymbol(@NotNull FirTypeRef $this$toRegularClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toRegularClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType($this$toRegularClassSymbol), session2);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> getContainingClassSymbol(@NotNull FirBasedSymbol<?> $this$getContainingClassSymbol, @NotNull FirSession session2) {
        FirClassLikeSymbol<Object> firClassLikeSymbol;
        Intrinsics.checkNotNullParameter($this$getContainingClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirBasedSymbol<?> firBasedSymbol = $this$getContainingClassSymbol;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)$this$getContainingClassSymbol);
            firClassLikeSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2) : null;
        } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = FirVisibilityCheckerKt.getContainingClassLookupTag((FirClassLikeSymbol)$this$getContainingClassSymbol);
            firClassLikeSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2) : null;
        } else {
            firClassLikeSymbol = null;
        }
        return firClassLikeSymbol;
    }

    @Nullable
    public static final FirClassLikeSymbol<?> getContainingClassSymbol(@NotNull FirDeclaration $this$getContainingClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getContainingClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.getContainingClassSymbol($this$getContainingClassSymbol.getSymbol(), session2);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> outerClassSymbol(@NotNull FirClassLikeSymbol<?> $this$outerClassSymbol, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$outerClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!($this$outerClassSymbol instanceof FirClassSymbol)) {
            return null;
        }
        return FirHelpersKt.getContainingDeclarationSymbol((FirClassSymbol)$this$outerClassSymbol, context.getSession());
    }

    @Nullable
    public static final FirClassLikeSymbol<?> getContainingDeclarationSymbol(@NotNull FirClassSymbol<?> $this$getContainingDeclarationSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getContainingDeclarationSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirClassLikeSymbol $this$isLocal$iv = $this$getContainingDeclarationSymbol;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getClassId().isLocal()) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.getContainingClassForLocalAttr((FirRegularClass)((FirRegularClassSymbol)$this$getContainingDeclarationSymbol).getFir());
            return coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, session2) : null;
        }
        FqName fqName2 = $this$getContainingDeclarationSymbol.getClassId().getRelativeClassName().parent();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.relativeClassName.parent()");
        FqName parentId = fqName2;
        if (!parentId.isRoot()) {
            ClassId containingDeclarationId = new ClassId($this$getContainingDeclarationSymbol.getClassId().getPackageFqName(), parentId, false);
            return FirSymbolProviderKt.getSymbolProvider(session2).getClassLikeSymbolByClassId(containingDeclarationId);
        }
        return null;
    }

    @Nullable
    public static final FirClass findClosestClassOrObject(@NotNull CheckerContext $this$findClosestClassOrObject) {
        Intrinsics.checkNotNullParameter($this$findClosestClassOrObject, "<this>");
        for (FirDeclaration it : CollectionsKt.asReversed($this$findClosestClassOrObject.getContainingDeclarations())) {
            if (!(it instanceof FirRegularClass) && !(it instanceof FirAnonymousObject)) continue;
            return (FirClass)it;
        }
        return null;
    }

    @NotNull
    public static final List<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirSimpleFunction $this$overriddenFunctions, @NotNull FirClassSymbol<?> containingClass, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$overriddenFunctions, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context, "context");
        return FirHelpersKt.overriddenFunctions($this$overriddenFunctions.getSymbol(), containingClass, context);
    }

    @NotNull
    public static final List<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirNamedFunctionSymbol $this$overriddenFunctions, @NotNull FirClassSymbol<?> containingClass, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$overriddenFunctions, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context, "context");
        FirTypeScope firTypeScope = FirKotlinScopeProviderKt.unsubstitutedScope(containingClass, context.getSessionHolder().getSession(), context.getSessionHolder().getScopeSession(), true);
        List overriddenFunctions2 = new ArrayList();
        firTypeScope.processFunctionsByName($this$overriddenFunctions.getCallableId().getCallableName(), overriddenFunctions.1.INSTANCE);
        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, $this$overriddenFunctions, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)new Function1<FirNamedFunctionSymbol, ProcessorAction>(overriddenFunctions2){
            final /* synthetic */ List<FirFunctionSymbol<?>> $overriddenFunctions;
            {
                this.$overriddenFunctions = $overriddenFunctions;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$overriddenFunctions.add(it);
                return ProcessorAction.NEXT;
            }
        });
        return overriddenFunctions2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<FirTypeRef, FirFieldSymbol> collectSupertypesWithDelegates(@NotNull FirClass $this$collectSupertypesWithDelegates) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$collectSupertypesWithDelegates, "<this>");
        Map<Integer, FirFieldSymbol> map = DelegateFieldsMapKt.getDelegateFieldsMap($this$collectSupertypesWithDelegates);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map<Integer, FirFieldSymbol> fieldsMap = map;
        Iterable $this$mapIndexed$iv = $this$collectSupertypesWithDelegates.getSuperTypeRefs();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void it;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it, fieldsMap.get((int)index2)));
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }

    @Nullable
    public static final Modality modality(@NotNull FirClass $this$modality) {
        Modality modality;
        Intrinsics.checkNotNullParameter($this$modality, "<this>");
        if ($this$modality instanceof FirRegularClass) {
            FirMemberDeclaration $this$modality$iv = $this$modality;
            boolean $i$f$getModality = false;
            modality = $this$modality$iv.getStatus().getModality();
        } else {
            modality = Modality.FINAL;
        }
        return modality;
    }

    @NotNull
    public static final Modality implicitModality(@NotNull FirMemberDeclaration $this$implicitModality, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$implicitModality, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        if ($this$implicitModality instanceof FirRegularClass && (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.CLASS || ((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.OBJECT)) {
            if (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.INTERFACE) {
                return Modality.ABSTRACT;
            }
            return Modality.FINAL;
        }
        FirClass firClass = FirHelpersKt.findClosestClassOrObject(context);
        if (firClass == null) {
            return Modality.FINAL;
        }
        FirClass klass = firClass;
        KtSourceElement ktSourceElement = $this$implicitModality.getSource();
        if (ktSourceElement == null) {
            return Modality.FINAL;
        }
        KtSourceElement source = ktSourceElement;
        FlyweightCapableTreeStructure<LighterASTNode> tree = source.getTreeStructure();
        if (LightTreePositioningStrategiesKt.overrideModifier(tree, source.getLighterASTNode()) != null) {
            IElementType klassModalityTokenType;
            IElementType iElementType;
            KtSourceElement ktSourceElement2 = klass.getSource();
            if (ktSourceElement2 != null) {
                KtSourceElement it = ktSourceElement2;
                boolean bl = false;
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.modalityModifier(tree, it.getLighterASTNode());
                iElementType = lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null;
            } else {
                iElementType = klassModalityTokenType = null;
            }
            if (Intrinsics.areEqual(klassModalityTokenType, KtTokens.ABSTRACT_KEYWORD) || Intrinsics.areEqual(klassModalityTokenType, KtTokens.OPEN_KEYWORD) || Intrinsics.areEqual(klassModalityTokenType, KtTokens.SEALED_KEYWORD)) {
                return Modality.OPEN;
            }
        }
        if (klass instanceof FirRegularClass && klass.getClassKind() == ClassKind.INTERFACE) {
            LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.visibilityModifier(tree, source.getLighterASTNode());
            if (!Intrinsics.areEqual(lighterASTNode3 != null ? lighterASTNode3.getTokenType() : null, KtTokens.PRIVATE_KEYWORD)) {
                return FirHelpersKt.hasBody($this$implicitModality) ? Modality.OPEN : Modality.ABSTRACT;
            }
        }
        return Modality.FINAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasBody(FirDeclaration $this$hasBody) {
        FirDeclaration firDeclaration = $this$hasBody;
        if (firDeclaration instanceof FirSimpleFunction) {
            if (((FirSimpleFunction)$this$hasBody).getBody() == null) return false;
            if (((FirSimpleFunction)$this$hasBody).getBody() instanceof FirEmptyExpressionBlock) return false;
            return true;
        }
        if (!(firDeclaration instanceof FirProperty)) return false;
        FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$hasBody).getSetter();
        FirBlock firBlock = firPropertyAccessor != null ? firPropertyAccessor.getBody() : null;
        if (!(firBlock == null ? true : firBlock instanceof FirEmptyExpressionBlock)) return true;
        FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$hasBody).getGetter();
        if (firPropertyAccessor2 == null) return false;
        FirBlock firBlock2 = firPropertyAccessor2.getBody();
        if (firBlock2 == null) {
            return false;
        }
        boolean bl = firBlock2 instanceof FirEmptyExpressionBlock;
        if (bl) return false;
        return true;
    }

    @Nullable
    public static final FirTypeRef findNonInterfaceSupertype(@NotNull FirClass $this$findNonInterfaceSupertype, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$findNonInterfaceSupertype, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        for (FirTypeRef superTypeRef : $this$findNonInterfaceSupertype.getSuperTypeRefs()) {
            FirClassSymbol symbol2;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(superTypeRef);
            Object object = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) continue;
            Object lookupTag2 = object;
            FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)lookupTag2, context.getSession());
            FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
            if (firClassSymbol == null || (symbol2 = firClassSymbol).getClassKind() == ClassKind.INTERFACE) continue;
            return superTypeRef;
        }
        return null;
    }

    public static final boolean isIterator(@NotNull FirFunctionCall $this$isIterator) {
        Intrinsics.checkNotNullParameter($this$isIterator, "<this>");
        return Intrinsics.areEqual($this$isIterator.getCalleeReference().getName(), SpecialNames.ITERATOR);
    }

    public static final boolean isSubtypeOfThrowable(@NotNull ConeKotlinType $this$isSubtypeOfThrowable, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOfThrowable, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.isSupertypeOf(session2.getBuiltinTypes().getThrowableType().getType(), TypeComponentsKt.getTypeContext(session2), TypeExpansionUtilsKt.fullyExpandedType($this$isSubtypeOfThrowable, session2));
    }

    public static final boolean getHasValOrVar(@NotNull FirValueParameter $this$hasValOrVar) {
        Intrinsics.checkNotNullParameter($this$hasValOrVar, "<this>");
        KtSourceElement ktSourceElement = $this$hasValOrVar.getSource();
        if (ktSourceElement == null) {
            return false;
        }
        KtSourceElement source = ktSourceElement;
        TokenSet tokenSet = KtParameter.VAL_VAR_TOKEN_SET;
        Intrinsics.checkNotNullExpressionValue(tokenSet, "VAL_VAR_TOKEN_SET");
        return FirSourceUtilsKt.getChild$default(source, tokenSet, 0, 0, false, 14, null) != null;
    }

    public static final boolean isSupertypeOf(@NotNull KotlinTypeMarker $this$isSupertypeOf, @NotNull TypeCheckerProviderContext context, @Nullable KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return type2 != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context, type2, $this$isSupertypeOf, false, 8, null);
    }

    public static final boolean isInlineOnly(@NotNull FirMemberDeclaration $this$isInlineOnly, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isInlineOnly, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirMemberDeclaration $this$isInline$iv = $this$isInlineOnly;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getStatus().isInline() && FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)$this$isInlineOnly, INLINE_ONLY_ANNOTATION_CLASS_ID, session2);
    }

    public static final boolean isSubtypeForTypeMismatch(@NotNull ConeInferenceContext context, @NotNull ConeKotlinType subtype, @NotNull ConeKotlinType supertype2) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        ConeKotlinType subtypeFullyExpanded = TypeExpansionUtilsKt.fullyExpandedType(subtype, context.getSession());
        ConeKotlinType supertypeFullyExpanded = TypeExpansionUtilsKt.fullyExpandedType(supertype2, context.getSession());
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context, (KotlinTypeMarker)subtypeFullyExpanded, (KotlinTypeMarker)supertypeFullyExpanded, false, 8, null);
    }

    public static final boolean isVisibleInClass(@NotNull FirCallableDeclaration $this$isVisibleInClass, @NotNull FirClass parentClass) {
        Intrinsics.checkNotNullParameter($this$isVisibleInClass, "<this>");
        Intrinsics.checkNotNullParameter(parentClass, "parentClass");
        return FirHelpersKt.isVisibleInClass($this$isVisibleInClass.getSymbol(), parentClass.getSymbol());
    }

    public static final boolean isVisibleInClass(@NotNull FirCallableSymbol<?> $this$isVisibleInClass, @NotNull FirClassSymbol<?> parentClassSymbol) {
        boolean $i$f$getVisibility;
        FirCallableSymbol<?> $this$visibility$iv;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$isVisibleInClass, "<this>");
                Intrinsics.checkNotNullParameter(parentClassSymbol, "parentClassSymbol");
                FqName fqName2 = parentClassSymbol.getClassId().getPackageFqName();
                Intrinsics.checkNotNullExpressionValue(fqName2, "parentClassSymbol.classId.packageFqName");
                FqName classPackage = fqName2;
                $this$visibility$iv = $this$isVisibleInClass;
                $i$f$getVisibility = false;
                if (Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility(), Visibilities.Private.INSTANCE)) break block2;
                $this$visibility$iv = $this$isVisibleInClass;
                $i$f$getVisibility = false;
                if ($this$visibility$iv.getResolvedStatus().getVisibility().visibleFromPackage(classPackage, $this$isVisibleInClass.getCallableId().getPackageName())) break block3;
            }
            return false;
        }
        $this$visibility$iv = $this$isVisibleInClass;
        $i$f$getVisibility = false;
        return !Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility(), Visibilities.Internal.INSTANCE) || Intrinsics.areEqual($this$isVisibleInClass.getModuleData(), parentClassSymbol.getModuleData()) && !$this$isVisibleInClass.getModuleData().getFriendDependencies().contains(parentClassSymbol.getModuleData());
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final ImplementationStatus getImplementationStatus(@NotNull FirCallableSymbol<?> $this$getImplementationStatus, @NotNull SessionHolder sessionHolder, @NotNull FirClassSymbol<?> parentClassSymbol) {
        block23: {
            block24: {
                block22: {
                    block19: {
                        block18: {
                            block21: {
                                block17: {
                                    block20: {
                                        Intrinsics.checkNotNullParameter($this$getImplementationStatus, "<this>");
                                        Intrinsics.checkNotNullParameter(sessionHolder, "sessionHolder");
                                        Intrinsics.checkNotNullParameter(parentClassSymbol, "parentClassSymbol");
                                        containingClassSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$getImplementationStatus, sessionHolder.getSession());
                                        symbol = $this$getImplementationStatus;
                                        if (Intrinsics.areEqual(FirDelegatedMemberScopeKt.getMultipleDelegatesWithTheSameSignature($this$getImplementationStatus), true) && Intrinsics.areEqual(containingClassSymbol, parentClassSymbol)) {
                                            return ImplementationStatus.AMBIGUOUSLY_INHERITED;
                                        }
                                        if (!(symbol instanceof FirIntersectionCallableSymbol)) break block19;
                                        if (containingClassSymbol == parentClassSymbol && FirHelpersKt.subjectToManyNotImplemented((FirIntersectionCallableSymbol)symbol, sessionHolder)) {
                                            return ImplementationStatus.AMBIGUOUSLY_INHERITED;
                                        }
                                        $this$any$iv = ((FirIntersectionCallableSymbol)symbol).getIntersections();
                                        $i$f$any = false;
                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block20;
                                        v0 = false;
                                        break block17;
                                    }
                                    for (T element$iv : $this$any$iv) {
                                        it = (FirCallableSymbol)element$iv;
                                        $i$a$-any-FirHelpersKt$getImplementationStatus$1 = false;
                                        $this$unwrapFakeOverrides$iv = (FirCallableDeclaration)it.getFir();
                                        $i$f$unwrapFakeOverrides = false;
                                        current$iv = $this$unwrapFakeOverrides$iv;
                                        while (true) {
                                            $this$originalIfFakeOverride$iv$iv = current$iv;
                                            $i$f$originalIfFakeOverride = false;
                                            $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                                            $i$f$getOriginalForSubstitutionOverride = false;
                                            v1 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) != false ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
                                            if (v1 == null) {
                                                $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                                                $i$f$getBaseForIntersectionOverride = false;
                                                v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
                                            }
                                            if (v1 == null) break;
                                            current$iv = next$iv = v1;
                                        }
                                        fir = current$iv;
                                        $this$isAbstract$iv = fir;
                                        $i$f$isAbstract = false;
                                        if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) ** GOTO lbl-1000
                                        $i$f$isAbstract = FirHelpersKt.getContainingClassSymbol(fir, sessionHolder.getSession());
                                        v2 = $i$f$isAbstract instanceof FirRegularClassSymbol != false ? (FirRegularClassSymbol)$i$f$isAbstract : null;
                                        if ((v2 != null ? v2.getClassKind() : null) == ClassKind.CLASS) {
                                            v3 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v3 = false;
                                        }
                                        if (!v3) continue;
                                        v0 = true;
                                        break block17;
                                    }
                                    v0 = false;
                                }
                                if (!v0) break block19;
                                $this$none$iv = ((FirIntersectionCallableSymbol)symbol).getIntersections();
                                $i$f$none = false;
                                if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block21;
                                v4 = true;
                                break block18;
                            }
                            for (T element$iv : $this$none$iv) {
                                it = (FirCallableSymbol)element$iv;
                                $i$a$-none-FirHelpersKt$getImplementationStatus$2 = false;
                                fir = (FirCallableDeclaration)it.getFir();
                                if (!Intrinsics.areEqual(fir.getOrigin(), FirDeclarationOrigin.Delegated.INSTANCE)) ** GOTO lbl-1000
                                $this$isAbstract$iv = fir;
                                $i$f$isAbstract = false;
                                if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) {
                                    v5 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v5 = false;
                                }
                                if (!v5) continue;
                                v4 = false;
                                break block18;
                            }
                            v4 = true;
                        }
                        if (v4) {
                            return ImplementationStatus.NOT_IMPLEMENTED;
                        }
                    }
                    if ($this$getImplementationStatus instanceof FirNamedFunctionSymbol) {
                        if (parentClassSymbol instanceof FirRegularClassSymbol) {
                            $this$isData$iv = parentClassSymbol;
                            $i$f$isData = false;
                            if ($this$isData$iv.getRawStatus().isData() && FirHelpersKt.getMatchesDataClassSyntheticMemberSignatures((FirNamedFunctionSymbol)$this$getImplementationStatus)) {
                                return ImplementationStatus.INHERITED_OR_SYNTHESIZED;
                            }
                        }
                        $this$isSuspend$iv = $this$getImplementationStatus;
                        $i$f$isSuspend = false;
                        if ($this$isSuspend$iv.getRawStatus().isSuspend()) {
                            return ImplementationStatus.INHERITED_OR_SYNTHESIZED;
                        }
                    }
                    $this$isFinal$iv = $this$getImplementationStatus;
                    $i$f$isFinal = false;
                    v6 = $this$isFinal$iv.getResolvedStatus().getModality();
                    if (!(v6 == null ? true : (modality$iv = v6) == Modality.FINAL)) break block22;
                    v7 = ImplementationStatus.CANNOT_BE_IMPLEMENTED;
                    break block23;
                }
                if (containingClassSymbol != parentClassSymbol || !Intrinsics.areEqual($this$getImplementationStatus.getOrigin(), FirDeclarationOrigin.Source.INSTANCE) && !Intrinsics.areEqual($this$getImplementationStatus.getOrigin(), FirDeclarationOrigin.Precompiled.INSTANCE)) break block24;
                v7 = ImplementationStatus.ALREADY_IMPLEMENTED;
                break block23;
            }
            if (!(containingClassSymbol instanceof FirRegularClassSymbol)) ** GOTO lbl-1000
            $this$isExpect$iv = (FirClassSymbol)containingClassSymbol;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getResolvedStatus().isExpect()) {
                v7 = ImplementationStatus.CANNOT_BE_IMPLEMENTED;
            } else lbl-1000:
            // 2 sources

            {
                $this$isAbstract$iv = $this$getImplementationStatus;
                $i$f$isAbstract = false;
                v7 = $this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT != false ? ImplementationStatus.NOT_IMPLEMENTED : ImplementationStatus.INHERITED_OR_SYNTHESIZED;
            }
        }
        return v7;
    }

    private static final boolean subjectToManyNotImplemented(FirIntersectionCallableSymbol $this$subjectToManyNotImplemented, SessionHolder sessionHolder) {
        int nonAbstractCountInClass = 0;
        int nonAbstractCountInInterface = 0;
        int abstractCountInInterface = 0;
        for (FirCallableSymbol<?> intersectionSymbol : $this$subjectToManyNotImplemented.getIntersections()) {
            FirRegularClassSymbol containingClassSymbol;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)intersectionSymbol, sessionHolder.getSession());
            FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            boolean hasInterfaceContainer = (firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.INTERFACE;
            FirCallableSymbol<?> $this$modality$iv = intersectionSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.ABSTRACT) {
                if (hasInterfaceContainer) {
                    ++nonAbstractCountInInterface;
                } else {
                    ++nonAbstractCountInClass;
                }
            } else if (hasInterfaceContainer) {
                ++abstractCountInInterface;
            }
            if (nonAbstractCountInClass + nonAbstractCountInInterface > 1) {
                return true;
            }
            if (nonAbstractCountInInterface <= 0 || abstractCountInInterface <= 0) continue;
            return true;
        }
        return false;
    }

    private static final boolean getMatchesDataClassSyntheticMemberSignatures(FirNamedFunctionSymbol $this$matchesDataClassSyntheticMemberSignatures) {
        Name name = $this$matchesDataClassSyntheticMemberSignatures.getCallableId().getCallableName();
        return Intrinsics.areEqual(name, OperatorNameConventions.EQUALS) && FirHelpersKt.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual(name, StandardNames.HASHCODE_NAME) && FirHelpersKt.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual(name, OperatorNameConventions.TO_STRING) && FirHelpersKt.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
    }

    private static final boolean getMatchesEqualsSignature(FirNamedFunctionSymbol $this$matchesEqualsSignature) {
        List<FirValueParameterSymbol> valueParameters2 = $this$matchesEqualsSignature.getValueParameterSymbols();
        return valueParameters2.size() == 1 && ConeBuiltinTypeUtilsKt.isNullableAny(FirTypeUtilsKt.getConeType(valueParameters2.get(0).getResolvedReturnTypeRef()));
    }

    private static final boolean getMatchesHashCodeSignature(FirNamedFunctionSymbol $this$matchesHashCodeSignature) {
        return $this$matchesHashCodeSignature.getValueParameterSymbols().isEmpty();
    }

    private static final boolean getMatchesToStringSignature(FirNamedFunctionSymbol $this$matchesToStringSignature) {
        return $this$matchesToStringSignature.getValueParameterSymbols().isEmpty();
    }

    public static final boolean isDelegated(@NotNull Name $this$isDelegated) {
        Intrinsics.checkNotNullParameter($this$isDelegated, "<this>");
        String string2 = $this$isDelegated.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString()");
        return StringsKt.startsWith$default(string2, "$$delegate_", false, 2, null);
    }

    public static final boolean isConflictingOrNotInvariant(@NotNull ConeTypeProjection $this$isConflictingOrNotInvariant) {
        Intrinsics.checkNotNullParameter($this$isConflictingOrNotInvariant, "<this>");
        return $this$isConflictingOrNotInvariant.getKind() != ProjectionKind.INVARIANT || $this$isConflictingOrNotInvariant instanceof ConeKotlinTypeConflictingProjection;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void checkTypeMismatch(@NotNull ConeKotlinType lValueOriginalType, @Nullable FirVariableAssignment assignment, @NotNull FirExpression rValue, @NotNull CheckerContext context, @NotNull KtSourceElement source, @NotNull DiagnosticReporter reporter, boolean isInitializer) {
        ConeInferenceContext typeContext2;
        Intrinsics.checkNotNullParameter(lValueOriginalType, "lValueOriginalType");
        Intrinsics.checkNotNullParameter(rValue, "rValue");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        ConeKotlinType lValueType = lValueOriginalType;
        ConeKotlinType rValueType = FirTypeUtilsKt.getConeType(rValue.getTypeRef());
        if (source.getKind() instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement && !ConeTypeUtilsKt.isNullable(lValueType) && ConeTypeUtilsKt.isNullable(rValueType)) {
            ConeKotlinType tempType = rValueType;
            rValueType = lValueType;
            lValueType = tempType;
        }
        if (FirHelpersKt.isSubtypeForTypeMismatch(typeContext2 = TypeComponentsKt.getTypeContext(context.getSession()), rValueType, lValueType)) return;
        if (rValueType instanceof ConeClassLikeType && Intrinsics.areEqual(((ConeClassLikeType)rValueType).getLookupTag().getClassId(), StandardClassIds.INSTANCE.getInt()) && ConeBuiltinTypeUtilsKt.isIntegerTypeOrNullableIntegerTypeOfAnySize(TypeExpansionUtilsKt.fullyExpandedType(lValueType, context.getSession())) && rValueType.getNullability() == ConeNullability.NOT_NULL) {
            return;
        }
        if (CompilerConeAttributesKt.isExtensionFunctionType(lValueType)) return;
        if (CompilerConeAttributesKt.isExtensionFunctionType(rValueType)) {
            return;
        }
        FirPureAbstractElement firPureAbstractElement = assignment;
        FirCallableSymbol firCallableSymbol = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getCalleeReference()) != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default((FirReference)firPureAbstractElement, false, 1, null) : null;
        FirPropertySymbol resolvedSymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
        if (resolvedSymbol != null && lValueType instanceof ConeCapturedType) {
            ProjectionKind it = ((ConeCapturedType)lValueType).getConstructor().getProjection().getKind();
            boolean bl = false;
            boolean bl2 = it == ProjectionKind.STAR || it == ProjectionKind.OUT;
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)assignment.getSource(), FirErrors.INSTANCE.getSETTER_PROJECTED_OUT(), (Object)resolvedSymbol, (DiagnosticContext)context, null, 16, null);
                return;
            }
        }
        if (FirTypeUtilsKt.isNullLiteral(rValue) && lValueType.getNullability() == ConeNullability.NOT_NULL) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)rValue.getSource(), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        if (isInitializer) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINITIALIZER_TYPE_MISMATCH(), (Object)lValueType, (Object)rValueType, (Object)InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context.getSession()), rValueType, lValueType), (DiagnosticContext)context, null, 64, null);
            return;
        }
        if (!(source.getKind() instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getASSIGNMENT_TYPE_MISMATCH(), (Object)lValueType, (Object)rValueType, (Object)InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context.getSession()), rValueType, lValueType), (DiagnosticContext)context, null, 64, null);
            return;
        }
        if (!ConeTypeUtilsKt.isNullable(lValueType) && ConeTypeUtilsKt.isNullable(rValueType)) {
            ConeKotlinType tempType = rValueType;
            rValueType = lValueType;
            lValueType = tempType;
        }
        if (ConeBuiltinTypeUtilsKt.isUnit(rValueType)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINC_DEC_SHOULD_NOT_RETURN_UNIT(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRESULT_TYPE_MISMATCH(), (Object)lValueType, (Object)rValueType, (DiagnosticContext)context, null, 32, null);
    }

    public static final void checkCondition(@NotNull FirExpression condition, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(condition, "condition");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        ConeSimpleKotlinType coneType = ConeTypeUtilsKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(condition.getTypeRef()));
        if (!(coneType instanceof ConeErrorType) && !TypeUtilsKt.isSubtypeOf((KotlinTypeMarker)coneType, TypeComponentsKt.getTypeContext(context.getSession()), context.getSession().getBuiltinTypes().getBooleanType().getType())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)condition.getSource(), FirErrors.INSTANCE.getCONDITION_TYPE_MISMATCH(), (Object)coneType, (Object)ConeBuiltinTypeUtilsKt.isNullableBoolean(coneType), (DiagnosticContext)context, null, 32, null);
        }
    }

    @Nullable
    public static final List<FirTypeRefSource> extractArgumentsTypeRefAndSource(@Nullable FirTypeRef typeRef) {
        if (!(typeRef instanceof FirResolvedTypeRef)) {
            return null;
        }
        List result2 = new ArrayList();
        FirTypeRef delegatedTypeRef = ((FirResolvedTypeRef)typeRef).getDelegatedTypeRef();
        if (delegatedTypeRef instanceof FirUserTypeRef) {
            List<FirQualifierPart> qualifier2 = ((FirUserTypeRef)delegatedTypeRef).getQualifier();
            for (int i = qualifier2.size() - 1; -1 < i; --i) {
                for (FirTypeProjection typeArgument : qualifier2.get(i).getTypeArgumentList().getTypeArguments()) {
                    FirTypeProjectionWithVariance firTypeProjectionWithVariance = typeArgument instanceof FirTypeProjectionWithVariance ? (FirTypeProjectionWithVariance)typeArgument : null;
                    result2.add(new FirTypeRefSource(firTypeProjectionWithVariance != null ? firTypeProjectionWithVariance.getTypeRef() : null, typeArgument.getSource()));
                }
            }
        } else if (delegatedTypeRef instanceof FirFunctionTypeRef) {
            List<FirFunctionTypeParameter> parameters2 = ((FirFunctionTypeRef)delegatedTypeRef).getParameters();
            FirTypeRef firTypeRef = ((FirFunctionTypeRef)delegatedTypeRef).getReceiverTypeRef();
            if (firTypeRef != null) {
                FirTypeRef it = firTypeRef;
                boolean bl = false;
                result2.add(new FirTypeRefSource(it, it.getSource()));
            }
            for (FirFunctionTypeParameter valueParameter2 : parameters2) {
                FirTypeRef valueParamTypeRef = valueParameter2.getReturnTypeRef();
                result2.add(new FirTypeRefSource(valueParamTypeRef, valueParamTypeRef.getSource()));
            }
            FirTypeRef returnTypeRef = ((FirFunctionTypeRef)delegatedTypeRef).getReturnTypeRef();
            result2.add(new FirTypeRefSource(returnTypeRef, returnTypeRef.getSource()));
        } else {
            return null;
        }
        return result2;
    }

    @Nullable
    public static final ClassKind getClassKind(@NotNull FirClassLikeSymbol<?> $this$classKind) {
        Intrinsics.checkNotNullParameter($this$classKind, "<this>");
        FirClassSymbol firClassSymbol = $this$classKind instanceof FirClassSymbol ? (FirClassSymbol)$this$classKind : null;
        return firClassSymbol != null ? firClassSymbol.getClassKind() : null;
    }

    @Nullable
    public static final List<FirTypeParameterSymbol> getTypeParameterSymbols(@NotNull FirBasedSymbol<?> $this$typeParameterSymbols) {
        Intrinsics.checkNotNullParameter($this$typeParameterSymbols, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$typeParameterSymbols;
        return firBasedSymbol instanceof FirCallableSymbol ? ((FirCallableSymbol)$this$typeParameterSymbols).getTypeParameterSymbols() : (firBasedSymbol instanceof FirClassSymbol ? ((FirClassSymbol)$this$typeParameterSymbols).getTypeParameterSymbols() : (firBasedSymbol instanceof FirTypeAliasSymbol ? ((FirTypeAliasSymbol)$this$typeParameterSymbols).getTypeParameterSymbols() : null));
    }

    public static final boolean isFunctionForExpectTypeFromCastFeature(@NotNull FirFunctionSymbol<?> $this$isFunctionForExpectTypeFromCastFeature) {
        block11: {
            block10: {
                boolean bl;
                FirTypeParameterSymbol typeParameterSymbol;
                block9: {
                    Intrinsics.checkNotNullParameter($this$isFunctionForExpectTypeFromCastFeature, "<this>");
                    FirTypeParameterSymbol firTypeParameterSymbol = CollectionsKt.singleOrNull($this$isFunctionForExpectTypeFromCastFeature.getTypeParameterSymbols());
                    if (firTypeParameterSymbol == null) {
                        return false;
                    }
                    typeParameterSymbol = firTypeParameterSymbol;
                    ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType($this$isFunctionForExpectTypeFromCastFeature.getResolvedReturnTypeRef());
                    ConeSimpleKotlinType coneSimpleKotlinType = ConeTypeUtilsKt.lowerBoundIfFlexible(returnType2);
                    ConeTypeParameterType coneTypeParameterType = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
                    if (!Intrinsics.areEqual(coneTypeParameterType != null ? coneTypeParameterType.getLookupTag() : null, typeParameterSymbol.toLookupTag())) {
                        return false;
                    }
                    Iterable $this$any$iv = $this$isFunctionForExpectTypeFromCastFeature.getValueParameterSymbols();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                            boolean bl2 = false;
                            if (!FirHelpersKt.isFunctionForExpectTypeFromCastFeature$isBadType(it.getResolvedReturnTypeRef(), typeParameterSymbol)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) break block10;
                FirResolvedTypeRef firResolvedTypeRef = $this$isFunctionForExpectTypeFromCastFeature.getResolvedReceiverTypeRef();
                boolean bl3 = firResolvedTypeRef != null ? FirHelpersKt.isFunctionForExpectTypeFromCastFeature$isBadType(firResolvedTypeRef, typeParameterSymbol) : false;
                if (!bl3) break block11;
            }
            return false;
        }
        return true;
    }

    @NotNull
    public static final AnnotationTargetList getActualTargetList(@NotNull FirDeclaration annotated) {
        AnnotationTargetList annotationTargetList;
        Intrinsics.checkNotNullParameter(annotated, "annotated");
        FirDeclaration firDeclaration = annotated;
        if (firDeclaration instanceof FirRegularClass) {
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)annotated;
            boolean $i$f$isInner = false;
            FirRegularClass $this$isCompanion$iv = (FirRegularClass)annotated;
            boolean $i$f$isCompanion = false;
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)annotated;
            boolean $i$f$isLocal = false;
            AnnotationTargetList annotationTargetList2 = new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(((FirRegularClass)annotated).getClassKind(), $this$isInner$iv.getStatus().isInner(), $this$isCompanion$iv.getStatus().isCompanion(), $this$isLocal$iv.getSymbol().getClassId().isLocal()), null, null, 6, null);
            annotationTargetList = annotationTargetList2;
        } else if (firDeclaration instanceof FirEnumEntry) {
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)annotated;
            boolean $i$f$isInner = false;
            AnnotationTargetList annotationTargetList3 = new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(ClassKind.ENUM_ENTRY, $this$isInner$iv.getStatus().isInner(), false, false), null, null, 6, null);
            annotationTargetList = annotationTargetList3;
        } else if (firDeclaration instanceof FirProperty) {
            if (((FirProperty)annotated).isLocal()) {
                KtSourceElement ktSourceElement = annotated.getSource();
                annotationTargetList = Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_DESTRUCTURING_DECLARATION() : AnnotationTargetLists.INSTANCE.getT_LOCAL_VARIABLE();
            } else if (FirHelpersKt.getActualTargetList$isMember(((FirProperty)annotated).getSymbol().getCallableId())) {
                KtSourceElement ktSourceElement = annotated.getSource();
                annotationTargetList = Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITH_VAL() : AnnotationTargetLists.INSTANCE.T_MEMBER_PROPERTY(DeclarationAttributesKt.getHasBackingField((FirProperty)annotated), ((FirProperty)annotated).getDelegate() != null);
            } else {
                annotationTargetList = AnnotationTargetLists.INSTANCE.T_TOP_LEVEL_PROPERTY(DeclarationAttributesKt.getHasBackingField((FirProperty)annotated), ((FirProperty)annotated).getDelegate() != null);
            }
        } else if (firDeclaration instanceof FirValueParameter) {
            annotationTargetList = FirHelpersKt.getHasValOrVar((FirValueParameter)annotated) ? AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITH_VAL() : AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITHOUT_VAL();
        } else if (firDeclaration instanceof FirConstructor) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_CONSTRUCTOR();
        } else if (firDeclaration instanceof FirAnonymousFunction) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_FUNCTION_EXPRESSION();
        } else if (firDeclaration instanceof FirSimpleFunction) {
            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)annotated;
            boolean $i$f$isLocal = false;
            annotationTargetList = Intrinsics.areEqual($this$isLocal$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_LOCAL_FUNCTION() : (FirHelpersKt.getActualTargetList$isMember(((FirSimpleFunction)annotated).getSymbol().getCallableId()) ? AnnotationTargetLists.INSTANCE.getT_MEMBER_FUNCTION() : AnnotationTargetLists.INSTANCE.getT_TOP_LEVEL_FUNCTION());
        } else if (firDeclaration instanceof FirTypeAlias) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_TYPEALIAS();
        } else if (firDeclaration instanceof FirPropertyAccessor) {
            annotationTargetList = ((FirPropertyAccessor)annotated).isGetter() ? AnnotationTargetLists.INSTANCE.getT_PROPERTY_GETTER() : AnnotationTargetLists.INSTANCE.getT_PROPERTY_SETTER();
        } else if (firDeclaration instanceof FirBackingField) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_BACKING_FIELD();
        } else if (firDeclaration instanceof FirFile) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_FILE();
        } else if (firDeclaration instanceof FirTypeParameter) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_TYPE_PARAMETER();
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_INITIALIZER();
        } else if (firDeclaration instanceof FirAnonymousObject) {
            KtSourceElement ktSourceElement = annotated.getSource();
            annotationTargetList = Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.EnumInitializer.INSTANCE) ? new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(ClassKind.ENUM_ENTRY, false, false, false), null, null, 6, null) : AnnotationTargetLists.INSTANCE.getT_OBJECT_LITERAL();
        } else {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getEMPTY();
        }
        return annotationTargetList;
    }

    public static final boolean explicitReceiverIsNotSuperReference(@NotNull FirQualifiedAccess $this$explicitReceiverIsNotSuperReference) {
        Intrinsics.checkNotNullParameter($this$explicitReceiverIsNotSuperReference, "<this>");
        FirExpression firExpression2 = $this$explicitReceiverIsNotSuperReference.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        return !((firQualifiedAccessExpression != null ? firQualifiedAccessExpression.getCalleeReference() : null) instanceof FirSuperReference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final KtSourceElement getDefaultValueForParameter(@NotNull KtSourceElement $this$defaultValueForParameter) {
        KtSourceElement ktSourceElement;
        Intrinsics.checkNotNullParameter($this$defaultValueForParameter, "<this>");
        KtSourceElement ktSourceElement2 = $this$defaultValueForParameter;
        if (ktSourceElement2 instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement;
            PsiElement psiElement = ((KtPsiSourceElement)$this$defaultValueForParameter).getPsi();
            KtExpression ktExpression = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
            if (ktExpression != null && (ktExpression = ktExpression.getDefaultValue()) != null) {
                PsiElement $this$toKtPsiSourceElement_u24default$iv = ktExpression;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                boolean $i$f$toKtPsiSourceElement = false;
                KtSourceElementKind ktSourceElementKind = kind$iv;
                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                } else {
                    if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                    ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                }
            } else {
                ktPsiSourceElement = null;
            }
            ktSourceElement = ktPsiSourceElement;
            return ktSourceElement;
        } else {
            if (!(ktSourceElement2 instanceof KtLightSourceElement)) throw new NoWhenBranchMatchedException();
            ktSourceElement = FirHelpersKt.findDefaultValue((KtLightSourceElement)$this$defaultValueForParameter);
        }
        return ktSourceElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtLightSourceElement findDefaultValue(KtLightSourceElement source) {
        void tree$iv;
        void endOffset$iv;
        void $this$toKtLightSourceElement_u24default$iv;
        Ref<T[]> childrenRef = new Ref<T[]>();
        source.getTreeStructure().getChildren(source.getLighterASTNode(), childrenRef);
        LighterASTNode defaultValue = null;
        int defaultValueOffset = source.getStartOffset();
        T[] TArray = childrenRef.get();
        Intrinsics.checkNotNullExpressionValue(TArray, "childrenRef.get()");
        for (LighterASTNode node : (LighterASTNode[])TArray) {
            if (node == null) continue;
            if (LightTreePositioningStrategiesKt.isExpression(node)) {
                defaultValue = node;
                break;
            }
            defaultValueOffset += node.getEndOffset() - node.getStartOffset();
        }
        if (defaultValue == null) {
            return null;
        }
        LighterASTNode[] lighterASTNodeArray = defaultValue;
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = source.getTreeStructure();
        int node = defaultValueOffset + defaultValue.getTextLength();
        KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
        boolean $i$f$toKtLightSourceElement = false;
        return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, defaultValueOffset, (int)endOffset$iv, (FlyweightCapableTreeStructure<LighterASTNode>)tree$iv, kind$iv);
    }

    @NotNull
    public static final ConeKotlinType getInlineClassUnderlyingType(@NotNull ConeKotlinType $this$getInlineClassUnderlyingType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getInlineClassUnderlyingType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!FirHelpersKt.isSingleFieldValueClass($this$getInlineClassUnderlyingType, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol($this$getInlineClassUnderlyingType, session2);
        Intrinsics.checkNotNull(firRegularClassSymbol);
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorSymbol(firRegularClassSymbol);
        Intrinsics.checkNotNull(firConstructorSymbol);
        return FirTypeUtilsKt.getConeType(firConstructorSymbol.getValueParameterSymbols().get(0).getResolvedReturnTypeRef());
    }

    @NotNull
    public static final List<FirNamedFunctionSymbol> directOverriddenFunctions(@NotNull FirNamedFunctionSymbol $this$directOverriddenFunctions, @NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter($this$directOverriddenFunctions, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$directOverriddenFunctions, session2);
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return CollectionsKt.emptyList();
        }
        FirClassSymbol classSymbol = firClassSymbol;
        FirTypeScope scope2 = FirKotlinScopeProviderKt.unsubstitutedScope(classSymbol, session2, scopeSession, false);
        scope2.processFunctionsByName($this$directOverriddenFunctions.getName(), directOverriddenFunctions.1.INSTANCE);
        return FirTypeScopeKt.getDirectOverriddenFunctions(scope2, $this$directOverriddenFunctions, true);
    }

    @NotNull
    public static final List<FirNamedFunctionSymbol> directOverriddenFunctions(@NotNull FirNamedFunctionSymbol $this$directOverriddenFunctions, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$directOverriddenFunctions, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return FirHelpersKt.directOverriddenFunctions($this$directOverriddenFunctions, context.getSession(), context.getSessionHolder().getScopeSession());
    }

    @Nullable
    public static final FirDeclaration getClosestNonLocal(@NotNull CheckerContext $this$closestNonLocal) {
        Intrinsics.checkNotNullParameter($this$closestNonLocal, "<this>");
        Iterable $this$takeWhile$iv = $this$closestNonLocal.getContainingDeclarations();
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            FirDeclaration it = (FirDeclaration)item$iv;
            boolean bl = false;
            if (!FirDeclarationUtilKt.isNonLocal(it)) break;
            list$iv.add(item$iv);
        }
        return (FirDeclaration)CollectionsKt.lastOrNull(list$iv);
    }

    @Nullable
    public static final FirDeclaration closestNonLocalWith(@NotNull CheckerContext $this$closestNonLocalWith, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter($this$closestNonLocalWith, "<this>");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Iterable $this$takeWhile$iv = CollectionsKt.plus((Collection)$this$closestNonLocalWith.getContainingDeclarations(), declaration);
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            FirDeclaration it = (FirDeclaration)item$iv;
            boolean bl = false;
            if (!FirDeclarationUtilKt.isNonLocal(it)) break;
            list$iv.add(item$iv);
        }
        return (FirDeclaration)CollectionsKt.lastOrNull(list$iv);
    }

    public static final boolean isTopLevel(@NotNull CheckerContext $this$isTopLevel) {
        Intrinsics.checkNotNullParameter($this$isTopLevel, "<this>");
        return CollectionsKt.lastOrNull($this$isTopLevel.getContainingDeclarations()) instanceof FirFile;
    }

    public static final boolean hasAnnotationOrInsideAnnotatedClass(@NotNull FirBasedSymbol<?> $this$hasAnnotationOrInsideAnnotatedClass, @NotNull ClassId classId, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$hasAnnotationOrInsideAnnotatedClass, "<this>");
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (FirAnnotationUtilsKt.hasAnnotation($this$hasAnnotationOrInsideAnnotatedClass, classId, session2)) {
            return true;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$hasAnnotationOrInsideAnnotatedClass, session2);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> container = firClassLikeSymbol;
        return FirHelpersKt.hasAnnotationOrInsideAnnotatedClass((FirBasedSymbol)container, classId, session2);
    }

    public static final boolean hasAnnotationOrInsideAnnotatedClass(@NotNull FirDeclaration $this$hasAnnotationOrInsideAnnotatedClass, @NotNull ClassId classId, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$hasAnnotationOrInsideAnnotatedClass, "<this>");
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$hasAnnotationOrInsideAnnotatedClass.getSymbol(), classId, session2);
    }

    @Nullable
    public static final String getAnnotationStringParameter(@NotNull FirBasedSymbol<?> $this$getAnnotationStringParameter, @NotNull ClassId classId, @NotNull FirSession session2) {
        FirConstExpression expression2;
        Intrinsics.checkNotNullParameter($this$getAnnotationStringParameter, "<this>");
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$getAnnotationStringParameter, classId, session2);
        FirAnnotationCall annotation2 = firAnnotation instanceof FirAnnotationCall ? (FirAnnotationCall)firAnnotation : null;
        Object object = annotation2;
        FirExpression firExpression2 = object != null && (object = ((FirAnnotationCall)object).getArgumentMapping()) != null && (object = ((FirAnnotationArgumentMapping)object).getMapping()) != null && (object = object.values()) != null ? (FirExpression)CollectionsKt.firstOrNull((Iterable)object) : null;
        FirConstExpression firConstExpression = expression2 = firExpression2 instanceof FirConstExpression ? (FirConstExpression)firExpression2 : null;
        firExpression2 = firConstExpression != null ? firConstExpression.getValue() : null;
        return firExpression2 instanceof String ? (String)((Object)firExpression2) : null;
    }

    private static final boolean isSupertypeOf$isSupertypeOf(FirClassSymbol<?> $this$isSupertypeOf_u24isSupertypeOf, FirSession $session, FirClassSymbol<?> other, Set<FirClassSymbol<?>> exclude) {
        for (FirResolvedTypeRef it : other.getResolvedSuperTypeRefs()) {
            FirRegularClassSymbol candidate2;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toClassLikeSymbol(it, $session);
            if (firRegularClassSymbol == null) continue;
            if ((firRegularClassSymbol = org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.fullyExpandedClass(firRegularClassSymbol, $session)) == null || exclude.contains(candidate2 = firRegularClassSymbol)) continue;
            exclude.add(candidate2);
            if (Intrinsics.areEqual(candidate2, $this$isSupertypeOf_u24isSupertypeOf)) {
                return true;
            }
            if (!FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf_u24isSupertypeOf, $session, candidate2, exclude)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isFunctionForExpectTypeFromCastFeature$isBadType(FirTypeRef $this$isFunctionForExpectTypeFromCastFeature_u24isBadType, FirTypeParameterSymbol typeParameterSymbol) {
        return ConeTypeUtilsKt.contains(FirTypeUtilsKt.getConeType($this$isFunctionForExpectTypeFromCastFeature_u24isBadType), (Function1<? super ConeKotlinType, Boolean>)new Function1<ConeKotlinType, Boolean>(typeParameterSymbol){
            final /* synthetic */ FirTypeParameterSymbol $typeParameterSymbol;
            {
                this.$typeParameterSymbol = $typeParameterSymbol;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ConeKotlinType it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ConeSimpleKotlinType coneSimpleKotlinType = ConeTypeUtilsKt.lowerBoundIfFlexible(it);
                ConeTypeParameterType coneTypeParameterType = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
                return Intrinsics.areEqual(coneTypeParameterType != null ? coneTypeParameterType.getLookupTag() : null, this.$typeParameterSymbol.toLookupTag());
            }
        });
    }

    private static final boolean getActualTargetList$isMember(CallableId $this$getActualTargetList_u24isMember) {
        return $this$getActualTargetList_u24isMember.getClassId() != null || $this$getActualTargetList_u24isMember.isLocal();
    }

    static {
        ClassId classId = ClassId.topLevel(new FqName("kotlin.internal.InlineOnly"));
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(FqName(\"kotlin.internal.InlineOnly\"))");
        INLINE_ONLY_ANNOTATION_CLASS_ID = classId;
    }
}

