/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirTopLevelPropertiesCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberFunctionsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkFunction", "containingDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "function", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMemberFunctionsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMemberFunctionsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberFunctionsChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,77:1\n56#2,11:78\n20#2,2:89\n12#3:91\n61#3:92\n12#3:93\n58#3:94\n56#3:95\n66#3:97\n66#3:98\n53#3:99\n21#3:101\n42#3:102\n37#4:96\n34#4:100\n*S KotlinDebug\n*F\n+ 1 FirMemberFunctionsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberFunctionsChecker\n*L\n26#1:78,11\n26#1:89,2\n43#1:91\n45#1:92\n45#1:93\n45#1:94\n45#1:95\n54#1:97\n61#1:98\n62#1:99\n63#1:101\n69#1:102\n45#1:96\n62#1:100\n*E\n"})
public final class FirMemberFunctionsChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirMemberFunctionsChecker INSTANCE = new FirMemberFunctionsChecker();

    private FirMemberFunctionsChecker() {
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Object v0;
        block6: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Iterable $this$lastIsInstanceOrNull$iv = context.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Object element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirClass)) continue;
                        v0 = element$iv;
                        break block6;
                    } while (0 <= n);
                }
                v0 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed($this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirClass)) continue;
                    v0 = element$iv$iv;
                    break block6;
                }
                v0 = null;
            }
        }
        FirClass firClass = v0;
        if (firClass == null) {
            return;
        }
        FirClass containingDeclaration = firClass;
        this.checkFunction(containingDeclaration, declaration, context, reporter);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkFunction(FirClass containingDeclaration, FirSimpleFunction function, CheckerContext context, DiagnosticReporter reporter) {
        block13: {
            block14: {
                v0 = function.getSource();
                if (v0 == null) {
                    return;
                }
                source = v0;
                if (source.getKind() instanceof KtFakeSourceElementKind) {
                    return;
                }
                functionSymbol = function.getSymbol();
                modifierList = FirKeywordUtilsKt.getModifierList(source);
                v1 = KtTokens.ABSTRACT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(v1, "ABSTRACT_KEYWORD");
                hasAbstractModifier = FirKeywordUtilsKt.contains(modifierList, v1);
                $this$isAbstract$iv = function;
                $i$f$isAbstract = false;
                v2 = isAbstract = $this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT != false || hasAbstractModifier != false;
                if (!isAbstract) break block13;
                if (!(containingDeclaration instanceof FirRegularClass)) break block14;
                $this$canHaveAbstractDeclaration$iv = (FirRegularClass)containingDeclaration;
                $i$f$getCanHaveAbstractDeclaration = false;
                $this$isAbstract$iv$iv = $this$canHaveAbstractDeclaration$iv;
                $i$f$isAbstract = false;
                if ($this$isAbstract$iv$iv.getStatus().getModality() == Modality.ABSTRACT) ** GOTO lbl-1000
                $this$isSealed$iv$iv = $this$canHaveAbstractDeclaration$iv;
                $i$f$isSealed = false;
                if ($this$isSealed$iv$iv.getStatus().getModality() == Modality.SEALED) ** GOTO lbl-1000
                $this$isEnumClass$iv$iv = $this$canHaveAbstractDeclaration$iv;
                $i$f$isEnumClass = false;
                $this$isEnumClass$iv$iv$iv = $this$isEnumClass$iv$iv.getClassKind();
                $i$f$isEnumClass = false;
                v3 = $this$isEnumClass$iv$iv$iv == ClassKind.ENUM_CLASS;
                if (v3) lbl-1000:
                // 3 sources

                {
                    v4 = true;
                } else {
                    v4 = false;
                }
                if (!v4) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS(), (Object)functionSymbol, (Object)((FirRegularClass)containingDeclaration).getSymbol(), (DiagnosticContext)context, null, 32, null);
                }
            }
            $this$hasBody$iv = function;
            $i$f$getHasBody = false;
            if ($this$hasBody$iv.getBody() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getABSTRACT_FUNCTION_WITH_BODY(), (Object)functionSymbol, (DiagnosticContext)context, null, 16, null);
            }
        }
        isInsideExpectClass = DeclarationUtilsKt.isInsideExpectClass(containingDeclaration, context);
        isInsideExternal = DeclarationUtilsKt.isInsideExternalClass(containingDeclaration, context);
        v5 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(v5, "OPEN_KEYWORD");
        hasOpenModifier = FirKeywordUtilsKt.contains(modifierList, v5);
        $this$hasBody$iv = function;
        $i$f$getHasBody = false;
        if (!($this$hasBody$iv.getBody() != null)) {
            $this$isInterface$iv = containingDeclaration;
            $i$f$isInterface = false;
            $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            $i$f$isInterface = false;
            v6 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (v6) {
                $this$visibility$iv = function;
                $i$f$getVisibility = false;
                if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getPRIVATE_FUNCTION_WITH_NO_BODY(), (Object)functionSymbol, (DiagnosticContext)context, null, 16, null);
                }
                if (!isInsideExpectClass && !hasAbstractModifier && hasOpenModifier) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREDUNDANT_OPEN_IN_INTERFACE(), (DiagnosticContext)context, null, 8, null);
                }
            } else if (!isInsideExpectClass && !hasAbstractModifier) {
                $this$isExternal$iv = function;
                $i$f$isExternal = false;
                if (!$this$isExternal$iv.getStatus().isExternal() && !isInsideExternal) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_ABSTRACT_FUNCTION_WITH_NO_BODY(), (Object)functionSymbol, (DiagnosticContext)context, null, 16, null);
                }
            }
        }
        FirTopLevelPropertiesCheckerKt.checkExpectDeclarationVisibilityAndBody(function, source, reporter, context);
    }
}

