/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirSuperCallWithDefaultsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirSuperCallWithDefaultsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuperCallWithDefaultsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirSuperCallWithDefaultsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1747#2,3:37\n*S KotlinDebug\n*F\n+ 1 FirSuperCallWithDefaultsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirSuperCallWithDefaultsChecker\n*L\n24#1:37,3\n*E\n"})
public final class FirSuperCallWithDefaultsChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirSuperCallWithDefaultsChecker INSTANCE = new FirSuperCallWithDefaultsChecker();

    private FirSuperCallWithDefaultsChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        FirNamedFunctionSymbol functionSymbol;
        block8: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (FirHelpersKt.explicitReceiverIsNotSuperReference(expression2)) {
                return;
            }
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedFunctionSymbol$default(expression2.getCalleeReference(), false, 1, null);
            if (firNamedFunctionSymbol == null) {
                return;
            }
            functionSymbol = firNamedFunctionSymbol;
            Iterable $this$any$iv = functionSymbol.getValueParameterSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl2 = false;
                    if (!it.getHasDefaultValue()) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        FirArgumentList firArgumentList = expression2.getArgumentList();
        FirResolvedArgumentList firResolvedArgumentList = firArgumentList instanceof FirResolvedArgumentList ? (FirResolvedArgumentList)firArgumentList : null;
        if (firResolvedArgumentList == null) {
            return;
        }
        FirResolvedArgumentList arguments2 = firResolvedArgumentList;
        if (arguments2.getArguments().size() < functionSymbol.getValueParameterSymbols().size()) {
            AbstractKtSourceElement abstractKtSourceElement = expression2.getCalleeReference().getSource();
            KtDiagnosticFactory1<String> ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getSUPER_CALL_WITH_DEFAULT_PARAMETERS();
            String string2 = functionSymbol.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "functionSymbol.name.asString()");
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)string2, (DiagnosticContext)context, null, 16, null);
        }
    }
}

