/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a'\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\u001c\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f\u001a0\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000b\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u0018\u001a\u00020\u0014*\u00020\u0019\u001a\u0012\u0010\u0018\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u001a\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u001b\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a,\u0010\u001b\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u001dH\u0086\b\u00f8\u0001\u0000\u001a\n\u0010\u001e\u001a\u00020\u0014*\u00020\u0001\u001a\u0012\u0010\u001f\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010 \u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010!\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\"\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000b\u001a\u0012\u0010#\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010$\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010%\u001a\u00020\u0014*\u00020&2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001\u001a\u0012\u0010)\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010*\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010+\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010,\u001a\u00020\b\u001a\u000e\u0010-\u001a\u0004\u0018\u00010\u0017*\u00020\bH\u0002\u001a\u0014\u0010.\u001a\u00020\u0001*\u00020/2\u0006\u00100\u001a\u00020\u0001H\u0002\u001a\u0018\u00101\u001a\b\u0012\u0004\u0012\u00020\u000102*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00f2\u0001\u0004\n\u00020\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00063"}, d2={"receiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "getReceiverType", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "returnType", "getReturnType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "findBaseInvokeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "findContributedInvokeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "expectedFunctionalType", "shouldCalculateReturnTypesOfFakeOverrides", "", "findSubtypeOfNonSuspendFunctionalType", "functionClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "isBuiltinFunctionalType", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "isFunctionalOrSuspendFunctionalType", "isFunctionalType", "predicate", "Lkotlin/Function1;", "isKClassType", "isKFunctionType", "isKMutableProperty", "isKProperty", "isSubtypeOfFunctionalType", "isSuspendFunctionType", "isSuspendOrKSuspendFunctionType", "isTypeMismatchDueToNullability", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "actualType", "expectedType", "kFunctionTypeToFunctionType", "suspendFunctionTypeToFunctionType", "suspendFunctionTypeToFunctionTypeWithContinuation", "continuationClassId", "toFunctionClassKind", "typeOrDefault", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "default", "valueParameterTypesIncludingReceiver", "", "providers"})
@SourceDebugExtension(value={"SMAP\nInferenceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferenceUtils.kt\norg/jetbrains/kotlin/fir/types/InferenceUtilsKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,264:1\n73#1,2:265\n73#1,2:267\n73#1,2:269\n73#1,2:271\n73#1,2:273\n37#2,2:275\n1747#3,3:277\n1549#3:281\n1620#3,3:282\n1747#3,3:285\n1549#3:288\n1620#3,3:289\n1#4:280\n21#5,4:292\n21#5,4:296\n*S KotlinDebug\n*F\n+ 1 InferenceUtils.kt\norg/jetbrains/kotlin/fir/types/InferenceUtilsKt\n*L\n79#1:265,2\n84#1:267,2\n89#1:269,2\n93#1:271,2\n98#1:273,2\n133#1:275,2\n155#1:277,3\n161#1:281\n161#1:282,3\n162#1:285,3\n248#1:288\n248#1:289,3\n251#1:292,4\n252#1:296,4\n*E\n"})
public final class InferenceUtilsKt {
    private static final ClassId classId(ConeKotlinType $this$classId, FirSession session2) {
        if (!($this$classId instanceof ConeClassLikeType)) {
            return null;
        }
        return TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$classId, session2, null, 2, null).getLookupTag().getClassId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKProperty(@NotNull ConeKotlinType $this$isKProperty, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isKProperty, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ClassId classId = InferenceUtilsKt.classId($this$isKProperty, session2);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual(classId2.getPackageFqName(), StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        String string2 = classId2.getShortClassName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string2, "classId.shortClassName.identifier");
        if (!StringsKt.startsWith$default(string2, "KProperty", false, 2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKMutableProperty(@NotNull ConeKotlinType $this$isKMutableProperty, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isKMutableProperty, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ClassId classId = InferenceUtilsKt.classId($this$isKMutableProperty, session2);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual(classId2.getPackageFqName(), StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        String string2 = classId2.getShortClassName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string2, "classId.shortClassName.identifier");
        if (!StringsKt.startsWith$default(string2, "KMutableProperty", false, 2, null)) return false;
        return true;
    }

    @Nullable
    public static final FunctionClassKind functionClassKind(@NotNull ConeKotlinType $this$functionClassKind, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$functionClassKind, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ClassId classId = InferenceUtilsKt.classId($this$functionClassKind, session2);
        return classId != null ? InferenceUtilsKt.toFunctionClassKind(classId) : null;
    }

    private static final FunctionClassKind toFunctionClassKind(ClassId $this$toFunctionClassKind) {
        FqName fqName2 = $this$toFunctionClassKind.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "packageFqName");
        String string2 = $this$toFunctionClassKind.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "relativeClassName.asString()");
        return FunctionClassKind.Companion.byClassNamePrefix(fqName2, string2);
    }

    public static final boolean isBuiltinFunctionalType(@NotNull ConeKotlinType $this$isBuiltinFunctionalType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isBuiltinFunctionalType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return InferenceUtilsKt.functionClassKind($this$isBuiltinFunctionalType, session2) != null;
    }

    public static final boolean isBuiltinFunctionalType(@NotNull ConeClassLikeLookupTag $this$isBuiltinFunctionalType) {
        Intrinsics.checkNotNullParameter($this$isBuiltinFunctionalType, "<this>");
        return InferenceUtilsKt.toFunctionClassKind($this$isBuiltinFunctionalType.getClassId()) != null;
    }

    public static final boolean isFunctionalType(@NotNull ConeKotlinType $this$isFunctionalType, @NotNull FirSession session2, @NotNull Function1<? super FunctionClassKind, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$isFunctionalType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType, session2);
        if (functionClassKind == null) {
            return false;
        }
        FunctionClassKind kind = functionClassKind;
        return predicate.invoke(kind);
    }

    public static final boolean isFunctionalType(@NotNull ConeKotlinType $this$isFunctionalType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isFunctionalType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeKotlinType $this$isFunctionalType$iv = $this$isFunctionalType;
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType$iv, session2);
        if (functionClassKind == null) {
            bl = false;
        } else {
            FunctionClassKind kind$iv;
            FunctionClassKind it = kind$iv = functionClassKind;
            boolean bl2 = false;
            bl = it == FunctionClassKind.Function;
        }
        return bl;
    }

    public static final boolean isFunctionalOrSuspendFunctionalType(@NotNull ConeKotlinType $this$isFunctionalOrSuspendFunctionalType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isFunctionalOrSuspendFunctionalType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeKotlinType $this$isFunctionalType$iv = $this$isFunctionalOrSuspendFunctionalType;
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType$iv, session2);
        if (functionClassKind == null) {
            bl = false;
        } else {
            FunctionClassKind kind$iv;
            FunctionClassKind it = kind$iv = functionClassKind;
            boolean bl2 = false;
            bl = it == FunctionClassKind.Function || it == FunctionClassKind.SuspendFunction;
        }
        return bl;
    }

    public static final boolean isSuspendOrKSuspendFunctionType(@NotNull ConeKotlinType $this$isSuspendOrKSuspendFunctionType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isSuspendOrKSuspendFunctionType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeKotlinType $this$isFunctionalType$iv = $this$isSuspendOrKSuspendFunctionType;
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType$iv, session2);
        if (functionClassKind == null) {
            bl = false;
        } else {
            FunctionClassKind kind$iv;
            FunctionClassKind it = kind$iv = functionClassKind;
            boolean bl2 = false;
            bl = it.isSuspendType();
        }
        return bl;
    }

    public static final boolean isSuspendFunctionType(@NotNull ConeKotlinType $this$isSuspendFunctionType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeKotlinType $this$isFunctionalType$iv = $this$isSuspendFunctionType;
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType$iv, session2);
        if (functionClassKind == null) {
            bl = false;
        } else {
            FunctionClassKind kind$iv;
            FunctionClassKind it = kind$iv = functionClassKind;
            boolean bl2 = false;
            bl = it == FunctionClassKind.SuspendFunction;
        }
        return bl;
    }

    public static final boolean isKFunctionType(@NotNull ConeKotlinType $this$isKFunctionType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isKFunctionType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeKotlinType $this$isFunctionalType$iv = $this$isKFunctionType;
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType$iv, session2);
        if (functionClassKind == null) {
            bl = false;
        } else {
            FunctionClassKind kind$iv;
            FunctionClassKind it = kind$iv = functionClassKind;
            boolean bl2 = false;
            bl = it.isReflectType();
        }
        return bl;
    }

    @NotNull
    public static final ConeClassLikeType kFunctionTypeToFunctionType(@NotNull ConeKotlinType $this$kFunctionTypeToFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$kFunctionTypeToFunctionType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!InferenceUtilsKt.isKFunctionType($this$kFunctionTypeToFunctionType, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FunctionClassKind kind = InferenceUtilsKt.isSuspendOrKSuspendFunctionType($this$kFunctionTypeToFunctionType, session2) ? FunctionClassKind.SuspendFunction : FunctionClassKind.Function;
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName($this$kFunctionTypeToFunctionType.getTypeArguments().length - 1));
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), $this$kFunctionTypeToFunctionType.getTypeArguments(), false, null, 8, null);
    }

    @NotNull
    public static final ConeClassLikeType suspendFunctionTypeToFunctionType(@NotNull ConeKotlinType $this$suspendFunctionTypeToFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$suspendFunctionTypeToFunctionType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!InferenceUtilsKt.isSuspendOrKSuspendFunctionType($this$suspendFunctionTypeToFunctionType, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FunctionClassKind kind = InferenceUtilsKt.isKFunctionType($this$suspendFunctionTypeToFunctionType, session2) ? FunctionClassKind.KFunction : FunctionClassKind.Function;
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName($this$suspendFunctionTypeToFunctionType.getTypeArguments().length - 1));
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), $this$suspendFunctionTypeToFunctionType.getTypeArguments(), false, $this$suspendFunctionTypeToFunctionType.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeClassLikeType suspendFunctionTypeToFunctionTypeWithContinuation(@NotNull ConeKotlinType $this$suspendFunctionTypeToFunctionTypeWithContinuation, @NotNull FirSession session2, @NotNull ClassId continuationClassId) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter($this$suspendFunctionTypeToFunctionTypeWithContinuation, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(continuationClassId, "continuationClassId");
        if (!InferenceUtilsKt.isSuspendOrKSuspendFunctionType($this$suspendFunctionTypeToFunctionTypeWithContinuation, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FunctionClassKind kind = InferenceUtilsKt.isKFunctionType($this$suspendFunctionTypeToFunctionTypeWithContinuation, session2) ? FunctionClassKind.KFunction : FunctionClassKind.Function;
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType($this$suspendFunctionTypeToFunctionTypeWithContinuation.getType(), session2);
        ConeTypeProjection[] typeArguments = fullyExpandedType2.getTypeArguments();
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName(typeArguments.length));
        ConeTypeProjection lastTypeArgument = ArraysKt.last(typeArguments);
        Object object = new ConeTypeProjection[]{lastTypeArgument};
        object = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ArraysKt.dropLast(typeArguments, 1), TypeConstructionUtilsKt.constructClassType$default(new ConeClassLikeLookupTagImpl(continuationClassId), object, false, null, 4, null)), lastTypeArgument);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), thisCollection$iv.toArray(new ConeTypeProjection[0]), ConeTypeUtilsKt.isNullable(fullyExpandedType2), fullyExpandedType2.getAttributes());
    }

    public static final boolean isSubtypeOfFunctionalType(@NotNull ConeKotlinType $this$isSubtypeOfFunctionalType, @NotNull FirSession session2, @NotNull ConeClassLikeType expectedFunctionalType) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOfFunctionalType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(expectedFunctionalType, "expectedFunctionalType");
        if (!InferenceUtilsKt.isBuiltinFunctionalType(expectedFunctionalType, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(session2), (KotlinTypeMarker)$this$isSubtypeOfFunctionalType, (KotlinTypeMarker)ConeTypeUtilsKt.replaceArgumentsWithStarProjections(expectedFunctionalType), false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ConeKotlinType findSubtypeOfNonSuspendFunctionalType(@NotNull ConeKotlinType $this$findSubtypeOfNonSuspendFunctionalType, @NotNull FirSession session2, @NotNull ConeClassLikeType expectedFunctionalType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$findSubtypeOfNonSuspendFunctionalType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(expectedFunctionalType, "expectedFunctionalType");
        if (!(InferenceUtilsKt.isBuiltinFunctionalType(expectedFunctionalType, session2) && !InferenceUtilsKt.isSuspendOrKSuspendFunctionType(expectedFunctionalType, session2))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ConeKotlinType coneKotlinType2 = $this$findSubtypeOfNonSuspendFunctionalType;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = InferenceUtilsKt.isSuspendOrKSuspendFunctionType($this$findSubtypeOfNonSuspendFunctionalType, session2) || !InferenceUtilsKt.isSubtypeOfFunctionalType($this$findSubtypeOfNonSuspendFunctionalType, session2, expectedFunctionalType) ? null : (ConeClassLikeType)$this$findSubtypeOfNonSuspendFunctionalType;
        } else if (coneKotlinType2 instanceof ConeIntersectionType) {
            ConeKotlinType it;
            boolean bl;
            block20: {
                Iterable $this$any$iv = ((ConeIntersectionType)$this$findSubtypeOfNonSuspendFunctionalType).getIntersectedTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!InferenceUtilsKt.isSuspendOrKSuspendFunctionType(it, session2)) continue;
                        bl = true;
                        break block20;
                    }
                    bl = false;
                }
            }
            if (bl) {
                coneKotlinType = null;
            } else {
                Object v2;
                block21: {
                    Iterable $i$f$any = ((ConeIntersectionType)$this$findSubtypeOfNonSuspendFunctionalType).getIntersectedTypes();
                    for (Object element$iv : $i$f$any) {
                        it = (ConeKotlinType)element$iv;
                        boolean bl3 = false;
                        if (!(InferenceUtilsKt.findSubtypeOfNonSuspendFunctionalType(it, session2, expectedFunctionalType) != null)) continue;
                        v2 = element$iv;
                        break block21;
                    }
                    v2 = null;
                }
                coneKotlinType = v2;
            }
        } else if (coneKotlinType2 instanceof ConeTypeParameterType) {
            boolean bl;
            List bounds;
            block22: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((ConeTypeParameterType)$this$findSubtypeOfNonSuspendFunctionalType).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$map = false;
                Iterable element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
                }
                bounds = (List)destination$iv$iv;
                Iterable $this$any$iv = bounds;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv2;
                        boolean bl5 = false;
                        if (!InferenceUtilsKt.isSuspendOrKSuspendFunctionType(it, session2)) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            if (bl) {
                coneKotlinType = null;
            } else {
                Object v4;
                block23: {
                    Iterable iterable = bounds;
                    for (Object t : iterable) {
                        ConeKotlinType it = (ConeKotlinType)t;
                        boolean bl6 = false;
                        if (!(InferenceUtilsKt.findSubtypeOfNonSuspendFunctionalType(it, session2, expectedFunctionalType) != null)) continue;
                        v4 = t;
                        break block23;
                    }
                    v4 = null;
                }
                coneKotlinType = v4;
            }
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final FirNamedFunctionSymbol findBaseInvokeSymbol(@NotNull ConeClassLikeType $this$findBaseInvokeSymbol, @NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter($this$findBaseInvokeSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        if (!InferenceUtilsKt.isBuiltinFunctionalType($this$findBaseInvokeSymbol, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol($this$findBaseInvokeSymbol.getLookupTag(), session2);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirClass firClass = firClassLikeDeclaration instanceof FirClass ? (FirClass)firClassLikeDeclaration : null;
        if (firClass == null) {
            return null;
        }
        FirClass functionN2 = firClass;
        Ref.ObjectRef<FirNamedFunctionSymbol> baseInvokeSymbol = new Ref.ObjectRef<FirNamedFunctionSymbol>();
        FirKotlinScopeProviderKt.unsubstitutedScope(functionN2, session2, scopeSession, false).processFunctionsByName(OperatorNameConventions.INVOKE, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(baseInvokeSymbol){
            final /* synthetic */ Ref.ObjectRef<FirNamedFunctionSymbol> $baseInvokeSymbol;
            {
                this.$baseInvokeSymbol = $baseInvokeSymbol;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
                this.$baseInvokeSymbol.element = functionSymbol;
            }
        });
        return (FirNamedFunctionSymbol)baseInvokeSymbol.element;
    }

    @Nullable
    public static final FirFunctionSymbol<?> findContributedInvokeSymbol(@NotNull ConeKotlinType $this$findContributedInvokeSymbol, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull ConeClassLikeType expectedFunctionalType, boolean shouldCalculateReturnTypesOfFakeOverrides) {
        Intrinsics.checkNotNullParameter($this$findContributedInvokeSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(expectedFunctionalType, "expectedFunctionalType");
        FirNamedFunctionSymbol firNamedFunctionSymbol = InferenceUtilsKt.findBaseInvokeSymbol(expectedFunctionalType, session2, scopeSession);
        if (firNamedFunctionSymbol == null) {
            return null;
        }
        FirNamedFunctionSymbol baseInvokeSymbol = firNamedFunctionSymbol;
        FakeOverrideTypeCalculator fakeOverrideTypeCalculator = shouldCalculateReturnTypesOfFakeOverrides ? (FakeOverrideTypeCalculator)FakeOverrideTypeCalculator.Forced.INSTANCE : (FakeOverrideTypeCalculator)FakeOverrideTypeCalculator.DoNothing.INSTANCE;
        FirTypeScope firTypeScope = ScopeUtilsKt.scope($this$findContributedInvokeSymbol, session2, scopeSession, fakeOverrideTypeCalculator, null);
        if (firTypeScope == null) {
            return null;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.ObjectRef<FirNamedFunctionSymbol> declaredInvoke = new Ref.ObjectRef<FirNamedFunctionSymbol>();
        scope2.processFunctionsByName(OperatorNameConventions.INVOKE, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(baseInvokeSymbol, declaredInvoke){
            final /* synthetic */ FirNamedFunctionSymbol $baseInvokeSymbol;
            final /* synthetic */ Ref.ObjectRef<FirNamedFunctionSymbol> $declaredInvoke;
            {
                this.$baseInvokeSymbol = $baseInvokeSymbol;
                this.$declaredInvoke = $declaredInvoke;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
                if (((FirSimpleFunction)functionSymbol.getFir()).getValueParameters().size() == ((FirSimpleFunction)this.$baseInvokeSymbol.getFir()).getValueParameters().size()) {
                    this.$declaredInvoke.element = functionSymbol;
                    return;
                }
            }
        });
        Ref.ObjectRef overriddenInvoke = new Ref.ObjectRef();
        if (declaredInvoke.element != null) {
            Object t = declaredInvoke.element;
            Intrinsics.checkNotNull(t);
            FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)t, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)new Function1<FirNamedFunctionSymbol, ProcessorAction>(baseInvokeSymbol, overriddenInvoke){
                final /* synthetic */ FirNamedFunctionSymbol $baseInvokeSymbol;
                final /* synthetic */ Ref.ObjectRef<FirFunctionSymbol<?>> $overriddenInvoke;
                {
                    this.$baseInvokeSymbol = $baseInvokeSymbol;
                    this.$overriddenInvoke = $overriddenInvoke;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                    ProcessorAction processorAction;
                    Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
                    if (!Intrinsics.areEqual(functionSymbol, this.$baseInvokeSymbol)) {
                        FirCallableSymbol $this$originalForSubstitutionOverride$iv = functionSymbol;
                        boolean $i$f$getOriginalForSubstitutionOverride = false;
                        FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = (FirCallableDeclaration)$this$originalForSubstitutionOverride$iv.getFir();
                        boolean $i$f$getOriginalForSubstitutionOverride2 = false;
                        FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
                        if (!Intrinsics.areEqual((FirNamedFunctionSymbol)(firCallableDeclaration != null ? firCallableDeclaration.getSymbol() : null), this.$baseInvokeSymbol)) {
                            processorAction = ProcessorAction.NEXT;
                            return processorAction;
                        }
                    }
                    this.$overriddenInvoke.element = functionSymbol;
                    processorAction = ProcessorAction.STOP;
                    return processorAction;
                }
            });
        }
        return overriddenInvoke.element != null ? (FirFunctionSymbol)declaredInvoke.element : null;
    }

    public static final boolean isKClassType(@NotNull ConeKotlinType $this$isKClassType) {
        Intrinsics.checkNotNullParameter($this$isKClassType, "<this>");
        return Intrinsics.areEqual(ConeTypeUtilsKt.getClassId($this$isKClassType), StandardClassIds.INSTANCE.getKClass());
    }

    private static final ConeKotlinType typeOrDefault(ConeTypeProjection $this$typeOrDefault, ConeKotlinType coneKotlinType) {
        ConeKotlinType coneKotlinType2;
        ConeTypeProjection coneTypeProjection = $this$typeOrDefault;
        if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
            coneKotlinType2 = ((ConeKotlinTypeProjection)$this$typeOrDefault).getType();
        } else if (coneTypeProjection instanceof ConeStarProjection) {
            coneKotlinType2 = coneKotlinType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType2;
    }

    @Nullable
    public static final ConeKotlinType receiverType(@NotNull ConeKotlinType $this$receiverType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$receiverType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!InferenceUtilsKt.isBuiltinFunctionalType($this$receiverType, session2) || !TypeUtilsKt.isExtensionFunctionType($this$receiverType, session2)) {
            return null;
        }
        ConeKotlinType expanded = TypeExpansionUtilsKt.fullyExpandedType($this$receiverType, session2);
        boolean bl = false;
        return InferenceUtilsKt.typeOrDefault(expanded.getTypeArguments()[CompilerConeAttributesKt.getContextReceiversNumberForFunctionType(expanded)], session2.getBuiltinTypes().getNothingType().getType());
    }

    @NotNull
    public static final ConeKotlinType returnType(@NotNull ConeKotlinType $this$returnType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$returnType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!($this$returnType instanceof ConeClassLikeType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return InferenceUtilsKt.typeOrDefault(ArraysKt.last(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$returnType, session2, null, 2, null).getTypeArguments()), session2.getBuiltinTypes().getNullableAnyType().getType());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeKotlinType> valueParameterTypesIncludingReceiver(@NotNull ConeKotlinType $this$valueParameterTypesIncludingReceiver, @NotNull FirSession session2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$valueParameterTypesIncludingReceiver, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!($this$valueParameterTypesIncludingReceiver instanceof ConeClassLikeType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Iterable $this$map$iv = ArraysKt.dropLast(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$valueParameterTypesIncludingReceiver, session2, null, 2, null).getTypeArguments(), 1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InferenceUtilsKt.typeOrDefault((ConeTypeProjection)it, session2.getBuiltinTypes().getNothingType().getType()));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ConeKotlinType getReturnType(@NotNull FirAnonymousFunction $this$returnType) {
        Intrinsics.checkNotNullParameter($this$returnType, "<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$returnType.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ConeKotlinType getReceiverType(@NotNull FirAnonymousFunction $this$receiverType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$receiverType, "<this>");
        FirPureAbstractElement firPureAbstractElement = $this$receiverType.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement $this$coneTypeSafe$iv = firPureAbstractElement;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    public static final boolean isTypeMismatchDueToNullability(@NotNull ConeTypeContext $this$isTypeMismatchDueToNullability, @NotNull ConeKotlinType actualType, @NotNull ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter($this$isTypeMismatchDueToNullability, "<this>");
        Intrinsics.checkNotNullParameter(actualType, "actualType");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        return $this$isTypeMismatchDueToNullability.isNullableType(actualType) && !$this$isTypeMismatchDueToNullability.isNullableType(expectedType) && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, $this$isTypeMismatchDueToNullability, (KotlinTypeMarker)actualType, (KotlinTypeMarker)TypeUtilsKt.withNullability$default(expectedType, ConeNullability.NULLABLE, $this$isTypeMismatchDueToNullability, null, 4, null), false, 8, null);
    }
}

