/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorBoxParameterOptimizationLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorBoxParameterOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "esClassWhichNeedBoxParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "requiredToHaveBoxParameter", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6ConstructorBoxParameterOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6ConstructorBoxParameterOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorBoxParameterOptimizationLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n766#2:141\n857#2,2:142\n*S KotlinDebug\n*F\n+ 1 ES6ConstructorBoxParameterOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorBoxParameterOptimizationLowering\n*L\n39#1:141\n39#1:142,2\n*E\n"})
public final class ES6ConstructorBoxParameterOptimizationLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final Set<IrClass> esClassWhichNeedBoxParameters;

    public ES6ConstructorBoxParameterOptimizationLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.esClassWhichNeedBoxParameters = this.context.getMapping().getEsClassWhichNeedBoxParameters();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        boolean shouldRemoveBoxRelatedDeclarationsAndStatements;
        IrFunction containerFunction;
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        if (!this.context.getEs6mode()) {
            return;
        }
        IrFunction irFunction2 = containerFunction = container instanceof IrFunction ? (IrFunction)container : null;
        boolean bl = shouldRemoveBoxRelatedDeclarationsAndStatements = (irFunction2 != null ? ES6ConstructorLoweringKt.isEs6ConstructorReplacement(irFunction2) : false) && !this.requiredToHaveBoxParameter(IrUtilsKt.getParentAsClass(containerFunction));
        if (containerFunction != null && shouldRemoveBoxRelatedDeclarationsAndStatements && irBody instanceof IrBlockBody) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = containerFunction.getValueParameters();
            IrFunction irFunction3 = containerFunction;
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrValueParameter it = (IrValueParameter)element$iv$iv;
                boolean bl2 = false;
                if (!(!ES6AddBoxParameterLoweringKt.isBoxParameter(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            irFunction3.setValueParameters((List)destination$iv$iv);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(shouldRemoveBoxRelatedDeclarationsAndStatements, this){
            final /* synthetic */ boolean $shouldRemoveBoxRelatedDeclarationsAndStatements;
            final /* synthetic */ ES6ConstructorBoxParameterOptimizationLowering this$0;
            {
                this.$shouldRemoveBoxRelatedDeclarationsAndStatements = $shouldRemoveBoxRelatedDeclarationsAndStatements;
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitWhen(@NotNull IrWhen expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return this.$shouldRemoveBoxRelatedDeclarationsAndStatements && ES6AddBoxParameterLoweringKt.isBoxParameterDefaultResolution(expression2) ? IrJsUtilsKt.irEmpty(ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0)) : super.visitWhen(expression2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                if (this.$shouldRemoveBoxRelatedDeclarationsAndStatements && (Intrinsics.areEqual(callee.getSymbol(), ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateThisSymbol()) || Intrinsics.areEqual(callee.getSymbol(), ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateExternalThisSymbol()))) {
                    expression2.putValueArgument(expression2.getValueArgumentsCount() - 1, IrJsUtilsKt.getVoid(ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0)));
                    irExpression = super.visitCall(expression2);
                } else if (ES6ConstructorLoweringKt.isEs6ConstructorReplacement(callee) && (!ES6ConstructorBoxParameterOptimizationLowering.access$requiredToHaveBoxParameter(this.this$0, IrUtilsKt.getParentAsClass(callee)) || this.$shouldRemoveBoxRelatedDeclarationsAndStatements)) {
                    void $this$visitCall_u24lambda_u240;
                    IrCallImpl irCallImpl;
                    int newArgumentsSize = expression2.getValueArgumentsCount() - 1;
                    IrCallImpl irCallImpl2 = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), expression2.getSymbol(), expression2.getTypeArgumentsCount(), newArgumentsSize, expression2.getOrigin(), expression2.getSuperQualifierSymbol());
                    lower.2 var8_6 = this;
                    boolean bl = false;
                    IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$visitCall_u24lambda_u240, expression2, 0, 2, null);
                    $this$visitCall_u24lambda_u240.setDispatchReceiver(expression2.getDispatchReceiver());
                    $this$visitCall_u24lambda_u240.setExtensionReceiver(expression2.getExtensionReceiver());
                    for (int i = 0; i < newArgumentsSize; ++i) {
                        $this$visitCall_u24lambda_u240.putValueArgument(i, expression2.getValueArgument(i));
                    }
                    irExpression = super.visitCall(irCallImpl);
                } else {
                    irExpression = super.visitCall(expression2);
                }
                return irExpression;
            }
        });
    }

    private final boolean requiredToHaveBoxParameter(IrClass $this$requiredToHaveBoxParameter) {
        return this.esClassWhichNeedBoxParameters.contains($this$requiredToHaveBoxParameter);
    }

    public static final /* synthetic */ JsIrBackendContext access$getContext$p(ES6ConstructorBoxParameterOptimizationLowering $this) {
        return $this.context;
    }

    public static final /* synthetic */ boolean access$requiredToHaveBoxParameter(ES6ConstructorBoxParameterOptimizationLowering $this, IrClass $receiver) {
        return $this.requiredToHaveBoxParameter($receiver);
    }
}

